/*
 * Decompiled with CFR 0.152.
 */
package bwcrossmod.galacticgreg;

import bartworks.common.configs.Configuration;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.system.oregen.BWOreLayer;
import cpw.mods.fml.common.registry.GameRegistry;
import galacticgreg.GalacticGreg;
import galacticgreg.WorldgenOreLayerSpace;
import galacticgreg.WorldgenOreSmallSpace;
import galacticgreg.api.ModContainer;
import galacticgreg.api.ModDimensionDef;
import galacticgreg.registry.GalacticGregRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.util.GTUtility;
import gregtech.common.WorldgenGTOreLayer;
import gregtech.common.WorldgenGTOreSmallPieces;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class VoidMinerUtility {
    public static final FluidStack[] NOBLE_GASSES = new FluidStack[]{WerkstoffLoader.Neon.getFluidOrGas(1), WerkstoffLoader.Krypton.getFluidOrGas(1), WerkstoffLoader.Xenon.getFluidOrGas(1), WerkstoffLoader.Oganesson.getFluidOrGas(1)};
    public static final int[] NOBLE_GASSES_MULTIPLIER = new int[]{4, 8, 16, 64};
    public static final Map<Integer, DropMap> dropMapsByDimId = new HashMap<Integer, DropMap>();
    public static final Map<String, DropMap> dropMapsByChunkProviderName = new HashMap<String, DropMap>();
    public static final Map<Integer, DropMap> extraDropsDimMap = new HashMap<Integer, DropMap>();

    public static void generateDropMaps() {
        dropMapsByDimId.put(-1, VoidMinerUtility.getDropMapVanilla(-1));
        dropMapsByDimId.put(0, VoidMinerUtility.getDropMapVanilla(0));
        dropMapsByDimId.put(1, VoidMinerUtility.getDropMapVanilla(1));
        dropMapsByDimId.put(7, VoidMinerUtility.getDropMapVanilla(7));
        dropMapsByDimId.put(Configuration.crossModInteractions.ross128BID, VoidMinerUtility.getDropMapRoss(Configuration.crossModInteractions.ross128BID));
        dropMapsByDimId.put(Configuration.crossModInteractions.ross128BAID, VoidMinerUtility.getDropMapRoss(Configuration.crossModInteractions.ross128BAID));
        for (ModContainer modContainer : GalacticGregRegistry.getModContainers()) {
            for (ModDimensionDef dimDef : modContainer.getDimensionList()) {
                dropMapsByChunkProviderName.put(dimDef.getChunkProviderName(), VoidMinerUtility.getDropMapSpace(dimDef));
            }
        }
    }

    private static DropMap getDropMapVanilla(int dimId) {
        DropMap dropMap = new DropMap();
        Predicate<WorldgenGTOreLayer> oreLayerPredicate = VoidMinerUtility.makeOreLayerPredicate(dimId);
        WorldgenGTOreLayer.sList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && oreLayerPredicate.test((WorldgenGTOreLayer)gt_worldgen)).forEach(element -> {
            dropMap.addDrop(element.mPrimaryMeta, (float)element.mWeight, false);
            dropMap.addDrop(element.mSecondaryMeta, (float)element.mWeight, false);
            dropMap.addDrop(element.mSporadicMeta, (float)element.mWeight / 8.0f, false);
            dropMap.addDrop(element.mBetweenMeta, (float)element.mWeight / 8.0f, false);
        });
        Predicate<WorldgenGTOreSmallPieces> smallOresPredicate = VoidMinerUtility.makeSmallOresPredicate(dimId);
        WorldgenGTOreSmallPieces.sList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && smallOresPredicate.test((WorldgenGTOreSmallPieces)gt_worldgen)).forEach(element -> dropMap.addDrop(element.mMeta, (float)element.mAmount, false));
        return dropMap;
    }

    private static Predicate<WorldgenGTOreLayer> makeOreLayerPredicate(int dimensionId) {
        Predicate<WorldgenGTOreLayer> predicate;
        switch (dimensionId) {
            case -1: {
                predicate = gt_worldgen -> gt_worldgen.mNether;
                break;
            }
            case 0: {
                predicate = gt_worldgen -> gt_worldgen.mOverworld;
                break;
            }
            case 1: {
                predicate = gt_worldgen -> gt_worldgen.mEnd || gt_worldgen.mEndAsteroid;
                break;
            }
            case 7: {
                predicate = gt_worldgen -> gt_worldgen.twilightForest;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return predicate;
    }

    private static Predicate<WorldgenGTOreSmallPieces> makeSmallOresPredicate(int dimensionId) {
        Predicate<WorldgenGTOreSmallPieces> predicate;
        switch (dimensionId) {
            case -1: {
                predicate = gt_worldgen -> gt_worldgen.mNether;
                break;
            }
            case 0: {
                predicate = gt_worldgen -> gt_worldgen.mOverworld;
                break;
            }
            case 1: {
                predicate = gt_worldgen -> gt_worldgen.mEnd;
                break;
            }
            case 7: {
                predicate = gt_worldgen -> gt_worldgen.twilightForest;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return predicate;
    }

    private static DropMap getDropMapRoss(int aID) {
        DropMap dropMap = new DropMap();
        for (BWOreLayer oreLayer : BWOreLayer.sList) {
            if (!oreLayer.mEnabled || !oreLayer.isGenerationAllowed("", aID, 0)) continue;
            List<ItemStack> data = oreLayer.getStacks();
            dropMap.addDrop(data.get(0), oreLayer.mWeight);
            dropMap.addDrop(data.get(1), oreLayer.mWeight);
            dropMap.addDrop(data.get(2), (float)oreLayer.mWeight / 8.0f);
            dropMap.addDrop(data.get(3), (float)oreLayer.mWeight / 8.0f);
        }
        return dropMap;
    }

    private static DropMap getDropMapSpace(ModDimensionDef finalDef) {
        DropMap dropMap = new DropMap();
        GalacticGreg.oreVeinWorldgenList.stream().filter(gt_worldgen -> {
            WorldgenOreLayerSpace oreLayerSpace;
            return gt_worldgen.mEnabled && gt_worldgen instanceof WorldgenOreLayerSpace && (oreLayerSpace = (WorldgenOreLayerSpace)gt_worldgen).isEnabledForDim(finalDef);
        }).map(gt_worldgen -> (WorldgenOreLayerSpace)gt_worldgen).forEach(element -> {
            dropMap.addDrop(element.mPrimaryMeta, (float)element.mWeight, false);
            dropMap.addDrop(element.mSecondaryMeta, (float)element.mWeight, false);
            dropMap.addDrop(element.mSporadicMeta, (float)element.mWeight / 8.0f, false);
            dropMap.addDrop(element.mBetweenMeta, (float)element.mWeight / 8.0f, false);
        });
        GalacticGreg.smallOreWorldgenList.stream().filter(gt_worldgen -> {
            WorldgenOreSmallSpace oreSmallPiecesSpace;
            return gt_worldgen.mEnabled && gt_worldgen instanceof WorldgenOreSmallSpace && (oreSmallPiecesSpace = (WorldgenOreSmallSpace)gt_worldgen).isEnabledForDim(finalDef);
        }).map(gt_worldgen -> (WorldgenOreSmallSpace)gt_worldgen).forEach(element -> dropMap.addDrop(element.mMeta, (float)element.mAmount, false));
        return dropMap;
    }

    public static void addBlockToDimensionList(int dimId, Block block, int meta, float weight) {
        if (!extraDropsDimMap.containsKey(dimId)) {
            extraDropsDimMap.put(dimId, new DropMap());
        }
        extraDropsDimMap.get(dimId).addDrop(block, meta, weight);
    }

    public static void addMaterialToDimensionList(int DimensionID, ISubTagContainer Material2, float weight) {
        if (Material2 instanceof Materials) {
            Materials gtMaterial = (Materials)Material2;
            VoidMinerUtility.addBlockToDimensionList(DimensionID, GregTechAPI.sBlockOres1, gtMaterial.mMetaItemSubID, weight);
        } else if (Material2 instanceof Werkstoff) {
            Werkstoff werkstoff = (Werkstoff)Material2;
            VoidMinerUtility.addBlockToDimensionList(DimensionID, WerkstoffLoader.BWOres, werkstoff.getmID(), weight);
        }
    }

    static {
        VoidMinerUtility.addMaterialToDimensionList(0, Materials.Tellurium, 8.0f);
    }

    public static class DropMap {
        private float totalWeight = 0.0f;
        private final Map<GTUtility.ItemId, Float> internalMap = new HashMap<GTUtility.ItemId, Float>();
        private final Set<String> voidMinerBlacklistedDrops;

        public DropMap() {
            this.voidMinerBlacklistedDrops = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Configuration.multiblocks.voidMinerBlacklist)));
        }

        public void addDrop(int meta, float weight, boolean isBWOres) {
            if (isBWOres) {
                this.addDrop(WerkstoffLoader.BWOres, meta, weight);
            } else {
                this.addDrop(GregTechAPI.sBlockOres1, meta, weight);
            }
        }

        public void addDrop(Block block, int meta, float weight) {
            if (this.voidMinerBlacklistedDrops.contains(String.format("%s:%d", GameRegistry.findUniqueIdentifierFor((Block)block).toString(), meta))) {
                return;
            }
            Item item = Item.func_150898_a((Block)block);
            this.addDrop(item, meta, weight);
        }

        public void addDrop(ItemStack itemStack, float weight) {
            Item item = itemStack.func_77973_b();
            int meta = Items.field_151008_G.getDamage(itemStack);
            if (this.voidMinerBlacklistedDrops.contains(String.format("%s:%d", GameRegistry.findUniqueIdentifierFor((Block)Block.func_149634_a((Item)item)).toString(), meta))) {
                return;
            }
            this.addDrop(item, meta, weight);
        }

        private void addDrop(Item item, int meta, float weight) {
            GTUtility.ItemId ore = GTUtility.ItemId.createNoCopy(item, meta, null);
            this.internalMap.merge(ore, Float.valueOf(weight), Float::sum);
            this.totalWeight += weight;
        }

        public float getTotalWeight() {
            return this.totalWeight;
        }

        public Map<GTUtility.ItemId, Float> getInternalMap() {
            return this.internalMap;
        }
    }
}

