/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.client.renderer.EICPistonVisualizer;
import bartworks.common.configs.Configuration;
import bartworks.common.loaders.ItemRegistry;
import bartworks.common.net.PacketEIC;
import bartworks.util.Coords;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.blocks.LudicrousBlocks;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.INEIPreviewModifier;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.common.misc.GTStructureChannels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTEElectricImplosionCompressor
extends MTEExtendedPowerMultiBlockBase<MTEElectricImplosionCompressor>
implements ISurvivalConstructable,
INEIPreviewModifier {
    private static final boolean pistonEnabled = !Configuration.multiblocks.disablePistonInEIC;
    private Boolean piston = true;
    private static final SoundResource sound = SoundResource.RANDOM_EXPLODE;
    private final ArrayList<ChunkCoordinates> chunkCoordinates = new ArrayList(5);
    private int mBlockTier = 0;
    private int mCasing;
    private boolean isSuccessful = true;
    private static final int CASING_INDEX = 16;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_MAIN_SUCCESSFUL = "main_successful";
    private static final String[][] shape = new String[][]{{"CCC", "CBC", "CCC"}, {"DDD", "DGD", "DDD"}, {"DDD", "DGD", "DDD"}, {"EEE", "EEE", "EEE"}, {"EFE", "FFF", "EFE"}, {"EEE", "EEE", "EEE"}, {"D~D", "DGD", "DDD"}, {"DDD", "DGD", "DDD"}, {"CCC", "CBC", "CCC"}};

    public MTEElectricImplosionCompressor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEElectricImplosionCompressor(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEElectricImplosionCompressor(this.mName);
    }

    public static ImmutableList<Pair<Block, Integer>> getTierBlockList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Pair.of((Object)GregTechAPI.sBlockMetal5, (Object)2));
        if (Mods.Avaritia.isModLoaded()) {
            builder.add((Object)Pair.of((Object)LudicrousBlocks.resource_block, (Object)1));
        }
        builder.add((Object)Pair.of((Object)GregTechAPI.sBlockMetal9, (Object)4));
        builder.add((Object)Pair.of((Object)GregTechAPI.sBlockMetal9, (Object)3));
        builder.add((Object)Pair.of((Object)GregTechAPI.sBlockMetal9, (Object)8));
        return builder.build();
    }

    @Nullable
    public static Integer getTierBlock(Block block, int meta) {
        if (block == null) {
            return null;
        }
        if (block == GregTechAPI.sBlockMetal5 && meta == 2) {
            return 1;
        }
        if (Mods.Avaritia.isModLoaded()) {
            if (block == LudicrousBlocks.resource_block && meta == 1) {
                return 2;
            }
            if (block == GregTechAPI.sBlockMetal9 && meta == 4) {
                return 3;
            }
            if (block == GregTechAPI.sBlockMetal9 && meta == 3) {
                return 4;
            }
            if (block == GregTechAPI.sBlockMetal9 && meta == 8) {
                return 5;
            }
        } else {
            if (block == GregTechAPI.sBlockMetal9 && meta == 4) {
                return 2;
            }
            if (block == GregTechAPI.sBlockMetal9 && meta == 3) {
                return 3;
            }
            if (block == GregTechAPI.sBlockMetal9 && meta == 8) {
                return 4;
            }
        }
        return null;
    }

    @Override
    public IStructureDefinition<MTEElectricImplosionCompressor> getStructureDefinition() {
        return StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])shape)).addShape(STRUCTURE_PIECE_MAIN_SUCCESSFUL, (String[][])Arrays.stream(StructureUtility.transpose((String[][])shape)).map(sa -> (String[])Arrays.stream(sa).map(s -> s.replaceAll("F", "H")).toArray(String[]::new)).toArray(x$0 -> new String[x$0][])).addElement('B', GTStructureUtility.buildHatchAdder(MTEElectricImplosionCompressor.class).atLeast(HatchElement.Energy.or(HatchElement.ExoticEnergy)).casingIndex(16).dot(2).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)4)))).addElement('C', GTStructureUtility.buildHatchAdder(MTEElectricImplosionCompressor.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(16).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)4)))).addElement('D', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)1)).addElement('E', GTStructureChannels.EIC_PISTON.use(StructureUtility.ofBlocksTiered(MTEElectricImplosionCompressor::getTierBlock, MTEElectricImplosionCompressor.getTierBlockList(), (Object)-1, (t, m) -> {
            t.mBlockTier = m;
        }, t -> t.mBlockTier))).addElement('F', GTStructureChannels.EIC_PISTON.use(StructureUtility.ofBlocksTiered(MTEElectricImplosionCompressor::getTierBlock, MTEElectricImplosionCompressor.getTierBlockList(), (Object)-1, (t, m) -> {
            t.mBlockTier = m;
        }, t -> t.mBlockTier))).addElement('G', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)0)).addElement('H', StructureUtility.isAir()).build();
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Implosion Compressor, EIC").addInfo("Explosions are fun").addInfo("Uses electricity instead of Explosives").addInfo("Can parallel up to 4^(Tier - 1)").addInfo("Tier is determined by containment block").addInfo("Valid blocks: Neutronium, Infinity, Transcendent Metal, Spacetime, Universium").addInfo("Minimum allowed energy hatch tier is one below recipe tier").addTecTechHatchInfo().beginStructureBlock(3, 9, 3, false).addController("Front 3rd layer center").addCasingInfoMin("Solid Steel Machine Casing", 8, false).addStructureInfo("Casings can be replaced with Explosion Warning Signs").addOtherStructurePart("Transformer-Winding Blocks", "Outer layer 2,3,7,8").addOtherStructurePart("Nickel-Zinc-Ferrite Blocks", "Inner layer 2,3,7,8").addOtherStructurePart("Containment Blocks", "Layer 4,5,6").addMaintenanceHatch("Any Solid Steel Machine casing", 1).addInputBus("Any Solid Steel Machine casing", 1).addInputHatch("Any Solid Steel Machine casing", 1).addOutputBus("Any Solid Steel Machine casing", 1).addEnergyHatch("Bottom middle and/or top middle", 2).addSubChannelUsage(GTStructureChannels.EIC_PISTON).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return BartWorksRecipeMaps.electricImplosionCompressorRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(MTEElectricImplosionCompressor.this.getMaxInputEu()).setAmperage(1L);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return (int)GTUtility.powInt(4.0, Math.max(this.mBlockTier - 1, 0));
    }

    private void updateChunkCoordinates() {
        this.chunkCoordinates.clear();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                int[] abc = new int[]{x, -2, z + 1};
                int[] xyz = new int[]{0, 0, 0};
                this.getExtendedFacing().getWorldOffset(abc, xyz);
                xyz[0] = xyz[0] + this.getBaseMetaTileEntity().getXCoord();
                xyz[1] = xyz[1] + this.getBaseMetaTileEntity().getYCoord();
                xyz[2] = xyz[2] + this.getBaseMetaTileEntity().getZCoord();
                this.chunkCoordinates.add(new ChunkCoordinates(xyz[0], xyz[1], xyz[2]));
            }
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.updateChunkCoordinates();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (pistonEnabled && aBaseMetaTileEntity.isActive() && aTick % 20L == 0L) {
            if (aBaseMetaTileEntity.isClientSide()) {
                this.animatePiston(aBaseMetaTileEntity);
            } else if (aBaseMetaTileEntity.hasMufflerUpgrade()) {
                GTValues.NW.sendPacketToAllPlayersInRange(aBaseMetaTileEntity.getWorld(), new PacketEIC(new Coords(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord()), true), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getZCoord());
            }
        }
    }

    @Override
    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        super.setExtendedFacing(newExtendedFacing);
        this.updateChunkCoordinates();
    }

    @Override
    public void stopMachine(@NotNull ShutDownReason reason) {
        this.resetPiston(this.mBlockTier);
        super.stopMachine(reason);
    }

    private void resetPiston(int tier) {
        if (!pistonEnabled) {
            return;
        }
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (!this.piston.booleanValue()) {
            ImmutableList<Pair<Block, Integer>> tiers = MTEElectricImplosionCompressor.getTierBlockList();
            Pair tieredBlock = (Pair)tiers.get(Math.min(tier, tiers.size()) - 1);
            this.chunkCoordinates.forEach(c -> {
                if (aBaseMetaTileEntity.getWorld().func_147437_c(c.field_71574_a, c.field_71572_b, c.field_71573_c)) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(c.field_71574_a, c.field_71572_b, c.field_71573_c, (Block)tieredBlock.getKey(), ((Integer)tieredBlock.getValue()).intValue(), 3);
                }
            });
            this.piston = this.piston == false;
        }
    }

    private void activatePiston() {
        if (!pistonEnabled) {
            return;
        }
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (this.piston.booleanValue()) {
            this.chunkCoordinates.forEach(c -> aBaseMetaTileEntity.getWorld().func_147468_f(c.field_71574_a, c.field_71572_b, c.field_71573_c));
            this.piston = this.piston == false;
            this.isSuccessful = true;
        }
    }

    private void animatePiston(IGregTechTileEntity aBaseMetaTileEntity) {
        if (!aBaseMetaTileEntity.getWorld().field_72995_K) {
            return;
        }
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            GTUtility.doSoundAtClient(sound, 10, 1.0f, 1.0f, (double)this.chunkCoordinates.get((int)0).field_71574_a, (double)this.chunkCoordinates.get((int)0).field_71572_b, (double)this.chunkCoordinates.get((int)0).field_71573_c);
        }
        this.spawnVisualPistonBlocks(aBaseMetaTileEntity.getWorld(), this.chunkCoordinates.get((int)2).field_71574_a, this.chunkCoordinates.get((int)2).field_71572_b, this.chunkCoordinates.get((int)2).field_71573_c);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVisualPistonBlocks(World world, int x, int y, int z) {
        EICPistonVisualizer pistonVisualizer = new EICPistonVisualizer(world, x, y, z, 10);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)pistonVisualizer);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("piston", this.piston.booleanValue());
        aNBT.func_74757_a("isSuccessful", this.isSuccessful);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("piston")) {
            this.piston = aNBT.func_74767_n("piston");
        }
        if (aNBT.func_74764_b("isSuccessful")) {
            this.isSuccessful = aNBT.func_74767_n("isSuccessful");
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        int pistonTier = this.mBlockTier;
        int mMaxHatchTier = 0;
        this.mCasing = 0;
        this.mBlockTier = -1;
        boolean isOK = this.isSuccessful ? this.checkPiece(STRUCTURE_PIECE_MAIN_SUCCESSFUL, 1, 6, 0) : this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 6, 0);
        List<MTEHatch> energyHatches = this.getExoticAndNormalEnergyHatchList();
        for (MTEHatch hatch : energyHatches) {
            mMaxHatchTier = Math.max(mMaxHatchTier, hatch.mTier);
        }
        boolean bl = isOK = isOK && this.mMaintenanceHatches.size() == 1 && !energyHatches.isEmpty();
        if (isOK) {
            this.activatePiston();
            return true;
        }
        this.isSuccessful = false;
        this.resetPiston(pistonTier);
        return false;
    }

    @Override
    public void onBlockDestroyed() {
        this.resetPiston(this.mBlockTier);
        super.onBlockDestroyed();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16)};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.isSuccessful = false;
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 1, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        this.isSuccessful = false;
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 6, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public void onPreviewStructureComplete(@NotNull ItemStack trigger) {
        this.resetPiston(this.mBlockTier);
    }
}

