/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.PHNatura;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class SaguaroGen
extends WorldGenerator {
    boolean useHeight;
    private final int saguaroMeta;
    private final Block saguaroBlock;

    public SaguaroGen(Block saguaroBlock, int saguaroMeta, boolean useHeight) {
        super(true);
        this.saguaroBlock = saguaroBlock;
        this.saguaroMeta = saguaroMeta;
        this.useHeight = useHeight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int yPos = this.findGround(world, x, y, z, this.useHeight);
        Block currentID = world.func_147439_a(x, yPos, z);
        if (!world.func_147437_c(x, yPos, z)) {
            if (currentID != this.saguaroBlock) return false;
            Block block = world.func_147439_a(x, yPos - 1, z);
            if (!block.canSustainPlant((IBlockAccess)world, x, yPos - 1, z, ForgeDirection.UP, (IPlantable)this.saguaroBlock)) {
                return false;
            }
        } else {
            Block block = world.func_147439_a(x, yPos - 1, z);
            if (!block.canSustainPlant((IBlockAccess)world, x, yPos - 1, z, ForgeDirection.UP, (IPlantable)this.saguaroBlock)) {
                return false;
            }
        }
        if (random.nextInt(20) == 0) {
            this.generateCactusTree(world, random, x, yPos, z);
            return true;
        } else {
            this.generateSmallCactus(world, random, x, yPos, z);
        }
        return true;
    }

    void generateCactusTree(World world, Random random, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            this.genBlock(world, x, y + i, z);
        }
        this.genBlock(world, x + 1, y + 2, z);
        this.genBlock(world, x - 1, y + 2, z);
        this.genBlock(world, x, y + 2, z + 1);
        this.genBlock(world, x, y + 2, z - 1);
        for (int height = 0; height < 2; ++height) {
            this.genBlock(world, x + 2, y + height + 2, z);
            this.genBlock(world, x - 2, y + height + 2, z);
            this.genBlock(world, x, y + height + 2, z + 2);
            this.genBlock(world, x, y + height + 2, z - 2);
            this.genBlock(world, x + 3, y + height + 3, z);
            this.genBlock(world, x - 3, y + height + 3, z);
            this.genBlock(world, x, y + height + 3, z + 3);
            this.genBlock(world, x, y + height + 3, z - 3);
            this.genBlock(world, x + 1, y + height + 5, z);
            this.genBlock(world, x - 1, y + height + 5, z);
            this.genBlock(world, x, y + height + 5, z + 1);
            this.genBlock(world, x, y + height + 5, z - 1);
        }
    }

    void generateSmallCactus(World world, Random random, int x, int y, int z) {
        int branch;
        int size;
        int height = random.nextInt(4) + 3;
        for (int iter = 0; iter < height; ++iter) {
            this.genBlock(world, x, y + iter, z);
        }
        int branchY = height >= 5 ? 2 : 1;
        y += branchY;
        if (random.nextBoolean()) {
            size = random.nextInt(height - branchY) + branchY - random.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.genBlock(world, x + 1, y + branch, z);
            }
        }
        if (random.nextBoolean()) {
            size = random.nextInt(height - branchY) + branchY - random.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.genBlock(world, x - 1, y + branch, z);
            }
        }
        if (random.nextBoolean()) {
            size = random.nextInt(height - branchY) + branchY - random.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.genBlock(world, x, y + branch, z + 1);
            }
        }
        if (random.nextBoolean()) {
            size = random.nextInt(height - branchY) + branchY - random.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.genBlock(world, x, y + branch, z - 1);
            }
        }
    }

    void genBlock(World world, int x, int y, int z) {
        if (!world.func_147439_a(x, y, z).func_149662_c()) {
            world.func_147465_d(x, y, z, this.saguaroBlock, this.saguaroMeta, 3);
        }
    }

    int findGround(World world, int x, int y, int z, boolean useHeight) {
        if (useHeight) {
            return y;
        }
        boolean foundGround = false;
        int height = PHNatura.seaLevel + 64;
        do {
            Block underID;
            if ((underID = world.func_147439_a(x, --height, z)) != Blocks.field_150354_m && underID != Blocks.field_150346_d && underID != Blocks.field_150349_c && height >= PHNatura.seaLevel) continue;
            foundGround = true;
        } while (!foundGround);
        return height + 1;
    }
}

