/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import com.google.common.base.Stopwatch;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.BailErrorStrategy;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.CharStreams;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.CommonTokenStream;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.ConsoleErrorListener;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.DefaultErrorStrategy;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.Parser;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.atn.ParserATNSimulator;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.atn.PredictionMode;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTree;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.TerminalNode;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.Util;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLLexer;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.CompatibilityTransformer;
import net.coderbot.iris.pipeline.transform.CompositeDepthTransformer;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.SodiumTransformer;
import net.coderbot.iris.pipeline.transform.parameter.AttributeParameters;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;

public class ShaderTransformer {
    static String tab = "";
    private static final Pattern versionPattern = Pattern.compile("#version\\s+(\\d+)(?:\\s+(\\w+))?");
    private static final int CACHE_SIZE = 100;
    private static final Object2ObjectLinkedOpenHashMap<TransformKey, Map<PatchShaderType, String>> shaderTransformationCache = new Object2ObjectLinkedOpenHashMap();
    private static final boolean useCache = true;
    private static final List<String> fullReservedWords = new ArrayList<String>();
    private static final Map<Integer, List<String>> versionedReservedWords = new HashMap<Integer, List<String>>();

    public static <P extends Parameters> Map<PatchShaderType, String> transform(String vertex, String geometry, String fragment, P parameters) {
        if (vertex == null && geometry == null && fragment == null) {
            return null;
        }
        Patch patchType = parameters.patch;
        EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        inputs.put(PatchShaderType.VERTEX, vertex);
        inputs.put(PatchShaderType.GEOMETRY, geometry);
        inputs.put(PatchShaderType.FRAGMENT, fragment);
        TransformKey key = new TransformKey(patchType, inputs, parameters, null);
        Map<PatchShaderType, String> result = (Map<PatchShaderType, String>)shaderTransformationCache.getAndMoveToFirst(key);
        if (result == null) {
            result = ShaderTransformer.transformInternal(inputs, patchType, parameters);
            parameters.type = null;
            if (shaderTransformationCache.size() >= 100) {
                shaderTransformationCache.removeLast();
            }
            shaderTransformationCache.putAndMoveToLast(key, result);
        }
        return result;
    }

    private static void configureNoError(Parser parser) {
        parser.setErrorHandler(new BailErrorStrategy());
        parser.removeErrorListeners();
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
    }

    private static void configureError(Parser parser) {
        parser.setErrorHandler(new DefaultErrorStrategy());
        parser.addErrorListener(ConsoleErrorListener.INSTANCE);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
    }

    private static <P extends Parameters> Map<PatchShaderType, String> transformInternal(EnumMap<PatchShaderType, String> inputs, Patch patchType, P parameters) {
        EnumMap<PatchShaderType, String> result = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        EnumMap<PatchShaderType, GLSLParser.Translation_unitContext> types = new EnumMap<PatchShaderType, GLSLParser.Translation_unitContext>(PatchShaderType.class);
        EnumMap<PatchShaderType, String> prepatched = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        ArrayList<GLSLParser.Translation_unitContext> textureLodExtensionPatches = new ArrayList<GLSLParser.Translation_unitContext>();
        Stopwatch watch = Stopwatch.createStarted();
        PatchShaderType[] patchShaderTypeArray = PatchShaderType.values();
        int n = patchShaderTypeArray.length;
        for (int i = 0; i < n; ++i) {
            GLSLParser.Translation_unitContext translationUnit;
            PatchShaderType type;
            parameters.type = type = patchShaderTypeArray[i];
            if (inputs.get((Object)type) == null) continue;
            String input = inputs.get((Object)type);
            Matcher matcher = versionPattern.matcher(input);
            if (!matcher.find()) {
                throw new IllegalArgumentException("No #version directive found in source code!");
            }
            String versionString = matcher.group(1);
            if (versionString == null) continue;
            String profile = "";
            int versionInt = Integer.parseInt(versionString);
            if (versionInt >= 150 && (profile = matcher.group(2)) == null) {
                profile = "core";
            }
            String profileString = "#version " + versionString + " " + profile + "\n";
            for (String reservedWord : fullReservedWords) {
                String newName = "iris_renamed_" + reservedWord;
                input = input.replaceAll("\\b" + reservedWord + "\\b", newName);
            }
            Iterator<Object> iterator = versionedReservedWords.keySet().iterator();
            while (iterator.hasNext()) {
                int version = (Integer)iterator.next();
                if (versionInt >= version) continue;
                for (String reservedWord : versionedReservedWords.get(version)) {
                    String newName = "iris_renamed_" + reservedWord;
                    input = input.replaceAll("\\b" + reservedWord + "\\b", newName);
                }
            }
            GLSLLexer lexer = new GLSLLexer(CharStreams.fromString(input));
            GLSLParser parser = new GLSLParser(new CommonTokenStream(lexer));
            parser.setBuildParseTree(true);
            ShaderTransformer.configureNoError(parser);
            try {
                translationUnit = ShaderTransformer.doTransform(parser, patchType, parameters, profile, versionInt);
            }
            catch (Exception e) {
                lexer.reset();
                parser.reset();
                ShaderTransformer.configureError(parser);
                translationUnit = ShaderTransformer.doTransform(parser, patchType, parameters, profile, versionInt);
            }
            if (versionInt <= 120 && (Util.containsCall(translationUnit, "texture2DLod") || Util.containsCall(translationUnit, "texture3DLod"))) {
                textureLodExtensionPatches.add(translationUnit);
            }
            types.put(type, translationUnit);
            prepatched.put(type, profileString);
        }
        CompatibilityTransformer.transformGrouped(types, parameters);
        for (Map.Entry entry : types.entrySet()) {
            String formattedShader = ShaderTransformer.getFormattedShader((ParseTree)entry.getValue(), (String)prepatched.get(entry.getKey()));
            if (textureLodExtensionPatches.contains(entry.getValue())) {
                String[] parts = formattedShader.split("\n", 2);
                parts[1] = "#extension GL_ARB_shader_texture_lod : require\n" + parts[1];
                formattedShader = parts[0] + "\n" + parts[1];
            }
            result.put((PatchShaderType)((Object)entry.getKey()), formattedShader);
        }
        watch.stop();
        Iris.logger.info("Transformed shader for {} in {}", patchType.name(), watch);
        return result;
    }

    private static GLSLParser.Translation_unitContext doTransform(GLSLParser parser, Patch patchType, Parameters parameters, String profile, int versionInt) {
        GLSLParser.Translation_unitContext translationUnit = parser.translation_unit();
        switch (patchType) {
            case SODIUM_TERRAIN: {
                SodiumTransformer.transform(translationUnit, parameters);
                break;
            }
            case COMPOSITE: {
                CompositeDepthTransformer.transform(translationUnit);
                break;
            }
            case ATTRIBUTES: {
                AttributeTransformer.transform(translationUnit, (AttributeParameters)parameters, profile, versionInt);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown patch type: " + patchType.name());
            }
        }
        CompatibilityTransformer.transformEach(translationUnit, parameters);
        return translationUnit;
    }

    public static void applyIntelHd4000Workaround(GLSLParser.Translation_unitContext translationUnit) {
        Util.renameFunctionCall(translationUnit, "ftransform", "iris_ftransform");
    }

    public static void replaceGlMultiTexCoordBounded(GLSLParser.Translation_unitContext translationUnit, int min, int max) {
        for (int i = min; i <= max; ++i) {
            Util.replaceExpression(translationUnit, "gl_MultiTexCoord" + i, "vec4(0.0, 0.0, 0.0, 1.0)");
        }
    }

    public static void patchMultiTexCoord3(GLSLParser.Translation_unitContext translationUnit, Parameters parameters) {
        if (parameters.type.glShaderType == ShaderType.VERTEX && Util.hasVariable(translationUnit, "gl_MultiTexCoord3") && !Util.hasVariable(translationUnit, "mc_midTexCoord")) {
            Util.rename(translationUnit, "gl_MultiTexCoord3", "mc_midTexCoord");
            Util.injectVariable(translationUnit, "attribute vec4 mc_midTexCoord;");
        }
    }

    public static void replaceMidTexCoord(GLSLParser.Translation_unitContext translationUnit, float textureScale) {
        int type = Util.findType(translationUnit, "mc_midTexCoord");
        if (type != 0) {
            Util.removeVariable(translationUnit, "mc_midTexCoord");
        }
        Util.replaceExpression(translationUnit, "mc_midTexCoord", "iris_MidTex");
        switch (type) {
            case 0: {
                return;
            }
            case 3: {
                return;
            }
            case 36: {
                Util.injectFunction(translationUnit, "float iris_MidTex = (mc_midTexCoord.x * " + textureScale + ").x;");
                break;
            }
            case 196: {
                Util.injectFunction(translationUnit, "vec2 iris_MidTex = (mc_midTexCoord.xy * " + textureScale + ").xy;");
                break;
            }
            case 197: {
                Util.injectFunction(translationUnit, "vec3 iris_MidTex = vec3(mc_midTexCoord.xy * " + textureScale + ", 0.0);");
                break;
            }
            case 198: {
                Util.injectFunction(translationUnit, "vec4 iris_MidTex = vec4(mc_midTexCoord.xy * " + textureScale + ", 0.0, 1.0);");
                break;
            }
        }
        Util.injectVariable(translationUnit, "in vec2 mc_midTexCoord;");
    }

    public static void addIfNotExists(GLSLParser.Translation_unitContext translationUnit, String name, String code) {
        if (!Util.hasVariable(translationUnit, name)) {
            Util.injectVariable(translationUnit, code);
        }
    }

    public static void addIfNotExistsType(GLSLParser.Translation_unitContext translationUnit, String name, String type) {
        if (!Util.hasVariable(translationUnit, name)) {
            Util.injectVariable(translationUnit, type + " " + name + ";");
        }
    }

    public static String getFormattedShader(ParseTree tree, String string) {
        StringBuilder sb = new StringBuilder(string + "\n");
        ShaderTransformer.getFormattedShader(tree, sb);
        return sb.toString();
    }

    private static void getFormattedShader(ParseTree tree, StringBuilder stringBuilder) {
        if (tree instanceof TerminalNode) {
            String text = tree.getText();
            if (text.equals("<EOF>")) {
                return;
            }
            if (text.equals("#")) {
                stringBuilder.append("\n#");
                return;
            }
            stringBuilder.append(text);
            if (text.equals("{")) {
                stringBuilder.append(" \n\t");
                tab = "\t";
            }
            if (text.equals("}")) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 2);
                tab = "";
            }
            stringBuilder.append(text.equals(";") ? " \n" + tab : " ");
        } else {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                ShaderTransformer.getFormattedShader(tree.getChild(i), stringBuilder);
            }
        }
    }

    static {
        fullReservedWords.add("texture");
        versionedReservedWords.put(400, Arrays.asList("sample"));
    }

    private static final class TransformKey<P extends Parameters> {
        private final Patch patchType;
        private final EnumMap<PatchShaderType, String> inputs;
        private final P params;

        private TransformKey(Patch patchType, EnumMap<PatchShaderType, String> inputs, P params) {
            this.patchType = patchType;
            this.inputs = inputs;
            this.params = params;
        }

        public Patch patchType() {
            return this.patchType;
        }

        public EnumMap<PatchShaderType, String> inputs() {
            return this.inputs;
        }

        public P params() {
            return this.params;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TransformKey that = (TransformKey)obj;
            return Objects.equals((Object)this.patchType, (Object)that.patchType) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.params, that.params);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.patchType, this.inputs, this.params});
        }

        public String toString() {
            return "TransformKey[patchType=" + (Object)((Object)this.patchType) + ", inputs=" + this.inputs + ", params=" + this.params + ']';
        }

        /* synthetic */ TransformKey(Patch x0, EnumMap x1, Parameters x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

