/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options.control;

import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.element.ControlElementFactory;
import me.jellysquid.mods.sodium.client.gui.options.named.NamedState;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.Validate;

public class CyclingControl<T extends Enum<T>>
implements Control<T> {
    private final Option<T> option;
    private final T[] allowedValues;
    private final String[] names;

    public CyclingControl(Option<T> option, Class<T> enumType) {
        this(option, enumType, (Enum[])enumType.getEnumConstants());
    }

    public CyclingControl(Option<T> option, Class<T> enumType, String[] names) {
        Object[] universe = (Enum[])enumType.getEnumConstants();
        Validate.isTrue((universe.length == names.length ? 1 : 0) != 0, (String)"Mismatch between universe length and names array length", (Object[])new Object[0]);
        Validate.notEmpty((Object[])universe, (String)"The enum universe must contain at least one item", (Object[])new Object[0]);
        this.option = option;
        this.allowedValues = universe;
        this.names = names;
    }

    public CyclingControl(Option<T> option, Class<T> enumType, T[] allowedValues) {
        Enum[] universe = (Enum[])enumType.getEnumConstants();
        this.option = option;
        this.allowedValues = allowedValues;
        this.names = new String[universe.length];
        for (int i = 0; i < this.names.length; ++i) {
            String name;
            String string;
            Enum value = universe[i];
            if (value instanceof NamedState) {
                NamedState namedState = (NamedState)((Object)value);
                string = namedState.getKey();
            } else {
                string = value.name();
            }
            this.names[i] = name = I18n.func_135052_a((String)string, (Object[])new Object[0]);
        }
    }

    @Override
    public Option<T> getOption() {
        return this.option;
    }

    @Override
    public ControlElement<T> createElement(Dim2i dim, ControlElementFactory factory) {
        return factory.cyclingControlElement(this.option, dim, (Enum[])this.allowedValues, this.names);
    }

    @Override
    public int getMaxWidth() {
        return 70;
    }
}

