/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.biome;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import java.util.BitSet;
import net.minecraft.client.Minecraft;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeAPI {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.CUSTOM_COLORS);
    public static final int WORLD_MAX_HEIGHT = 255;
    private static boolean biomesLogged;
    private static BiomeGenBase lastBiome;
    private static int lastI;
    private static int lastK;

    BiomeAPI() {
    }

    public static void parseBiomeList(String list, BitSet bits) {
        BiomeAPI.logBiomes();
        if (MCPatcherUtils.isNullOrEmpty(list)) {
            return;
        }
        for (String s : list.split(list.contains(",") ? "\\s*,\\s*" : "\\s+")) {
            BiomeGenBase biome = BiomeAPI.findBiomeByName(s);
            if (biome == null) continue;
            bits.set(biome.field_76756_M);
        }
    }

    public static BitSet getHeightListProperty(PropertiesFile properties, String suffix) {
        int minHeight = Math.max(properties.getInt("minHeight" + suffix, 0), 0);
        int maxHeight = Math.min(properties.getInt("maxHeight" + suffix, 255), 255);
        String heightStr = properties.getString("heights" + suffix, "");
        if (minHeight == 0 && maxHeight == 255 && heightStr.isEmpty()) {
            return null;
        }
        BitSet heightBits = new BitSet(256);
        if (heightStr.isEmpty()) {
            heightStr = minHeight + "-" + maxHeight;
        }
        for (int i : MCPatcherUtils.parseIntegerList(heightStr, 0, 255)) {
            heightBits.set(i);
        }
        return heightBits;
    }

    public static BiomeGenBase findBiomeByName(String name) {
        BiomeAPI.logBiomes();
        if (name == null) {
            return null;
        }
        if ((name = name.replace(" ", "")).isEmpty()) {
            return null;
        }
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || biome.field_76791_y == null || !name.equalsIgnoreCase(biome.field_76791_y) && !name.equalsIgnoreCase(biome.field_76791_y.replace(" ", "")) || biome.field_76756_M < 0 || biome.field_76756_M >= BiomeGenBase.func_150565_n().length) continue;
            return biome;
        }
        return null;
    }

    public static IBlockAccess getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static int getBiomeIDAt(IBlockAccess blockAccess, int i, int j, int k) {
        BiomeGenBase biome = BiomeAPI.getBiomeGenAt(blockAccess, i, j, k);
        return biome == null ? BiomeGenBase.func_150565_n().length : biome.field_76756_M;
    }

    public static BiomeGenBase getBiomeGenAt(IBlockAccess blockAccess, int i, int j, int k) {
        if (lastBiome == null || i != lastI || k != lastK) {
            lastI = i;
            lastK = k;
            lastBiome = blockAccess.func_72807_a(i, k);
        }
        return lastBiome;
    }

    public static int getWaterColorMultiplier(BiomeGenBase biome) {
        return biome == null ? 0xFFFFFF : biome.getWaterColorMultiplier();
    }

    private static void logBiomes() {
        if (!biomesLogged) {
            biomesLogged = true;
            for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
                BiomeGenBase biome = BiomeGenBase.func_150565_n()[i];
                if (biome == null) continue;
                int x = (int)(255.0f * (1.0f - biome.field_76750_F));
                int y = (int)(255.0f * (1.0f - biome.field_76750_F * biome.field_76751_G));
                logger.config("setupBiome #%d id=%d \"%s\" %06x (%d,%d)", i, biome.field_76756_M, biome.field_76791_y, biome.field_76759_H, x, y);
            }
        }
    }
}

