/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.transform.compat.handlers;

import com.gtnewhorizons.angelica.config.CompatConfig;
import com.gtnewhorizons.angelica.transform.compat.handlers.CompatHandler;
import com.gtnewhorizons.angelica.transform.compat.handlers.ExtraUtilsCompatHandler;
import com.gtnewhorizons.angelica.transform.compat.handlers.ImmersiveEngineeringCompatHandler;
import com.gtnewhorizons.angelica.transform.compat.handlers.StacksOnStacksCompatHandler;
import com.gtnewhorizons.angelica.transform.compat.handlers.ThaumcraftCompatHandler;
import com.gtnewhorizons.angelica.transform.compat.handlers.ThaumicHorizonsCompatHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public enum CompatHandlers {
    STACKS_ON_STACKS(() -> CompatConfig.fixStacksOnStacks, new StacksOnStacksCompatHandler()),
    EXTRA_UTILS(() -> CompatConfig.fixExtraUtils, new ExtraUtilsCompatHandler()),
    IMMERSIVE_ENGINEERING(() -> CompatConfig.fixImmersiveEngineering, new ImmersiveEngineeringCompatHandler()),
    THAUMCRAFT(() -> CompatConfig.fixThaumcraft, new ThaumcraftCompatHandler()),
    THAUMIC_HORIZONS(() -> CompatConfig.fixThaumicHorizons, new ThaumicHorizonsCompatHandler());

    private final Supplier<Boolean> applyIf;
    private final CompatHandler handler;
    private static List<CompatHandler> compatHandlers;

    private CompatHandlers(Supplier<Boolean> applyIf, CompatHandler handler) {
        this.applyIf = applyIf;
        this.handler = handler;
    }

    public static List<CompatHandler> getHandlers() {
        if (compatHandlers != null) {
            return compatHandlers;
        }
        compatHandlers = new ArrayList<CompatHandler>();
        for (CompatHandlers value : CompatHandlers.values()) {
            if (!value.applyIf.get().booleanValue()) continue;
            compatHandlers.add(value.handler);
        }
        return compatHandlers;
    }

    static {
        compatHandlers = null;
    }
}

