/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.hooks;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.RedoServerCacheCommand;
import com.sinthoras.visualprospecting.database.RedoServerSpawnCacheCommand;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.WorldIdHandler;
import com.sinthoras.visualprospecting.database.cachebuilder.WorldAnalysis;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import com.sinthoras.visualprospecting.hooks.HooksEventBus;
import com.sinthoras.visualprospecting.hooks.HooksFML;
import com.sinthoras.visualprospecting.item.ProspectorsLog;
import com.sinthoras.visualprospecting.network.ProspectingNotification;
import com.sinthoras.visualprospecting.network.ProspectingRequest;
import com.sinthoras.visualprospecting.network.ProspectionSharing;
import com.sinthoras.visualprospecting.network.WorldIdNotification;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import gregtech.api.GregTechAPI;
import java.io.File;
import java.io.IOException;
import java.util.zip.DataFormatException;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

public class HooksShared {
    private static boolean newWorld = false;

    public void fmlLifeCycleEvent(FMLPreInitializationEvent event) {
        Config.syncronizeConfiguration(event.getSuggestedConfigurationFile());
        VP.network = NetworkRegistry.INSTANCE.newSimpleChannel("visualprospecting");
        int networkId = 0;
        VP.network.registerMessage(ProspectingRequest.Handler.class, ProspectingRequest.class, networkId++, Side.SERVER);
        VP.network.registerMessage(ProspectingNotification.Handler.class, ProspectingNotification.class, networkId++, Side.CLIENT);
        VP.network.registerMessage(WorldIdNotification.Handler.class, WorldIdNotification.class, networkId++, Side.CLIENT);
        VP.network.registerMessage(ProspectionSharing.ServerHandler.class, ProspectionSharing.class, networkId++, Side.SERVER);
        VP.network.registerMessage(ProspectionSharing.ClientHandler.class, ProspectionSharing.class, networkId++, Side.CLIENT);
        ProspectorsLog.instance = new ProspectorsLog();
        GameRegistry.registerItem((Item)ProspectorsLog.instance, (String)ProspectorsLog.instance.func_77658_a());
    }

    public void fmlLifeCycleEvent(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new HooksEventBus());
        FMLCommonHandler.instance().bus().register((Object)new HooksFML());
    }

    public void fmlLifeCycleEvent(FMLPostInitializationEvent event) {
        GregTechAPI.sAfterGTPostload.add(new VeinTypeCaching());
    }

    public void fmlLifeCycleEvent(FMLServerAboutToStartEvent event) {
        File worldDir = DimensionManager.getCurrentSaveRootDirectory();
        if (worldDir != null) {
            File regionFolder = new File(worldDir, "region");
            newWorld = !regionFolder.exists();
        }
    }

    public void fmlLifeCycleEvent(FMLServerStartingEvent event) {
        WorldServer world = DimensionManager.getWorld((int)0);
        WorldIdHandler.load(world);
        boolean loaded = ServerCache.instance.loadVeinCache(WorldIdHandler.getWorldId());
        if (!(newWorld || loaded && !Config.recacheVeins)) {
            try {
                WorldAnalysis worldAnalysis = new WorldAnalysis(world.func_72860_G().func_75765_b());
                worldAnalysis.cacheVeins();
            }
            catch (IOException | DataFormatException e) {
                VP.LOG.info("Could not load world save files to build vein cache!", (Throwable)e);
            }
        }
        event.registerServerCommand((ICommand)new RedoServerCacheCommand());
        event.registerServerCommand((ICommand)new RedoServerSpawnCacheCommand());
    }

    public void fmlLifeCycleEvent(FMLServerStartedEvent event) {
    }

    public void fmlLifeCycleEvent(FMLServerStoppingEvent event) {
        ServerCache.instance.saveVeinCache();
        ServerCache.instance.reset();
    }

    public void fmlLifeCycleEvent(FMLServerStoppedEvent event) {
    }
}

