/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import forestry.api.genetics.IFlowerGrowthHelper;
import forestry.api.genetics.IFlowerGrowthRule;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.world.World;

public class GrowthRuleFlowerPot
implements IFlowerGrowthRule {
    @Override
    public boolean growFlower(IFlowerRegistry fr, String flowerType, World world, IIndividual individual, int x, int y, int z) {
        return GrowthRuleFlowerPot.growFlower(flowerType, world, x, y, z);
    }

    @Override
    public boolean growFlower(IFlowerGrowthHelper helper, String flowerType, World world, int x, int y, int z) {
        return GrowthRuleFlowerPot.growFlower(flowerType, world, x, y, z);
    }

    private static boolean growFlower(String flowerType, World world, int x, int y, int z) {
        int flower;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityFlowerPot)) {
            return false;
        }
        TileEntityFlowerPot flowerPotTile = (TileEntityFlowerPot)tile;
        if (flowerPotTile.func_145965_a() != null) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (!(block instanceof BlockFlowerPot)) {
            return false;
        }
        BlockFlowerPot flowerPot = (BlockFlowerPot)block;
        switch (flowerType) {
            case "flowersVanilla": 
            case "flowersSnow": {
                flower = world.field_73012_v.nextInt(2) + 1;
                break;
            }
            case "flowersJungle": {
                flower = 6;
                break;
            }
            case "flowersCacti": {
                flower = world.field_73012_v.nextInt(2) + 9;
                break;
            }
            case "flowersMushrooms": {
                flower = world.field_73012_v.nextInt(2) + 7;
                break;
            }
            default: {
                return false;
            }
        }
        TileEntityFlowerPot newTile = (TileEntityFlowerPot)flowerPot.func_149915_a(world, flower);
        flowerPotTile.func_145964_a(newTile.func_145965_a(), newTile.func_145966_b());
        flowerPotTile.func_70296_d();
        if (!world.func_72921_c(x, y, z, 1, 2)) {
            world.func_147471_g(x, y, z);
        }
        return true;
    }
}

