/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.api.recipes.IFlexibleCrafter;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FakeFlexibleCrafter
implements IFlexibleCrafter {
    private final IFlexibleCrafter original;
    private int[] usedItems;
    private int[] usedFluids;

    public FakeFlexibleCrafter(IFlexibleCrafter original) {
        this.original = original;
        this.usedFluids = new int[original.getCraftingFluidStackSize()];
        this.usedItems = new int[original.getCraftingItemStackSize()];
    }

    @Override
    public ItemStack getCraftingItemStack(int slotId) {
        ItemStack output = this.original.getCraftingItemStack(slotId);
        if (this.usedItems[slotId] == 0) {
            return output;
        }
        if (output.field_77994_a <= this.usedItems[slotId]) {
            return null;
        }
        output = output.func_77946_l();
        output.field_77994_a -= this.usedItems[slotId];
        return output;
    }

    @Override
    public ItemStack decrCraftingItemStack(int slotId, int amount) {
        ItemStack output = this.original.getCraftingItemStack(slotId);
        int result = Math.min(output.field_77994_a - this.usedItems[slotId], amount);
        int n = slotId;
        this.usedItems[n] = this.usedItems[n] + result;
        if (result == 0) {
            return null;
        }
        ItemStack decrOut = output.func_77946_l();
        decrOut.field_77994_a = result;
        return decrOut;
    }

    @Override
    public int getCraftingItemStackSize() {
        return this.usedItems.length;
    }

    @Override
    public FluidStack getCraftingFluidStack(int slotId) {
        FluidStack output = this.original.getCraftingFluidStack(slotId);
        if (this.usedFluids[slotId] == 0) {
            return output;
        }
        if (output.amount <= this.usedFluids[slotId]) {
            return null;
        }
        output = output.copy();
        output.amount -= this.usedFluids[slotId];
        return output;
    }

    @Override
    public FluidStack decrCraftingFluidStack(int slotId, int amount) {
        FluidStack output = this.original.getCraftingFluidStack(slotId);
        int result = Math.min(output.amount - this.usedFluids[slotId], amount);
        int n = slotId;
        this.usedFluids[n] = this.usedFluids[n] + result;
        if (result == 0) {
            return null;
        }
        FluidStack decrOut = output.copy();
        decrOut.amount = result;
        return decrOut;
    }

    @Override
    public int getCraftingFluidStackSize() {
        return this.usedFluids.length;
    }
}

