/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.loader;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.kuba6000.mobsinfo.api.DummyWorld;
import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.IMobInfoProvider;
import com.kuba6000.mobsinfo.api.LoaderReference;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobDropSimplified;
import com.kuba6000.mobsinfo.api.MobOverride;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.api.RandomSequencer;
import com.kuba6000.mobsinfo.api.event.PostMobRegistrationEvent;
import com.kuba6000.mobsinfo.api.event.PostMobsRegistrationEvent;
import com.kuba6000.mobsinfo.api.event.PreMobRegistrationEvent;
import com.kuba6000.mobsinfo.api.event.PreMobsRegistrationEvent;
import com.kuba6000.mobsinfo.api.helper.ProgressBarWrapper;
import com.kuba6000.mobsinfo.api.utils.FastRandom;
import com.kuba6000.mobsinfo.api.utils.GSONUtils;
import com.kuba6000.mobsinfo.api.utils.ItemID;
import com.kuba6000.mobsinfo.api.utils.ModUtils;
import com.kuba6000.mobsinfo.config.Config;
import com.kuba6000.mobsinfo.config.OverridesConfig;
import com.kuba6000.mobsinfo.loader.VanillaMobRecipeLoader;
import com.kuba6000.mobsinfo.loader.extras.ExtraLoader;
import com.kuba6000.mobsinfo.mixin.InfernalMobs.InfernalMobsCoreAccessor;
import com.kuba6000.mobsinfo.mixin.minecraft.EntityAccessor;
import com.kuba6000.mobsinfo.mixin.minecraft.EntityLivingAccessor;
import com.kuba6000.mobsinfo.mixin.minecraft.EntityLivingBaseAccessor;
import com.kuba6000.mobsinfo.mixin.minecraft.EntitySlimeAccessor;
import com.kuba6000.mobsinfo.nei.MobHandler;
import com.kuba6000.mobsinfo.network.LoadConfigPacket;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.common.items.wands.ItemWandCasting;

public class MobRecipeLoader {
    private static final Logger LOG = LogManager.getLogger((String)"mobsinfo[Mob Recipe Loader]");
    private static final String addRandomArmorName = ModUtils.isDeobfuscatedEnvironment ? "addRandomArmor" : "func_82164_bB";
    private static final String enchantEquipmentName = ModUtils.isDeobfuscatedEnvironment ? "enchantEquipment" : "func_82162_bC";
    private static boolean alreadyGenerated = false;
    public static boolean isInGenerationProcess = false;
    public static final String randomEnchantmentDetectedString = "RandomEnchantmentDetected";
    private static final long GET_DROPS_TIMEOUT = (long)(Config.MobHandler.mobTimeout * 1.0E9);
    public static final HashMap<String, GeneralMappedMob> GeneralMobList = new HashMap();
    public static final List<Double> DQRChances = new ArrayList<Double>();
    private static EntityLiving currentEntity = null;

    public static void preGenerationEntityModifiers(EntityLiving entity, String mobName) {
        if (entity instanceof EntitySkeleton && mobName.equals("witherSkeleton")) {
            ((EntitySkeleton)entity).func_82201_a(1);
        } else if (entity instanceof EntitySlime) {
            ((EntitySlimeAccessor)entity).callSetSlimeSize(entity.getClass() == EntityMagmaCube.class ? 2 : 1);
        } else if (entity instanceof EntityBat) {
            ((EntityBat)entity).func_82236_f(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateMobRecipeMap() {
        boolean registeringWitherSkeleton;
        if (alreadyGenerated) {
            return;
        }
        alreadyGenerated = true;
        if (!Config.MobHandler.mobHandlerEnabled) {
            return;
        }
        VanillaMobRecipeLoader.init();
        DummyWorld f = new DummyWorld(){

            @Override
            public boolean func_72838_d(Entity p_72838_1_) {
                if (p_72838_1_ instanceof EntityItem && isInGenerationProcess && currentEntity != null) {
                    currentEntity.func_70099_a(((EntityItem)p_72838_1_).func_92059_d(), 0.0f);
                    return true;
                }
                return false;
            }
        };
        f.field_72995_K = true;
        RandomSequencer frand = new RandomSequencer();
        f.field_73012_v = frand;
        File cache = Config.getConfigFile("MobRecipeLoader.cache");
        Gson gson = GSONUtils.GSON_BUILDER.create();
        String modlistversion = Config.MobHandler.regenerationTrigger == Config.MobHandler._CacheRegenerationTrigger.ModAdditionRemoval ? ModUtils.getModListVersionForMobDrops(false) : ModUtils.getModListVersionForMobDrops(true);
        isInGenerationProcess = true;
        if (Config.MobHandler.regenerationTrigger != Config.MobHandler._CacheRegenerationTrigger.Always && cache.exists()) {
            LOG.info("Parsing Cached map");
            BufferedReader reader = null;
            try {
                reader = Files.newReader((File)cache, (Charset)StandardCharsets.UTF_8);
                MobRecipeLoaderCacheStructure s = (MobRecipeLoaderCacheStructure)gson.fromJson((Reader)reader, MobRecipeLoaderCacheStructure.class);
                if (Config.MobHandler.regenerationTrigger == Config.MobHandler._CacheRegenerationTrigger.Never || s.version.equals(modlistversion)) {
                    ProgressBarWrapper bar = new ProgressBarWrapper("Parsing cached Mob Recipe Map", s.moblist.size());
                    for (Map.Entry<String, ArrayList<MobDrop>> entry : s.moblist.entrySet()) {
                        String mobName = entry.getKey();
                        bar.step(mobName);
                        GeneralMappedMob vanillaMob = VanillaMobRecipeLoader.vanillaMobList.get(mobName);
                        if (vanillaMob != null && (vanillaMob.mob.getClass() == EntityList.field_75625_b.get(mobName) || mobName.equals("witherSkeleton") && !EntityList.field_75625_b.containsKey("witherSkeleton"))) {
                            GeneralMobList.put(mobName, vanillaMob);
                            continue;
                        }
                        try {
                            Object e = mobName.equals("witherSkeleton") && !EntityList.field_75625_b.containsKey("witherSkeleton") ? new EntitySkeleton((World)f) : (EntityLiving)((Class)EntityList.field_75625_b.get(mobName)).getConstructor(World.class).newInstance(new Object[]{f});
                            MobRecipeLoader.preGenerationEntityModifiers((EntityLiving)e, mobName);
                            ArrayList<MobDrop> drops = entry.getValue();
                            if (drops == null) {
                                if (!(e instanceof IMobInfoProvider)) continue;
                                IMobInfoProvider provider = (IMobInfoProvider)e;
                                drops = new ArrayList();
                                provider.provideDropsInformation(drops);
                                for (MobDrop drop : drops) {
                                    drop.clampChance();
                                }
                                GeneralMobList.put(mobName, new GeneralMappedMob((EntityLiving)e, MobRecipe.generateMobRecipe((EntityLiving)e, mobName, drops), drops, true));
                                continue;
                            }
                            drops.forEach(MobDrop::reconstructStack);
                            GeneralMobList.put(mobName, new GeneralMappedMob((EntityLiving)e, MobRecipe.generateMobRecipe((EntityLiving)e, mobName, drops), drops));
                        }
                        catch (Exception e) {}
                    }
                    bar.end();
                    LOG.info("Parsed cached map, skipping generation");
                    isInGenerationProcess = false;
                    return;
                }
                LOG.info("Cached map version mismatch, generating a new one");
            }
            catch (Exception ignored) {
                LOG.warn("There was an exception while parsing cached map, generating a new one");
            }
            finally {
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            LOG.info("Cached map doesn't exist or config option forced, generating a new one");
        }
        LOG.info("Generating Recipe Map for Mob Handler");
        long time = System.currentTimeMillis();
        dropCollector collector = new dropCollector();
        boolean bl = registeringWitherSkeleton = !EntityList.field_75625_b.containsKey("witherSkeleton");
        if (registeringWitherSkeleton) {
            EntityList.field_75625_b.put("witherSkeleton", EntitySkeleton.class);
        }
        ProgressBarWrapper bar = new ProgressBarWrapper("Generating Mob Recipe Map", EntityList.field_75625_b.size());
        EntityList.field_75625_b.forEach((name, entity) -> {
            EntityLiving e;
            bar.step((String)name);
            if (entity == null) {
                return;
            }
            GeneralMappedMob vanillaMob = VanillaMobRecipeLoader.vanillaMobList.get(name);
            if (vanillaMob != null && vanillaMob.mob.getClass() == entity) {
                GeneralMobList.put((String)name, vanillaMob);
                return;
            }
            if (Modifier.isAbstract(entity.getModifiers())) {
                if (Config.Debug.loggingLevel == Config.Debug.LoggingLevel.Detailed) {
                    LOG.info("Entity " + name + " is abstract, skipping");
                }
                return;
            }
            if (!EntityLiving.class.isAssignableFrom((Class<?>)entity)) {
                if (Config.Debug.loggingLevel == Config.Debug.LoggingLevel.Detailed) {
                    LOG.info("Entity " + name + " is not a LivingEntity, skipping");
                }
                return;
            }
            try {
                e = (EntityLiving)entity.getConstructor(World.class).newInstance((Object)f);
            }
            catch (NoSuchMethodException ex) {
                if (Config.Debug.loggingLevel == Config.Debug.LoggingLevel.Detailed) {
                    LOG.info("Entity " + name + " doesn't have constructor, skipping");
                }
                return;
            }
            catch (NoClassDefFoundError ex) {
                if (Config.Debug.loggingLevel == Config.Debug.LoggingLevel.Detailed) {
                    LOG.info("Entity " + name + " is using undefined classes, skipping");
                }
                return;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return;
            }
            if (!(registeringWitherSkeleton && name.equals("witherSkeleton") || !e.func_70005_c_().startsWith("entity."))) {
                LOG.warn("Entity " + name + " doesn't have localized name!");
            }
            try {
                int div;
                int chance;
                e.captureDrops = true;
                MobRecipeLoader.preGenerationEntityModifiers(e, name);
                ((EntityAccessor)e).setRand(frand);
                if (e instanceof IMobInfoProvider) {
                    IMobInfoProvider provider = (IMobInfoProvider)e;
                    boolean illegalOverride = false;
                    Class clazz = entity;
                    while (true) {
                        try {
                            clazz.getDeclaredMethod("provideDropsInformation", ArrayList.class);
                        }
                        catch (Exception exception) {
                            try {
                                clazz.getDeclaredMethod("dropFewItems", Boolean.TYPE, Integer.TYPE);
                                illegalOverride = true;
                            }
                            catch (Exception exception2) {
                                try {
                                    clazz.getDeclaredMethod("dropRareDrop", Integer.TYPE);
                                    illegalOverride = true;
                                }
                                catch (Exception exception3) {
                                    clazz = clazz.getSuperclass();
                                    continue;
                                }
                            }
                        }
                        break;
                    }
                    if (illegalOverride) {
                        LOG.error("Entity {} is implementing IMobInfoProvider interface in its superclass and doesn't override provideDropsInformation WHILE also overriding dropFewItems or dropRareItems! IGNORING this provider and using normal generation!!!", new Object[]{name});
                    } else {
                        ArrayList<MobDrop> moboutputs = new ArrayList<MobDrop>();
                        provider.provideDropsInformation(moboutputs);
                        for (MobDrop moboutput : moboutputs) {
                            moboutput.clampChance();
                        }
                        GeneralMobList.put((String)name, new GeneralMappedMob(e, MobRecipe.generateMobRecipe(e, name, moboutputs), moboutputs, true));
                        return;
                    }
                }
                droplist drops = new droplist();
                droplist raredrops = new droplist();
                droplist superraredrops = new droplist();
                droplist additionaldrops = new droplist();
                droplist dropslooting = new droplist();
                frand.newRound();
                collector.newRound();
                Runnable checkForWitchery = () -> {
                    if (entity.getName().startsWith("com.emoniph.witchery")) {
                        ((EntityLivingBaseAccessor)e).callDropFewItems(true, 0);
                        frand.newRound();
                        frand.exceptionOnEnchantTry = true;
                        boolean enchantmentDetected = false;
                        try {
                            ((EntityLivingBaseAccessor)e).callDropFewItems(true, 0);
                        }
                        catch (Exception ex) {
                            enchantmentDetected = true;
                        }
                        int w = frand.walkCounter;
                        frand.newRound();
                        if (enchantmentDetected) {
                            frand.maxWalkCount = w;
                            collector.booksAlwaysRandomlyEnchanted = true;
                        }
                        e.capturedDrops.clear();
                    }
                };
                ModUtils.TriConsumer<Supplier, droplist, String> doTheDrop = (callerCanceller, dList, dListName) -> {
                    boolean second = false;
                    long start = System.nanoTime();
                    while (((Boolean)callerCanceller.get()).booleanValue()) {
                        collector.addDrop((droplist)dList, e.capturedDrops, frand.chance);
                        if (second && frand.chance < 1.0E-7) {
                            LOG.warn("Skipping " + name + " " + dListName + " dropmap because it's too randomized");
                            break;
                        }
                        if (second && System.nanoTime() - start >= GET_DROPS_TIMEOUT) {
                            LOG.warn("{} {} dropmap took too long, skipping", new Object[]{name, dListName});
                            break;
                        }
                        second = true;
                        if (frand.nextRound()) continue;
                    }
                    frand.newRound();
                    collector.newRound();
                };
                ModUtils.TriConsumer<Supplier, droplist, String> doTheDQRDrop = (callerCanceller, dList, dListName) -> {
                    if (((Boolean)callerCanceller.get()).booleanValue()) {
                        if (e.capturedDrops.size() != DQRChances.size()) {
                            int c = DQRChances.size();
                            DQRChances.clear();
                            throw new RuntimeException("DQR MOB PARSE EXCEPTION -> captured mobs " + e.capturedDrops.size() + " / DQRChances " + c);
                        }
                        for (int i = 0; i < e.capturedDrops.size(); ++i) {
                            dList.add(new dropinstance(((EntityItem)e.capturedDrops.get(i)).func_92059_d(), (droplist)dList), DQRChances.get(i));
                        }
                    }
                    frand.newRound();
                    DQRChances.clear();
                    e.capturedDrops.clear();
                };
                currentEntity = e;
                if (entity.getName().startsWith("dqr.entity.") && !entity.getName().equals("dqr.entity.mobEntity.monsterTensei.DqmEntitySweetbag")) {
                    doTheDQRDrop.accept(() -> {
                        ((EntityLivingBaseAccessor)e).callDropFewItems(true, 0);
                        return true;
                    }, drops, "normal");
                    doTheDQRDrop.accept(() -> {
                        ((EntityLivingBaseAccessor)e).callDropFewItems(true, 1);
                        return true;
                    }, dropslooting, "normal");
                    doTheDQRDrop.accept(() -> {
                        ((EntityLivingBaseAccessor)e).callDropRareDrop(0);
                        return true;
                    }, raredrops, "rare");
                    doTheDQRDrop.accept(() -> {
                        ((EntityLivingBaseAccessor)e).callDropRareDrop(1);
                        return true;
                    }, superraredrops, "rare");
                } else {
                    checkForWitchery.run();
                    doTheDrop.accept(() -> {
                        ((EntityLivingBaseAccessor)e).callDropFewItems(true, 0);
                        return true;
                    }, drops, "normal");
                    checkForWitchery.run();
                    doTheDrop.accept(() -> {
                        ((EntityLivingBaseAccessor)e).callDropFewItems(true, 1);
                        return true;
                    }, dropslooting, "normal");
                    doTheDrop.accept(() -> {
                        ((EntityLivingBaseAccessor)e).callDropRareDrop(0);
                        return true;
                    }, raredrops, "rare");
                    doTheDrop.accept(() -> {
                        ((EntityLivingBaseAccessor)e).callDropRareDrop(1);
                        return true;
                    }, superraredrops, "rare");
                    if (registeringWitherSkeleton && e instanceof EntitySkeleton && name.equals("witherSkeleton")) {
                        dropinstance i = new dropinstance(new ItemStack(Items.field_151052_q), additionaldrops);
                        i.isDamageRandomized = true;
                        int maxdamage = i.stack.func_77958_k();
                        int max = Math.max(maxdamage - 25, 1);
                        for (int d = Math.min(max, 25); d <= max; ++d) {
                            i.damagesPossible.put(d, 1);
                        }
                        additionaldrops.add(i, 1.0);
                    } else {
                        try {
                            boolean detectedException;
                            Class<?> cl = e.getClass();
                            do {
                                detectedException = false;
                                try {
                                    cl.getDeclaredMethod(addRandomArmorName, new Class[0]);
                                }
                                catch (Exception ex) {
                                    detectedException = true;
                                    cl = cl.getSuperclass();
                                }
                            } while (detectedException && !cl.equals(Entity.class));
                            if (cl.equals(EntityLiving.class) || cl.equals(Entity.class)) {
                                throw new Exception();
                            }
                            cl = e.getClass();
                            do {
                                detectedException = false;
                                try {
                                    cl.getDeclaredMethod(enchantEquipmentName, new Class[0]);
                                }
                                catch (Exception ex) {
                                    detectedException = true;
                                    cl = cl.getSuperclass();
                                }
                            } while (detectedException && !cl.equals(EntityLiving.class));
                            boolean usingVanillaEnchantingMethod = cl.equals(EntityLiving.class);
                            double chanceModifierLocal = 1.0;
                            if (entity.getName().startsWith("twilightforest.entity")) {
                                frand.forceFloatValue = 0.0f;
                                chanceModifierLocal = 0.25;
                            }
                            boolean second = false;
                            do {
                                ((EntityLivingAccessor)e).callAddRandomArmor();
                                if (!usingVanillaEnchantingMethod) {
                                    ((EntityLivingAccessor)e).callEnchantEquipment();
                                }
                                ItemStack[] lastActiveItems = e.func_70035_c();
                                int lastActiveItemsLength = lastActiveItems.length;
                                for (int j = 0; j < lastActiveItemsLength; ++j) {
                                    ItemStack stack = lastActiveItems[j];
                                    if (stack == null || LoaderReference.Thaumcraft.isLoaded && stack.func_77973_b() instanceof ItemWandCasting) continue;
                                    int randomenchant = -1;
                                    if (stack.func_77942_o() && stack.field_77990_d.func_74764_b(randomEnchantmentDetectedString)) {
                                        randomenchant = stack.field_77990_d.func_74762_e(randomEnchantmentDetectedString);
                                        stack.field_77990_d.func_82580_o("ench");
                                    }
                                    dropinstance i = additionaldrops.add(new dropinstance(stack.func_77946_l(), additionaldrops), frand.chance * chanceModifierLocal * (usingVanillaEnchantingMethod ? (j == 0 ? 0.75 : 0.5) : 1.0));
                                    if (!i.isDamageRandomized && i.stack.func_77984_f()) {
                                        i.isDamageRandomized = true;
                                        int maxdamage = i.stack.func_77958_k();
                                        int max = Math.max(maxdamage - 25, 1);
                                        for (int d = Math.min(max, 25); d <= max; ++d) {
                                            i.damagesPossible.put(d, 1);
                                        }
                                    }
                                    if (!i.isEnchatmentRandomized && randomenchant != -1) {
                                        i.isEnchatmentRandomized = true;
                                        i.enchantmentLevel = randomenchant;
                                    }
                                    if (!usingVanillaEnchantingMethod) continue;
                                    if (!stack.func_77942_o()) {
                                        stack.field_77990_d = new NBTTagCompound();
                                    }
                                    stack.field_77990_d.func_74768_a(randomEnchantmentDetectedString, 14);
                                    dropinstance newdrop = additionaldrops.add(new dropinstance(stack.func_77946_l(), additionaldrops), frand.chance * chanceModifierLocal * (j == 0 ? 0.25 : 0.5));
                                    newdrop.isEnchatmentRandomized = true;
                                    newdrop.enchantmentLevel = 14;
                                    newdrop.isDamageRandomized = i.isDamageRandomized;
                                    newdrop.damagesPossible = (HashMap)i.damagesPossible.clone();
                                }
                                Arrays.fill(e.func_70035_c(), null);
                                if (second && frand.chance < 1.0E-7) {
                                    LOG.warn("Skipping " + name + " additional dropmap because it's too randomized");
                                    break;
                                }
                                second = true;
                            } while (frand.nextRound());
                        }
                        catch (Exception cl) {
                            // empty catch block
                        }
                    }
                    frand.newRound();
                    collector.newRound();
                }
                currentEntity = null;
                if (drops.isEmpty() && raredrops.isEmpty() && additionaldrops.isEmpty()) {
                    ArrayList<MobDrop> arr = new ArrayList<MobDrop>();
                    GeneralMobList.put((String)name, new GeneralMappedMob(e, MobRecipe.generateMobRecipe(e, name, arr), arr));
                    if (Config.Debug.loggingLevel == Config.Debug.LoggingLevel.Detailed) {
                        LOG.info("Mapped " + name);
                    }
                    return;
                }
                ArrayList<MobDrop> moboutputs = new ArrayList<MobDrop>(drops.size() + raredrops.size() + additionaldrops.size());
                for (dropinstance drop : drops.drops) {
                    ItemStack stack = drop.stack;
                    if (stack.func_77942_o()) {
                        stack.field_77990_d.func_82580_o(randomEnchantmentDetectedString);
                    }
                    if ((chance = drop.getchance(10000)) > 10000) {
                        div = (int)Math.ceil((double)chance / 10000.0);
                        stack.field_77994_a *= div;
                        chance /= div;
                    }
                    dropinstance dlooting = dropslooting.get(drop);
                    moboutputs.add(new MobDrop(stack, MobDrop.DropType.Normal, chance, drop.isEnchatmentRandomized ? Integer.valueOf(drop.enchantmentLevel) : null, drop.isDamageRandomized ? drop.damagesPossible : null, dlooting != null && dlooting.dropcount > drop.dropcount, false));
                }
                for (dropinstance drop : raredrops.drops) {
                    ItemStack stack = drop.stack;
                    if (stack.func_77942_o()) {
                        stack.field_77990_d.func_82580_o(randomEnchantmentDetectedString);
                    }
                    if ((chance = drop.getchance(250)) > 10000) {
                        div = (int)Math.ceil((double)chance / 10000.0);
                        stack.field_77994_a *= div;
                        chance /= div;
                    }
                    moboutputs.add(new MobDrop(stack, MobDrop.DropType.Rare, chance, drop.isEnchatmentRandomized ? Integer.valueOf(drop.enchantmentLevel) : null, drop.isDamageRandomized ? drop.damagesPossible : null, false, false));
                }
                for (dropinstance drop : superraredrops.drops) {
                    if (raredrops.contains(drop)) continue;
                    ItemStack stack = drop.stack;
                    if (stack.func_77942_o()) {
                        stack.field_77990_d.func_82580_o(randomEnchantmentDetectedString);
                    }
                    if ((chance = drop.getchance(50)) > 10000) {
                        div = (int)Math.ceil((double)chance / 10000.0);
                        stack.field_77994_a *= div;
                        chance /= div;
                    }
                    moboutputs.add(new MobDrop(stack, MobDrop.DropType.Rare, chance, drop.isEnchatmentRandomized ? Integer.valueOf(drop.enchantmentLevel) : null, drop.isDamageRandomized ? drop.damagesPossible : null, false, false));
                }
                for (dropinstance drop : additionaldrops.drops) {
                    ItemStack stack = drop.stack;
                    if (stack.func_77942_o()) {
                        stack.field_77990_d.func_82580_o(randomEnchantmentDetectedString);
                    }
                    if ((chance = drop.getchance(850)) > 10000) {
                        div = (int)Math.ceil((double)chance / 10000.0);
                        stack.field_77994_a *= div;
                        chance /= div;
                    }
                    moboutputs.add(new MobDrop(stack, MobDrop.DropType.Additional, chance, drop.isEnchatmentRandomized ? Integer.valueOf(drop.enchantmentLevel) : null, drop.isDamageRandomized ? drop.damagesPossible : null, false, false));
                }
                GeneralMobList.put((String)name, new GeneralMappedMob(e, MobRecipe.generateMobRecipe(e, name, moboutputs), moboutputs));
                if (Config.Debug.loggingLevel == Config.Debug.LoggingLevel.Detailed) {
                    LOG.info("Mapped " + name);
                }
            }
            catch (Throwable ex) {
                currentEntity = null;
                LOG.error("Something went wrong while generating recipes for " + name + ", stacktrace: ");
                ex.printStackTrace();
            }
        });
        if (registeringWitherSkeleton) {
            EntityList.field_75625_b.remove("witherSkeleton");
        }
        time -= System.currentTimeMillis();
        time = -time;
        LOG.info("Recipe map generated! Mapped " + GeneralMobList.size() + " entities! It took " + time + "ms");
        bar.end();
        isInGenerationProcess = false;
        LOG.info("Saving generated map to file");
        MobRecipeLoaderCacheStructure s = new MobRecipeLoaderCacheStructure();
        s.version = modlistversion;
        s.moblist = new HashMap<String, ArrayList<MobDrop>>();
        GeneralMobList.forEach((k, v) -> s.moblist.put((String)k, v.isProvidedFromAPI ? null : v.drops));
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)cache, (Charset)StandardCharsets.UTF_8);
            gson.toJson((Object)s, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static droplist getInfernalDrops() {
        InfernalMobsCoreAccessor infernalMobsCore = (InfernalMobsCoreAccessor)InfernalMobsCore.instance();
        droplist infernaldrops = new droplist();
        LOG.info("Generating Infernal drops");
        double chance = 1.0 / (double)infernalMobsCore.getEliteRarity();
        ArrayList<ItemStack> elitelist = infernalMobsCore.getDropIdListElite();
        for (ItemStack itemStack : elitelist) {
            dropinstance instance = infernaldrops.add(new dropinstance(itemStack.func_77946_l(), infernaldrops), chance / (double)elitelist.size());
            instance.isEnchatmentRandomized = true;
            instance.enchantmentLevel = itemStack.func_77973_b().func_77619_b();
        }
        ArrayList<ItemStack> ultralist = infernalMobsCore.getDropIdListUltra();
        chance *= 1.0 / (double)infernalMobsCore.getUltraRarity();
        for (ItemStack stack : ultralist) {
            dropinstance instance = infernaldrops.add(new dropinstance(stack.func_77946_l(), infernaldrops), chance / (double)ultralist.size());
            instance.isEnchatmentRandomized = true;
            instance.enchantmentLevel = stack.func_77973_b().func_77619_b();
        }
        ArrayList<ItemStack> arrayList = infernalMobsCore.getDropIdListInfernal();
        chance *= 1.0 / (double)infernalMobsCore.getInfernoRarity();
        for (ItemStack stack : arrayList) {
            dropinstance instance = infernaldrops.add(new dropinstance(stack.func_77946_l(), infernaldrops), chance / (double)arrayList.size());
            instance.isEnchatmentRandomized = true;
            instance.enchantmentLevel = stack.func_77973_b().func_77619_b();
        }
        return infernaldrops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File makeCustomDrops() {
        dropCollector collector = new dropCollector();
        HashMap<String, MobOverride> customDropsMap = new HashMap<String, MobOverride>();
        isInGenerationProcess = true;
        for (Map.Entry<String, GeneralMappedMob> mob : GeneralMobList.entrySet()) {
            EntityLiving e = mob.getValue().mob;
            String k = mob.getKey();
            ((EntityAccessor)e).setRand(new FastRandom());
            e.field_70170_p.field_72995_K = false;
            FakePlayer fp = new FakePlayer(FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0], new GameProfile(UUID.nameUUIDFromBytes("[MobRecipeLoader]".getBytes(StandardCharsets.UTF_8)), "[MobRecipeLoader]"));
            droplist dropscustom = new droplist();
            try {
                for (int i = 0; i < 10000; ++i) {
                    if (ForgeHooks.onLivingDrops((EntityLivingBase)e, (DamageSource)DamageSource.func_76365_a((EntityPlayer)fp), (ArrayList)e.capturedDrops, (int)0, (boolean)true, (int)100)) {
                        LOG.warn("Event onLivingDrops for " + k + " has been cancelled, I am gonna ignore that!");
                        break;
                    }
                    collector.addDrop(dropscustom, e.capturedDrops, 1.0E-4);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            e.field_70170_p.field_72995_K = true;
            collector.newRound();
            if (dropscustom.isEmpty()) continue;
            MobOverride override = new MobOverride();
            for (dropinstance drop : dropscustom.drops) {
                int chance;
                ItemStack stack = drop.stack;
                if (stack.func_77942_o()) {
                    stack.field_77990_d.func_82580_o(randomEnchantmentDetectedString);
                }
                if ((chance = drop.getchance(10000)) > 10000) {
                    int div = (int)Math.ceil((double)chance / 10000.0);
                    stack.field_77994_a *= div;
                    chance /= div;
                }
                override.additions.add(new MobDrop(drop.stack, MobDrop.DropType.Normal, chance, drop.isEnchatmentRandomized ? Integer.valueOf(drop.enchantmentLevel) : null, drop.isDamageRandomized ? drop.damagesPossible : null, false, false));
                customDropsMap.put(k, override);
            }
        }
        BufferedWriter writer = null;
        Gson gson = GSONUtils.GSON_BUILDER_PRETTY.create();
        File f = new File("CustomDropsMap.json");
        try {
            writer = Files.newWriter((File)f, (Charset)StandardCharsets.UTF_8);
            gson.toJson(customDropsMap, (Appendable)writer);
            ((Writer)writer).flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            f = null;
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
        isInGenerationProcess = false;
        return f;
    }

    public static void processMobRecipeMap() {
        LOG.info("Loading config");
        Config.synchronizeConfiguration();
        OverridesConfig.LoadConfig();
        if (ModUtils.isClientSided) {
            MobHandler.clearRecipes();
        }
        MobRecipe.MobNameToRecipeMap.clear();
        LoadConfigPacket.instance.mobsToLoad.clear();
        LoadConfigPacket.instance.mobsOverrides.clear();
        MinecraftForge.EVENT_BUS.post((Event)new PreMobsRegistrationEvent());
        for (Map.Entry<String, GeneralMappedMob> entry : GeneralMobList.entrySet()) {
            String k = entry.getKey();
            GeneralMappedMob v = entry.getValue();
            if (Arrays.asList(Config.MobHandler.mobBlacklist).contains(k)) {
                if (Config.Debug.loggingLevel != Config.Debug.LoggingLevel.Detailed) continue;
                LOG.info("Entity {} is blacklisted, skipping", new Object[]{k});
                continue;
            }
            MobRecipe recipe = v.recipe;
            recipe = recipe.copy();
            ArrayList<MobDrop> drops = v.copyDrops();
            recipe.generateSpawnList();
            if (MinecraftForge.EVENT_BUS.post((Event)new PreMobRegistrationEvent(k, drops, recipe))) continue;
            ExtraLoader.process(k, drops, recipe);
            MobOverride override = OverridesConfig.overrides.get(k);
            if (override != null) {
                if (override.removeAll) {
                    drops.clear();
                } else {
                    for (MobDropSimplified removal : override.removals) {
                        drops.removeIf(removal::isMatching);
                    }
                }
                drops.addAll(override.additions);
                LoadConfigPacket.instance.mobsOverrides.put(k, override);
            }
            MinecraftForge.EVENT_BUS.post((Event)new PostMobRegistrationEvent(k, drops, recipe));
            for (MobDrop drop : drops) {
                drop.chanceModifiers.sort(Collections.reverseOrder(Comparator.comparingInt(IChanceModifier::getPriority)));
            }
            recipe.mOutputs.clear();
            recipe.mOutputs.addAll(drops);
            recipe.refresh();
            if (drops.isEmpty()) {
                if (Config.Debug.loggingLevel == Config.Debug.LoggingLevel.Detailed) {
                    LOG.info("Entity " + k + " doesn't drop any items");
                }
                if (!Config.MobHandler.includeEmptyMobs) continue;
            }
            MobRecipe.MobNameToRecipeMap.put(k, recipe);
            LoadConfigPacket.instance.mobsToLoad.add(k);
            if (Config.Debug.loggingLevel != Config.Debug.LoggingLevel.Detailed) continue;
            LOG.info("Registered " + k);
        }
        LOG.info("Registered " + MobRecipe.MobNameToRecipeMap.size() + " entities!");
        MinecraftForge.EVENT_BUS.post((Event)new PostMobsRegistrationEvent());
    }

    @SideOnly(value=Side.CLIENT)
    public static void processMobRecipeMap(HashSet<String> mobs, HashMap<String, MobOverride> overrides) {
        MobHandler.clearRecipes();
        MobRecipe.MobNameToRecipeMap.clear();
        MinecraftForge.EVENT_BUS.post((Event)new PreMobsRegistrationEvent());
        mobs.forEach(k -> {
            GeneralMappedMob v = GeneralMobList.get(k);
            MobRecipe recipe = v.recipe;
            recipe = recipe.copy();
            ArrayList<MobDrop> drops = v.copyDrops();
            recipe.generateSpawnList();
            if (MinecraftForge.EVENT_BUS.post((Event)new PreMobRegistrationEvent((String)k, drops, recipe))) {
                return;
            }
            ExtraLoader.process(k, drops, recipe);
            recipe.mOutputs.clear();
            recipe.mOutputs.addAll(drops);
            MobOverride override = (MobOverride)overrides.get(k);
            if (override != null) {
                if (override.removeAll) {
                    drops.clear();
                    recipe.mOutputs.clear();
                } else {
                    for (MobDropSimplified removal : override.removals) {
                        drops.removeIf(removal::isMatching);
                        recipe.mOutputs.removeIf(removal::isMatching);
                    }
                }
                drops.addAll(override.additions);
                recipe.mOutputs.addAll(override.additions);
            }
            MinecraftForge.EVENT_BUS.post((Event)new PostMobRegistrationEvent((String)k, drops, recipe));
            for (MobDrop drop : drops) {
                drop.chanceModifiers.sort(Collections.reverseOrder(Comparator.comparingInt(IChanceModifier::getPriority)));
            }
            drops.sort(Comparator.comparing(d -> d.type));
            recipe.refresh();
            MobRecipe.MobNameToRecipeMap.put((String)k, recipe);
            MobHandler.addRecipe(v.mob, drops);
            if (Config.Debug.loggingLevel == Config.Debug.LoggingLevel.Detailed) {
                LOG.info("Registered " + k);
            }
        });
        MinecraftForge.EVENT_BUS.post((Event)new PostMobsRegistrationEvent());
        LOG.info("Registered " + MobRecipe.MobNameToRecipeMap.size() + " entities!");
        LOG.info("Sorting NEI map");
        MobHandler.sortCachedRecipes();
    }

    private static class MobRecipeLoaderCacheStructure {
        String version;
        Map<String, ArrayList<MobDrop>> moblist;

        private MobRecipeLoaderCacheStructure() {
        }
    }

    public static class GeneralMappedMob {
        public final EntityLiving mob;
        public final MobRecipe recipe;
        public final ArrayList<MobDrop> drops;
        public final boolean isProvidedFromAPI;

        public GeneralMappedMob(EntityLiving mob, MobRecipe recipe, ArrayList<MobDrop> drops) {
            this.mob = mob;
            this.recipe = recipe;
            this.drops = drops;
            this.isProvidedFromAPI = false;
        }

        public GeneralMappedMob(EntityLiving mob, MobRecipe recipe, ArrayList<MobDrop> drops, boolean isProvidedFromAPI) {
            this.mob = mob;
            this.recipe = recipe;
            this.drops = drops;
            this.isProvidedFromAPI = isProvidedFromAPI;
        }

        public ArrayList<MobDrop> copyDrops() {
            ArrayList<MobDrop> copy = new ArrayList<MobDrop>(this.drops.size());
            for (MobDrop drop : this.drops) {
                copy.add(drop.copy());
            }
            return copy;
        }
    }

    private static class dropCollector {
        final HashMap<ItemID, Integer> damagableChecker = new HashMap();
        private boolean booksAlwaysRandomlyEnchanted = false;

        private dropCollector() {
        }

        public void addDrop(droplist fdrops, ArrayList<EntityItem> listToParse, double chance) {
            for (EntityItem entityItem : listToParse) {
                ItemStack ostack = entityItem.func_92059_d();
                if (ostack == null) continue;
                boolean randomchomenchantdetected = ostack.func_77942_o() && ostack.field_77990_d.func_74764_b(MobRecipeLoader.randomEnchantmentDetectedString);
                int randomenchantmentlevel = 0;
                if (randomchomenchantdetected) {
                    randomenchantmentlevel = ostack.field_77990_d.func_74762_e(MobRecipeLoader.randomEnchantmentDetectedString);
                    ostack.field_77990_d.func_82580_o("ench");
                    ostack.field_77990_d.func_74768_a(MobRecipeLoader.randomEnchantmentDetectedString, 0);
                }
                if ((this.booksAlwaysRandomlyEnchanted || randomchomenchantdetected) && Items.field_151134_bR == ostack.func_77973_b()) {
                    NBTTagCompound tagCompound = (NBTTagCompound)ostack.field_77990_d.func_74737_b();
                    tagCompound.func_82580_o("StoredEnchantments");
                    ostack = new ItemStack(Items.field_151122_aG, ostack.field_77994_a, 0);
                    if (!tagCompound.func_82582_d()) {
                        ostack.field_77990_d = tagCompound;
                    }
                    if (randomenchantmentlevel == 0) {
                        randomenchantmentlevel = 1;
                    }
                    randomchomenchantdetected = true;
                }
                boolean randomdamagedetected = false;
                int newdamage = -1;
                if (ostack.func_77984_f()) {
                    int odamage = ostack.func_77960_j();
                    ostack.func_77964_b(1);
                    ItemID id = ItemID.createNoCopy(ostack);
                    this.damagableChecker.putIfAbsent(id, odamage);
                    int check = this.damagableChecker.get(id);
                    if (check != odamage) {
                        randomdamagedetected = true;
                        newdamage = odamage;
                        ostack.func_77964_b(check);
                    } else {
                        ostack.func_77964_b(odamage);
                    }
                }
                dropinstance drop = fdrops.add(new dropinstance(ostack.func_77946_l(), fdrops), chance);
                if (!drop.isEnchatmentRandomized && randomchomenchantdetected) {
                    drop.isEnchatmentRandomized = true;
                    drop.enchantmentLevel = randomenchantmentlevel;
                }
                if (drop.isDamageRandomized && !randomdamagedetected) {
                    drop.damagesPossible.merge(drop.stack.func_77960_j(), 1, Integer::sum);
                }
                if (!randomdamagedetected) continue;
                if (!drop.isDamageRandomized) {
                    drop.isDamageRandomized = true;
                    drop.damagesPossible.merge(drop.stack.func_77960_j(), drop.dropcount - 1, Integer::sum);
                }
                if (newdamage == -1) {
                    newdamage = drop.stack.func_77960_j();
                }
                drop.damagesPossible.merge(newdamage, 1, Integer::sum);
            }
            listToParse.clear();
        }

        public void newRound() {
            this.damagableChecker.clear();
            this.booksAlwaysRandomlyEnchanted = false;
        }
    }

    public static class droplist {
        private final ArrayList<dropinstance> drops = new ArrayList();
        private final HashMap<ItemID, Integer> dropschecker = new HashMap();

        public dropinstance add(dropinstance i, double chance) {
            if (this.contains(i)) {
                int ssize = i.stack.field_77994_a;
                i = this.get(this.dropschecker.get(i.itemId));
                i.dropchance += chance * (double)ssize;
                i.dropcount += ssize;
                return i;
            }
            this.drops.add(i);
            i.dropchance += chance * (double)i.stack.field_77994_a;
            i.dropcount += i.stack.field_77994_a - 1;
            i.stack.field_77994_a = 1;
            this.dropschecker.put(i.itemId, this.drops.size() - 1);
            return i;
        }

        public dropinstance get(int index) {
            return this.drops.get(index);
        }

        public dropinstance get(dropinstance i) {
            if (!this.contains(i)) {
                return null;
            }
            return this.get(this.dropschecker.get(i.itemId));
        }

        public boolean contains(dropinstance i) {
            return this.dropschecker.containsKey(i.itemId);
        }

        public boolean contains(ItemStack stack) {
            return this.dropschecker.containsKey(ItemID.createNoCopy(stack));
        }

        public boolean isEmpty() {
            return this.drops.isEmpty();
        }

        public int size() {
            return this.drops.size();
        }

        public int indexOf(dropinstance i) {
            if (!this.contains(i)) {
                return -1;
            }
            return this.dropschecker.get(i.itemId);
        }
    }

    public static class dropinstance {
        public boolean isDamageRandomized = false;
        public HashMap<Integer, Integer> damagesPossible = new HashMap();
        public boolean isEnchatmentRandomized = false;
        public int enchantmentLevel = 0;
        public final ItemStack stack;
        public final ItemID itemId;
        private double dropchance = 0.0;
        private int dropcount = 1;

        public dropinstance(ItemStack s, droplist owner) {
            this.stack = s;
            this.itemId = ItemID.createNoCopy(this.stack);
        }

        public int getchance(int chancemodifier) {
            this.dropchance = (double)Math.round(this.dropchance * 100000.0) / 100000.0;
            return (int)(this.dropchance * (double)chancemodifier);
        }

        public int hashCode() {
            return this.itemId.hashCode();
        }
    }
}

