/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import com.google.common.collect.UnmodifiableIterator;
import com.kuba6000.mobsinfo.api.LoaderReference;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.SpawnInfo;
import com.kuba6000.mobsinfo.api.helper.EnderIOHelper;
import com.kuba6000.mobsinfo.api.helper.InfernalMobsCoreHelper;
import com.kuba6000.mobsinfo.loader.MobRecipeLoader;
import com.kuba6000.mobsinfo.mixin.InfernalMobs.InfernalMobsCoreAccessor;
import jas.spawner.modern.MVELProfile;
import jas.spawner.modern.spawner.biome.group.BiomeHelper;
import jas.spawner.modern.spawner.biome.structure.StructureHandler;
import jas.spawner.modern.spawner.biome.structure.StructureHandlerRegistry;
import jas.spawner.modern.spawner.creature.entry.BiomeSpawnListRegistry;
import jas.spawner.modern.spawner.creature.entry.SpawnListEntry;
import jas.spawner.modern.spawner.creature.handler.LivingHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.lang3.tuple.Pair;

public class MobRecipe {
    public final ArrayList<MobDrop> mOutputs;
    public int mMaxDamageChance;
    public final boolean infernalityAllowed;
    public final boolean alwaysinfernal;
    public static MobRecipeLoader.droplist infernaldrops;
    public final boolean isPeacefulAllowed;
    public final EntityLiving entity;
    public final float maxEntityHealth;
    public final boolean isUsableInVial;
    public final String entityName;
    public HashSet<SpawnInfo> spawnList;
    public static HashMap<String, MobRecipe> MobNameToRecipeMap;
    public static HashMap<String, ArrayList<Pair<BiomeGenBase, BiomeGenBase.SpawnListEntry>>> MobNameToBiomeSpawnList;
    public static HashMap<String, ArrayList<String>> MobNameToStructureList;

    public MobRecipe copy() {
        return new MobRecipe((ArrayList)this.mOutputs.clone(), this.mMaxDamageChance, this.infernalityAllowed, this.alwaysinfernal, this.isPeacefulAllowed, this.entity, this.maxEntityHealth, this.isUsableInVial, this.entityName, this.spawnList == null ? null : (HashSet)this.spawnList.clone());
    }

    private MobRecipe(ArrayList<MobDrop> mOutputs, int mMaxDamageChance, boolean infernalityAllowed, boolean alwaysinfernal, boolean isPeacefulAllowed, EntityLiving entity, float maxEntityHealth, boolean isUsable, String entityName, HashSet<SpawnInfo> spawnList) {
        this.mOutputs = mOutputs;
        this.mMaxDamageChance = mMaxDamageChance;
        this.infernalityAllowed = infernalityAllowed;
        this.alwaysinfernal = alwaysinfernal;
        this.isPeacefulAllowed = isPeacefulAllowed;
        this.entity = entity;
        this.maxEntityHealth = maxEntityHealth;
        this.isUsableInVial = isUsable;
        this.entityName = entityName;
        this.spawnList = spawnList;
    }

    public static MobRecipe generateMobRecipe(EntityLiving e, String entityID, ArrayList<MobDrop> outputs) {
        return new MobRecipe(e, entityID, outputs);
    }

    private MobRecipe(EntityLiving e, String entityID, ArrayList<MobDrop> outputs) {
        if (LoaderReference.InfernalMobs.isLoaded) {
            InfernalMobsCoreAccessor infernalMobsCore = (InfernalMobsCoreAccessor)InfernalMobsCore.instance();
            if (infernaldrops == null) {
                infernaldrops = MobRecipeLoader.getInfernalDrops();
            }
            this.infernalityAllowed = InfernalMobsCoreHelper.callIsClassAllowed((InfernalMobsCore)infernalMobsCore, (EntityLivingBase)e);
            this.alwaysinfernal = infernalMobsCore.callCheckEntityClassForced((EntityLivingBase)e);
        } else {
            this.infernalityAllowed = false;
            this.alwaysinfernal = false;
        }
        if (infernaldrops == null) {
            infernaldrops = new MobRecipeLoader.droplist();
        }
        this.isPeacefulAllowed = !(e instanceof IMob);
        this.mOutputs = (ArrayList)outputs.clone();
        int maxdamagechance = 0;
        for (MobDrop o : this.mOutputs) {
            if (o.damages == null) continue;
            for (int v : o.damages.values()) {
                maxdamagechance += v;
            }
        }
        this.mMaxDamageChance = maxdamagechance;
        this.maxEntityHealth = e.func_110138_aP();
        this.entity = e;
        this.isUsableInVial = EnderIOHelper.canEntityBeCapturedWithSoulVial((Entity)e, entityID);
        this.entityName = entityID;
    }

    public void generateSpawnList() {
        ArrayList<String> structs;
        if (MobNameToBiomeSpawnList == null) {
            MobNameToBiomeSpawnList = new HashMap();
            MobNameToStructureList = new HashMap();
            BiomeSpawnListRegistry biomeList = BiomeGenBase.func_150565_n();
            if (LoaderReference.JustAnotherSpawner.isLoaded) {
                BiomeSpawnListRegistry biomeSpawnListRegistry = MVELProfile.worldSettings().biomeSpawnListRegistry();
                for (BiomeSpawnListRegistry biome : biomeList) {
                    if (biome == null) continue;
                    new SpawnInfo.SpawnInfoBiome((BiomeGenBase)biome);
                    for (SpawnListEntry spawnListEntry : biomeSpawnListRegistry.getSpawnListFor(BiomeHelper.getPackageName((BiomeGenBase)biome))) {
                        LivingHandler handler = spawnListEntry.getLivingHandler();
                        if (handler.namedJASSpawnables.isEmpty()) continue;
                        for (String namedJASSpawnable : handler.namedJASSpawnables) {
                            Class entityClass = (Class)biomeSpawnListRegistry.livingGroupRegistry.jasNametoEntityClass().get((Object)namedJASSpawnable);
                            if (entityClass == null) continue;
                            MobNameToBiomeSpawnList.computeIfAbsent((String)EntityList.field_75626_c.get(entityClass), s -> new ArrayList()).add(Pair.of((Object)biome, null));
                        }
                    }
                }
                StructureHandlerRegistry structureHandlerRegistry = MVELProfile.worldSettings().structureHandlerRegistry();
                for (StructureHandler registryhandler : structureHandlerRegistry.handlers()) {
                    for (String structureKey : registryhandler.getStructureKeys()) {
                        new SpawnInfo.SpawnInfoStructure(structureKey);
                        for (SpawnListEntry spawnListEntry : registryhandler.getStructureSpawnList(structureKey)) {
                            LivingHandler handler = spawnListEntry.getLivingHandler();
                            if (handler.namedJASSpawnables.isEmpty()) continue;
                            for (String namedJASSpawnable : handler.namedJASSpawnables) {
                                Class entityClass = (Class)MVELProfile.worldSettings().livingGroupRegistry().jasNametoEntityClass().get((Object)namedJASSpawnable);
                                if (entityClass == null) continue;
                                MobNameToStructureList.computeIfAbsent((String)EntityList.field_75626_c.get(entityClass), s -> new ArrayList()).add(structureKey);
                            }
                        }
                    }
                }
            }
            for (Object biome : biomeList) {
                if (biome == null) continue;
                new SpawnInfo.SpawnInfoBiome((BiomeGenBase)biome);
                for (UnmodifiableIterator type : EnumCreatureType.values()) {
                    List spawnableList = biome.func_76747_a((EnumCreatureType)type);
                    if (spawnableList == null) continue;
                    for (BiomeGenBase.SpawnListEntry entry : spawnableList) {
                        MobNameToBiomeSpawnList.computeIfAbsent((String)EntityList.field_75626_c.get(entry.field_76300_b), s -> new ArrayList()).add(Pair.of((Object)biome, (Object)entry));
                    }
                }
            }
        }
        ArrayList<Pair<BiomeGenBase, BiomeGenBase.SpawnListEntry>> ar = MobNameToBiomeSpawnList.get(this.entityName);
        this.spawnList = new HashSet();
        if (ar != null) {
            for (Pair pair : ar) {
                this.spawnList.add(new SpawnInfo.SpawnInfoBiome((BiomeGenBase)pair.getKey()));
            }
        }
        if ((structs = MobNameToStructureList.get(this.entityName)) != null) {
            for (String struct : structs) {
                this.spawnList.add(new SpawnInfo.SpawnInfoStructure(struct));
            }
        }
    }

    public void refresh() {
        int maxdamagechance = 0;
        for (MobDrop o : this.mOutputs) {
            if (o.damages == null) continue;
            for (int v : o.damages.values()) {
                maxdamagechance += v;
            }
        }
        this.mMaxDamageChance = maxdamagechance;
    }

    public ItemStack[] generateRandomOutputs(World world, Random rnd, int lootinglevel, boolean includePlayerOnlyLoot, boolean includeInfernalDropsIfPossible) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.mOutputs.size());
        for (MobDrop o : this.mOutputs) {
            int chance = o.chance;
            if (o.playerOnly && !includePlayerOnlyLoot) continue;
            int amount = o.stack.field_77994_a;
            if (o.lootable && lootinglevel > 0 && (chance += lootinglevel * 5000) > 10000) {
                int div = (int)Math.ceil((double)chance / 10000.0);
                amount *= div;
                chance /= div;
            }
            if (chance != 10000 && rnd.nextInt(10000) >= chance) continue;
            ItemStack s = o.stack.func_77946_l();
            s.field_77994_a = amount;
            if (o.enchantable != null) {
                EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)s, (int)o.enchantable);
            }
            if (o.damages != null) {
                int rChance = rnd.nextInt(this.mMaxDamageChance);
                int cChance = 0;
                for (Map.Entry<Integer, Integer> damage : o.damages.entrySet()) {
                    if (rChance > (cChance += damage.getValue().intValue())) continue;
                    s.func_77964_b(damage.getKey().intValue());
                    break;
                }
            }
            stacks.add(s);
        }
        if (LoaderReference.InfernalMobs.isLoaded && includeInfernalDropsIfPossible) {
            InfernalMobsCoreAccessor infernalMobsCore = (InfernalMobsCoreAccessor)InfernalMobsCore.instance();
            if (this.infernalityAllowed && !InfernalMobsCoreHelper.getDimensionBlackList((InfernalMobsCore)infernalMobsCore).contains(world.field_73011_w.field_76574_g)) {
                int p = 0;
                if (this.alwaysinfernal || rnd.nextInt(infernalMobsCore.getEliteRarity()) == 0) {
                    p = 1;
                    if (rnd.nextInt(infernalMobsCore.getUltraRarity()) == 0) {
                        p = 2;
                        if (rnd.nextInt(infernalMobsCore.getInfernoRarity()) == 0) {
                            p = 3;
                        }
                    }
                }
                ArrayList<ItemStack> infernalstacks = null;
                if (p > 0) {
                    infernalstacks = p == 1 ? infernalMobsCore.getDropIdListElite() : (p == 2 ? infernalMobsCore.getDropIdListUltra() : infernalMobsCore.getDropIdListInfernal());
                }
                if (infernalstacks != null) {
                    ItemStack infernalstack = infernalstacks.get(rnd.nextInt(infernalstacks.size())).func_77946_l();
                    EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)infernalstack, (int)infernalstack.func_77973_b().func_77619_b());
                    stacks.add(infernalstack);
                }
            }
        }
        return stacks.toArray(new ItemStack[0]);
    }

    public EntityLiving createEntityCopy() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        EntityLiving entityCopy = (EntityLiving)this.entity.getClass().getConstructor(World.class).newInstance(this.entity.field_70170_p);
        MobRecipeLoader.preGenerationEntityModifiers(entityCopy, this.entityName);
        return entityCopy;
    }

    public static MobRecipe getRecipeByEntityName(String mobName) {
        return MobNameToRecipeMap.get(mobName);
    }

    public static ArrayList<Pair<BiomeGenBase, BiomeGenBase.SpawnListEntry>> getBiomeSpawnListByMobName(String mobName) {
        return MobNameToBiomeSpawnList.get(mobName);
    }

    public static Set<SpawnInfo> getSpawnListByMobName(String mobName) {
        if (!MobNameToRecipeMap.containsKey(mobName)) {
            return Collections.emptySet();
        }
        return MobRecipe.MobNameToRecipeMap.get((Object)mobName).spawnList;
    }

    static {
        MobNameToRecipeMap = new HashMap();
        MobNameToBiomeSpawnList = null;
        MobNameToStructureList = null;
    }
}

