/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tuhljin.automagy.blocks.ModBlockTorch;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.lib.NeighborNotifier;
import tuhljin.automagy.tiles.TileEntityTorchInversion;

public class BlockTorchInversion
extends ModBlockTorch {
    private boolean isLit;
    private static Map overloadDetect = new HashMap();

    public BlockTorchInversion(String name, boolean lit) {
        super(name, lit);
        this.isLit = lit;
        if (lit) {
            this.func_149715_a(0.5f);
        }
    }

    private boolean handleOverloadDetection(World world, int x, int y, int z, boolean lit) {
        if (!overloadDetect.containsKey(world)) {
            overloadDetect.put(world, new ArrayList());
        }
        List list = (List)overloadDetect.get(world);
        if (lit) {
            list.add(new Toggle(x, y, z, world.func_82737_E()));
        }
        int l = 0;
        for (int i1 = 0; i1 < list.size(); ++i1) {
            Toggle toggle = (Toggle)list.get(i1);
            if (toggle.x != x || toggle.y != y || toggle.z != z || ++l < 30) continue;
            return true;
        }
        return false;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return this.isLit ? new TileEntityTorchInversion() : null;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess blockaccess, int x, int y, int z, int side) {
        TileEntity te;
        if (this.isLit && (te = blockaccess.func_147438_o(x, y, z)) instanceof TileEntityTorchInversion) {
            return ((TileEntityTorchInversion)te).getRedstoneSignalStrength();
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess blockaccess, int x, int y, int z, int side) {
        return side == 0 ? this.func_149709_b(blockaccess, x, y, z, side) : 0;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        boolean removed = this.func_150108_b(world, x, y, z, block);
        if (!removed) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        if (this.isLit) {
            NeighborNotifier.notifyBlocksOfExtendedNeighborChange(world, x, y, z, (Block)this);
        }
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
    }

    public int func_149738_a(World world) {
        return 2;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        List list = (List)overloadDetect.get(world);
        while (list != null && !list.isEmpty() && world.func_82737_E() - ((Toggle)list.get((int)0)).time > 60L) {
            list.remove(0);
        }
        if (this.isLit) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileEntityTorchInversion) {
                TileEntityTorchInversion teTI = (TileEntityTorchInversion)te;
                int prev = teTI.getRedstoneSignalStrength();
                int strength = this.getPowerIntoAttachedBlock(world, x, y, z);
                if ((strength = 15 - strength) != prev && this.handleOverloadDetection(world, x, y, z, true)) {
                    strength = 0;
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                    for (int l = 0; l < 5; ++l) {
                        double d0 = (double)x + rand.nextDouble() * 0.6 + 0.2;
                        double d1 = (double)y + rand.nextDouble() * 0.6 + 0.2;
                        double d2 = (double)z + rand.nextDouble() * 0.6 + 0.2;
                        world.func_72869_a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (strength == 0) {
                    world.func_147465_d(x, y, z, ModBlocks.torchInversion_off, world.func_72805_g(x, y, z), 3);
                } else if (strength != prev) {
                    teTI.setRedstoneSignalStrength(strength);
                    NeighborNotifier.notifyBlocksOfExtendedNeighborChange(world, x, y, z, (Block)this);
                }
            }
        } else if (this.getPowerIntoAttachedBlock(world, x, y, z) < 15 && !this.handleOverloadDetection(world, x, y, z, false)) {
            world.func_147465_d(x, y, z, ModBlocks.torchInversion_on, world.func_72805_g(x, y, z), 3);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.isLit) {
            int l = world.func_72805_g(x, y, z);
            double d0 = (double)((float)x + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)y + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)z + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d3 = 0.22f;
            double d4 = 0.27f;
            if (l == 1) {
                world.func_72869_a("reddust", d0 - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            } else if (l == 2) {
                world.func_72869_a("reddust", d0 + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            } else if (l == 3) {
                world.func_72869_a("reddust", d0, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
            } else if (l == 4) {
                world.func_72869_a("reddust", d0, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
            } else {
                world.func_72869_a("reddust", d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)ModBlocks.torchInversion_on);
    }

    public boolean func_149667_c(Block block) {
        return block == ModBlocks.torchInversion_off || block == ModBlocks.torchInversion_on;
    }

    static class Toggle {
        int x;
        int y;
        int z;
        long time;
        private static final String __OBFID = "CL_00000299";

        public Toggle(int x, int y, int z, long time) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.time = time;
        }
    }
}

