/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.multipart.microblock;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.IFaceRenderer;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IMicroMaterialRender;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.rwtema.extrautils.multipart.microblock.IFence;
import com.rwtema.extrautils.multipart.microblock.IMicroBlock;
import com.rwtema.extrautils.multipart.microblock.ItemMicroBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public abstract class PartMicroBlock
extends JCuboidPart
implements JIconHitEffects,
IFaceRenderer,
IMicroMaterialRender,
JNormalOcclusion,
IFence,
IMicroBlock {
    public MicroMaterialRegistry.IMicroMaterial mat = null;
    int material;
    boolean overEthereal = false;

    public PartMicroBlock() {
    }

    public PartMicroBlock(int material) {
        this.material = material;
    }

    public boolean isEthereal() {
        return false;
    }

    @Override
    public boolean hideCreativeTab() {
        return false;
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    public void harvest(MovingObjectPosition hit, EntityPlayer player) {
        super.harvest(hit, player);
    }

    public void renderFace(Vertex5[] face, int side) {
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeInt(this.material);
    }

    public void readDesc(MCDataInput packet) {
        this.material = packet.readInt();
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74778_a("mat", MicroMaterialRegistry.materialName((int)this.material));
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.material = MicroMaterialRegistry.materialID((String)tag.func_74779_i("mat"));
    }

    public abstract Iterable<Cuboid6> getCollisionBoxes();

    public ItemStack getItemDrop() {
        ItemStack item = new ItemStack((Item)ItemMicroBlock.instance, 1, this.getMetadata());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("mat", MicroMaterialRegistry.materialName((int)this.material));
        item.func_77982_d(tag);
        return item;
    }

    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(this.getItemDrop());
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItemDrop();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingIcon(Object subPart, int side) {
        return this.getBrokenIcon(side);
    }

    public MicroMaterialRegistry.IMicroMaterial getMaterial() {
        if (this.mat == null) {
            this.mat = MicroMaterialRegistry.getMaterial((int)this.material);
        }
        return this.mat;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBrokenIcon(int side) {
        if (this.mat != null) {
            return this.mat.getBreakingIcon(side);
        }
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void addDestroyEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer, (boolean)false);
    }

    public Cuboid6 getRenderBounds() {
        return this.getBounds();
    }

    public int getLightValue() {
        return MicroMaterialRegistry.getMaterial((int)this.material).getLightValue();
    }

    public void onNeighborChanged() {
        this.reloadShape();
    }

    public void drop() {
        TileMultipart.dropItem((ItemStack)this.getItemDrop(), (World)this.world(), (Vector3)Vector3.fromTileEntityCenter((TileEntity)this.tile()));
        this.tile().remPart((TMultiPart)this);
    }

    public void onPartChanged(TMultiPart part) {
        this.reloadShape();
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        ArrayList<IndexedCuboid6> boxes = new ArrayList<IndexedCuboid6>();
        this.overEthereal = true;
        for (Cuboid6 cuboid6 : this.getCollisionBoxes()) {
            boxes.add(new IndexedCuboid6((Object)0, cuboid6));
        }
        this.overEthereal = false;
        return boxes;
    }

    public void onWorldJoin() {
        this.reloadShape();
        super.onWorldJoin();
    }

    public abstract void reloadShape();

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        this.reloadShape();
        if (this.mat == null) {
            this.mat = MicroMaterialRegistry.getMaterial((int)this.material);
        }
        if (this.mat != null && this.mat.canRenderInPass(pass)) {
            this.render(pos, pass);
            return true;
        }
        return false;
    }

    public abstract void render(Vector3 var1, int var2);

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return this.getMaterial().getStrength(player);
    }
}

