/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.item;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.init.BlockList;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.mechanics.energy.EnergyChunkData;
import chylex.hee.mechanics.enhancements.EnhancementHandler;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.EnergySavefile;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.ItemUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityEnergyCluster;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ItemAbstractEnergyAcceptor
extends Item {
    public abstract boolean canAcceptEnergy(ItemStack var1);

    public abstract void onEnergyAccepted(ItemStack var1);

    public abstract int getEnergyPerUse(ItemStack var1);

    protected abstract float getRegenSpeedMultiplier();

    public static void enhanceCapacity(ItemStack is) {
        int prev = is.func_77973_b().func_77612_l();
        int now = is.func_77958_k();
        is.func_77964_b(is.func_77960_j() + (now - prev));
    }

    public final int calculateMaxDamage(ItemStack is, Enum capacityEnhancement) {
        return EnhancementHandler.hasEnhancement(is, capacityEnhancement) ? MathUtil.ceil(1.5f * (float)super.getMaxDamage(is)) : super.getMaxDamage(is);
    }

    public void func_77663_a(ItemStack is, World world, Entity entity, int slot, boolean isHeld) {
        if (!this.canAcceptEnergy(is)) {
            return;
        }
        NBTTagCompound nbt = ItemUtil.getTagRoot(is, true);
        if (nbt.func_74764_b("engDrain") && entity instanceof EntityPlayer) {
            boolean stop = false;
            BlockPosM loc = BlockPosM.tmp(nbt.func_74763_f("engDrain"));
            byte wait = nbt.func_74771_c("engWait");
            if (!world.field_72995_K && Math.abs((double)nbt.func_74760_g("engDist") - MathUtil.distance((double)loc.x + 0.5 - entity.field_70165_t, (double)loc.y + 0.5 - entity.field_70163_u, (double)loc.z + 0.5 - entity.field_70161_v)) > 0.05) {
                stop = true;
            } else if (wait > 0) {
                nbt.func_74774_a("engWait", (byte)(wait - 1));
            } else {
                TileEntity tile = loc.getTileEntity((IBlockAccess)world);
                if (tile instanceof TileEntityEnergyCluster) {
                    TileEntityEnergyCluster cluster = (TileEntityEnergyCluster)tile;
                    if (cluster.data.drainEnergyUnit()) {
                        cluster.synchronize();
                        if (!world.field_72995_K) {
                            this.onEnergyAccepted(is);
                            CausatumUtils.increase((EntityPlayer)entity, CausatumMeters.END_ENERGY, 0.12f);
                        } else {
                            Random rand = world.field_73012_v;
                            for (int a = 0; a < 26; ++a) {
                                HardcoreEnderExpansion.fx.energyClusterMoving(world, (double)cluster.field_145851_c + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2, (double)cluster.field_145848_d + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2, (double)cluster.field_145849_e + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2, ((double)rand.nextFloat() - 0.5) * 0.4, ((double)rand.nextFloat() - 0.5) * 0.4, ((double)rand.nextFloat() - 0.5) * 0.4, cluster.getColor(0), cluster.getColor(1), cluster.getColor(2));
                            }
                        }
                    } else {
                        stop = true;
                    }
                } else {
                    stop = true;
                }
                if (!stop) {
                    nbt.func_74774_a("engWait", (byte)4);
                }
            }
            if (stop) {
                nbt.func_82580_o("engDrain");
                nbt.func_82580_o("engWait");
                nbt.func_82580_o("engDist");
            }
        }
        if (world.field_73011_w.field_76574_g == 1) {
            short timer = nbt.func_74765_d("engRgnTim");
            if ((float)(timer = (short)(timer + 1)) <= (float)(42 + world.field_73012_v.nextInt(20)) / this.getRegenSpeedMultiplier()) {
                nbt.func_74777_a("engRgnTim", timer);
                return;
            }
            nbt.func_74777_a("engRgnTim", (short)0);
            EnergyChunkData chunk = ((EnergySavefile)WorldDataHandler.get(EnergySavefile.class)).getFromBlockCoords(world, (int)entity.field_70165_t, (int)entity.field_70161_v, true);
            if (chunk.drainEnergyUnit()) {
                this.onEnergyAccepted(is);
                if (entity instanceof EntityPlayer) {
                    CausatumUtils.increase((EntityPlayer)entity, CausatumMeters.END_ENERGY, 0.12f);
                }
            }
        }
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        NBTTagCompound nbt = ItemUtil.getTagRoot(is, true);
        if (BlockPosM.tmp(x, y, z).getBlock((IBlockAccess)world) == BlockList.energy_cluster && this.canAcceptEnergy(is)) {
            if (nbt.func_74764_b("engDrain")) {
                nbt.func_82580_o("engDrain");
                nbt.func_82580_o("engWait");
                nbt.func_82580_o("engDist");
            } else if (BlockPosM.tmp(x, y, z).getTileEntity((IBlockAccess)world) instanceof TileEntityEnergyCluster) {
                nbt.func_74772_a("engDrain", BlockPosM.tmp(x, y, z).toLong());
                nbt.func_74776_a("engDist", (float)MathUtil.distance((double)x + 0.5 - player.field_70165_t, (double)y + 0.5 - player.field_70163_u, (double)z + 0.5 - player.field_70161_v));
            }
            return true;
        }
        return false;
    }

    public void damageItem(ItemStack is, EntityLivingBase owner) {
        is.func_77972_a(this.getEnergyPerUse(is), owner);
    }
}

