/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.render.IRenderLabel;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityDrawersRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private final RenderItem itemRenderer = new RenderItem(){
        private final RenderBlocks renderBlocksRi = new RenderBlocks();

        public byte getMiniBlockCount(ItemStack stack, byte original) {
            return 1;
        }

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }

        public void renderItemIntoGUI(FontRenderer fontRenderer, TextureManager texManager, ItemStack itemStack, int x, int y, boolean renderEffect) {
            if (itemStack.func_94608_d() == 0 && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)itemStack.func_77973_b()).func_149645_b())) {
                this.renderItemIntoGUIBlock(fontRenderer, texManager, itemStack, x, y, renderEffect);
                return;
            }
            Item item = itemStack.func_77973_b();
            int meta = itemStack.func_77960_j();
            ResourceLocation loc = itemStack.func_77973_b().func_77623_v() ? (item.func_94901_k() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c) : texManager.func_130087_a(itemStack.func_94608_d());
            for (int i = 0; i < item.getRenderPasses(meta); ++i) {
                IIcon icon;
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                texManager.func_110577_a(loc);
                IIcon iIcon = icon = itemStack.func_77973_b().func_77623_v() ? item.getIcon(itemStack, i) : itemStack.func_77954_c();
                if (icon == null) continue;
                int color = itemStack.func_77973_b().func_82790_a(itemStack, i);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                if (this.field_77024_a) {
                    GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
                }
                GL11.glEnable((int)32823);
                GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                GL11.glEnable((int)3008);
                this.func_94149_a(x, y, icon, 16, 16);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                if (renderEffect && itemStack.hasEffect(i)) {
                    this.renderEffect(texManager, x, y);
                }
                GL11.glDisable((int)32823);
            }
        }

        public void renderEffect(TextureManager manager, int x, int y) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            manager.func_110577_a(RES_ITEM_GLINT);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)1.0f);
            this.renderGlint(x, y, 16, 16);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }

        private void renderGlint(int x, int y, int w, int h) {
            for (int i = 0; i < 2; ++i) {
                OpenGlHelper.func_148821_a((int)772, (int)1, (int)0, (int)0);
                float uScale = 0.00390625f;
                float vScale = 0.00390625f;
                float u = (float)(Minecraft.func_71386_F() % (long)(3000 + i * 1873)) / (3000.0f + (float)(i * 1873)) * 256.0f;
                float v = 0.0f;
                float hScale = i < 1 ? 4.0f : -1.0f;
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)(x + 0), (double)(y + h), 0.0, (double)((u + (float)h * hScale) * uScale), (double)((v + (float)h) * vScale));
                tessellator.func_78374_a((double)(x + w), (double)(y + h), 0.0, (double)((u + (float)w + (float)h * hScale) * uScale), (double)((v + (float)h) * vScale));
                tessellator.func_78374_a((double)(x + w), (double)(y + 0), 0.0, (double)((u + (float)w) * uScale), (double)((v + 0.0f) * vScale));
                tessellator.func_78374_a((double)(x + 0), (double)(y + 0), 0.0, (double)((u + 0.0f) * uScale), (double)((v + 0.0f) * vScale));
                tessellator.func_78381_a();
            }
        }

        private void renderItemIntoGUIBlock(FontRenderer fontRenderer, TextureManager texManager, ItemStack itemStack, int x, int y, boolean renderEffect) {
            texManager.func_110577_a(TextureMap.field_110575_b);
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            if (block.func_149701_w() != 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            } else {
                GL11.glAlphaFunc((int)516, (float)0.5f);
                GL11.glDisable((int)3042);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x - 2), (float)(y + 3), (float)(this.field_77023_b - 3.0f));
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int color = itemStack.func_77973_b().func_82790_a(itemStack, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            if (this.field_77024_a) {
                GL11.glColor4f((float)(r * 1.0f), (float)(g * 1.0f), (float)(b * 1.0f), (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)32823);
            GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
            this.renderBlocksRi.field_147844_c = this.field_77024_a;
            this.renderBlocksRi.func_147800_a(block, itemStack.func_77960_j(), 1.0f);
            this.renderBlocksRi.field_147844_c = true;
            GL11.glDisable((int)32823);
            if (block.func_149701_w() == 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
            GL11.glPopMatrix();
        }
    };
    private final float[] itemOffset2X = new float[]{0.5f, 0.5f};
    private final float[] itemOffset2Y = new float[]{10.25f, 2.25f};
    private final float[] itemOffset4X = new float[]{0.25f, 0.25f, 0.75f, 0.75f};
    private final float[] itemOffset4Y = new float[]{10.25f, 2.25f, 10.25f, 2.25f};
    private final float[] itemOffset3X = new float[]{0.5f, 0.25f, 0.75f};
    private final float[] itemOffset3Y = new float[]{9.75f, 2.25f, 2.25f};
    private final RenderBlocks renderBlocks = new RenderBlocks();
    private float brightness;
    private static final float unit = 0.0625f;
    private final boolean[] renderAsBlock = new boolean[4];
    private final ItemStack[] renderStacks = new ItemStack[4];
    private static final float[] sideRotationY = new float[]{0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 3.0f};
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f};
    private static final float[] offsetX = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTickTime) {
        TileEntityDrawers tileDrawers = (TileEntityDrawers)tile;
        if (tileDrawers == null) {
            return;
        }
        if (tileDrawers.isShrouded() || tileDrawers.isSealed()) {
            return;
        }
        Block block = tile.func_145831_w().func_147439_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        if (!(block instanceof BlockDrawers)) {
            return;
        }
        float depth = ((BlockDrawers)block).halfDepth ? 0.5f : 1.0f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        this.itemRenderer.func_76976_a(RenderManager.field_78727_a);
        ForgeDirection side = ForgeDirection.getOrientation((int)tileDrawers.getDirection());
        int ambLight = tile.func_145831_w().func_72802_i(tile.field_145851_c + side.offsetX, tile.field_145848_d + side.offsetY, tile.field_145849_e + side.offsetZ, 0);
        int lu = ambLight % 65536;
        int lv = ambLight / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lu, (float)lv);
        this.brightness = tile.func_145831_w().func_72801_o(tile.field_145851_c + side.offsetX, tile.field_145848_d + side.offsetY, tile.field_145849_e + side.offsetZ) * 1.25f;
        if (this.brightness > 1.0f) {
            this.brightness = 1.0f;
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean cache = mc.field_71474_y.field_74347_j;
        mc.field_71474_y.field_74347_j = true;
        try {
            if (StorageDrawers.config.isFancyItemRenderEnabled()) {
                this.renderFancyItemSet(tileDrawers, side, depth);
            } else {
                this.renderFastItemSet(tileDrawers, side, depth, partialTickTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        mc.field_71474_y.field_74347_j = cache;
        GL11.glPopMatrix();
    }

    private void renderFancyItemSet(TileEntityDrawers tile, ForgeDirection side, float depth) {
        boolean restoreGLState = false;
        boolean isLightingEnabled = false;
        boolean isBlendEnabled = false;
        int drawerCount = tile.getDrawerCount();
        for (int i = 0; i < drawerCount; ++i) {
            IDrawer drawer;
            ItemStack itemStack;
            if (!tile.isDrawerEnabled(i) || (itemStack = (drawer = tile.getDrawer(i)).getStoredItemPrototype()) == null) continue;
            if (!restoreGLState) {
                restoreGLState = true;
                isLightingEnabled = GL11.glIsEnabled((int)2896);
                isBlendEnabled = GL11.glIsEnabled((int)3042);
            }
            this.renderFancyItem(itemStack, tile, i, side, depth);
        }
        if (restoreGLState) {
            if (isLightingEnabled) {
                GL11.glEnable((int)2896);
            } else {
                GL11.glDisable((int)2896);
            }
            if (isBlendEnabled) {
                GL11.glEnable((int)3042);
            } else {
                GL11.glDisable((int)3042);
            }
        }
    }

    private void renderFastItemSet(TileEntityDrawers tile, ForgeDirection side, float depth, float partialTickTime) {
        int i;
        int drawerCount = tile.getDrawerCount();
        boolean restoreItemState = false;
        boolean restoreBlockState = false;
        for (i = 0; i < drawerCount; ++i) {
            IDrawer drawer;
            ItemStack itemStack;
            this.renderStacks[i] = null;
            if (!tile.isDrawerEnabled(i) || (itemStack = (drawer = tile.getDrawer(i)).getStoredItemPrototype()) == null) continue;
            this.renderStacks[i] = itemStack;
            this.renderAsBlock[i] = this.isItemBlockType(itemStack);
            if (this.renderAsBlock[i]) {
                restoreBlockState = true;
                continue;
            }
            restoreItemState = true;
        }
        if (restoreItemState || restoreBlockState) {
            GL11.glPushAttrib((int)24640);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i] == null || this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, i, side, depth, partialTickTime);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i] == null || !this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, i, side, depth, partialTickTime);
        }
        if (restoreItemState || restoreBlockState) {
            GL11.glPopAttrib();
        }
    }

    private void renderFancyItem(ItemStack itemStack, TileEntityDrawers tile, int slot, ForgeDirection side, float depth) {
        float relScale;
        int drawerCount = tile.getDrawerCount();
        boolean isBlockType = this.isItemBlockType(itemStack);
        BlockDrawers block = (BlockDrawers)tile.func_145838_q();
        float xunit = this.getXOffset(drawerCount, slot);
        float yunit = this.getYOffset(drawerCount, slot);
        float zunit = isBlockType ? 1.95f * block.getTrimDepth() : block.getTrimDepth();
        float xc = 0.0f;
        float zc = 0.0f;
        float itemDepth = depth + 0.001f;
        float f = relScale = tile.getDrawerCount() == 1 ? 2.0f : 1.0f;
        if (isBlockType) {
            try {
                Block itemBlock = Block.func_149634_a((Item)itemStack.func_77973_b());
                itemBlock.func_149719_a((IBlockAccess)tile.func_145831_w(), 0, 0, 0);
                itemBlock.func_149683_g();
                double zDepth = (double)(1.0f / relScale) - itemBlock.func_149693_C();
                itemDepth = (float)((double)itemDepth + zDepth * (double)zunit);
            }
            catch (Exception itemBlock) {
                // empty catch block
            }
        }
        switch (tile.getDirection()) {
            case 3: {
                xc = xunit;
                zc = itemDepth - zunit;
                break;
            }
            case 2: {
                xc = 1.0f - xunit;
                zc = 1.0f - itemDepth + zunit;
                break;
            }
            case 5: {
                xc = itemDepth - zunit;
                zc = 1.0f - xunit;
                break;
            }
            case 4: {
                xc = 1.0f - itemDepth + zunit;
                zc = xunit;
            }
        }
        float yAdj = 0.0f;
        if (drawerCount == 2 || drawerCount == 4) {
            yAdj = -0.5f;
        } else if (drawerCount == 1) {
            yAdj = -3.0f;
        }
        GL11.glPushMatrix();
        if (isBlockType) {
            GL11.glTranslatef((float)xc, (float)(0.0625f * (yunit + 1.75f + yAdj)), (float)zc);
            GL11.glScalef((float)(1.0f * relScale), (float)(1.0f * relScale), (float)(1.0f * relScale));
            GL11.glRotatef((float)(this.getRotationYForSide(side) + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)xc, (float)(0.0625f * (yunit + 0.75f + yAdj)), (float)zc);
            GL11.glScalef((float)(0.5f * relScale), (float)(0.5f * relScale), (float)(0.5f * relScale));
            GL11.glRotatef((float)this.getRotationYForSide(side), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        try {
            EntityItem itemEnt = new EntityItem(null, 0.0, 0.0, 0.0, itemStack);
            itemEnt.field_70290_d = 0.0f;
            this.itemRenderer.func_76986_a(itemEnt, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glPopMatrix();
    }

    private void renderFastItem(ItemStack itemStack, TileEntityDrawers tile, int slot, ForgeDirection side, float depth, float partialTickTime) {
        String itemBlockName;
        boolean skipRenderHook = false;
        Block itemBlock = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (itemBlock != null && (itemBlockName = GameData.getBlockRegistry().func_148750_c((Object)itemBlock)) != null && itemBlockName.equals("Mariculture:tanks")) {
            skipRenderHook = true;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int drawerCount = tile.getDrawerCount();
        float xunit = this.getXOffset(drawerCount, slot);
        float yunit = this.getYOffset(drawerCount, slot);
        float size = drawerCount == 1 ? 0.5f : 0.25f;
        BlockDrawers block = (BlockDrawers)tile.func_145838_q();
        GL11.glPushMatrix();
        this.alignRendering(side);
        this.moveRendering(size, this.getOffsetXForSide(side, xunit) * 16.0f - 8.0f * size, 12.25f - yunit, 1.0f - depth + block.getTrimDepth() - 0.005f);
        List<IRenderLabel> renderHandlers = StorageDrawers.renderRegistry.getRenderHandlers();
        int n = renderHandlers.size();
        for (int i = 0; i < n; ++i) {
            renderHandlers.get(i).render(tile, tile, slot, this.brightness, partialTickTime);
        }
        GL11.glPushMatrix();
        if (drawerCount == 1) {
            GL11.glScalef((float)2.6f, (float)2.6f, (float)1.0f);
            GL11.glRotatef((float)171.6f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)84.9f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glScalef((float)1.92f, (float)1.92f, (float)1.0f);
            GL11.glRotatef((float)169.2f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)79.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2977);
        try {
            if (skipRenderHook || !ForgeHooksClient.renderInventoryItem((RenderBlocks)this.renderBlocks, (TextureManager)mc.field_71446_o, (ItemStack)itemStack, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
                this.itemRenderer.renderItemIntoGUI(mc.field_71466_p, mc.field_71446_o, itemStack, 0, 0, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glPopMatrix();
    }

    private boolean isItemBlockType(ItemStack itemStack) {
        return itemStack.func_94608_d() == 0 && itemStack.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)itemStack.func_77973_b()).func_149645_b());
    }

    private float getXOffset(int drawerCount, int slot) {
        switch (drawerCount) {
            case 1: {
                return 0.5f;
            }
            case 2: {
                return this.itemOffset2X[slot];
            }
            case 3: {
                return this.itemOffset3X[slot];
            }
            case 4: {
                return this.itemOffset4X[slot];
            }
        }
        return 0.0f;
    }

    private float getYOffset(int drawerCount, int slot) {
        switch (drawerCount) {
            case 1: {
                return 8.25f;
            }
            case 2: {
                return this.itemOffset2Y[slot];
            }
            case 3: {
                return this.itemOffset3Y[slot];
            }
            case 4: {
                return this.itemOffset4Y[slot];
            }
        }
        return 0.0f;
    }

    private void alignRendering(ForgeDirection side) {
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)this.getRotationYForSide2D(side), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    private void moveRendering(float size, float offsetX, float offsetY, float offsetZ) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)offsetZ);
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)-1.0E-4f);
        GL11.glTranslatef((float)offsetX, (float)offsetY, (float)0.0f);
        GL11.glScalef((float)size, (float)size, (float)1.0f);
    }

    private float getRotationYForSide(ForgeDirection side) {
        return sideRotationY[side.ordinal()] * 90.0f;
    }

    private float getRotationYForSide2D(ForgeDirection side) {
        return sideRotationY2D[side.ordinal()] * 90.0f;
    }

    private float getOffsetXForSide(ForgeDirection side, float x) {
        return Math.abs(offsetX[side.ordinal()] - x);
    }
}

