/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.items.behaviours;

import codechicken.lib.math.MathHelper;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourNone;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.entity.projectile.EntityLightningAttack;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.helpers.ChargingHelper;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechTools;
import ic2.api.item.IElectricItemManager;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Behaviour_Electric_Lighter
extends BehaviourNone {
    private final String mTooltip = GTLanguageManager.addStringLocalization("gt.behaviour.lighter.tooltip", "Can light things on Fire");
    private final String mTooltipUses = GTLanguageManager.addStringLocalization("gt.behaviour.lighter.uses", "Remaining Uses:");
    private final String mTooltipUnstackable = GTLanguageManager.addStringLocalization("gt.behaviour.unstackable", "Not usable when stacked!");

    @Override
    public boolean onLeftClickEntity(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (!aPlayer.field_70170_p.field_72995_K && aStack != null && aStack.field_77994_a == 1) {
            boolean rOutput = false;
            if (aEntity instanceof EntityCreeper && (this.prepare(aStack) || aPlayer.field_71075_bZ.field_75098_d)) {
                GTUtility.sendSoundToPlayers(aPlayer.field_70170_p, SoundResource.FIRE_IGNITE, 1.0f, 1.0f, MathHelper.floor_double((double)aEntity.field_70165_t), MathHelper.floor_double((double)aEntity.field_70163_u), MathHelper.floor_double((double)aEntity.field_70161_v));
                ((EntityCreeper)aEntity).func_146079_cb();
                rOutput = true;
            }
            return rOutput;
        }
        return false;
    }

    @Override
    public boolean onItemUse(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ) {
        if (!aWorld.field_72995_K && aStack != null && aStack.field_77994_a == 1) {
            if (aPlayer.func_70093_af()) {
                Logger.INFO("Changing Mode");
                boolean aCurrentMode = NBTUtils.getBoolean(aStack, "aFireballMode");
                Logger.INFO("Is currently in Fireball mode? " + aCurrentMode);
                boolean aNewMode = !aCurrentMode;
                Logger.INFO("Is now set to Fireball mode? " + aNewMode);
                aStack.func_77978_p().func_74757_a("aFireballMod", aNewMode);
                PlayerUtils.messagePlayer(aPlayer, "Current Mode: " + EnumChatFormatting.RED + (aNewMode ? "Projectile" : "Fire Starter"));
            } else {
                boolean aCurrentMode = NBTUtils.getBoolean(aStack, "aFireballMode");
                if (aCurrentMode) {
                    aWorld.func_72956_a((Entity)aPlayer, "random.bow", 0.5f, 0.4f / (GTPPCore.RANDOM.nextFloat() * 0.4f + 0.8f));
                    if (!aWorld.field_72995_K) {
                        aWorld.func_72838_d((Entity)new EntityLightningAttack(aWorld, (EntityLivingBase)aPlayer, hitX, hitY, hitZ));
                    }
                } else {
                    Logger.WARNING("Preparing Lighter a");
                    boolean rOutput = false;
                    ForgeDirection tDirection = ForgeDirection.getOrientation((int)ordinalSide);
                    if (GTUtility.isBlockAir(aWorld, aX += tDirection.offsetX, aY += tDirection.offsetY, aZ += tDirection.offsetZ) && aPlayer.func_82247_a(aX, aY, aZ, ordinalSide, aStack)) {
                        Logger.WARNING("Preparing Lighter b");
                        if (this.prepare(aStack) || aPlayer.field_71075_bZ.field_75098_d) {
                            Logger.WARNING("Preparing Lighter c");
                            GTUtility.sendSoundToPlayers(aWorld, SoundResource.FIRE_IGNITE, 1.0f, 1.0f, aX, aY, aZ);
                            aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
                            rOutput = true;
                            return rOutput;
                        }
                    }
                }
            }
        }
        Logger.WARNING("Preparing Lighter z");
        return false;
    }

    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ) {
        if (!aWorld.field_72995_K && aStack != null && aStack.field_77994_a == 1) {
            if (aPlayer.func_70093_af()) {
                Logger.INFO("Changing Mode");
                boolean aCurrentMode = NBTUtils.getBoolean(aStack, "aFireballMode");
                Logger.INFO("Is currently in Fireball mode? " + aCurrentMode);
                boolean aNewMode = !aCurrentMode;
                Logger.INFO("Is now set to Fireball mode? " + aNewMode);
                aStack.func_77978_p().func_74757_a("aFireballMode", aNewMode);
                PlayerUtils.messagePlayer(aPlayer, "Current Mode: " + EnumChatFormatting.RED + (aNewMode ? "Projectile" : "Fire Starter"));
            } else {
                boolean aCurrentMode = NBTUtils.getBoolean(aStack, "aFireballMode");
                if (aCurrentMode) {
                    aWorld.func_72956_a((Entity)aPlayer, "random.bow", 0.5f, 0.4f / (GTPPCore.RANDOM.nextFloat() * 0.4f + 0.8f));
                    if (!aWorld.field_72995_K) {
                        aWorld.func_72838_d((Entity)new EntityLightningAttack(aWorld, (EntityLivingBase)aPlayer, hitX, hitY, hitZ));
                    }
                } else {
                    Logger.WARNING("Preparing Lighter a");
                    boolean rOutput = false;
                    ForgeDirection tDirection = ForgeDirection.getOrientation((int)ordinalSide);
                    if (GTUtility.isBlockAir(aWorld, aX += tDirection.offsetX, aY += tDirection.offsetY, aZ += tDirection.offsetZ) && aPlayer.func_82247_a(aX, aY, aZ, ordinalSide, aStack)) {
                        Logger.WARNING("Preparing Lighter b");
                        if (this.prepare(aStack) || aPlayer.field_71075_bZ.field_75098_d) {
                            Logger.WARNING("Preparing Lighter c");
                            GTUtility.sendSoundToPlayers(aWorld, SoundResource.FIRE_IGNITE, 1.0f, 1.0f, aX, aY, aZ);
                            aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
                            rOutput = true;
                            return rOutput;
                        }
                    }
                }
            }
        }
        Logger.WARNING("Preparing Lighter z");
        return false;
    }

    private boolean prepare(ItemStack aStack) {
        if (aStack != null) {
            Logger.WARNING("Preparing Lighter 1");
            if (aStack.func_77973_b() instanceof MetaGeneratedGregtechTools) {
                Logger.WARNING("Preparing Lighter 2");
                if (ChargingHelper.isItemValid(aStack)) {
                    Logger.WARNING("Preparing Lighter 3");
                    Item item = aStack.func_77973_b();
                    if (item instanceof IElectricItemManager) {
                        IElectricItemManager aItemElec = (IElectricItemManager)item;
                        Logger.WARNING("Preparing Lighter 4");
                        double aCharge = aItemElec.getCharge(aStack);
                        long aEuCost = 8192L;
                        if (aCharge >= (double)aEuCost) {
                            Logger.WARNING("Preparing Lighter 5");
                            aItemElec.discharge(aStack, (double)aEuCost, 3, true, true, false);
                            return true;
                        }
                    }
                }
            }
        }
        Logger.WARNING("Preparing Lighter 0");
        return false;
    }

    private void useUp(ItemStack aStack) {
    }

    @Override
    public List<String> getAdditionalToolTips(MetaBaseItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        int aUses = 0;
        if (aStack != null && aStack.func_77973_b() instanceof MetaGeneratedGregtechTools) {
            boolean aCurrentMode;
            Item item;
            if (ChargingHelper.isItemValid(aStack) && (item = aStack.func_77973_b()) instanceof IElectricItemManager) {
                IElectricItemManager aItemElec = (IElectricItemManager)item;
                double aCharge = aItemElec.getCharge(aStack);
                long aEuCost = 8192L;
                aUses = (int)(aCharge / (double)aEuCost);
            }
            if (!NBTUtils.hasTagCompound(aStack)) {
                NBTUtils.createEmptyTagCompound(aStack);
            }
            if (NBTUtils.hasKey(aStack, "aFireballMode")) {
                aCurrentMode = NBTUtils.getBoolean(aStack, "aFireballMode");
            } else {
                aStack.func_77978_p().func_74757_a("aFireballMode", false);
                aCurrentMode = false;
            }
            aList.add("Current Mode: " + EnumChatFormatting.RED + (aCurrentMode ? "Projectile" : "Fire Starter"));
        }
        aList.add(this.mTooltipUses + " " + aUses);
        aList.add(this.mTooltipUnstackable);
        return aList;
    }
}

