/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.werkstoff_loaders.recipe;

import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import bartworks.util.Pair;
import gregtech.api.enums.Element;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourDataOrb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CellLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (!werkstoff.hasItemType(OrePrefixes.cell)) {
            return;
        }
        if ((werkstoff.getStats().isElektrolysis() || werkstoff.getStats().isCentrifuge()) && !werkstoff.hasItemType(OrePrefixes.dust)) {
            ArrayList<FluidStack> flOutputs = new ArrayList<FluidStack>();
            ArrayList<ItemStack> stOutputs = new ArrayList<ItemStack>();
            Element[] tracker = new HashMap();
            int cells = 0;
            for (Pair container : werkstoff.getContents().getValue().toArray(new Pair[0])) {
                FluidStack tmpFl;
                if (container.getKey() instanceof Materials) {
                    if ((((Materials)container.getKey()).hasCorrespondingGas() || ((Materials)container.getKey()).hasCorrespondingFluid() || ((Materials)container.getKey()).mIconSet == TextureSet.SET_FLUID) && ((Materials)container.getKey()).getDust(0) == null) {
                        tmpFl = ((Materials)container.getKey()).getGas(1000L * (long)((Integer)container.getValue()).intValue());
                        if (tmpFl == null || tmpFl.getFluid() == null) {
                            tmpFl = ((Materials)container.getKey()).getFluid(1000L * (long)((Integer)container.getValue()).intValue());
                        }
                        flOutputs.add(tmpFl);
                        if (flOutputs.size() <= 1) continue;
                        if (!tracker.containsKey(container.getKey())) {
                            stOutputs.add(((Materials)container.getKey()).getCells((Integer)container.getValue()));
                            tracker.put((ISubTagContainer)container.getKey(), new Pair<Integer, Integer>((Integer)container.getValue(), stOutputs.size() - 1));
                        } else {
                            stOutputs.add(((Materials)container.getKey()).getCells((Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                            stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                        }
                        cells += ((Integer)container.getValue()).intValue();
                        continue;
                    }
                    if (((Materials)container.getKey()).getDust((Integer)container.getValue()) == null) continue;
                    if (!tracker.containsKey(container.getKey())) {
                        stOutputs.add(((Materials)container.getKey()).getDust((Integer)container.getValue()));
                        tracker.put((ISubTagContainer)container.getKey(), new Pair<Integer, Integer>((Integer)container.getValue(), stOutputs.size() - 1));
                        continue;
                    }
                    stOutputs.add(((Materials)container.getKey()).getDust((Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                    stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                    continue;
                }
                if (!(container.getKey() instanceof Werkstoff)) continue;
                if (((Werkstoff)container.getKey()).getStats().isGas() || ((Werkstoff)container.getKey()).hasItemType(OrePrefixes.cell)) {
                    tmpFl = ((Werkstoff)container.getKey()).getFluidOrGas(1000 * (Integer)container.getValue());
                    if (tmpFl == null || tmpFl.getFluid() == null) {
                        tmpFl = ((Werkstoff)container.getKey()).getFluidOrGas(1000 * (Integer)container.getValue());
                    }
                    flOutputs.add(tmpFl);
                    if (flOutputs.size() <= 1) continue;
                    if (!tracker.containsKey(container.getKey())) {
                        stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.cell, (Integer)container.getValue()));
                        tracker.put((ISubTagContainer)container.getKey(), new Pair<Integer, Integer>((Integer)container.getValue(), stOutputs.size() - 1));
                    } else {
                        stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.cell, (Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                        stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                    }
                    cells += ((Integer)container.getValue()).intValue();
                    continue;
                }
                if (!((Werkstoff)container.getKey()).hasItemType(OrePrefixes.dust)) continue;
                if (!tracker.containsKey(container.getKey())) {
                    stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.dust, (Integer)container.getValue()));
                    tracker.put((ISubTagContainer)container.getKey(), new Pair<Integer, Integer>((Integer)container.getValue(), stOutputs.size() - 1));
                    continue;
                }
                stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.dust, (Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
            }
            ItemStack input = werkstoff.get(OrePrefixes.cell);
            input.field_77994_a = 1;
            int cellEmpty = cells - 1;
            stOutputs.add(Materials.Empty.getCells(-cellEmpty));
            if (werkstoff.getStats().isElektrolysis()) {
                RecipeMaps.electrolyzerRecipes.add(new GTRecipe(true, new ItemStack[]{input, cellEmpty > 0 ? Materials.Empty.getCells(cellEmpty) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{!flOutputs.isEmpty() ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() * (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0));
            }
            if (werkstoff.getStats().isCentrifuge()) {
                RecipeMaps.centrifugeRecipes.add(new GTRecipe(true, new ItemStack[]{input, cellEmpty > 0 ? Materials.Empty.getCells(cellEmpty) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{!flOutputs.isEmpty() ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoff.getStats().getMass() * (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 5, 0));
            }
        }
        GTUtility.addFluidContainerData(new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)werkstoff)), 1000), werkstoff.get(OrePrefixes.cell), Materials.Empty.getCells(1)));
        FluidContainerRegistry.registerFluidContainer((Fluid)werkstoff.getFluidOrGas(1).getFluid(), (ItemStack)werkstoff.get(OrePrefixes.cell), (ItemStack)Materials.Empty.getCells(1));
        if (Mods.Forestry.isModLoaded()) {
            FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)werkstoff)), 1000), werkstoff.get(OrePrefixes.capsule), GTModHandler.getModItem(Mods.Forestry.ID, "waxCapsule", 1L), true);
            GTUtility.addFluidContainerData(emptyData);
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)emptyData);
        }
        if (werkstoff.hasItemType(OrePrefixes.dust)) {
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dust)).fluidOutputs(werkstoff.getFluidOrGas(1000)).duration(werkstoff.getStats().getMass()).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo(RecipeMaps.fluidExtractionRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1)).itemOutputs(werkstoff.get(OrePrefixes.dust)).fluidInputs(werkstoff.getFluidOrGas(1000)).duration((int)werkstoff.getStats().getMass()).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo(RecipeMaps.fluidSolidifierRecipes);
        }
        if (Werkstoff.Types.ELEMENT.equals((Object)werkstoff.getType())) {
            Materials werkstoffBridgeMaterial = null;
            boolean ElementSet = false;
            for (Element e : Element.values()) {
                if (!e.toString().equals(werkstoff.getToolTip())) continue;
                werkstoffBridgeMaterial = werkstoff.getBridgeMaterial() != null ? werkstoff.getBridgeMaterial() : new Materials(-1, werkstoff.getTexSet(), 0.0f, 0, 0, false, werkstoff.getDefaultName(), werkstoff.getDefaultName());
                werkstoffBridgeMaterial.mElement = e;
                e.mLinkedMaterials.add(werkstoffBridgeMaterial);
                ElementSet = true;
                werkstoff.setBridgeMaterial(werkstoffBridgeMaterial);
                break;
            }
            if (!ElementSet) {
                return;
            }
            GTOreDictUnificator.addAssociation(OrePrefixes.cell, werkstoffBridgeMaterial, werkstoff.get(OrePrefixes.cell), false);
            ItemStack scannerOutput = ItemList.Tool_DataOrb.get(1L, new Object[0]);
            BehaviourDataOrb.setDataTitle(scannerOutput, "Elemental-Scan");
            BehaviourDataOrb.setDataName(scannerOutput, werkstoff.getToolTip());
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.cell)).itemOutputs(scannerOutput).special(ItemList.Tool_DataOrb.get(1L, new Object[0])).duration(werkstoffBridgeMaterial.getMass() * 8192L).eut(TierEU.RECIPE_LV).noOptimize().ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes);
        }
    }
}

