/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.processingLoaders;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.common.loaders.BioCultureLoader;
import bartworks.common.loaders.BioItemList;
import bartworks.common.loaders.FluidLoader;
import bartworks.common.loaders.ItemRegistry;
import bartworks.system.material.BWNonMetaMaterialItems;
import bartworks.system.material.WerkstoffLoader;
import bartworks.system.material.processingLoaders.AddSomeRecipes;
import bartworks.util.BioCulture;
import bartworks.util.BioDNA;
import bartworks.util.BioData;
import bartworks.util.BioPlasmid;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourDataOrb;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AdditionalRecipes {
    private static void runBWRecipes() {
        FluidStack[] easyFluids;
        FluidStack[] dnaFluid = new FluidStack[]{Mods.Gendustry.isModLoaded() ? FluidRegistry.getFluidStack((String)"liquiddna", (int)1000) : Materials.Biomass.getFluid(1000L)};
        for (ItemStack stack : BioItemList.getAllPetriDishes()) {
            BioData bioData = BioData.getBioDataFromNBTTag(stack.func_77978_p().func_74775_l("DNA"));
            if (bioData == null) continue;
            ItemStack Detergent = BioItemList.getOther(1);
            ItemStack DNAFlask = BioItemList.getDNASampleFlask(null);
            ItemStack EthanolCell = Materials.Ethanol.getCells(1);
            GTValues.RA.stdBuilder().itemInputs(stack, DNAFlask, Detergent, EthanolCell).itemOutputs(BioItemList.getDNASampleFlask(BioDNA.convertDataToDNA(bioData)), GTOreDictUnificator.get(OrePrefixes.cell, Materials.Empty, 1L)).outputChances(bioData.getChance(), 10000).fluidInputs(FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)).special(BioItemList.mBioLabParts[0]).duration(500).eut(GTValues.VP[3 + bioData.getTier()]).ignoreCollision().fake().addTo(BartWorksRecipeMaps.bioLabRecipes);
        }
        for (ItemStack stack : BioItemList.getAllDNASampleFlasks()) {
            BioData bioData = BioData.getBioDataFromNBTTag(stack.func_77978_p());
            if (bioData == null) continue;
            ItemStack Outp = ItemList.Tool_DataOrb.get(1L, new Object[0]);
            BehaviourDataOrb.setDataTitle(Outp, "DNA Sample");
            BehaviourDataOrb.setDataName(Outp, bioData.getName());
            GTValues.RA.stdBuilder().itemInputs(stack, FluidLoader.BioLabFluidCells[0], FluidLoader.BioLabFluidCells[3], ItemList.Tool_DataOrb.get(1L, new Object[0])).itemOutputs(Outp, ItemList.Cell_Empty.get(2L, new Object[0])).outputChances(bioData.getChance(), 10000).fluidInputs(dnaFluid).special(BioItemList.mBioLabParts[1]).duration(500).eut(GTValues.VP[4 + bioData.getTier()]).ignoreCollision().fake().addTo(BartWorksRecipeMaps.bioLabRecipes);
        }
        for (ItemStack stack : BioItemList.getAllPlasmidCells()) {
            BioData bioData = BioData.getBioDataFromNBTTag(stack.func_77978_p());
            if (bioData == null) continue;
            ItemStack inp = ItemList.Tool_DataOrb.get(0L, new Object[0]);
            BehaviourDataOrb.setDataTitle(inp, "DNA Sample");
            BehaviourDataOrb.setDataName(inp, bioData.getName());
            ItemStack inp2 = ItemList.Tool_DataOrb.get(0L, new Object[0]);
            BehaviourDataOrb.setDataTitle(inp2, "DNA Sample");
            BehaviourDataOrb.setDataName(inp2, BioCultureLoader.BIO_DATA_BETA_LACMATASE.getName());
            GTValues.RA.stdBuilder().itemInputs(FluidLoader.BioLabFluidCells[1], BioItemList.getPlasmidCell(null), inp, inp2).itemOutputs(stack, ItemList.Cell_Empty.get(1L, new Object[0])).outputChances(bioData.getChance(), 10000).fluidInputs(dnaFluid).special(BioItemList.mBioLabParts[2]).duration(500).eut(GTValues.VP[4 + bioData.getTier()]).ignoreCollision().fake().addTo(BartWorksRecipeMaps.bioLabRecipes);
        }
        for (ItemStack stack : BioItemList.getAllPetriDishes()) {
            BioData bioData = BioData.getBioDataFromNBTTag(stack.func_77978_p().func_74775_l("DNA"));
            BioData Plasmid = BioData.getBioDataFromNBTTag(stack.func_77978_p().func_74775_l("Plasmid"));
            if (Objects.equals(bioData.getName(), Plasmid.getName())) continue;
            GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(BioCulture.getBioCulture(bioData.getName())), BioItemList.getPlasmidCell(BioPlasmid.convertDataToPlasmid(Plasmid)), FluidLoader.BioLabFluidCells[2]).itemOutputs(stack, ItemList.Cell_Empty.get(1L, new Object[0])).outputChances(Plasmid.getChance(), 10000).fluidInputs(FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)).special(BioItemList.mBioLabParts[3]).duration(500).eut(TierEU.RECIPE_LuV).ignoreCollision().fake().addTo(BartWorksRecipeMaps.bioLabRecipes);
        }
        ItemStack Outp = ItemList.Tool_DataOrb.get(1L, new Object[0]);
        BehaviourDataOrb.setDataTitle(Outp, "DNA Sample");
        BehaviourDataOrb.setDataName(Outp, "Any DNA");
        GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(null), BioItemList.getOther(4), ItemList.Circuit_Chip_Stemcell.get(2L, new Object[0]), Outp).itemOutputs(BioItemList.getPetriDish(null).func_151001_c("The Culture made from DNA")).outputChances(7500).fluidInputs(new FluidStack(dnaFluid[0].getFluid(), 8000)).special(BioItemList.mBioLabParts[4]).duration(500).eut(TierEU.RECIPE_LuV).ignoreCollision().fake().addTo(BartWorksRecipeMaps.bioLabRecipes);
        for (FluidStack fluidStack : easyFluids = new FluidStack[]{Materials.Water.getFluid(1000L), FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}) {
            for (BioCulture bioCulture : BioCulture.BIO_CULTURE_ARRAY_LIST) {
                if (!bioCulture.isBreedable() || bioCulture.getTier() != 0) continue;
                GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1), new ItemStack(Items.field_151102_aT, 64)).special(BioItemList.getPetriDish(bioCulture)).fluidInputs(fluidStack).fluidOutputs(new FluidStack(bioCulture.getFluid(), 10)).duration(1000).eut(TierEU.RECIPE_MV).addTo(BartWorksRecipeMaps.bacterialVatRecipes);
                GTValues.RA.stdBuilder().itemInputs(BioItemList.getPetriDish(null), fluidStack.equals((Object)Materials.Water.getFluid(1000L)) ? Materials.Water.getCells(1) : GTUtility.getContainersFromFluid(GTModHandler.getDistilledWater(1000L)).get(0)).itemOutputs(BioItemList.getPetriDish(bioCulture), Materials.Empty.getCells(1)).outputChances(bioCulture.getChance(), 10000).fluidInputs(new FluidStack(bioCulture.getFluid(), 1000)).duration(500).eut(TierEU.RECIPE_HV).addTo(BartWorksRecipeMaps.bioLabRecipes);
            }
        }
        List<Pair> list = Arrays.asList(ImmutablePair.of((Object)Materials.PhosphoricAcid, (Object)36), ImmutablePair.of((Object)Materials.DilutedHydrochloricAcid, (Object)14), ImmutablePair.of((Object)Materials.HypochlorousAcid, (Object)30), ImmutablePair.of((Object)Materials.HydrofluoricAcid, (Object)40), ImmutablePair.of((Object)Materials.HydrochloricAcid, (Object)28), ImmutablePair.of((Object)Materials.NitricAcid, (Object)24), ImmutablePair.of((Object)Materials.Mercury, (Object)32), ImmutablePair.of((Object)Materials.DilutedSulfuricAcid, (Object)9), ImmutablePair.of((Object)Materials.SulfuricAcid, (Object)18), ImmutablePair.of((Object)Materials.AceticAcid, (Object)11), ImmutablePair.of((Object)WerkstoffLoader.FormicAcid.getBridgeMaterial(), (Object)40));
        for (Pair fuel : list) {
            GTValues.RA.stdBuilder().itemInputs(((Materials)fuel.getLeft()).getCells(1)).itemOutputs(Materials.Empty.getCells(1)).metadata(GTRecipeConstants.FUEL_VALUE, (Integer)fuel.getRight()).addTo(BartWorksRecipeMaps.acidGenFuels);
        }
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.cellMolten, Materials.Redstone, 1L)).itemOutputs(Materials.Empty.getCells(1)).metadata(GTRecipeConstants.FUEL_VALUE, 10).addTo(BartWorksRecipeMaps.acidGenFuels);
    }

    public static void run() {
        AdditionalRecipes.runBWRecipes();
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.RawAdemicSteel.get(OrePrefixes.dust)).itemOutputs(WerkstoffLoader.AdemicSteel.get(OrePrefixes.dust)).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 4).addTo(RecipeMaps.implosionRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.YttriumOxide.get(OrePrefixes.dustSmall, 2), WerkstoffLoader.Thorianit.get(OrePrefixes.dustSmall, 2)).itemOutputs(new ItemStack(ItemRegistry.bw_glasses[0], 1, 12)).fluidInputs(Materials.Glass.getMolten(144L)).duration(800).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.COIL_HEAT, 3663).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Thorianit.get(OrePrefixes.crushedPurified)).itemOutputs(WerkstoffLoader.Thorianit.get(OrePrefixes.dust), WerkstoffLoader.Thorianit.get(OrePrefixes.dust), WerkstoffLoader.Thorianit.get(OrePrefixes.dust), Materials.Thorium.getDust(1), Materials.Thorium.getDust(1), WerkstoffLoader.Thorium232.get(OrePrefixes.dust)).outputChances(7000, 1300, 700, 600, 300, 100).duration(400).eut((int)TierEU.RECIPE_IV).addTo(RecipeMaps.sifterRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Thorianit.get(OrePrefixes.dust, 9), Materials.Aluminium.getDust(4)).itemOutputs(Materials.Thorium.getDust(3), Materials.Aluminiumoxide.getDust(10)).duration(1000).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Thorianit.get(OrePrefixes.dust, 3), Materials.Magnesium.getDust(2)).itemOutputs(Materials.Thorium.getDust(1), Materials.Magnesia.getDust(4)).duration(1000).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Thorianit.get(OrePrefixes.crushed), ItemList.Crop_Drop_Thorium.get(9L, new Object[0])).itemOutputs(WerkstoffLoader.Thorianit.get(OrePrefixes.crushedPurified, 4)).fluidInputs(Materials.Water.getFluid(1000L)).fluidOutputs(Materials.Thorium.getMolten(144L)).duration(96).eut(24).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Quartzite, 40L), Materials.Amethyst.getDust(10)).itemOutputs(WerkstoffLoader.Prasiolite.get(OrePrefixes.gemFlawed, 20)).duration(800).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 500).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Quartzite, 40L)).itemOutputs(Materials.Amethyst.getDust(10)).duration(800).eut(0).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 6).addTo(RecipeMaps.primitiveBlastRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.Yttrium.getDust(2), GTUtility.getIntegratedCircuit(5)).itemOutputs(WerkstoffLoader.YttriumOxide.get(OrePrefixes.dust, 5)).fluidInputs(Materials.Oxygen.getGas(3000L)).duration(4096).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Zirconium.get(OrePrefixes.dust, 10), WerkstoffLoader.YttriumOxide.get(OrePrefixes.dust, 0)).itemOutputs(WerkstoffLoader.CubicZirconia.get(OrePrefixes.gemFlawed, 40)).fluidInputs(Materials.Oxygen.getGas(20000L)).duration(57600).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.COIL_HEAT, 2953).noOptimize().addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.crushed, Materials.Lead, 10L), GTUtility.getIntegratedCircuit(17)).itemOutputs(Materials.Lead.getIngots(10), Materials.Tellurium.getNuggets(20)).duration(800).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 722).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().fluidInputs(Materials.Plutonium.getMolten(48L), Materials.Beryllium.getMolten(48L)).fluidOutputs(WerkstoffLoader.Californium.getMolten(48)).duration(240).eut(49152).metadata(GTRecipeConstants.FUSION_THRESHOLD, 480000000).addTo(RecipeMaps.fusionRecipes);
        GTValues.RA.stdBuilder().fluidInputs(WerkstoffLoader.Californium.getMolten(32), WerkstoffLoader.Calcium.getMolten(720)).fluidOutputs(WerkstoffLoader.Oganesson.getFluidOrGas(720)).duration(480).eut(49152).metadata(GTRecipeConstants.FUSION_THRESHOLD, 600000000).addTo(RecipeMaps.fusionRecipes);
        GTValues.RA.stdBuilder().fluidInputs(Materials.LiquidAir.getFluid(100000000L)).fluidOutputs(Materials.Nitrogen.getGas(78084000L), Materials.Oxygen.getGas(20946000L), Materials.Argon.getGas(934000L), Materials.CarbonDioxide.getGas(40700L), WerkstoffLoader.Neon.getFluidOrGas(1818), Materials.Helium.getGas(524L), Materials.Methane.getGas(180L), WerkstoffLoader.Krypton.getFluidOrGas(114), Materials.Hydrogen.getGas(55L), WerkstoffLoader.Xenon.getFluidOrGas(9)).duration(7500).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.distillationTowerRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.dust)).itemOutputs(WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gemChipped, 9)).outputChances(9000).fluidInputs(WerkstoffLoader.Neon.getFluidOrGas(1000)).duration(500).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.autoclaveRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.dust)).itemOutputs(WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gem)).fluidInputs(WerkstoffLoader.Krypton.getFluidOrGas(1000)).duration(500).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.autoclaveRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1)).itemOutputs(Materials.Sugar.getDustSmall(21), Materials.Calcium.getDustTiny(1), Materials.Magnesium.getDustTiny(1), Materials.Potassium.getDustTiny(1), Materials.Sodium.getDustTiny(4), Materials.Phosphorus.getDustTiny(1)).outputChances(10000, 10000, 1000, 10000, 1000, 1000).fluidInputs(Materials.Milk.getFluid(10000L)).fluidOutputs(Materials.Water.getFluid(8832L)).duration(50).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Tiberium.get(OrePrefixes.bolt)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 12500).addTo(RecipeMaps.smallNaquadahReactorFuels);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Tiberium.get(OrePrefixes.stick)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 62500).addTo(RecipeMaps.largeNaquadahReactorFuels);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Tiberium.get(OrePrefixes.stickLong)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 125000).addTo(RecipeMaps.hugeNaquadahReactorFuels);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Tiberium.get(OrePrefixes.stick)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 31250).addTo(RecipeMaps.extremeNaquadahReactorFuels);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Tiberium.get(OrePrefixes.stickLong)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 125000).addTo(RecipeMaps.ultraHugeNaquadahReactorFuels);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Large_Fluid_Cell_TungstenSteel.get(1L, new Object[0]), WerkstoffLoader.Tiberium.get(OrePrefixes.dust, 3)).itemOutputs(BWNonMetaMaterialItems.TiberiumCell_1.get(1L, new Object[0])).duration(30).eut(16).addTo(RecipeMaps.cannerRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.TiberiumCell_1.get(2L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.stick, Materials.TungstenSteel, 4L)).itemOutputs(BWNonMetaMaterialItems.TiberiumCell_2.get(1L, new Object[0])).duration(100).eut(400).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.TiberiumCell_1.get(4L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.TungstenSteel, 6L)).itemOutputs(BWNonMetaMaterialItems.TiberiumCell_4.get(1L, new Object[0])).duration(150).eut(400).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(BWNonMetaMaterialItems.TiberiumCell_2.get(2L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.stick, Materials.TungstenSteel, 4L)).itemOutputs(BWNonMetaMaterialItems.TiberiumCell_4.get(1L, new Object[0])).duration(100).eut(400).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.NaquadahCell_1.get(32L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.TungstenSteel, 64L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.TungstenSteel, 64L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.TungstenSteel, 64L), WerkstoffLoader.Tiberium.get(OrePrefixes.dust, 64), WerkstoffLoader.Tiberium.get(OrePrefixes.dust, 64)).itemOutputs(BWNonMetaMaterialItems.TheCoreCell.get(1L, new Object[0])).duration(100).eut(TierEU.RECIPE_LuV).addTo(RecipeMaps.assemblerRecipes);
        GregTechAPI.sAfterGTPostload.add(new AddSomeRecipes());
    }
}

