/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.util.BWTooltipReference;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TierEU;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.MTEDrillerBase;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class MTEDeepEarthHeatingPump
extends MTEDrillerBase {
    private byte mMode;

    public MTEDeepEarthHeatingPump(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEDeepEarthHeatingPump(String aName) {
        super(aName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mMode", this.mMode);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mMode = aNBT.func_74771_c("mMode");
        super.loadNBTData(aNBT);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEDeepEarthHeatingPump(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        tt.addMachineType("Geothermal Heat Pump").addInfo("Consumes " + TierEU.RECIPE_HV + "EU/t").addInfo("Has 2 Modes, use the Screwdriver to change them:");
        tt.addInfo("Direct Steam and Coolant Heating").addInfo("Direct Steam Mode: Consumes Distilled Water to produce 512000L/s of Superheated Steam").addInfo("Coolant Heating Mode: Converts 3840L/s Coolant to Hot Coolant").addInfo("Each maintenance issue lowers output efficiency by 10%").addInfo("Explodes when it runs out of Distilled Water/Coolant");
        tt.addSeparator().beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch(GTValues.VN[this.getMinTier()] + "+, Any base casing").addMaintenanceHatch("Any base casing").addInputBus("Mining Pipes, optional, any base casing").addInputHatch("Any base casing").addOutputHatch("Any base casing").toolTipFinisher(BWTooltipReference.MULTIBLOCK_ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS);
        return tt;
    }

    @Override
    protected ItemList getCasingBlockItem() {
        return ItemList.Casing_HeatProof;
    }

    @Override
    protected Materials getFrameMaterial() {
        return Materials.Tungsten;
    }

    @Override
    protected int getCasingTextureIndex() {
        return 11;
    }

    @Override
    public boolean supportsMachineModeSwitch() {
        return true;
    }

    @Override
    public Pos2d getMachineModeSwitchButtonPos() {
        return new Pos2d(98, 91);
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.clear();
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_STEAM);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_FLUID);
    }

    @Override
    public String getMachineModeName() {
        return StatCollector.func_74838_a((String)("GT5U.DEHP.mode." + this.machineMode));
    }

    @Override
    protected int getMinTier() {
        return 3;
    }

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mOutputHatches.isEmpty() && !this.mInputHatches.isEmpty();
    }

    private long getFluidFromHatches(Fluid f) {
        long ret = 0L;
        for (MTEHatchInput ih : this.mInputHatches) {
            if (!ih.getFluid().getFluid().equals(f)) continue;
            ret += (long)ih.getFluidAmount();
        }
        return ret;
    }

    private long getWaterFromHatches(boolean onlyDistilled) {
        Fluid toConsume1 = FluidRegistry.WATER;
        Fluid toConsume2 = GTModHandler.getDistilledWater(1L).getFluid();
        if (onlyDistilled) {
            toConsume1 = toConsume2;
        }
        long ret = 0L;
        for (MTEHatchInput ih : this.mInputHatches) {
            if (!ih.getFluid().getFluid().equals(toConsume1) && !ih.getFluid().getFluid().equals(toConsume2)) continue;
            ret += (long)ih.getFluidAmount();
        }
        return ret;
    }

    @Override
    protected void addOperatingMessages() {
        this.addResultMessage(0, true, "deploying_pipe");
        this.addResultMessage(0, false, "extracting_pipe");
        this.addResultMessage(1, true, "circulating_fluid");
        this.addResultMessage(1, false, "no_mining_pipe");
        this.addResultMessage(2, true, "retracting_pipe");
        this.addResultMessage(2, false, "drill_generic_finished");
        this.addResultMessage(3, true, "retracting_pipe");
        this.addResultMessage(3, false, "drill_retract_pipes_finished");
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.setMachineMode(this.nextMachineMode());
        PlayerUtils.messagePlayer(aPlayer, String.format(StatCollector.func_74838_a((String)"GT5U.MULTI_MACHINE_CHANGE"), this.getMachineModeName()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.tryLowerPipeState(true) == 0) {
            this.workState = 0;
            return true;
        }
        if (this.machineMode == 0) {
            long steamProduced = 25600L * (long)this.mEfficiency / 10000L;
            long waterConsume = (steamProduced + 160L) / 160L;
            if (this.getWaterFromHatches(true) - waterConsume > 0L) {
                this.consumeFluid(GTModHandler.getDistilledWater(1L).getFluid(), waterConsume);
                this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)((int)steamProduced)));
                return true;
            }
            this.explodeMultiblock();
            return false;
        }
        if (this.machineMode != 1) return true;
        long coolantConverted = 192L * (long)this.mEfficiency / 10000L;
        if (this.getFluidFromHatches(FluidRegistry.getFluid((String)"ic2coolant")) - coolantConverted > 0L) {
            this.consumeFluid(FluidRegistry.getFluid((String)"ic2coolant"), coolantConverted);
            this.addOutput(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)((int)coolantConverted)));
            return true;
        }
        this.explodeMultiblock();
        return false;
    }

    private boolean consumeFluid(Fluid fluid, long ammount) {
        if (ammount > Integer.MAX_VALUE) {
            int[] tmp = new int[(int)(ammount / Integer.MAX_VALUE)];
            Arrays.fill(tmp, (int)(ammount / Integer.MAX_VALUE));
            block0: for (int i = 0; i < tmp.length; ++i) {
                for (MTEHatchInput ih : this.mInputHatches) {
                    if (fluid.equals(FluidRegistry.WATER) ? ih.getFluid().getFluid().equals(fluid) || ih.getFluid().getFluid().equals(GTModHandler.getDistilledWater(1L).getFluid()) : ih.getFluid().getFluid().equals(fluid)) {
                        int n = i;
                        tmp[n] = tmp[n] - ih.drain((int)((int)ammount), (boolean)true).amount;
                    }
                    if (tmp[i] > 0) continue;
                    continue block0;
                }
            }
            return tmp[tmp.length - 1] <= 0;
        }
        long tmp = ammount;
        for (MTEHatchInput ih : this.mInputHatches) {
            if (fluid.equals(FluidRegistry.WATER) ? ih.getFluid().getFluid().equals(fluid) || ih.getFluid().getFluid().equals(GTModHandler.getDistilledWater(1L).getFluid()) : ih.getFluid().getFluid().equals(fluid)) {
                tmp -= (long)ih.drain((int)((int)ammount), (boolean)true).amount;
            }
            if (tmp > 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setElectricityStats() {
        try {
            this.mEUt = this.isPickingPipes ? -60 : -((int)TierEU.RECIPE_HV);
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
            this.mEUt = 0x7FFFFFF8;
        }
        this.mProgresstime = 0;
        this.mMaxProgresstime = 1;
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
    }
}

