/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.core.handler;

import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.util.StringTranslate;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalizationUpdater {
    private static final String LANG_DIR = "https://api.github.com/repos/%s/%s/contents/%s?ref=%s";
    private static final String RAW_URL = "https://raw.githubusercontent.com/%s/%s/%s";
    private static final Logger LOGGER = LogManager.getLogger((String)"RemoteIO:Localization");
    private Map<String, Map<String, String>> loadedLangFiles = Maps.newConcurrentMap();
    private final String langUrl;
    private final String rawUrl;
    private boolean optout = false;

    public LocalizationUpdater(String owner, String repo, String branch, String langPath) {
        this(String.format(LANG_DIR, owner, repo, langPath, branch), String.format(RAW_URL, owner, repo, branch) + "/%s");
    }

    public LocalizationUpdater(String langUrl, String rawUrl) {
        this.langUrl = langUrl;
        this.rawUrl = rawUrl;
    }

    public void initializeThread(Configuration configuration) {
        this.optout = configuration.get("optout", "localization_update", false, "Opt-out of localization updates, and only use lang files packaged with the JAR").getBoolean(false);
        if (!this.optout) {
            new Thread(() -> {
                try {
                    Map[] json;
                    URL url = new URL(this.langUrl);
                    InputStream con = url.openStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)con));
                    con.close();
                    for (Map aJson : json = (Map[])new Gson().fromJson(data, Map[].class)) {
                        String name = (String)aJson.get("name");
                        if (!name.endsWith(".lang")) continue;
                        LOGGER.info("Discovered " + name + ". Downloading...");
                        URL url1 = new URL(String.format(this.rawUrl, aJson.get("path")));
                        InputStream con1 = url1.openStream();
                        HashMap map = StringTranslate.parseLangFile((InputStream)con1);
                        this.loadedLangFiles.put(name.substring(0, name.lastIndexOf(".lang")), map);
                        con1.close();
                    }
                }
                catch (UnknownHostException e) {
                    this.optout = true;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to update localization!", (Throwable)e);
                }
            }).start();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerListener() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(p_110549_1_ -> this.loadLangFiles());
    }

    private void loadLangFiles() {
        if (this.optout) {
            return;
        }
        Map<String, String> map = this.loadedLangFiles.get(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a());
        if (map == null) {
            return;
        }
        try {
            Map languageList = (Map)ObfuscationReflectionHelper.getPrivateValue(StringTranslate.class, (Object)StringTranslate.field_74817_a, (String[])new String[]{"languageList", "field_74816_c", "d"});
            languageList.putAll(map);
            StringTranslate.field_74817_a.field_150511_e = System.currentTimeMillis();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

