/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import galaxyspace.core.item.block.GSItemBlockDesc;
import galaxyspace.core.tile.machine.TileEntityConverterSurface;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockConverterSurface
extends BlockTileGC
implements GSItemBlockDesc.IBlockShiftDesc {
    public static final int CONVERTER_SURFACE_METADATA = 0;
    private IIcon iconMachineSide;
    private IIcon iconOutput;
    private IIcon iconFuelOutput;
    private IIcon[] iconConverterSurface = new IIcon[1];

    public BlockConverterSurface(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    public void func_149749_a(World var1, int var2, int var3, int var4, Block var5, int var6) {
        TileEntity var7 = var1.func_147438_o(var2, var3, var4);
        if (var7 instanceof IMultiBlock) {
            ((IMultiBlock)var7).onDestroy(var7);
        }
        super.func_149749_a(var1, var2, var3, var4, var5, var6);
    }

    public CreativeTabs func_149708_J() {
        return GalaxySpace.tabBlocks;
    }

    public int func_149645_b() {
        return GalaxySpace.proxy.getBlockRender((Block)this);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine");
        this.iconOutput = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_output");
        this.iconMachineSide = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_side");
        this.iconFuelOutput = iconRegister.func_94245_a("galaxyspace:overworld/machine_water_input");
        this.iconConverterSurface[0] = iconRegister.func_94245_a("galaxyspace:overworld/converter_surface");
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
            return this.iconConverterSurface[0];
        }
        return this.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.field_149761_L;
        }
        if (metadata >= 0) {
            if (side == metadata + 2) {
                return this.iconOutput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconFuelOutput;
            }
            if (metadata == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
                return this.iconConverterSurface[0];
            }
        }
        return this.iconMachineSide;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
    }

    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = par1World.func_72805_g(x, y, z);
        int original = metadata & 3;
        int change = 0;
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        par1World.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
        return true;
    }

    public boolean onMachineActivated(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (!par1World.field_72995_K) {
            par5EntityPlayer.openGui((Object)GalaxySpace.instance, -1, par1World, x, y, z);
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if ((metadata &= 0xC) == 0) {
            return new TileEntityConverterSurface();
        }
        return null;
    }

    public ItemStack getFuelGenerator() {
        return new ItemStack((Block)this, 1, 0);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(this.getFuelGenerator());
    }

    public int func_149692_a(int metadata) {
        return metadata & 0xC;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = this.func_149643_k(world, x, y, z);
        return new ItemStack((Block)this, 1, metadata);
    }

    @Override
    public String getDescription(int meta) {
        return null;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.ConverterSurface.desc");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }
}

