/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.client.renderer.util.WorldUtil;
import com.gtnewhorizons.angelica.compat.mojang.ChunkOcclusionDataBuilder;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.mixins.interfaces.ITexturesCache;
import com.gtnewhorizons.angelica.rendering.AngelicaBlockSafetyRegistry;
import com.gtnewhorizons.angelica.rendering.AngelicaRenderQueue;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderManager;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.joml.Vector3d;

public class ChunkRenderRebuildTask<T extends ChunkGraphicsState>
extends ChunkRenderBuildTask<T> {
    private final ChunkRenderContainer<T> render;
    private final BlockPos offset;
    private final ChunkRenderContext context;
    private Vector3d camera;
    private final boolean translucencySorting;

    public ChunkRenderRebuildTask(ChunkRenderContainer<T> render, ChunkRenderContext context, BlockPos offset) {
        this.render = render;
        this.offset = offset;
        this.context = context;
        this.camera = new Vector3d();
        this.translucencySorting = SodiumClientMod.options().advanced.translucencySorting;
    }

    public ChunkRenderRebuildTask<T> withCameraPosition(Vector3d camera) {
        this.camera = camera;
        return this;
    }

    private boolean rendersOutsideBoundingBox(TileEntity entity, int baseX, int baseY, int baseZ) {
        AxisAlignedBB box = entity.getRenderBoundingBox();
        if (box == TileEntity.INFINITE_EXTENT_AABB) {
            return true;
        }
        if (box.field_72340_a < (double)baseX || box.field_72338_b < (double)baseY || box.field_72339_c < (double)baseZ) {
            return true;
        }
        return box.field_72336_d > (double)(baseX + 16) || box.field_72337_e > (double)(baseY + 16) || box.field_72334_f > (double)(baseZ + 16);
    }

    private boolean rendersOffThread(Block block) {
        int type = block.func_149645_b();
        return type < 42 && type != 22 && AngelicaBlockSafetyRegistry.canBlockRenderOffThread(block, false, false) || AngelicaBlockSafetyRegistry.canBlockRenderOffThread(block, true, false);
    }

    private void handleRenderBlocksTextures(RenderBlocks rb, ChunkRenderData.Builder builder) {
        if (!AngelicaConfig.speedupAnimations || !(rb instanceof ITexturesCache)) {
            return;
        }
        for (IIcon texture : ((ITexturesCache)rb).getRenderedTextures()) {
            if (!(texture instanceof TextureAtlasSprite)) continue;
            TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)texture;
            builder.addSprite(textureAtlasSprite);
        }
    }

    @Override
    public ChunkBuildResult<T> performBuild(ChunkRenderCacheLocal cache, ChunkBuildBuffers buffers, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        ChunkOcclusionDataBuilder occluder = new ChunkOcclusionDataBuilder();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        buffers.init(renderData);
        cache.init(this.context);
        WorldSlice slice = cache.getWorldSlice();
        RenderBlocks renderBlocks = new RenderBlocks((IBlockAccess)slice);
        if (renderBlocks instanceof ITexturesCache) {
            ((ITexturesCache)renderBlocks).enableTextureTracking();
        }
        int baseX = this.render.getOriginX();
        int baseY = this.render.getOriginY();
        int baseZ = this.render.getOriginZ();
        BlockPos pos = new BlockPos();
        BlockPos renderOffset = this.offset;
        LongArrayFIFOQueue mainThreadBlocks = new LongArrayFIFOQueue();
        boolean hasMainThreadBlocks = false;
        for (int relY = 0; relY < 16; ++relY) {
            if (cancellationSource.isCancelled()) {
                return null;
            }
            for (int relZ = 0; relZ < 16; ++relZ) {
                for (int relX = 0; relX < 16; ++relX) {
                    Block block = slice.getBlockRelative(relX + 16, relY + 16, relZ + 16);
                    if (block.func_149688_o() == Material.field_151579_a) continue;
                    int meta = slice.getBlockMetadataRelative(relX + 16, relY + 16, relZ + 16);
                    pos.set(baseX + relX, baseY + relY, baseZ + relZ);
                    buffers.setRenderOffset(pos.x - renderOffset.getX(), pos.y - renderOffset.getY(), pos.z - renderOffset.getZ());
                    if (AngelicaConfig.enableIris) {
                        buffers.iris$setLocalPos(relX, relY, relZ);
                    }
                    if (this.rendersOffThread(block)) {
                        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
                            if (!block.canRenderInPass(pass.ordinal()) || ChunkRenderRebuildTask.shouldUseSodiumFluidRendering(block)) continue;
                            ChunkRenderManager.setWorldRenderPass(pass);
                            long seed = MathUtil.hashPos(pos.x, pos.y, pos.z);
                            if (AngelicaConfig.enableIris) {
                                buffers.iris$setMaterialId(block, (short)-1);
                            }
                            if (!cache.getBlockRenderer().renderModel(cache.getWorldSlice(), renderBlocks, block, meta, pos, buffers.get(pass), true, seed)) continue;
                            bounds.addBlock(relX, relY, relZ);
                        }
                    } else {
                        mainThreadBlocks.enqueue(pos.asLong());
                        hasMainThreadBlocks = true;
                    }
                    if (ChunkRenderRebuildTask.shouldUseSodiumFluidRendering(block)) {
                        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
                            if (!block.canRenderInPass(pass.ordinal())) continue;
                            ChunkRenderManager.setWorldRenderPass(pass);
                            if (AngelicaConfig.enableIris) {
                                buffers.iris$setMaterialId(block, (short)1);
                            }
                            if (!cache.getFluidRenderer().render(slice, cache.getWorldSlice(), block, pos, buffers.get(pass))) continue;
                            bounds.addBlock(relX, relY, relZ);
                        }
                    }
                    if (AngelicaConfig.enableIris) {
                        buffers.iris$resetBlockContext();
                    }
                    if (block.hasTileEntity(meta)) {
                        TileEntity entity = slice.func_147438_o(pos.x, pos.y, pos.z);
                        TileEntitySpecialRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(entity);
                        if (entity != null && renderer != null) {
                            renderData.addTileEntity(entity, !this.rendersOutsideBoundingBox(entity, baseX, baseY, baseZ));
                            bounds.addBlock(relX, relY, relZ);
                        }
                    }
                    if (!block.func_149662_c()) continue;
                    occluder.markClosed(pos);
                }
            }
        }
        this.handleRenderBlocksTextures(renderBlocks, renderData);
        if (hasMainThreadBlocks) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.performMainBuild(cache, buffers, cancellationSource, bounds, renderData, mainThreadBlocks), AngelicaRenderQueue.executor());
            while (!future.isDone() && !cancellationSource.isCancelled()) {
                try {
                    future.get();
                }
                catch (InterruptedException relZ) {
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            if (cancellationSource.isCancelled()) {
                return null;
            }
        }
        this.render.setRebuildForTranslucents(false);
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            ChunkMeshData mesh = buffers.createMesh(pass, (float)this.camera.x - (float)this.offset.getX(), (float)this.camera.y - (float)this.offset.getY(), (float)this.camera.z - (float)this.offset.getZ(), this.translucencySorting);
            if (mesh == null) continue;
            renderData.setMesh(pass, mesh);
            if (!this.translucencySorting || !pass.isTranslucent()) continue;
            this.render.setRebuildForTranslucents(true);
        }
        renderData.setOcclusionData(occluder.build());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        return new ChunkBuildResult<T>(this.render, renderData.build());
    }

    private void performMainBuild(ChunkRenderCacheLocal cache, ChunkBuildBuffers buffers, CancellationSource cancellationSource, ChunkRenderBounds.Builder bounds, ChunkRenderData.Builder renderData, LongArrayFIFOQueue mainThreadBlocks) {
        WorldSlice slice = cache.getWorldSlice();
        BlockPos pos = new BlockPos();
        int baseX = this.render.getOriginX();
        int baseY = this.render.getOriginY();
        int baseZ = this.render.getOriginZ();
        BlockPos renderOffset = this.offset;
        RenderBlocks rb = new RenderBlocks((IBlockAccess)slice.getWorld());
        if (rb instanceof ITexturesCache) {
            ((ITexturesCache)rb).enableTextureTracking();
        }
        while (!mainThreadBlocks.isEmpty()) {
            int relZ;
            int relY;
            long longPos = mainThreadBlocks.dequeueLong();
            if (cancellationSource.isCancelled()) {
                return;
            }
            pos.set(longPos);
            int relX = pos.getX() - baseX;
            Block block = slice.getBlockRelative(relX + 16, (relY = pos.getY() - baseY) + 16, (relZ = pos.getZ() - baseZ) + 16);
            if (block.func_149688_o() == Material.field_151579_a || this.rendersOffThread(block)) continue;
            int meta = slice.getBlockMetadataRelative(relX + 16, relY + 16, relZ + 16);
            buffers.setRenderOffset(pos.x - renderOffset.getX(), pos.y - renderOffset.getY(), pos.z - renderOffset.getZ());
            if (AngelicaConfig.enableIris) {
                buffers.iris$setLocalPos(relX, relY, relZ);
            }
            for (BlockRenderPass pass : BlockRenderPass.VALUES) {
                if (!block.canRenderInPass(pass.ordinal()) || ChunkRenderRebuildTask.shouldUseSodiumFluidRendering(block)) continue;
                ChunkRenderManager.setWorldRenderPass(pass);
                long seed = MathUtil.hashPos(pos.x, pos.y, pos.z);
                if (AngelicaConfig.enableIris) {
                    buffers.iris$setMaterialId(block, (short)-1);
                }
                if (!cache.getBlockRenderer().renderModel((IBlockAccess)slice.getWorld(), rb, block, meta, pos, buffers.get(pass), true, seed)) continue;
                bounds.addBlock(relX, relY, relZ);
            }
            if (!AngelicaConfig.enableIris) continue;
            buffers.iris$resetBlockContext();
        }
        this.handleRenderBlocksTextures(rb, renderData);
    }

    @Override
    public void releaseResources() {
        this.context.releaseResources();
    }

    public String toString() {
        return "ChunkRenderRebuildTask{offset=" + this.offset + ", camera=" + this.camera + ", translucencySorting=" + this.translucencySorting + '}';
    }

    private static boolean shouldUseSodiumFluidRendering(Block block) {
        return AngelicaConfig.enableSodiumFluidRendering && WorldUtil.isFluidBlock((Block)block);
    }
}

