/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node;

import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.query.Root;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.traversal.ASTVisitor;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.Token;

public class Identifier
extends ASTNode {
    private String name;

    public Identifier(String name) {
        this.name = name;
        Identifier.validateContents(name);
    }

    public Identifier(Token token) {
        this(token.getText());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name.equals(name)) {
            return;
        }
        Identifier.validateContents(name);
        this.getRoot().unregisterIdentifierRename(this);
        this.name = name;
        this.getRoot().registerIdentifierRename(this);
    }

    @Deprecated
    public void setNameInternal(String name) {
        this.name = name;
    }

    public static final void validateContents(String str) {
        if (str.length() == 0) {
            throw new IllegalArgumentException("Identifier cannot be empty");
        }
        if (!Character.isLetter(str.charAt(0)) && str.charAt(0) != '_') {
            throw new IllegalArgumentException("Identifier must start with a letter or underscore");
        }
        for (int i = 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
            throw new IllegalArgumentException("Invalid identifier name: " + str);
        }
    }

    @Override
    public <R> R accept(ASTVisitor<R> visitor) {
        return visitor.visitIdentifier(this);
    }

    @Override
    public Identifier clone() {
        return new Identifier(this.name);
    }

    @Override
    public Identifier cloneInto(Root root) {
        return (Identifier)super.cloneInto(root);
    }

    @Override
    public Identifier cloneSeparate() {
        return (Identifier)super.cloneSeparate();
    }
}

