/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading;

import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.gtnhlib.asm.ASMUtil;
import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.loading.MixinCompatHackTweaker;
import com.gtnewhorizons.angelica.mixins.Mixins;
import com.gtnewhorizons.angelica.mixins.TargetedMod;
import com.gtnewhorizons.angelica.transform.compat.CompatASMTransformers;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jss.notfine.asm.AsmTransformers;
import jss.notfine.asm.mappings.Namer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.service.mojang.MixinServiceLaunchWrapper;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.TransformerExclusions(value={"com.gtnewhorizons.angelica.transform.RedirectorTransformer", "com.gtnewhorizons.angelica.glsm.GLStateManager"})
public class AngelicaTweaker
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    private static final boolean DUMP_CLASSES = Boolean.parseBoolean(System.getProperty("angelica.dumpClass", "false"));
    private static boolean OBF_ENV;
    public static final Logger LOGGER;
    private String[] transformerClasses;
    private static final ImmutableMap<String, TargetedMod> MODS_BY_CLASS;
    public static final Set<TargetedMod> coreMods;

    public String[] getASMTransformerClass() {
        List mixinTweakClasses = (List)GlobalProperties.get((GlobalProperties.Keys)MixinServiceLaunchWrapper.BLACKBOARD_KEY_TWEAKCLASSES);
        if (mixinTweakClasses != null) {
            mixinTweakClasses.add(MixinCompatHackTweaker.class.getName());
        }
        if (this.transformerClasses == null) {
            ArrayList<String> transformers = new ArrayList<String>(CompatASMTransformers.getTransformers());
            List<String> notFineTransformers = AsmTransformers.getTransformers();
            if (!notFineTransformers.isEmpty()) {
                Namer.initNames();
            }
            transformers.addAll(notFineTransformers);
            this.transformerClasses = transformers.toArray(new String[0]);
        }
        return this.transformerClasses;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        OBF_ENV = (Boolean)data.get("runtimeDeobfuscationEnabled");
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String getMixinConfig() {
        return "mixins.angelica.early.json";
    }

    public List<String> getMixins(Set<String> loadedCoreMods) {
        return Mixins.getEarlyMixins(loadedCoreMods);
    }

    public static boolean DUMP_CLASSES() {
        return DUMP_CLASSES || !OBF_ENV;
    }

    public static boolean isObfEnv() {
        return OBF_ENV;
    }

    public static void dumpClass(String className, byte[] originalBytes, byte[] transformedBytes, Object transformer) {
        if (AngelicaTweaker.DUMP_CLASSES()) {
            ASMUtil.saveAsRawClassFile((byte[])originalBytes, (String)(className + "_PRE"), (Object)transformer);
            ASMUtil.saveAsRawClassFile((byte[])transformedBytes, (String)(className + "_POST"), (Object)transformer);
        }
    }

    private static void detectCoreMods(Set<String> loadedCoreMods) {
        MODS_BY_CLASS.forEach((key, value) -> {
            if (loadedCoreMods.contains(key)) {
                coreMods.add((TargetedMod)((Object)value));
            }
        });
    }

    static {
        LOGGER = LogManager.getLogger((String)"Angelica");
        try {
            ConfigurationManager.registerConfig(AngelicaConfig.class);
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig("");
            if (AngelicaConfig.enableDebugLogging) {
                loggerConfig.setLevel(Level.DEBUG);
            }
            ctx.updateLoggers();
            AngelicaConfig.enableTestBlocks = Boolean.parseBoolean(System.getProperty("angelica.enableTestBlocks", "false"));
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        MODS_BY_CLASS = ImmutableMap.builder().put((Object)"optifine.OptiFineForgeTweaker", (Object)TargetedMod.OPTIFINE).put((Object)"fastcraft.Tweaker", (Object)TargetedMod.FASTCRAFT).put((Object)"cofh.asm.LoadingPlugin", (Object)TargetedMod.COFHCORE).build();
        coreMods = new HashSet<TargetedMod>();
    }
}

