/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.texture;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.texture.TextureInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.IntBuffer;
import org.jetbrains.annotations.Nullable;

public class TextureInfoCache {
    public static final TextureInfoCache INSTANCE = new TextureInfoCache();
    private final Int2ObjectMap<TextureInfo> cache = new Int2ObjectOpenHashMap();

    private TextureInfoCache() {
    }

    public TextureInfo getInfo(int id) {
        if (id < 0 || !GLStateManager.isMainThread()) {
            return null;
        }
        return (TextureInfo)this.cache.computeIfAbsent(id, TextureInfo::new);
    }

    public void onTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable IntBuffer pixels) {
        if (target == 3553 && level == 0) {
            TextureInfo info = this.getInfo(GLStateManager.getBoundTexture());
            if (info == null) {
                return;
            }
            info.internalFormat = internalformat;
            info.width = width;
            info.height = height;
        }
    }

    public void onTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels_buffer_offset) {
        if (target == 3553 && level == 0) {
            TextureInfo info = this.getInfo(GLStateManager.getBoundTexture());
            if (info == null) {
                return;
            }
            info.internalFormat = internalformat;
            info.width = width;
            info.height = height;
        }
    }

    public void onDeleteTexture(int id) {
        if (id >= 0 && GLStateManager.isMainThread()) {
            this.cache.remove(id);
        }
    }
}

