/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.railcraft.common.carts.EntityCartTNTWood;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.world.World;

public class EntityCartPumpkin
extends EntityCartTNTWood {
    private static final byte SPAWN_DIST = 2;
    private static final Map<String, Integer> mobWeights = new HashMap<String, Integer>();
    private static final Map<String, Integer> mobNumber = new HashMap<String, Integer>();
    private static final List<String> mobs = new ArrayList<String>();
    private static final List<Integer> potions = new ArrayList<Integer>();

    public EntityCartPumpkin(World world) {
        super(world);
    }

    public EntityCartPumpkin(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.setBlastRadius(1.5f);
    }

    @Override
    public Block func_145820_n() {
        return Blocks.field_150423_aK;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.field_151143_au));
            items.add(new ItemStack(Blocks.field_150423_aK));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    protected float getMinBlastRadius() {
        return 0.5f;
    }

    @Override
    protected float getMaxBlastRadius() {
        return 4.0f;
    }

    @Override
    public void explode() {
        if (Game.isHost(this.getWorld())) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getBlastRadius(), true);
            this.func_70106_y();
            this.spawnMob();
            this.spawnPotion();
        }
    }

    private String getMobToSpawn() {
        int weight;
        String mob;
        do {
            int index = this.field_70146_Z.nextInt(mobs.size());
            mob = mobs.get(index);
            weight = this.field_70146_Z.nextInt(100);
        } while (mobWeights.get(mob) < weight);
        return mob;
    }

    private void spawnMob() {
        String mobName = this.getMobToSpawn();
        int numToSpawn = mobNumber.get(mobName);
        for (int i = 0; i < numToSpawn; ++i) {
            Entity mob = EntityList.func_75620_a((String)mobName, (World)this.field_70170_p);
            if (mob == null) {
                return;
            }
            double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0;
            double y = this.field_70163_u + (double)mob.field_70131_O + (double)this.field_70146_Z.nextInt(3);
            double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0;
            EntityLiving living = mob instanceof EntityLiving ? (EntityLiving)mob : null;
            mob.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            if (!this.field_70170_p.func_72855_b(mob.field_70121_D) || !this.field_70170_p.func_72945_a(mob, mob.field_70121_D).isEmpty() || this.field_70170_p.func_72953_d(mob.field_70121_D)) continue;
            if (mob instanceof EntitySkeleton) {
                EntitySkeleton skel = (EntitySkeleton)mob;
                if (this.field_70146_Z.nextInt(4) == 0) {
                    skel.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)skel, EntityPlayer.class, 0.25, false));
                    skel.func_82201_a(1);
                    skel.func_70062_b(0, new ItemStack(Items.field_151052_q));
                } else {
                    skel.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)skel, 0.25, 60, 10.0f));
                    skel.func_70062_b(0, new ItemStack((Item)Items.field_151031_f));
                }
                mob.func_70062_b(4, new ItemStack(this.field_70146_Z.nextFloat() < 0.25f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            } else if (living != null) {
                living.func_110161_a(null);
            }
            this.field_70170_p.func_72838_d(mob);
            this.field_70170_p.func_72926_e(2004, (int)x, (int)y, (int)z, 0);
            if (living == null) continue;
            living.func_70656_aK();
        }
    }

    private void spawnPotion() {
        int meta = potions.get(this.field_70146_Z.nextInt(potions.size()));
        ItemStack potion = new ItemStack((Item)Items.field_151068_bn, 1, meta);
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0;
        double y = this.field_70163_u + 1.0 + (double)this.field_70146_Z.nextInt(3) - 1.0;
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0;
        InvTools.dropItem(potion, this.field_70170_p, x, y, z);
    }

    static {
        mobs.add("Skeleton");
        mobs.add("Bat");
        mobs.add("Witch");
        mobs.add("Ghast");
        mobs.add("PigZombie");
        mobs.add("WitherBoss");
        mobWeights.put("Skeleton", 50);
        mobWeights.put("Bat", 75);
        mobWeights.put("Witch", 25);
        mobWeights.put("Ghast", 25);
        mobWeights.put("PigZombie", 25);
        mobWeights.put("WitherBoss", 5);
        mobNumber.put("Skeleton", 1);
        mobNumber.put("Bat", 3);
        mobNumber.put("Witch", 1);
        mobNumber.put("Ghast", 1);
        mobNumber.put("PigZombie", 1);
        mobNumber.put("WitherBoss", 1);
        for (int meta = 0; meta <= Short.MAX_VALUE; ++meta) {
            List effects = PotionHelper.func_77917_b((int)meta, (boolean)false);
            if (effects == null || effects.isEmpty()) continue;
            potions.add(meta);
        }
    }
}

