/*
 * Decompiled with CFR 0.152.
 */
package gregtech.shadow.com.github.technus.avrClone.instructions;

import java.util.ArrayList;
import java.util.TreeSet;

public class OperandLimit {
    public static final ArrayList<OperandLimit> registry = new ArrayList();
    public static final OperandLimit R = new OperandLimit(0, 31).setNameAndRegister("R");
    public static final OperandLimit Rh = new OperandLimit(R, 16, 31).setNameAndRegister("Rh");
    public static final OperandLimit Rq = new OperandLimit(R, 16, 23).setNameAndRegister("Rq");
    public static final OperandLimit Rpair = new OperandLimit(0, 30).setNameAndRegister("Rpair");
    public static final OperandLimit Rpmov = new OperandLimit(Rpair, false, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30).setNameAndRegister("Rpmov");
    public static final OperandLimit Rp = new OperandLimit(Rpair, false, 24, 26, 28, 30).setNameAndRegister("Rp");
    public static final OperandLimit Z = new OperandLimit(Rpair, true, 30).setNameAndRegister("Z");
    public static final OperandLimit mask32 = new OperandLimit().setNameAndRegister("mask");
    public static final OperandLimit b = new OperandLimit(true, mask32).setNameAndRegister("b");
    public static final OperandLimit K32 = new OperandLimit().setNameAndRegister("K32");
    public static final OperandLimit K16 = new OperandLimit(0, 65535).setNameAndRegister("K16");
    public static final OperandLimit K16pointer = new OperandLimit(0, 65535, true).setNameAndRegister("K16*");
    public static final OperandLimit K8s = new OperandLimit(K32, -128, 255).setNameAndRegister("K8s");
    public static final OperandLimit K8b = new OperandLimit(mask32, 0, 255).setNameAndRegister("K8b");
    public static final OperandLimit K6 = new OperandLimit(K16, 0, 63).setNameAndRegister("K6");
    public static final OperandLimit K6pointer = new OperandLimit(K16pointer, 0, 63, true).setNameAndRegister("K6*");
    public static final OperandLimit K1pointer = new OperandLimit(K16pointer, 0, 0, true).setNameAndRegister("K1*");
    public static final OperandLimit IO32 = new OperandLimit().setNameAndRegister("IO32");
    public static final OperandLimit IO16 = new OperandLimit(IO32, 0, 65535).setNameAndRegister("IO16");
    public static final OperandLimit IO8 = new OperandLimit(0, 255).setNameAndRegister("IO8");
    public static final OperandLimit IO6 = new OperandLimit(IO16, 0, 63).setNameAndRegister("IO6");
    public static final OperandLimit IO5 = new OperandLimit(IO8, 0, 31).setNameAndRegister("IO5");
    public static final OperandLimit D32 = new OperandLimit().setNameAndRegister("D32");
    public static final OperandLimit D16 = new OperandLimit(D32, 0, 65535).setNameAndRegister("D16");
    public static final OperandLimit S16 = new OperandLimit(true, null, Short.MIN_VALUE, Short.MAX_VALUE).setRelative().setNameAndRegister("S16");
    public static final OperandLimit S12 = new OperandLimit(true, S16, -2048, 2047).setRelative().setNameAndRegister("S12");
    public static final OperandLimit S8 = new OperandLimit(true, null, -128, 127).setRelative().setNameAndRegister("S8");
    public static final OperandLimit S7 = new OperandLimit(true, S8, -64, 63).setRelative().setNameAndRegister("S7");
    public static final OperandLimit P32 = new OperandLimit().setNameAndRegister("P32");
    public static final OperandLimit P22 = new OperandLimit(P32, 0, 0x3FFFFF).setNameAndRegister("P22");
    public static final OperandLimit FP = new OperandLimit().setFP().setNameAndRegister("FP");
    private OperandLimit broader;
    private boolean asOffset;
    private boolean intMaxMin;
    private boolean floatingPointPreffered;
    private boolean relativePreffered;
    private TreeSet<Integer> possibleValues;
    private final int min;
    private final int max;
    public String name = "UNNAMED";

    private OperandLimit() {
        this.min = Integer.MIN_VALUE;
        this.max = Integer.MAX_VALUE;
    }

    private OperandLimit(int value) {
        this(true, value, value);
    }

    private OperandLimit(int min, int max) {
        this(true, min, max);
    }

    private OperandLimit(int min, int max, boolean intMaxMin) {
        this(true, min, max);
        this.intMaxMin = intMaxMin;
    }

    private OperandLimit(boolean generateOnly8, OperandLimit broader) {
        this.possibleValues = new TreeSet();
        int limit = generateOnly8 ? 8 : 32;
        for (int i = 0; i < limit; ++i) {
            this.possibleValues.add(1 << i);
        }
        this.broader = broader;
        this.min = this.possibleValues.first();
        this.max = this.possibleValues.last();
    }

    private OperandLimit(boolean asOffset, OperandLimit broader, int min, int max) {
        this(true, min, max);
        this.broader = broader;
        this.asOffset = asOffset;
    }

    private OperandLimit(boolean limitOnly, int ... possibleValues) {
        if (limitOnly) {
            this.min = possibleValues[0];
            this.max = possibleValues[possibleValues.length - 1];
        } else {
            this.possibleValues = new TreeSet();
            for (int value : possibleValues) {
                this.possibleValues.add(value);
            }
            this.min = this.possibleValues.first();
            this.max = this.possibleValues.last();
        }
    }

    private OperandLimit(OperandLimit broader, int min, int max) {
        this(true, min, max);
        this.broader = broader;
    }

    private OperandLimit(OperandLimit broader, int min, int max, boolean intMaxMin) {
        this(true, min, max);
        this.broader = broader;
        this.intMaxMin = intMaxMin;
    }

    private OperandLimit(OperandLimit broader, boolean limitOnly, int ... possibleValues) {
        this(limitOnly, possibleValues);
        this.broader = broader;
    }

    private OperandLimit setFP() {
        this.floatingPointPreffered = true;
        return this;
    }

    private OperandLimit setRelative() {
        this.relativePreffered = true;
        return this;
    }

    public int clamp(int value, int programCounter, boolean broader) {
        if (this.asOffset) {
            return this.clampChange(value, programCounter, broader);
        }
        return this.clampValue(value, broader);
    }

    private int clampValue(int value, boolean broader) {
        if (this.intMaxMin && (value == Integer.MIN_VALUE || value == Integer.MAX_VALUE)) {
            return value;
        }
        if (broader && this.broader != null) {
            return this.clampValue(value, false);
        }
        if (this.possibleValues == null) {
            return value > this.max ? this.max : (value < this.min ? this.min : value);
        }
        if (value < this.possibleValues.first()) {
            return this.possibleValues.first();
        }
        return this.possibleValues.floor(value);
    }

    private int clampChange(int newValue, int currentValue, boolean broader) {
        int diff = newValue - currentValue;
        diff = this.clampValue(diff, broader);
        return currentValue + diff;
    }

    private OperandLimit setNameAndRegister(String name) {
        this.name = name;
        registry.add(this);
        return this;
    }

    public String getPossibleValuesString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.possibleValues == null) {
            stringBuilder.append(this.min).append(" to ").append(this.max).append(' ');
        } else {
            for (int i : this.possibleValues) {
                stringBuilder.append(i).append(' ');
            }
        }
        if (this.asOffset) {
            stringBuilder.append("difference");
        }
        if (this.intMaxMin) {
            stringBuilder.append(", special max min ");
        }
        return stringBuilder.toString();
    }

    public OperandLimit getBroader() {
        return this.broader;
    }

    public boolean isFloatingPointPreffered() {
        return this.floatingPointPreffered;
    }

    public boolean isRelativePreffered() {
        return this.relativePreffered;
    }
}

