/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.internal.IGTRecipeAdder;
import gregtech.api.interfaces.internal.IThaumcraftCompat;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.objects.GTCoverDefault;
import gregtech.api.objects.GTCoverNone;
import gregtech.api.objects.GTHashSet;
import gregtech.api.objects.GTItemStack;
import gregtech.api.threads.RunnableCableUpdate;
import gregtech.api.threads.RunnableMachineUpdate;
import gregtech.api.util.CircuitryBehavior;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTCreativeTab;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.item.ItemHolder;
import gregtech.api.world.GTWorldgen;
import gregtech.common.GTDummyWorld;
import gregtech.common.items.ItemIntegratedCircuit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GregTechAPI {
    public static final Collection<Map<?, ?>> sItemStackMappings = new ArrayList();
    public static final Collection<SetMultimap<? extends ItemHolder, ?>> itemStackMultiMaps = new ArrayList();
    public static final short MAXIMUM_METATILE_IDS = 32766;
    public static final CreativeTabs TAB_GREGTECH = new GTCreativeTab("Main", "Main");
    public static final CreativeTabs TAB_GREGTECH_MATERIALS = new GTCreativeTab("Materials", "Materials");
    public static final CreativeTabs TAB_GREGTECH_ORES = new GTCreativeTab("Ores", "Ores");
    public static final IMetaTileEntity[] METATILEENTITIES = new IMetaTileEntity[32766];
    public static final Map<GTItemStack, ITexture> sCovers = new ConcurrentHashMap<GTItemStack, ITexture>();
    public static final Map<GTItemStack, CoverBehaviorBase<?>> sCoverBehaviors = new ConcurrentHashMap();
    public static final Map<Integer, CircuitryBehavior> sCircuitryBehaviors = new ConcurrentHashMap<Integer, CircuitryBehavior>();
    public static final Map<Block, Integer> sMachineIDs = new ConcurrentHashMap<Block, Integer>();
    public static final Map<Integer, Byte> sWirelessRedstone = new ConcurrentHashMap<Integer, Byte>();
    public static final Map<String, Map<Integer, Map<Long, Byte>>> sAdvancedWirelessRedstone = new ConcurrentHashMap<String, Map<Integer, Map<Long, Byte>>>();
    public static final Map<Integer, Integer> sIDSUList = new ConcurrentHashMap<Integer, Integer>();
    public static final Map<String, ItemStack> sBookList = new ConcurrentHashMap<String, ItemStack>();
    @Deprecated
    public static final Map<Integer, String> sSoundList = SoundResource.asSoundList();
    public static final GTHashSet<GTItemStack> sToolList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sCrowbarList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sScrewdriverList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sWrenchList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sSoftHammerList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sHardHammerList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sWireCutterList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sSolderingToolList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sSolderingMetalList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sJackhammerList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sGasHazmatList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sBioHazmatList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sFrostHazmatList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sHeatHazmatList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sRadioHazmatList = new GTHashSet();
    public static final GTHashSet<GTItemStack> sElectroHazmatList = new GTHashSet();
    private static final Multimap<Integer, ItemStack> sRealConfigurationList = Multimaps.newListMultimap(new TreeMap(), ArrayList::new);
    private static final Map<Integer, List<ItemStack>> sConfigurationLists = new ConcurrentHashMap<Integer, List<ItemStack>>();
    private static final Map<Predicate<ItemStack>, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> sRealCircuitProgrammerList = new LinkedHashMap<Predicate<ItemStack>, BiFunction<ItemStack, EntityPlayerMP, ItemStack>>();
    public static final Map<Predicate<ItemStack>, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> sCircuitProgrammerList = Collections.unmodifiableMap(sRealCircuitProgrammerList);
    public static final Collection<Integer> sDimensionalList = new HashSet<Integer>();
    public static final List<GTWorldgen> sWorldgenList = new ArrayList<GTWorldgen>();
    public static final Materials[] sGeneratedMaterials = new Materials[1000];
    public static final CoverBehavior sDefaultBehavior = new GTCoverDefault();
    public static final CoverBehavior sNoBehavior = new GTCoverNone();
    public static volatile int VERSION = 509;
    @Deprecated
    public static IGTRecipeAdder sRecipeAdder;
    public static IThaumcraftCompat sThaumcraftCompat;
    public static List<Runnable> sBeforeGTPreload;
    public static List<Runnable> sAfterGTPreload;
    public static List<Runnable> sBeforeGTLoad;
    public static List<Runnable> sAfterGTLoad;
    public static List<Runnable> sBeforeGTPostload;
    public static List<Runnable> sAfterGTPostload;
    public static List<Runnable> sFirstWorldTick;
    public static List<Runnable> sBeforeGTServerstart;
    public static List<Runnable> sAfterGTServerstart;
    public static List<Runnable> sBeforeGTServerstop;
    public static List<Runnable> sAfterGTServerstop;
    public static List<Runnable> sGTBlockIconload;
    public static List<Runnable> sGTItemIconload;
    public static List<Runnable> sGTCompleteLoad;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sBlockIcons;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sItemIcons;
    public static int TICKS_FOR_LAG_AVERAGING;
    public static int MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING;
    public static Block sBlockMachines;
    public static Block sBlockOres1;
    public static Block sBlockOresUb1;
    public static Block sBlockOresUb2;
    public static Block sBlockOresUb3;
    public static Block sBlockMetal1;
    public static Block sBlockMetal2;
    public static Block sBlockMetal3;
    public static Block sBlockMetal4;
    public static Block sBlockMetal5;
    public static Block sBlockMetal6;
    public static Block sBlockMetal7;
    public static Block sBlockMetal8;
    public static Block sBlockMetal9;
    public static Block sBlockGem1;
    public static Block sBlockGem2;
    public static Block sBlockGem3;
    public static Block sBlockReinforced;
    public static Block sBlockGranites;
    public static Block sBlockConcretes;
    public static Block sBlockStones;
    public static Block sBlockCasings1;
    public static Block sBlockCasings2;
    public static Block sBlockCasings3;
    public static Block sBlockCasings4;
    public static Block sBlockCasings5;
    public static Block sBlockCasings6;
    public static Block sBlockCasings8;
    public static Block sBlockCasings9;
    public static Block sBlockCasings10;
    public static Block sBlockCasings11;
    public static Block sSolenoidCoilCasings;
    public static Block sBlockLongDistancePipes;
    public static Block sDroneRender;
    public static Block sBlockFrames;
    public static Block sBlockGlass1;
    public static Block sBlockTintedGlass;
    public static Block sLaserRender;
    public static Block sWormholeRender;
    public static Block sBlackholeRender;
    public static boolean sTimber;
    public static boolean sDrinksAlwaysDrinkable;
    public static boolean sMultiThreadedSounds;
    public static boolean sDoShowAllItemsInCreative;
    public static boolean sColoredGUI;
    public static boolean sMachineMetalGUI;
    public static boolean sMachineExplosions;
    public static boolean sMachineFlammable;
    public static boolean sMachineNonWrenchExplosions;
    public static boolean sMachineRainExplosions;
    public static boolean sMachineThunderExplosions;
    public static boolean sMachineFireExplosions;
    public static boolean sMachineWireFire;
    public static boolean mOutputRF;
    public static boolean mInputRF;
    public static boolean mRFExplosions;
    public static boolean mServerStarted;
    public static int mEUtoRF;
    public static int mRFtoEU;
    public static boolean sUseMachineMetal;
    public static boolean mUseOnlyGoodSolderingMaterials;
    private static final String aTextIC2Lower;
    public static boolean sUnificationEntriesRegistered;
    public static boolean sPreloadStarted;
    public static boolean sPreloadFinished;
    public static boolean sLoadStarted;
    public static boolean sLoadFinished;
    public static boolean sPostloadStarted;
    public static boolean sPostloadFinished;
    public static boolean sFullLoadFinished;
    private static final IntFunction<TileEntity>[] teCreators;
    private static final Set<Class<?>> dummyWorlds;

    public static void addDummyWorld(Class<?> clazz) {
        dummyWorlds.add(clazz);
    }

    public static boolean isDummyWorld(@Nonnull World w) {
        return dummyWorlds.contains(w.getClass());
    }

    public static ItemStack getUnificatedOreDictStack(ItemStack aOreStack) {
        if (!sPreloadFinished) {
            GTLog.err.println("GregTechAPI ERROR: " + aOreStack.func_77973_b() + "." + aOreStack.func_77960_j() + " - OreDict Unification Entries are not registered now, please call it in the postload phase.");
        }
        return GTOreDictUnificator.get(true, aOreStack);
    }

    public static boolean causeMachineUpdate(World aWorld, int aX, int aY, int aZ) {
        if (aWorld != null && !aWorld.field_72995_K && !GregTechAPI.isDummyWorld(aWorld)) {
            RunnableMachineUpdate.setMachineUpdateValues(aWorld, aX, aY, aZ);
            return true;
        }
        return false;
    }

    public static boolean causeCableUpdate(World aWorld, int aX, int aY, int aZ) {
        if (aWorld == null || aWorld.field_72995_K || GregTechAPI.isDummyWorld(aWorld)) {
            return false;
        }
        RunnableCableUpdate.setCableUpdateValues(aWorld, aX, aY, aZ);
        return true;
    }

    public static boolean registerMachineBlock(Block aBlock, int aMeta) {
        if (aBlock == null) {
            return false;
        }
        if (sThaumcraftCompat != null) {
            sThaumcraftCompat.registerPortholeBlacklistedBlock(aBlock);
        }
        sMachineIDs.put(aBlock, aMeta);
        return true;
    }

    public static boolean registerMachineBlock(Block aBlock, boolean ... aMeta) {
        if (aBlock == null || aMeta == null || aMeta.length == 0) {
            return false;
        }
        if (sThaumcraftCompat != null) {
            sThaumcraftCompat.registerPortholeBlacklistedBlock(aBlock);
        }
        int rMeta = 0;
        for (int i = 0; i < aMeta.length && i < 16; i = (int)((byte)(i + 1))) {
            if (!aMeta[i]) continue;
            rMeta |= GTValues.B[i];
        }
        sMachineIDs.put(aBlock, rMeta);
        return true;
    }

    public static boolean isMachineBlock(Block aBlock, int aMeta) {
        if (aBlock != null) {
            Integer id = sMachineIDs.get(aBlock);
            return id != null && (id & GTValues.B[aMeta]) != 0;
        }
        return false;
    }

    public static BaseMetaTileEntity constructBaseMetaTileEntity() {
        try {
            return new BaseMetaTileEntity();
        }
        catch (Throwable e) {
            GTLog.err.println("GTMod: Fatal Error occurred while initializing TileEntities, crashing Minecraft.");
            e.printStackTrace(GTLog.err);
            throw new RuntimeException(e);
        }
    }

    public static void registerConfigurationCircuit(ItemStack aStack) {
        GregTechAPI.registerConfigurationCircuit(aStack, 0);
    }

    public static void registerConfigurationCircuit(ItemStack aStack, int minTier) {
        if (GTUtility.isStackInvalid(aStack)) {
            return;
        }
        for (ItemStack tRegistered : sRealConfigurationList.values()) {
            if (!GTUtility.areStacksEqual(tRegistered, aStack)) continue;
            return;
        }
        ItemStack stack = GTUtility.copyAmount(0, aStack);
        sRealConfigurationList.put((Object)minTier, (Object)stack);
        for (Map.Entry<Integer, List<ItemStack>> e : sConfigurationLists.entrySet()) {
            if (e.getKey() < minTier) continue;
            e.getValue().add(stack);
            e.getValue().sort(GregTechAPI.getConfigurationCircuitsComparator());
        }
    }

    public static List<ItemStack> getConfigurationCircuitList(int machineTier) {
        return Collections.unmodifiableList(sConfigurationLists.computeIfAbsent(machineTier, t -> sRealConfigurationList.entries().stream().filter(e -> (Integer)e.getKey() <= machineTier).map(Map.Entry::getValue).sorted(GregTechAPI.getConfigurationCircuitsComparator()).collect(Collectors.toList())));
    }

    public static Comparator<ItemStack> getConfigurationCircuitsComparator() {
        return Comparator.comparingInt(is -> is.func_77973_b() instanceof ItemIntegratedCircuit ? 0 : 1).thenComparing(ItemStack::func_77977_a).thenComparing(ItemStack::func_77960_j);
    }

    public static void registerCircuitProgrammer(ItemStack stack, boolean ignoreNBT, boolean useContainer) {
        GregTechAPI.registerCircuitProgrammer((ItemStack rhs) -> GTUtility.areStacksEqual(stack, rhs, ignoreNBT), useContainer);
    }

    public static void registerCircuitProgrammer(Predicate<ItemStack> predicate, boolean useContainer) {
        sRealCircuitProgrammerList.put(predicate, useContainer ? (s, p) -> s.func_77973_b().getContainerItem(s) : (s, p) -> s);
    }

    public static void registerCircuitProgrammer(Predicate<ItemStack> predicate, BiFunction<ItemStack, EntityPlayerMP, ItemStack> doDamage) {
        sRealCircuitProgrammerList.put(predicate, doDamage);
    }

    public static void registerCover(ItemStack aStack, ITexture aCover, CoverBehavior aBehavior) {
        GregTechAPI.registerCover(aStack, aCover, aBehavior);
    }

    public static void registerCover(ItemStack aStack, ITexture aCover, CoverBehaviorBase<?> aBehavior) {
        if (!sCovers.containsKey(new GTItemStack(aStack))) {
            sCovers.put(new GTItemStack(aStack), aCover == null || !aCover.isValidTexture() ? Textures.BlockIcons.ERROR_RENDERING[0] : aCover);
        }
        if (aBehavior != null) {
            sCoverBehaviors.put(new GTItemStack(aStack), aBehavior);
        }
    }

    public static void registerCoverBehavior(ItemStack aStack, CoverBehavior aBehavior) {
        GregTechAPI.registerCoverBehavior(aStack, aBehavior);
    }

    public static void registerCoverBehavior(ItemStack aStack, CoverBehaviorBase<?> aBehavior) {
        sCoverBehaviors.put(new GTItemStack(aStack), aBehavior == null ? sDefaultBehavior : aBehavior);
    }

    public static void registerCover(Collection<ItemStack> aStackList, ITexture aCover, CoverBehavior aBehavior) {
        GregTechAPI.registerCover(aStackList, aCover, aBehavior);
    }

    public static void registerCover(Collection<ItemStack> aStackList, ITexture aCover, CoverBehaviorBase<?> aBehavior) {
        if (aCover.isValidTexture()) {
            aStackList.forEach(tStack -> GregTechAPI.registerCover(tStack, aCover, aBehavior));
        }
    }

    public static CoverBehaviorBase<?> getCoverBehaviorNew(ItemStack aStack) {
        if (aStack == null || aStack.func_77973_b() == null) {
            return sNoBehavior;
        }
        CoverBehaviorBase<?> rCover = sCoverBehaviors.get(new GTItemStack(aStack));
        if (rCover != null) {
            return rCover;
        }
        rCover = sCoverBehaviors.get(new GTItemStack(aStack, true));
        if (rCover != null) {
            return rCover;
        }
        return sDefaultBehavior;
    }

    public static CoverBehaviorBase<?> getCoverBehaviorNew(int aStack) {
        if (aStack == 0) {
            return sNoBehavior;
        }
        return GregTechAPI.getCoverBehaviorNew(GTUtility.intToStack(aStack));
    }

    public static boolean registerWrench(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sWrenchList);
    }

    public static boolean registerCrowbar(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sCrowbarList);
    }

    public static boolean registerScrewdriver(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sScrewdriverList);
    }

    public static boolean registerSoftHammer(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sSoftHammerList);
    }

    public static boolean registerHardHammer(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sHardHammerList);
    }

    public static boolean registerWireCutter(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sWireCutterList);
    }

    public static boolean registerSolderingTool(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sSolderingToolList);
    }

    public static boolean registerSolderingMetal(ItemStack aTool) {
        return GregTechAPI.registerTool(aTool, sSolderingMetalList);
    }

    public static boolean registerTool(ItemStack aTool, Collection<GTItemStack> aToolList) {
        if (aTool == null || GTUtility.isStackInList(aTool, sToolList) || !aTool.func_77973_b().func_77645_m() && !GTModHandler.isElectricItem(aTool) && !(aTool.func_77973_b() instanceof IDamagableItem)) {
            return false;
        }
        aToolList.add(new GTItemStack(GTUtility.copyAmount(1, aTool)));
        sToolList.add(new GTItemStack(GTUtility.copyAmount(1, aTool)));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setBlockIconRegister(IIconRegister aIconRegister) {
        sBlockIcons = aIconRegister;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setItemIconRegister(IIconRegister aIconRegister) {
        sItemIcons = aIconRegister;
    }

    public static void registerTileEntityConstructor(int meta, IntFunction<TileEntity> constructor) {
        if (meta < 0 || meta > 15 || constructor == null) {
            throw new IllegalArgumentException();
        }
        if (teCreators[meta] != null) {
            throw new IllegalStateException("previous constructor: " + teCreators[meta] + " new constructor: " + constructor + " meta:" + meta);
        }
        GregTechAPI.teCreators[meta] = constructor;
    }

    public static TileEntity createTileEntity(int meta) {
        if (teCreators[meta = GTUtility.clamp(meta, 0, 15)] == null) {
            return null;
        }
        return teCreators[meta].apply(meta);
    }

    static {
        sBeforeGTPreload = new ArrayList<Runnable>();
        sAfterGTPreload = new ArrayList<Runnable>();
        sBeforeGTLoad = new ArrayList<Runnable>();
        sAfterGTLoad = new ArrayList<Runnable>();
        sBeforeGTPostload = new ArrayList<Runnable>();
        sAfterGTPostload = new ArrayList<Runnable>();
        sFirstWorldTick = new ArrayList<Runnable>();
        sBeforeGTServerstart = new ArrayList<Runnable>();
        sAfterGTServerstart = new ArrayList<Runnable>();
        sBeforeGTServerstop = new ArrayList<Runnable>();
        sAfterGTServerstop = new ArrayList<Runnable>();
        sGTBlockIconload = new ArrayList<Runnable>();
        sGTItemIconload = new ArrayList<Runnable>();
        sGTCompleteLoad = new ArrayList<Runnable>();
        TICKS_FOR_LAG_AVERAGING = 25;
        MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING = 100;
        sTimber = true;
        sDrinksAlwaysDrinkable = false;
        sMultiThreadedSounds = false;
        sDoShowAllItemsInCreative = false;
        sColoredGUI = true;
        sMachineMetalGUI = false;
        sMachineExplosions = true;
        sMachineFlammable = true;
        sMachineNonWrenchExplosions = true;
        sMachineRainExplosions = true;
        sMachineThunderExplosions = true;
        sMachineFireExplosions = true;
        sMachineWireFire = true;
        mOutputRF = false;
        mInputRF = false;
        mRFExplosions = false;
        mServerStarted = false;
        mEUtoRF = 360;
        mRFtoEU = 20;
        sUseMachineMetal = false;
        mUseOnlyGoodSolderingMaterials = false;
        aTextIC2Lower = Mods.IndustrialCraft2.ID.toLowerCase(Locale.ENGLISH);
        sUnificationEntriesRegistered = false;
        sPreloadStarted = false;
        sPreloadFinished = false;
        sLoadStarted = false;
        sLoadFinished = false;
        sPostloadStarted = false;
        sPostloadFinished = false;
        sFullLoadFinished = false;
        teCreators = new IntFunction[16];
        dummyWorlds = new HashSet();
        sItemStackMappings.add(sCovers);
        sItemStackMappings.add(sCoverBehaviors);
        dummyWorlds.add(GTDummyWorld.class);
    }
}

