/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.worldgen;

import bartworks.system.worldgen.BWWorldGenUtil;
import bartworks.util.Pair;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.threads.RunnableMachineUpdate;
import java.security.SecureRandom;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MapGenRuins
extends WorldGenerator {
    protected Pair<Block, Integer>[][] ToBuildWith = new Pair[4][0];
    int[] statBlocks = new int[4];

    public boolean func_76484_a(World p_76484_1_, Random p_76484_2_, int p_76484_3_, int p_76484_4_, int p_76484_5_) {
        return false;
    }

    protected void setFloorBlocks(int[] metas, Block ... blocks) {
        this.ToBuildWith[0] = new Pair[metas.length];
        for (int i = 0; i < metas.length; ++i) {
            this.ToBuildWith[0][i] = new Pair<Block, Integer>(blocks[i % blocks.length], metas[i]);
        }
    }

    protected void setWallBlocks(int[] metas, Block ... blocks) {
        this.ToBuildWith[1] = new Pair[metas.length];
        for (int i = 0; i < metas.length; ++i) {
            this.ToBuildWith[1][i] = new Pair<Block, Integer>(blocks[i % blocks.length], metas[i]);
        }
    }

    protected void setRoofBlocks(int[] metas, Block ... blocks) {
        this.ToBuildWith[2] = new Pair[metas.length];
        for (int i = 0; i < metas.length; ++i) {
            this.ToBuildWith[2][i] = new Pair<Block, Integer>(blocks[i % blocks.length], metas[i]);
        }
    }

    protected void setMiscBlocks(int[] metas, Block ... blocks) {
        this.ToBuildWith[3] = new Pair[metas.length];
        for (int i = 0; i < metas.length; ++i) {
            this.ToBuildWith[3][i] = new Pair<Block, Integer>(blocks[i % blocks.length], metas[i]);
        }
    }

    protected void setRandomBlockWAirChance(World worldObj, int x, int y, int z, Random rand, int airchance, Pair<Block, Integer> ... blocks) {
        if (rand.nextInt(100) > airchance) {
            this.setRandomBlock(worldObj, x, y, z, rand, blocks);
        } else {
            this.setBlock(worldObj, x, y, z, Blocks.field_150350_a, 0);
        }
    }

    protected void setRandomBlock(World worldObj, int x, int y, int z, Random rand, Pair<Block, Integer> ... blocks) {
        Block toSet = blocks[rand.nextInt(blocks.length)].getKey();
        int meta = blocks[rand.nextInt(blocks.length)].getValue();
        this.setBlock(worldObj, x, y, z, toSet, meta);
    }

    protected void setBlock(World worldObj, int x, int y, int z, Block block, int meta) {
        this.func_150516_a(worldObj, x, y, z, block, meta);
    }

    protected void setBlock(World worldObj, int x, int y, int z, Pair<Block, Integer> pair) {
        this.func_150516_a(worldObj, x, y, z, pair.getKey(), pair.getValue());
    }

    private TileEntity setGTMachineBlock(World worldObj, int x, int y, int z, int meta) {
        boolean isEnabled = true;
        try {
            isEnabled = RunnableMachineUpdate.isEnabled();
        }
        catch (Throwable ignored) {
            isEnabled = false;
        }
        if (isEnabled) {
            throw new IllegalStateException("Machine Block Runnable needs to be disabled while creating world!");
        }
        this.func_150516_a(worldObj, x, y, z, BWWorldGenUtil.GT_TILES, GregTechAPI.METATILEENTITIES[meta].getTileEntityBaseType());
        TileEntity tile = worldObj.func_147438_o(x, y, z);
        ((IGregTechTileEntity)tile).setInitialValuesAsNBT(null, (short)meta);
        return tile;
    }

    protected TileEntity reSetGTTileEntity(IGregTechTileEntity bte, World worldObj, int x, int y, int z, int meta) {
        worldObj.func_147475_p(x, y, z);
        this.setBlock(worldObj, x, y, z, Blocks.field_150350_a, 0);
        return this.setGTMachineBlock(worldObj, x, y, z, meta);
    }

    protected void setGTMachineBlockWChance(World worldObj, int x, int y, int z, Random rand, int airchance, int meta) {
        if (rand.nextInt(100) > airchance) {
            this.setGTMachineBlock(worldObj, x, y, z, meta);
        } else {
            this.setBlock(worldObj, x, y, z, Blocks.field_150350_a, 0);
        }
    }

    protected void setGTCablekWChance(World worldObj, int x, int y, int z, Random rand, int airchance, int meta) {
        if (rand.nextInt(100) > airchance) {
            this.setGTCable(worldObj, x, y, z, meta);
        } else {
            this.setBlock(worldObj, x, y, z, Blocks.field_150350_a, 0);
        }
    }

    protected void setGTMachine(World worldObj, int x, int y, int z, int meta, String ownerName, ForgeDirection facing) {
        try {
            RunnableMachineUpdate.setDisabled();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setGTMachineBlock(worldObj, x, y, z, meta);
        BaseMetaTileEntity BTE = (BaseMetaTileEntity)worldObj.func_147438_o(x, y, z);
        BTE.setOwnerName(ownerName);
        BTE.setFrontFacing(facing);
        BTE = (BaseMetaTileEntity)worldObj.func_147438_o(x, y, z);
        this.checkTile(BTE, worldObj, x, y, z, meta, ownerName, facing, 0);
        try {
            RunnableMachineUpdate.setEnabled();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkTile(BaseMetaTileEntity BTE, World worldObj, int x, int y, int z, int meta, String ownerName, ForgeDirection facing, int depth) {
        if (depth < 25) {
            if (BTE.getMetaTileID() != meta || worldObj.func_147438_o(x, y, z) != BTE || BTE.func_145837_r()) {
                this.redoTile(BTE, worldObj, x, y, z, meta, ownerName, facing);
                this.checkTile(BTE, worldObj, x, y, z, meta, ownerName, facing, depth);
            }
        } else {
            worldObj.func_147475_p(x, y, z);
            worldObj.func_147468_f(x, y, z);
        }
    }

    private void redoTile(BaseMetaTileEntity BTE, World worldObj, int x, int y, int z, int meta, String ownerName, ForgeDirection facing) {
        this.reSetGTTileEntity(BTE, worldObj, x, y, z, meta);
        BTE = (BaseMetaTileEntity)worldObj.func_147438_o(x, y, z);
        BTE.setOwnerName(ownerName);
        BTE.setFrontFacing(facing);
    }

    protected void setGTCable(World worldObj, int x, int y, int z, int meta) {
        try {
            RunnableMachineUpdate.setDisabled();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BaseMetaPipeEntity BTE = (BaseMetaPipeEntity)this.setGTMachineBlock(worldObj, x, y, z, meta);
        MetaPipeEntity MPE = (MetaPipeEntity)BTE.getMetaTileEntity();
        BTE.mConnections = (byte)(BTE.mConnections | 0x10);
        BTE.mConnections = (byte)(BTE.mConnections | (byte)(1 << ForgeDirection.getOrientation((int)4).getOpposite().ordinal()));
        BaseMetaTileEntity BPE = (BaseMetaTileEntity)worldObj.func_147438_o(x, y, z - 1);
        if (BPE != null) {
            BTE.mConnections = (byte)(BTE.mConnections | 4);
        }
        MPE.mConnections = BTE.mConnections;
        try {
            RunnableMachineUpdate.setEnabled();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class RuinsBase
    extends MapGenRuins {
        private static final String owner = "Ancient Cultures";

        @Override
        public boolean func_76484_a(World worldObj, Random rand1, int x, int y, int z) {
            for (int i = 0; i < rand1.nextInt(144); ++i) {
                rand1.nextLong();
            }
            XSTR rand = new XSTR(rand1.nextLong());
            SecureRandom secureRandom = new SecureRandom();
            if (worldObj.func_147439_a(x, y, z) == Blocks.field_150350_a) {
                while (worldObj.func_147439_a(x, y, z) == Blocks.field_150350_a) {
                    --y;
                }
            }
            this.setFloorBlocks(new int[]{0, 0, 0}, new Block[]{Blocks.field_150336_V, Blocks.field_150334_T, Blocks.field_150417_aV});
            this.setWallBlocks(new int[]{0, 1, 2, 1, 1}, Blocks.field_150417_aV);
            this.setRoofBlocks(new int[]{9}, Blocks.field_150364_r);
            this.setMiscBlocks(new int[]{1}, Blocks.field_150364_r);
            this.statBlocks = new int[]{((Random)rand).nextInt(this.ToBuildWith[0].length)};
            int colored = ((Random)rand).nextInt(15);
            int tier = secureRandom.nextInt(5);
            boolean useColor = ((Random)rand).nextBoolean();
            byte set = 0;
            byte toSet = (byte)(((Random)rand).nextInt(5 - tier) + 1);
            int cablemeta = BWWorldGenUtil.getCable(secureRandom, tier);
            int treeinaRow = 0;
            boolean lastset = ((Random)rand).nextBoolean();
            for (int dx = -6; dx <= 6; ++dx) {
                for (int dy = 0; dy <= 8; ++dy) {
                    block11: for (int dz = -6; dz <= 6; ++dz) {
                        this.setBlock(worldObj, x + dx, y + dy, z + dz, Blocks.field_150350_a, 0);
                        if (dy == 0) {
                            Pair floor = this.ToBuildWith[0][this.statBlocks[0]];
                            this.setBlock(worldObj, x + dx, y + 0, z + dz, (Block)floor.getKey(), (Integer)floor.getValue());
                            continue;
                        }
                        if (dy > 0 && dy < 4) {
                            if (Math.abs(dx) == 5 && Math.abs(dz) == 5) {
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, rand, 5, this.ToBuildWith[3][0]);
                            } else if (dx == 0 && dz == -5 && (dy == 1 || dy == 2)) {
                                if (dy == 1) {
                                    this.setBlock(worldObj, x + dx, y + 1, z - 5, Blocks.field_150454_av, 1);
                                }
                                if (dy == 2) {
                                    this.setBlock(worldObj, x + dx, y + 2, z + dz, Blocks.field_150454_av, 8);
                                }
                            } else if (Math.abs(dx) == 5 && Math.abs(dz) < 5 || Math.abs(dz) == 5 && Math.abs(dx) < 5) {
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, rand, 25, this.ToBuildWith[1]);
                                if (dy == 2 && ((Random)rand).nextInt(100) < 12) {
                                    if (useColor) {
                                        this.setRandomBlockWAirChance(worldObj, x + dx, y + 2, z + dz, rand, 25, new Pair<BlockStainedGlassPane, Integer>(Blocks.field_150397_co, colored));
                                    }
                                } else {
                                    this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, rand, 25, new Pair<Block, Integer>(Blocks.field_150410_aZ, 0));
                                }
                            }
                            if (dy == 3 && Math.abs(dx) == 6) {
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + 3, z + dz, rand, 25, this.ToBuildWith[2]);
                            }
                            if (dy != 1) continue;
                            if (dx == 3 && dz == -3) {
                                this.setBlock(worldObj, x + 3, y + 1, z + dz, Blocks.field_150462_ai, 0);
                            }
                            if (dx == -3 && (dz == -3 || dz == -2)) {
                                this.setBlock(worldObj, x - 3, y + dy, z + dz, (Block)Blocks.field_150486_ae, 5);
                                IInventory chest = (IInventory)worldObj.func_147438_o(x + dx, y + dy, z + dz);
                                if (chest != null) {
                                    WeightedRandomChestContent.func_76293_a((Random)secureRandom, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"pyramidJungleChest", (Random)rand), (IInventory)chest, (int)ChestGenHooks.getCount((String)"pyramidJungleChest", (Random)rand));
                                }
                            }
                            if (dx == 4 && dz == 4) {
                                int meta = BWWorldGenUtil.getGenerator(secureRandom, tier);
                                this.setGTMachine(worldObj, x + dx, y + dy, z + dz, meta, owner, tier > 0 ? ForgeDirection.WEST : ForgeDirection.UP);
                                continue;
                            }
                            if (dx == 3 && dz == 4) {
                                if (tier > 0) {
                                    int meta = BWWorldGenUtil.getBuffer(secureRandom, tier);
                                    this.setGTMachine(worldObj, x + dx, y + dy, z + dz, meta, owner, ForgeDirection.WEST);
                                    continue;
                                }
                                this.setGTCablekWChance(worldObj, x + dx, y + dy, z + dz, rand, 33, cablemeta);
                                continue;
                            }
                            if (dx < 3 && dx > -5 && dz == 4) {
                                this.setGTCablekWChance(worldObj, x + dx, y + dy, z + dz, rand, 33, cablemeta);
                                continue;
                            }
                            if (dx >= 3 || dx <= -5 || dz != 3 || set >= toSet) continue;
                            if (!lastset || treeinaRow > 2) {
                                int meta = BWWorldGenUtil.getMachine(secureRandom, tier);
                                this.setGTMachine(worldObj, x + dx, y + dy, z + dz, meta, owner, ForgeDirection.UP);
                                set = (byte)(set + 1);
                                treeinaRow = 0;
                                lastset = true;
                                continue;
                            }
                            lastset = ((Random)rand).nextBoolean();
                            if (!lastset) continue;
                            treeinaRow = (byte)(treeinaRow + 1);
                            continue;
                        }
                        switch (dy) {
                            case 4: {
                                if (Math.abs(dx) == 5) {
                                    this.setRandomBlockWAirChance(worldObj, x + dx, y + 4, z + dz, rand, 25, this.ToBuildWith[2]);
                                    continue block11;
                                }
                                if (Math.abs(dz) != 5 || Math.abs(dx) >= 5) continue block11;
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, rand, 25, this.ToBuildWith[1]);
                                continue block11;
                            }
                            case 5: {
                                if (Math.abs(dx) == 4) {
                                    this.setRandomBlockWAirChance(worldObj, x + dx, y + 5, z + dz, rand, 25, this.ToBuildWith[2]);
                                    continue block11;
                                }
                                if (Math.abs(dz) != 5 || Math.abs(dx) >= 4) continue block11;
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, rand, 25, this.ToBuildWith[1]);
                                continue block11;
                            }
                            case 6: {
                                if (Math.abs(dx) == 3) {
                                    this.setRandomBlockWAirChance(worldObj, x + dx, y + 6, z + dz, rand, 25, this.ToBuildWith[2]);
                                    continue block11;
                                }
                                if (Math.abs(dz) != 5 || Math.abs(dx) >= 3) continue block11;
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, rand, 25, this.ToBuildWith[1]);
                                continue block11;
                            }
                            case 7: {
                                if (Math.abs(dx) == 2) {
                                    this.setRandomBlockWAirChance(worldObj, x + dx, y + 7, z + dz, rand, 25, this.ToBuildWith[2]);
                                    continue block11;
                                }
                                if (Math.abs(dz) != 5 || Math.abs(dx) >= 2) continue block11;
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, rand, 25, this.ToBuildWith[1]);
                                continue block11;
                            }
                            case 8: {
                                if (Math.abs(dx) != 1 && Math.abs(dx) != 0) continue block11;
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + 8, z + dz, rand, 25, this.ToBuildWith[2]);
                                continue block11;
                            }
                        }
                    }
                }
            }
            block12: while (set < toSet) {
                int dy = 1;
                int dz = 3;
                for (int dx = 2; dx > -5; --dx) {
                    if (set >= toSet) break block12;
                    if (!lastset || treeinaRow > 2 && worldObj.func_147438_o(x + dx, y + dy, z + dz) == null) {
                        int meta = BWWorldGenUtil.getMachine(secureRandom, tier);
                        this.setGTMachine(worldObj, x + dx, y + dy, z + dz, meta, owner, ForgeDirection.UP);
                        set = (byte)(set + 1);
                        treeinaRow = 0;
                        lastset = true;
                        continue;
                    }
                    lastset = ((Random)rand).nextBoolean();
                    if (!lastset) continue;
                    treeinaRow = (byte)(treeinaRow + 1);
                }
            }
            return true;
        }
    }
}

