/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.PoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.spawner.BlockPoweredSpawner;
import crazypants.enderio.machine.spawner.DummyRecipe;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TilePoweredSpawner
extends AbstractPoweredTaskEntity {
    public static final int MIN_SPAWN_DELAY_BASE = Config.poweredSpawnerMinDelayTicks;
    public static final int MAX_SPAWN_DELAY_BASE = Config.poweredSpawnerMaxDelayTicks;
    public static final int POWER_PER_TICK_ONE = Config.poweredSpawnerLevelOnePowerPerTickRF;
    private static final BasicCapacitor CAP_ONE = new BasicCapacitor(Capacitors.BASIC_CAPACITOR.capacitor.getTier(), (int)((double)POWER_PER_TICK_ONE * 1.25), Capacitors.BASIC_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_TWO = Config.poweredSpawnerLevelTwoPowerPerTickRF;
    private static final BasicCapacitor CAP_TWO = new BasicCapacitor(Capacitors.ACTIVATED_CAPACITOR.capacitor.getTier(), (int)((double)POWER_PER_TICK_TWO * 1.25), Capacitors.ACTIVATED_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_THREE = Config.poweredSpawnerLevelThreePowerPerTickRF;
    private static final BasicCapacitor CAP_THREE = new BasicCapacitor(Capacitors.ENDER_CAPACITOR.capacitor.getTier(), (int)((double)POWER_PER_TICK_THREE * 1.25), Capacitors.ENDER_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_FOUR = Config.poweredSpawnerLevelFourPowerPerTickRF;
    private static final BasicCapacitor CAP_FOUR = new BasicCapacitor(Capacitors.CRYSTALLINE_CAPACITOR.capacitor.getTier(), (int)((double)POWER_PER_TICK_FOUR * 1.25), Capacitors.CRYSTALLINE_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_FIVE = Config.poweredSpawnerLevelFivePowerPerTickRF;
    private static final BasicCapacitor CAP_FIVE = new BasicCapacitor(Capacitors.MELODIC_CAPACITOR.capacitor.getTier(), (int)((double)POWER_PER_TICK_FIVE * 1.25), Capacitors.MELODIC_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_SIX = Config.poweredSpawnerLevelSixPowerPerTickRF;
    private static final BasicCapacitor CAP_SIX = new BasicCapacitor(Capacitors.STELLAR_CAPACITOR.capacitor.getTier(), (int)((double)POWER_PER_TICK_SIX * 1.25), Capacitors.STELLAR_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_SEVEN = Config.poweredSpawnerLevelSevenPowerPerTickRF;
    private static final BasicCapacitor CAP_SEVEN = new BasicCapacitor(Capacitors.TOTEMIC_CAPACITOR.capacitor.getTier(), (int)((double)POWER_PER_TICK_SEVEN * 1.25), Capacitors.TOTEMIC_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_EIGHT = Config.poweredSpawnerLevelEightPowerPerTickRF;
    private static final BasicCapacitor CAP_EIGHT = new BasicCapacitor(Capacitors.SILVER_CAPACITOR.capacitor.getTier(), (int)((double)POWER_PER_TICK_EIGHT * 1.25), Capacitors.SILVER_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_NINE = Config.poweredSpawnerLevelNinePowerPerTickRF;
    private static final BasicCapacitor CAP_NINE = new BasicCapacitor(Capacitors.ENDERGETIC_CAPACITOR.capacitor.getTier(), (int)((double)POWER_PER_TICK_NINE * 1.25), Capacitors.ENDERGETIC_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int POWER_PER_TICK_TEN = Config.poweredSpawnerLevelTenPowerPerTickRF;
    private static final BasicCapacitor CAP_TEN = new BasicCapacitor(Capacitors.ENDERGISED_CAPACITOR.capacitor.getTier(), (int)((double)POWER_PER_TICK_TEN * 1.25), Capacitors.ENDERGISED_CAPACITOR.capacitor.getMaxEnergyStored());
    public static final int MIN_PLAYER_DISTANCE = Config.poweredSpawnerMaxPlayerDistance;
    public static final boolean USE_VANILLA_SPAWN_CHECKS = Config.poweredSpawnerUseVanillaSpawChecks;
    private static final String NULL_ENTITY_NAME = "None";
    private String entityTypeName = "None";
    private boolean isSpawnMode = true;
    private int powerUsePerTick;
    private int remainingSpawnTries;

    public TilePoweredSpawner() {
        super(new SlotDefinition(1, 1, 1));
    }

    public boolean isSpawnMode() {
        return this.isSpawnMode;
    }

    public void setSpawnMode(boolean isSpawnMode) {
        if (isSpawnMode != this.isSpawnMode) {
            this.currentTask = null;
        }
        this.isSpawnMode = isSpawnMode;
    }

    @Override
    protected void taskComplete() {
        super.taskComplete();
        if (this.isSpawnMode) {
            this.remainingSpawnTries = Config.poweredSpawnerSpawnCount + Config.poweredSpawnerMaxSpawnTries;
            for (int i = 0; i < Config.poweredSpawnerSpawnCount && this.remainingSpawnTries > 0 && this.trySpawnEntity(); ++i) {
            }
        } else {
            if (this.func_70301_a(0) == null || this.func_70301_a(1) != null || !this.hasEntityName()) {
                return;
            }
            ItemStack res = EnderIO.itemSoulVessel.createVesselWithEntityStub(this.getEntityName());
            this.func_70298_a(0, 1);
            this.func_70299_a(1, res);
        }
    }

    @Override
    public void onCapacitorTypeChange() {
        int basePowerUse;
        BasicCapacitor refCap;
        switch (this.getCapacitorType()) {
            default: {
                refCap = CAP_ONE;
                basePowerUse = POWER_PER_TICK_ONE;
                break;
            }
            case ACTIVATED_CAPACITOR: {
                refCap = CAP_TWO;
                basePowerUse = POWER_PER_TICK_TWO;
                break;
            }
            case ENDER_CAPACITOR: {
                refCap = CAP_THREE;
                basePowerUse = POWER_PER_TICK_THREE;
                break;
            }
            case CRYSTALLINE_CAPACITOR: {
                refCap = CAP_FOUR;
                basePowerUse = POWER_PER_TICK_FOUR;
                break;
            }
            case MELODIC_CAPACITOR: {
                refCap = CAP_FIVE;
                basePowerUse = POWER_PER_TICK_FIVE;
                break;
            }
            case STELLAR_CAPACITOR: {
                refCap = CAP_SIX;
                basePowerUse = POWER_PER_TICK_SIX;
                break;
            }
            case TOTEMIC_CAPACITOR: {
                refCap = CAP_SEVEN;
                basePowerUse = POWER_PER_TICK_SEVEN;
                break;
            }
            case SILVER_CAPACITOR: {
                refCap = CAP_EIGHT;
                basePowerUse = POWER_PER_TICK_EIGHT;
                break;
            }
            case ENDERGETIC_CAPACITOR: {
                refCap = CAP_NINE;
                basePowerUse = POWER_PER_TICK_NINE;
                break;
            }
            case ENDERGISED_CAPACITOR: {
                refCap = CAP_TEN;
                basePowerUse = POWER_PER_TICK_TEN;
            }
        }
        double multiplier = PoweredSpawnerConfig.getInstance().getCostMultiplierFor(this.getEntityName());
        this.setCapacitor(new BasicCapacitor(refCap.getTier(), (int)((double)refCap.getMaxEnergyExtracted() * multiplier), refCap.getMaxEnergyStored()));
        this.powerUsePerTick = (int)Math.ceil((double)basePowerUse * multiplier);
        this.forceClientUpdate = true;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockPoweredSpawner.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null || this.isSpawnMode) {
            return false;
        }
        if (this.slotDefinition.isInputSlot(i)) {
            return itemstack.func_77973_b() == EnderIO.itemSoulVessel && !EnderIO.itemSoulVessel.containsSoul(itemstack);
        }
        return false;
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        if (!this.hasEntityName()) {
            return null;
        }
        if (this.isSpawnMode ? MIN_PLAYER_DISTANCE > 0 && this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, (double)MIN_PLAYER_DISTANCE) == null : this.func_70301_a(0) == null || this.func_70301_a(1) != null) {
            return null;
        }
        return new DummyRecipe();
    }

    @Override
    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        return super.startNextTask(nextRecipe, chance);
    }

    @Override
    public int getPowerUsePerTick() {
        return this.powerUsePerTick;
    }

    @Override
    protected boolean hasInputStacks() {
        return true;
    }

    @Override
    protected boolean canInsertResult(float chance, IMachineRecipe nextRecipe) {
        return true;
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        String mobType = BlockPoweredSpawner.readMobTypeFromNBT(nbtRoot);
        if (mobType == null) {
            mobType = NULL_ENTITY_NAME;
        }
        this.entityTypeName = mobType;
        this.isSpawnMode = !nbtRoot.func_74764_b("isSpawnMode") ? true : nbtRoot.func_74767_n("isSpawnMode");
        super.readCommon(nbtRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        if (this.hasEntityName()) {
            BlockPoweredSpawner.writeMobTypeToNBT(nbtRoot, this.getEntityName());
        } else {
            BlockPoweredSpawner.writeMobTypeToNBT(nbtRoot, null);
        }
        nbtRoot.func_74757_a("isSpawnMode", this.isSpawnMode);
        super.writeCommon(nbtRoot);
    }

    @Override
    protected void updateEntityClient() {
        if (this.isActive()) {
            double x = (float)this.field_145851_c + this.field_145850_b.field_73012_v.nextFloat();
            double y = (float)this.field_145848_d + this.field_145850_b.field_73012_v.nextFloat();
            double z = (float)this.field_145849_e + this.field_145850_b.field_73012_v.nextFloat();
            this.field_145850_b.func_72869_a("smoke", x, y, z, 0.0, 0.0, 0.0);
            this.field_145850_b.func_72869_a("flame", x, y, z, 0.0, 0.0, 0.0);
        }
        super.updateEntityClient();
    }

    @Override
    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        PoweredTask res = new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
        int ticksDelay = this.isSpawnMode ? MIN_SPAWN_DELAY_BASE + (int)Math.round((double)(MAX_SPAWN_DELAY_BASE - MIN_SPAWN_DELAY_BASE) * Math.random()) : MAX_SPAWN_DELAY_BASE - (MAX_SPAWN_DELAY_BASE - MIN_SPAWN_DELAY_BASE) / 2;
        int powerPerTick = this.getPowerUsePerTick();
        res.setRequiredEnergy(powerPerTick * (ticksDelay >>= Math.min(3, this.getCapacitor().getTier() - 1)));
        return res;
    }

    protected boolean canSpawnEntity(EntityLiving entityliving) {
        boolean spaceClear;
        boolean bl = spaceClear = this.field_145850_b.func_72855_b(entityliving.field_70121_D) && this.field_145850_b.func_72945_a((Entity)entityliving, entityliving.field_70121_D).isEmpty() && (!this.field_145850_b.func_72953_d(entityliving.field_70121_D) || entityliving.isCreatureType(EnumCreatureType.waterCreature, false));
        if (spaceClear && USE_VANILLA_SPAWN_CHECKS) {
            spaceClear = entityliving.func_70601_bi();
        }
        return spaceClear;
    }

    Entity createEntity(boolean forceAlive) {
        Entity ent = EntityList.func_75620_a((String)this.getEntityName(), (World)this.field_145850_b);
        if (forceAlive && MIN_PLAYER_DISTANCE <= 0 && Config.poweredSpawnerDespawnTimeSeconds > 0 && ent instanceof EntityLiving) {
            ent.getEntityData().func_74772_a("spawnedByPoweredSpawner", this.field_145850_b.func_82737_E());
            ((EntityLiving)ent).func_110163_bv();
        }
        return ent;
    }

    protected boolean trySpawnEntity() {
        int nearbyEntities;
        Entity entity = this.createEntity(true);
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        int spawnRange = Config.poweredSpawnerSpawnRange;
        if (Config.poweredSpawnerMaxNearbyEntities > 0 && (nearbyEntities = this.field_145850_b.func_72872_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)(this.field_145851_c - spawnRange * 2), (double)(this.field_145848_d - 4), (double)(this.field_145849_e - spawnRange * 2), (double)(this.field_145851_c + spawnRange * 2), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + spawnRange * 2))).size()) >= Config.poweredSpawnerMaxNearbyEntities) {
            return false;
        }
        while (this.remainingSpawnTries-- > 0) {
            double x = (double)this.field_145851_c + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange;
            double y = this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(3) - 1;
            double z = (double)this.field_145849_e + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange;
            entity.func_70012_b(x, y, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!this.canSpawnEntity(entityliving)) continue;
            entityliving.func_110161_a(null);
            this.field_145850_b.func_72838_d((Entity)entityliving);
            this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
            entityliving.func_70656_aK();
            return true;
        }
        return false;
    }

    public String getEntityName() {
        return this.entityTypeName;
    }

    public boolean hasEntityName() {
        return !NULL_ENTITY_NAME.equals(this.entityTypeName);
    }
}

