/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules;

import com.gtnewhorizons.gtnhintergalactic.gui.IG_UITextures;
import com.gtnewhorizons.gtnhintergalactic.recipe.IGRecipeMaps;
import com.gtnewhorizons.gtnhintergalactic.recipe.IG_Recipe;
import com.gtnewhorizons.gtnhintergalactic.spaceprojects.ProjectAsteroidOutpost;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules.ModuleOverclockDescriber;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules.TileEntityModuleBase;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IOverclockDescriptionProvider;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.objects.XSTR;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.ParallelHelper;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.enums.SolarSystem;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceBody;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.TecTech;
import tectech.thing.gui.TecTechUITextures;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public abstract class TileEntityModuleMiner
extends TileEntityModuleBase
implements IOverclockDescriptionProvider {
    protected static int BONUS_STACK_BASE_CHANCE = 5000;
    protected static int BONUS_STACK_MAX_CHANCE = 7500;
    protected static final double MIN_RECIPE_TIME_MODIFIER = 0.5;
    protected static final double MAX_DISTANCE = 300.0;
    protected static int PLASMA_HELIUM_USAGE = 1000;
    protected static int PLASMA_BISMUTH_USAGE = 500;
    protected static int PLASMA_RADON_USAGE = 300;
    protected static int WHITELIST_SIZE = 64;
    protected static int WHITELIST_WINDOW_ID = 200;
    protected static String IS_WHITELISTED_NBT_TAG = "isWhitelisted";
    protected static String WHITELIST_NBT_TAG = "whitelist";
    protected boolean wasFilterModified;
    protected static final ISpaceProject ASTEROID_OUTPOST = SpaceProjectManager.getProject((String)"AsteroidOutput");
    Parameters.Group.ParameterIn distanceSetting;
    Parameters.Group.ParameterIn parallelSetting;
    Parameters.Group.ParameterIn overdriveSetting;
    Parameters.Group.ParameterIn modeSetting;
    Parameters.Group.ParameterIn rangeSetting;
    Parameters.Group.ParameterIn stepSetting;
    Parameters.Group.ParameterOut distanceDisplay;
    private static final INameFunction<TileEntityModuleMiner> DISTANCE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.0");
    private static final IStatusFunction<TileEntityModuleMiner> DISTANCE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)0.0, (double)200.0, (double)300.0, (double[])new double[0]);
    private static final INameFunction<TileEntityModuleMiner> PARALLEL_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.1");
    private static final IStatusFunction<TileEntityModuleMiner> PARALLEL_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)100.0, (double)base.getMaxParallels(), (double[])new double[0]);
    private static final INameFunction<TileEntityModuleMiner> OVERDRIVE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.2");
    private static final IStatusFunction<TileEntityModuleMiner> OVERDRIVE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)1.5, (double)2.0, (double[])new double[0]);
    private static final INameFunction<TileEntityModuleMiner> MODE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.4");
    private static final IStatusFunction<TileEntityModuleMiner> MODE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)0.0, (double)1.1, (double)1.1, (double[])new double[0]);
    private static final INameFunction<TileEntityModuleMiner> RANGE_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.5");
    private static final IStatusFunction<TileEntityModuleMiner> RANGE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)0.0, (double)50.0, (double)150.0, (double[])new double[0]);
    private static final INameFunction<TileEntityModuleMiner> STEP_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.6");
    private static final IStatusFunction<TileEntityModuleMiner> STEP_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)0.0, (double)10.0, (double)20.0, (double[])new double[0]);
    protected final OverclockDescriber overclockDescriber;
    protected ProjectAsteroidOutpost asteroidOutpost;
    protected boolean isWhitelisted = false;
    protected HashSet<String> configuredOres;
    protected ItemStackHandler whiteListHandler = new ItemStackHandler(WHITELIST_SIZE);
    protected static Textures.BlockIcons.CustomIcon engraving;

    public TileEntityModuleMiner(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aID, aName, aNameRegional, tTier, tModuleTier, tMinMotorTier);
        this.overclockDescriber = new ModuleOverclockDescriber((byte)tTier, tModuleTier);
    }

    public TileEntityModuleMiner(String aName, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aName, tTier, tModuleTier, tMinMotorTier);
        this.overclockDescriber = new ModuleOverclockDescriber((byte)tTier, tModuleTier);
    }

    public OverclockDescriber getOverclockDescriber() {
        return this.overclockDescriber;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isWhitelisted = aNBT.func_74767_n(IS_WHITELISTED_NBT_TAG);
        if (this.whiteListHandler != null) {
            this.whiteListHandler.deserializeNBT(aNBT.func_74775_l(WHITELIST_NBT_TAG));
        }
        this.generateOreConfigurationList();
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a(IS_WHITELISTED_NBT_TAG, this.isWhitelisted);
        if (this.whiteListHandler != null) {
            aNBT.func_74782_a(WHITELIST_NBT_TAG, (NBTBase)this.whiteListHandler.serializeNBT());
        }
    }

    public RecipeMap<?> getRecipeMap() {
        return IGRecipeMaps.spaceMiningRecipes;
    }

    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        if (!this.overdriveSetting.getStatus((boolean)false).isOk) {
            return SimpleCheckRecipeResult.ofFailure((String)"invalid_overdrive");
        }
        if (GTValues.V[this.tTier] * (long)this.parallelSetting.get() > this.getEUVar()) {
            return CheckRecipeResultRegistry.insufficientPower((long)(GTValues.V[this.tTier] * (long)this.parallelSetting.get()));
        }
        this.lEUt = 0L;
        this.eAmpereFlow = 0L;
        this.eRequiredData = 0L;
        this.mEfficiencyIncrease = 0;
        this.mPollution = 0;
        this.mOutputItems = null;
        this.mOutputFluids = null;
        ArrayList inputFluids = this.getStoredFluids();
        if (inputFluids.isEmpty()) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_plasma");
        }
        for (FluidStack fluidStack : inputFluids) {
            CheckRecipeResult result;
            int availablePlasmaTier = this.getTierFromPlasma(fluidStack);
            if (availablePlasmaTier <= 0 || !(result = this.process(this.getStoredInputs().toArray(new ItemStack[0]), inputFluids.toArray(new FluidStack[0]), availablePlasmaTier, fluidStack, this.getParallels(fluidStack, this.getPlasmaUsageFromTier(availablePlasmaTier)))).wasSuccessful()) continue;
            this.cycleDistance();
            return result;
        }
        this.cycleDistance();
        return CheckRecipeResultRegistry.NO_RECIPE;
    }

    public CheckRecipeResult process(ItemStack[] inputs, FluidStack[] fluidInputs, int availablePlasmaTier, FluidStack plasma, int maxParallels) {
        int recipeIndex;
        if (inputs == null && fluidInputs == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (plasma == null || availablePlasmaTier <= 0) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_plasma");
        }
        long tVoltage = this.getMaxInputVoltage();
        int distance = (int)this.distanceDisplay.get();
        List recipes = IGRecipeMaps.spaceMiningRecipes.findRecipeQuery().items(inputs).fluids(fluidInputs).voltage(tVoltage).findAll().filter(IG_Recipe.IG_SpaceMiningRecipe.class::isInstance).map(IG_Recipe.IG_SpaceMiningRecipe.class::cast).filter(recipe -> recipe.minDistance <= distance && recipe.maxDistance >= distance && recipe.mSpecialValue <= this.tModuleTier).collect(Collectors.toList());
        if (recipes.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        float compModifier = 1.0f;
        float plasmaModifier = 1.0f;
        if (this.asteroidOutpost != null) {
            compModifier -= this.asteroidOutpost.getComputationDiscount();
            plasmaModifier -= this.asteroidOutpost.getPlasmaDiscount();
        }
        int totalWeight = recipes.stream().mapToInt(IG_Recipe.IG_SpaceMiningRecipe::getRecipeWeight).sum();
        double r = Math.random() * (double)totalWeight;
        for (recipeIndex = 0; recipeIndex < recipes.size() - 1 && !((r -= (double)((IG_Recipe.IG_SpaceMiningRecipe)((Object)recipes.get(recipeIndex))).getRecipeWeight()) <= 0.0); ++recipeIndex) {
        }
        IG_Recipe.IG_SpaceMiningRecipe tRecipe = (IG_Recipe.IG_SpaceMiningRecipe)((Object)recipes.get(recipeIndex));
        if (tRecipe == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if ((long)tRecipe.mEUt > tVoltage) {
            return CheckRecipeResultRegistry.insufficientPower((long)tRecipe.mEUt);
        }
        if ((maxParallels = (int)Math.min((float)maxParallels, (float)this.getAvailableData_EM() / ((float)tRecipe.computation * compModifier))) <= 0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        ParallelHelper helper = new ParallelHelper().setMaxParallel(maxParallels).setRecipe((GTRecipe)tRecipe).setFluidInputs(fluidInputs).setItemInputs(inputs).setAvailableEUt(GTValues.V[this.tTier]).setMachine((IVoidable)this, false, false).setConsumption(true).build();
        int parallels = helper.getCurrentParallel();
        if (parallels <= 0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        HashMap<GTUtility.ItemId, Long> outputs = new HashMap<GTUtility.ItemId, Long>();
        int totalChance = Arrays.stream(tRecipe.mChances).sum();
        try {
            block3: for (int i = 0; i < tRecipe.maxSize * parallels; ++i) {
                int bonusStackChance = 0;
                if (i >= tRecipe.minSize * parallels) {
                    bonusStackChance = this.getBonusStackChance(availablePlasmaTier);
                }
                if (i >= tRecipe.minSize * parallels && bonusStackChance <= XSTR.XSTR_INSTANCE.nextInt(10000)) continue;
                int random = XSTR.XSTR_INSTANCE.nextInt(totalChance);
                int currentChance = 0;
                for (int j = 0; j < tRecipe.mChances.length; ++j) {
                    if (random > (currentChance += tRecipe.mChances[j])) continue;
                    ItemStack generatedOre = tRecipe.mOutputs[j];
                    if (this.configuredOres != null && !this.configuredOres.isEmpty() && this.isWhitelisted != this.configuredOres.contains(this.getOreString(generatedOre))) continue block3;
                    outputs.merge(GTUtility.ItemId.createNoCopy((ItemStack)generatedOre), Long.valueOf(generatedOre.field_77994_a), Long::sum);
                    continue block3;
                }
            }
        }
        catch (Exception ignored) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        plasma.amount = (int)Math.max(0.0, Math.ceil((float)plasma.amount - (float)(parallels * this.getPlasmaUsageFromTier(availablePlasmaTier)) * plasmaModifier));
        ArrayList outputItems = new ArrayList();
        for (Map.Entry entry : outputs.entrySet()) {
            ParallelHelper.addItemsLong(outputItems, (ItemStack)((GTUtility.ItemId)entry.getKey()).getItemStack(), (long)((Long)entry.getValue()));
        }
        this.mOutputItems = outputItems.toArray(new ItemStack[0]);
        this.lEUt = (long)(-tRecipe.mEUt) * (long)parallels;
        this.eAmpereFlow = 1L;
        this.eRequiredData = (int)Math.ceil((float)(tRecipe.computation * parallels) * compModifier);
        this.mMaxProgresstime = this.getRecipeTime(tRecipe.mDuration, availablePlasmaTier);
        this.mEfficiencyIncrease = 10000;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    protected int getTierFromPlasma(FluidStack fluidStack) {
        if (fluidStack == null) {
            return 0;
        }
        if (fluidStack.isFluidEqual(Materials.Radon.getPlasma(1L)) && fluidStack.amount >= PLASMA_RADON_USAGE) {
            return 3;
        }
        if (fluidStack.isFluidEqual(Materials.Bismuth.getPlasma(1L)) && fluidStack.amount >= PLASMA_BISMUTH_USAGE) {
            return 2;
        }
        if (fluidStack.isFluidEqual(Materials.Helium.getPlasma(1L)) && fluidStack.amount >= PLASMA_HELIUM_USAGE) {
            return 1;
        }
        return 0;
    }

    protected int getPlasmaUsageFromTier(int plasmaTier) {
        int n;
        switch (plasmaTier) {
            case 1: {
                n = PLASMA_HELIUM_USAGE;
                break;
            }
            case 2: {
                n = PLASMA_BISMUTH_USAGE;
                break;
            }
            case 3: {
                n = PLASMA_RADON_USAGE;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    protected int getBonusStackChance(int plasmaTier) {
        if (plasmaTier <= 0 || plasmaTier > 3) {
            return 0;
        }
        return Math.min((int)((double)(BONUS_STACK_BASE_CHANCE + 1000 * (plasmaTier - 1)) * (2.0 - this.overdriveSetting.get())), BONUS_STACK_MAX_CHANCE);
    }

    protected void generateOreConfigurationList() {
        if (this.configuredOres == null) {
            this.configuredOres = new HashSet();
        } else {
            this.configuredOres.clear();
        }
        if (this.whiteListHandler != null) {
            for (ItemStack item : this.whiteListHandler.getStacks()) {
                this.configuredOres.add(this.getOreString(item));
            }
        }
    }

    protected String getOreString(ItemStack oreStack) {
        if (oreStack == null || oreStack.func_77973_b() == null) {
            return null;
        }
        if (oreStack.func_77977_a().startsWith("gt.blockores")) {
            return oreStack.func_77973_b().func_77658_a() + ":" + oreStack.func_77960_j() % 1000;
        }
        return oreStack.func_77973_b().func_77658_a() + ":" + oreStack.func_77960_j();
    }

    protected abstract int getMaxParallels();

    protected int getParallels(FluidStack plasma, int plasmaUsage) {
        if (plasma == null) {
            return 0;
        }
        float plasmaModifier = this.asteroidOutpost != null ? 1.0f - this.asteroidOutpost.getPlasmaDiscount() : 1.0f;
        return Math.min((int)Math.min((double)this.getMaxParallels(), this.parallelSetting.get()), (int)((float)plasma.amount / ((float)plasmaUsage * plasmaModifier)));
    }

    protected int getRecipeTime(int unboostedTime, int plasmaTier) {
        return plasmaTier > 0 ? (int)((double)unboostedTime * Math.max((1.0 - 0.1 * (double)(plasmaTier - 1)) / this.overdriveSetting.get(), 0.5)) : unboostedTime;
    }

    protected void cycleDistance() {
        if ((int)this.modeSetting.get() != 0) {
            if (this.distanceDisplay.get() + this.stepSetting.get() <= Math.min(300.0, this.distanceSetting.get() + this.rangeSetting.get())) {
                this.distanceDisplay.set(this.distanceDisplay.get() + this.stepSetting.get());
            } else {
                this.distanceDisplay.set(Math.max(0.0, this.distanceSetting.get() - this.rangeSetting.get()));
            }
        } else {
            this.distanceDisplay.set(Math.min(300.0, Math.max(0.0, this.distanceSetting.get())));
        }
    }

    @Override
    protected void parametersInstantiation_EM() {
        super.parametersInstantiation_EM();
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, false);
        Parameters.Group hatch_1 = this.parametrization.getGroup(1, false);
        Parameters.Group hatch_2 = this.parametrization.getGroup(2, false);
        Parameters.Group hatch_3 = this.parametrization.getGroup(3, false);
        this.distanceSetting = hatch_0.makeInParameter(0, 1.0, DISTANCE_SETTING_NAME, DISTANCE_STATUS);
        this.parallelSetting = hatch_0.makeInParameter(1, (double)this.getMaxParallels(), PARALLEL_SETTING_NAME, PARALLEL_STATUS);
        this.overdriveSetting = hatch_1.makeInParameter(0, 1.0, OVERDRIVE_SETTING_NAME, OVERDRIVE_STATUS);
        this.modeSetting = hatch_2.makeInParameter(0, 0.0, MODE_SETTING_NAME, MODE_STATUS);
        this.rangeSetting = hatch_2.makeInParameter(1, 0.0, RANGE_SETTING_NAME, RANGE_STATUS);
        this.stepSetting = hatch_3.makeInParameter(0, 0.0, STEP_SETTING_NAME, STEP_STATUS);
        this.distanceDisplay = hatch_0.makeOutParameter(1, 1.0, DISTANCE_SETTING_NAME, DISTANCE_STATUS);
    }

    protected ButtonWidget createSafeVoidButton() {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(WHITELIST_WINDOW_ID);
            }
        }).setPlayClickSound(false).setBackground(new IDrawable[]{TecTechUITextures.BUTTON_STANDARD_16x16, IG_UITextures.OVERLAY_BUTTON_OPTIONS}).setPos(174, 132).setSize(16, 16);
        button.addTooltip("Configure Filter").setTooltipShowUpDelay(5);
        return (ButtonWidget)button;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.isWhitelisted, val -> {
            this.isWhitelisted = val;
        }));
        buildContext.addSyncedWindow(WHITELIST_WINDOW_ID, this::createWhitelistConfigWindow);
    }

    protected ModularWindow createWhitelistConfigWindow(EntityPlayer player) {
        return ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)ModularWindow.builder((int)158, (int)180).setBackground(new IDrawable[]{TecTechUITextures.BACKGROUND_SCREEN_BLUE}).setGuiTint(this.getGUIColorization()).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.isWhitelisted = !this.isWhitelisted;
            this.wasFilterModified = true;
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_STANDARD_16x16);
            if (this.isWhitelisted) {
                ret.add(IG_UITextures.OVERLAY_BUTTON_WHITELIST);
            } else {
                ret.add(IG_UITextures.OVERLAY_BUTTON_BLACKLIST);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(7, 9).setSize(16, 16).addTooltip("Mode").setTooltipShowUpDelay(5))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.wasFilterModified = true;
            if (!widget.isClient() && this.whiteListHandler != null) {
                for (int i = 0; i < this.whiteListHandler.getSlots(); ++i) {
                    this.whiteListHandler.setStackInSlot(i, null);
                }
            }
        }).setPlayClickSound(false).setBackground(new IDrawable[]{TecTechUITextures.BUTTON_STANDARD_16x16, IG_UITextures.OVERLAY_BUTTON_CROSS}).setPos(25, 9).setSize(16, 16).addTooltip("Clear").setTooltipShowUpDelay(5))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.wasFilterModified = true;
            if (!widget.isClient()) {
                int i = 0;
                for (ItemStack itemStack : this.getStoredInputs()) {
                    if (i >= WHITELIST_SIZE) continue;
                    ItemStack copy = itemStack.func_77946_l();
                    copy.field_77994_a = 1;
                    this.whiteListHandler.setStackInSlot(i++, copy);
                }
            }
        }).setPlayClickSound(false).setBackground(new IDrawable[]{TecTechUITextures.BUTTON_STANDARD_16x16, IG_UITextures.OVERLAY_BUTTON_CONFIGURE}).setPos(43, 9).setSize(16, 16).addTooltip("Load from Bus").setTooltipShowUpDelay(5))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.whiteListHandler, (int)8).startFromSlot(0).endAtSlot(WHITELIST_SIZE - 1).applyForWidget(slotWidget -> slotWidget.setChangeListener(() -> {
            this.wasFilterModified = true;
        })).phantom(true).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(7, 27))).build();
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)screenElements.widget(TextWidget.dynamicString(() -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.4") + ": " + ((int)this.modeSetting.get() == 0 ? StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.4.1") : StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.project.ig.miner.cfgi.4.2"))).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> (int)this.modeSetting.get(), val -> this.parametrization.trySetParameters(this.modeSetting.id % 10, this.modeSetting.id / 10, this.modeSetting.get())));
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096), new TTRenderedExtendedFacingTexture((IIconContainer)(aActive ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF))};
        }
        if (facing.getRotation(ForgeDirection.UP) == side || facing.getRotation(ForgeDirection.DOWN) == side) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096), new TTRenderedExtendedFacingTexture((IIconContainer)engraving)};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096)};
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        engraving = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_SIDE_MINER_MODULE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        ISpaceProject proj;
        if (!super.checkMachine_EM(aBaseMetaTileEntity, aStack)) {
            return false;
        }
        if (this.wasFilterModified) {
            this.wasFilterModified = false;
            this.generateOreConfigurationList();
        }
        if (SpaceProjectManager.teamHasProject((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (ISpaceProject)ASTEROID_OUTPOST) && (proj = SpaceProjectManager.getTeamProject((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (ISpaceBody)SolarSystem.KuiperBelt, (String)"AsteroidOutpost")).isFinished()) {
            this.asteroidOutpost = (ProjectAsteroidOutpost)proj;
        }
        return true;
    }

    public static class TileEntityModuleMinerT3
    extends TileEntityModuleMiner {
        protected static final int MODULE_VOLTAGE_TIER = 10;
        protected static final int MODULE_TIER = 3;
        protected static final int MINIMUM_MOTOR_TIER = 3;
        protected static final int MAXIMUM_PARALLELS = 8;

        public TileEntityModuleMinerT3(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 10, 3, 3);
        }

        public TileEntityModuleMinerT3(String aName) {
            super(aName, 10, 3, 3);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModuleMinerT3(this.mName);
        }

        @Override
        protected int getMaxParallels() {
            return 8;
        }

        @Override
        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t3.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t3.desc5")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc6")).beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[0]);
            return tt;
        }
    }

    public static class TileEntityModuleMinerT2
    extends TileEntityModuleMiner {
        protected static final int MODULE_VOLTAGE_TIER = 9;
        protected static final int MODULE_TIER = 2;
        protected static final int MINIMUM_MOTOR_TIER = 2;
        protected static final int MAXIMUM_PARALLELS = 4;

        public TileEntityModuleMinerT2(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 9, 2, 2);
        }

        public TileEntityModuleMinerT2(String aName) {
            super(aName, 9, 2, 2);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModuleMinerT2(this.mName);
        }

        @Override
        protected int getMaxParallels() {
            return 4;
        }

        @Override
        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t2.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t2.desc5")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc6")).beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[0]);
            return tt;
        }
    }

    public static class TileEntityModuleMinerT1
    extends TileEntityModuleMiner {
        protected static final int MODULE_VOLTAGE_TIER = 8;
        protected static final int MODULE_TIER = 1;
        protected static final int MINIMUM_MOTOR_TIER = 1;
        protected static final int MAXIMUM_PARALLELS = 2;

        public TileEntityModuleMinerT1(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 8, 1, 1);
        }

        public TileEntityModuleMinerT1(String aName) {
            super(aName, 8, 1, 1);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModuleMinerT1(this.mName);
        }

        @Override
        protected int getMaxParallels() {
            return 2;
        }

        @Override
        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t1.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.t1.desc5")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.miner.desc6")).beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[0]);
            return tt;
        }
    }
}

