/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.features.IRecipeHandlerRegistry;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IRecipeHandler;
import appeng.api.recipes.ISubItemResolver;
import appeng.core.AELog;
import appeng.recipes.RecipeHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class RecipeHandlerRegistry
implements IRecipeHandlerRegistry {
    private final Map<String, Class<? extends ICraftHandler>> handlers = new HashMap<String, Class<? extends ICraftHandler>>(20);
    private final Collection<ISubItemResolver> resolvers = new LinkedList<ISubItemResolver>();

    @Override
    public void addNewCraftHandler(String name, Class<? extends ICraftHandler> handler) {
        this.handlers.put(name.toLowerCase(Locale.ENGLISH), handler);
    }

    @Override
    public void addNewSubItemResolver(ISubItemResolver sir) {
        this.resolvers.add(sir);
    }

    @Override
    @Nullable
    public ICraftHandler getCraftHandlerFor(String name) {
        Class<? extends ICraftHandler> clz = this.handlers.get(name);
        if (clz == null) {
            return null;
        }
        try {
            return clz.newInstance();
        }
        catch (Throwable e) {
            AELog.error("Error Caused when trying to construct " + clz.getName(), new Object[0]);
            AELog.debug(e);
            this.handlers.put(name, null);
            return null;
        }
    }

    @Override
    public IRecipeHandler createNewRecipehandler() {
        return new RecipeHandler();
    }

    @Override
    @Nullable
    public Object resolveItem(String nameSpace, String itemName) {
        for (ISubItemResolver sir : this.resolvers) {
            Object rr = null;
            try {
                rr = sir.resolveItemByName(nameSpace, itemName);
            }
            catch (Throwable t) {
                AELog.debug(t);
            }
            if (rr == null) continue;
            return rr;
        }
        return null;
    }
}

