/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.renderers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.codechicken.lib.math.MathHelper;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.models.ModelThirstyTank;
import tuhljin.automagy.tiles.TileEntityThirstyTank;

public class BlockThirstyTankRenderer
extends TileEntitySpecialRenderer {
    public static final String TEXTURE = "textures/models/thirstyTank.png";
    public static int renderPass = 0;
    private final ModelThirstyTank model = new ModelThirstyTank();

    public void func_147500_a(TileEntity te, double x, double y, double z, float scale) {
        FluidStack fluidStack;
        TileEntityThirstyTank teTT = te instanceof TileEntityThirstyTank ? (TileEntityThirstyTank)te : null;
        World world = te.func_145831_w();
        if ((renderPass == 0 || world == null) && teTT != null && (fluidStack = teTT.tank.getFluid()) != null) {
            int color;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GL11.glScaled((double)0.7, (double)0.8, (double)0.7);
            GL11.glTranslated((double)0.0, (double)0.02, (double)0.0);
            GL11.glDisable((int)2896);
            Fluid fluid = fluidStack.getFluid();
            IIcon texture = fluid.getStillIcon();
            if (texture != null) {
                this.func_147499_a(BlockThirstyTankRenderer.getFluidSheet(fluid));
                color = fluid.getColor(fluidStack);
            } else {
                this.func_147499_a(TextureMap.field_110575_b);
                texture = Minecraft.func_71410_x().func_147117_R().func_110572_b("missingno");
                color = -1;
            }
            Tessellator t = Tessellator.field_78398_a;
            double height = teTT.getFractionFull();
            if (teTT.liquidRenderHeight != height) {
                teTT.liquidRenderHeight = teTT.liquidRenderHeight == -1.0 || TjUtil.areDoublesAlmostEqual_lowprec(height, teTT.liquidRenderHeight) ? height : (height = MathHelper.approachLinear(teTT.liquidRenderHeight, height, 0.015));
            }
            double ySouthEast = height;
            double yNorthEast = height;
            double ySouthWest = height;
            double yNorthWest = height;
            double uMin = texture.func_94214_a(0.0);
            double uMax = texture.func_94214_a(16.0);
            double vMin = texture.func_94207_b(0.0);
            double vMax = texture.func_94207_b(16.0);
            double vHeight = vMax - vMin;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5, -0.5, uMax, vMin);
            t.func_78374_a(-0.5, -0.5, -0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMin, vMin + vHeight * yNorthWest);
            t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMax, vMin + vHeight * yNorthEast);
            t.func_78374_a(0.5, -0.5, 0.5, uMin, vMin);
            t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMin, vMin + vHeight * ySouthEast);
            t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMax, vMin + vHeight * ySouthWest);
            t.func_78374_a(-0.5, -0.5, 0.5, uMax, vMin);
            t.func_78374_a(0.5, -0.5, -0.5, uMin, vMin);
            t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMin, vMin + vHeight * yNorthEast);
            t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMax, vMin + vHeight * ySouthEast);
            t.func_78374_a(0.5, -0.5, 0.5, uMax, vMin);
            t.func_78374_a(-0.5, -0.5, 0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMin, vMin + vHeight * ySouthWest);
            t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMax, vMin + vHeight * yNorthWest);
            t.func_78374_a(-0.5, -0.5, -0.5, uMax, vMin);
            t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMax, vMin);
            t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMin, vMax);
            t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMax, vMax);
            t.func_78374_a(0.5, -0.5, -0.5, uMax, vMin);
            t.func_78374_a(0.5, -0.5, 0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5, 0.5, uMin, vMax);
            t.func_78374_a(-0.5, -0.5, -0.5, uMax, vMax);
            t.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("Automagy".toLowerCase(), TEXTURE));
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glScalef((float)0.94f, (float)0.94f, (float)0.94f);
        GL11.glTranslatef((float)0.0f, (float)0.098f, (float)0.0f);
        if (world == null) {
            this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        } else if (renderPass == 0) {
            this.model.renderStone(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        } else {
            this.model.renderGlass(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        GL11.glPopMatrix();
        if (teTT != null && (renderPass == 0 || world == null)) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            if (world != null) {
                RenderHelper.func_74518_a();
            }
            int brightness = 230;
            if (world != null) {
                brightness = ModBlocks.thirstyTank.func_149677_c((IBlockAccess)world, te.field_145851_c, te.field_145848_d, te.field_145849_e);
            }
            float size = 0.22f;
            int glyph = teTT.glyphs[0];
            if (glyph > 0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)-0.503, (double)0.0);
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                UtilsFX.renderQuadCenteredFromIcon((boolean)false, (IIcon)ModItems.tankGlyph.getInstalledIcon(glyph), (float)size, (float)1.0f, (float)1.0f, (float)1.0f, (int)brightness, (int)771, (float)1.0f);
                GL11.glPopMatrix();
            }
            if ((glyph = teTT.glyphs[1]) > 0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.438, (double)0.0);
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                UtilsFX.renderQuadCenteredFromIcon((boolean)false, (IIcon)ModItems.tankGlyph.getInstalledIcon(glyph), (float)size, (float)1.0f, (float)1.0f, (float)1.0f, (int)brightness, (int)771, (float)1.0f);
                GL11.glPopMatrix();
            }
            if ((glyph = teTT.glyphs[2]) > 0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)-0.36);
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                UtilsFX.renderQuadCenteredFromIcon((boolean)false, (IIcon)ModItems.tankGlyph.getInstalledIcon(glyph), (float)size, (float)1.0f, (float)1.0f, (float)1.0f, (int)brightness, (int)771, (float)1.0f);
                GL11.glPopMatrix();
            }
            if ((glyph = teTT.glyphs[3]) > 0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)0.36);
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                UtilsFX.renderQuadCenteredFromIcon((boolean)false, (IIcon)ModItems.tankGlyph.getInstalledIcon(glyph), (float)size, (float)1.0f, (float)1.0f, (float)1.0f, (int)brightness, (int)771, (float)1.0f);
                GL11.glPopMatrix();
            }
            if ((glyph = teTT.glyphs[4]) > 0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.36, (double)0.0, (double)0.0);
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                UtilsFX.renderQuadCenteredFromIcon((boolean)false, (IIcon)ModItems.tankGlyph.getInstalledIcon(glyph), (float)size, (float)1.0f, (float)1.0f, (float)1.0f, (int)brightness, (int)771, (float)1.0f);
                GL11.glPopMatrix();
            }
            if ((glyph = teTT.glyphs[5]) > 0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.36, (double)0.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                UtilsFX.renderQuadCenteredFromIcon((boolean)false, (IIcon)ModItems.tankGlyph.getInstalledIcon(glyph), (float)size, (float)1.0f, (float)1.0f, (float)1.0f, (int)brightness, (int)771, (float)1.0f);
                GL11.glPopMatrix();
            }
            if (world != null) {
                RenderHelper.func_74519_b();
            }
            GL11.glPopMatrix();
        }
    }

    public static ResourceLocation getFluidSheet(FluidStack liquid) {
        if (liquid == null) {
            return TextureMap.field_110575_b;
        }
        return BlockThirstyTankRenderer.getFluidSheet(liquid.getFluid());
    }

    public static ResourceLocation getFluidSheet(Fluid liquid) {
        return TextureMap.field_110575_b;
    }
}

