/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.impl;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import java.util.function.Supplier;

public interface Module {
    default public void emptyData() {
        this.queueConfigScan();
        this.queueInternalScan();
        this.clearFieldData();
        this.clearClientData();
    }

    default public void clearFieldData() {
    }

    default public void clearClientData() {
        this.setInUse(false);
        this.clearAttributes();
    }

    default public void clearActiveData() {
        this.clearClientData();
    }

    default public void clearAttributes() {
    }

    default public void preTick() {
    }

    default public void postTick() {
    }

    default public void onTick() {
        boolean needsInternalUpdate;
        this.preTick();
        this.setEnabled(this.canBeEnabled());
        boolean needsConfigUpdate = this.isEnabled() && !this.hasScannedConfig() && this.canFetchConfig();
        boolean bl = needsInternalUpdate = this.isEnabled() && !this.hasScannedInternals() && this.canFetchInternals();
        if (needsConfigUpdate) {
            this.scanConfigData();
            this.markConfigScanned();
        }
        if (needsInternalUpdate) {
            this.scanInternalData();
            this.markInternalsScanned();
        }
        if (this.isEnabled()) {
            if (this.canBeUsed()) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearActiveData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
        this.postTick();
    }

    public void updateData();

    public void initPresence();

    public void updatePresence();

    public void getInternalData();

    public void getConfigData();

    public void syncArgument(String var1, Supplier<Boolean> var2, Supplier<Object> var3, boolean var4);

    default public void syncArgument(String argumentName, Supplier<Object> event, boolean plain) {
        this.syncArgument(argumentName, null, event, plain);
    }

    default public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event) {
        this.syncArgument(argumentName, condition, event, false);
    }

    default public void syncArgument(String argumentName, Supplier<Object> event) {
        this.syncArgument(argumentName, null, event);
    }

    default public Supplier<Object> getModuleFunction(Supplier<Boolean> condition, Supplier<Object> event) {
        return () -> this.isInUse() && (condition == null || (Boolean)condition.get() != false) && event != null ? event.get() : null;
    }

    default public Supplier<Object> getModuleFunction(Supplier<Object> event) {
        return this.getModuleFunction(null, event);
    }

    default public void printException(Throwable ex) {
        Constants.LOG.debugError(ex);
    }

    default public void scanConfigData() {
        Constants.getThreadFactory().newThread(() -> {
            try {
                this.getConfigData();
            }
            catch (Throwable ex) {
                this.printException(ex);
            }
        }).start();
    }

    default public void scanInternalData() {
        Constants.getThreadFactory().newThread(() -> {
            try {
                this.getInternalData();
            }
            catch (Throwable ex) {
                this.printException(ex);
            }
        }).start();
    }

    default public boolean canBeEnabled() {
        return true;
    }

    default public boolean isEnabled() {
        return true;
    }

    default public void setEnabled(boolean state) {
    }

    default public boolean canBeUsed() {
        return true;
    }

    default public boolean isInUse() {
        return true;
    }

    default public void setInUse(boolean state) {
    }

    default public boolean canBeLoaded() {
        return Constants.HAS_GAME_LOADED;
    }

    default public boolean canFetchInternals() {
        return true;
    }

    default public boolean hasScannedInternals() {
        return true;
    }

    default public void setScannedInternals(boolean state) {
    }

    default public void markInternalsScanned() {
        this.setScannedInternals(true);
    }

    default public void queueInternalScan() {
        this.setScannedInternals(false);
    }

    default public boolean canFetchConfig() {
        return true;
    }

    default public boolean hasScannedConfig() {
        return true;
    }

    default public void setScannedConfig(boolean state) {
    }

    default public void markConfigScanned() {
        this.setScannedConfig(true);
    }

    default public void queueConfigScan() {
        this.setScannedConfig(false);
    }
}

