/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.util.gregtech5;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.FluidComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.util.FluidDictUtil;
import com.google.common.collect.Lists;
import gregtech.api.enums.ItemList;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class GregTechFluidDictUtil {
    private GregTechFluidDictUtil() {
    }

    public static Optional<ItemComponent> fluidToDisplayItem(FluidComponent component) {
        ItemStack itemStack = GTUtility.getFluidDisplayStack((Fluid)component.fluid());
        return Optional.ofNullable(itemStack).map(ItemComponent::create);
    }

    public static Optional<FluidComponent> displayItemToFluid(ItemComponent component) {
        if (component.item() != ItemList.Display_Fluid.getItem()) {
            return Optional.empty();
        }
        Fluid fluid = FluidRegistry.getFluid((int)component.damage());
        return Optional.ofNullable(fluid).map(FluidComponent::create);
    }

    public static Optional<FluidComponent> getFluidContents(Component component) {
        if (component.type() == Component.ComponentType.ITEM && ((ItemComponent)component).item() == ItemList.Display_Fluid.getItem()) {
            return GregTechFluidDictUtil.displayItemToFluid((ItemComponent)component);
        }
        return FluidDictUtil.getFluidContents(component);
    }

    public static Optional<ItemComponent> getDisplayItem(Component component) {
        return GregTechFluidDictUtil.getFluidContents(component).flatMap(GregTechFluidDictUtil::fluidToDisplayItem);
    }

    public static Optional<ItemComponent> fillCell(Component component) {
        return GregTechFluidDictUtil.getFluidContents(component).map(fluidComponent -> GTUtility.fillFluidContainer((FluidStack)fluidComponent.stack(), (ItemStack)ItemList.Cell_Empty.get(1L, new Object[0]), (boolean)false, (boolean)false)).map(ItemComponent::create);
    }

    public static Component getCellOrDisplayItem(Component component) {
        return GregTechFluidDictUtil.fillCell(component).map(Component.class::cast).orElse(GregTechFluidDictUtil.getDisplayItem(component).map(Component.class::cast).orElse(component));
    }

    public static List<Component> getAssociatedComponents(Component component) {
        Optional<FluidComponent> fluidOptional = GregTechFluidDictUtil.getFluidContents(component);
        if (!fluidOptional.isPresent()) {
            return Lists.newArrayList();
        }
        FluidComponent fluid = fluidOptional.get();
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(fluid);
        FluidDictUtil.itemToFluid(fluid).ifPresent(list::add);
        GregTechFluidDictUtil.fluidToDisplayItem(fluid).ifPresent(list::add);
        GregTechFluidDictUtil.fillCell(fluid).ifPresent(list::add);
        if (!list.contains(component)) {
            list.add(component);
        }
        return list;
    }
}

