/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialtools;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialtools.LayoutHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialtools.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechDiagramUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.google.common.collect.ImmutableList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

class DiagramFactory {
    private final LayoutHandler layoutHandler;
    private final RecipeHandler recipeHandler;

    DiagramFactory(LayoutHandler layoutHandler, RecipeHandler recipeHandler) {
        this.layoutHandler = layoutHandler;
        this.recipeHandler = recipeHandler;
    }

    Diagram buildDiagram(Materials material) {
        Diagram.Builder diagramBuilder = Diagram.builder().addAllLayouts((Iterable<Layout>)this.layoutHandler.requiredLayouts()).addAllOptionalLayouts((Iterable<Layout>)this.layoutHandler.optionalLayouts()).addInteractable(GregTechDiagramUtil.buildMaterialInfoButton(LayoutHandler.MATERIAL_INFO_POSITION, material));
        GregTechOreDictUtil.getComponent(OrePrefixes.stick, material.mHandleMaterial).ifPresent(handle -> diagramBuilder.autoInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.TOOL_PARTS).insertIntoNextSlot(DisplayComponent.builder(handle).setAdditionalTooltip(Tooltip.create(Lang.GREGTECH_5_MATERIAL_TOOLS.trans("handlelabel"), Tooltip.INFO_FORMATTING)).build()));
        diagramBuilder.autoInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.TOOLS).insertEachGroupSafe(this.recipeHandler.getTools(material));
        diagramBuilder.autoInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.TURBINES).insertEachGroupSafe(this.recipeHandler.getTurbines(material));
        diagramBuilder.autoInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.SCANNERS).insertEachGroupSafe(this.recipeHandler.getScanners(material));
        diagramBuilder.autoInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.ELECTRIC_SCANNERS).insertEachGroupSafe(this.recipeHandler.getElectricScanners(material));
        Arrays.stream(MaterialPart.values()).forEach(part -> ((MaterialPart)part).insertIntoSlot(diagramBuilder, material));
        return diagramBuilder.build();
    }

    private static List<DisplayComponent> getPrefixComponents(ImmutableList<OrePrefixes> prefixes, Materials material) {
        ArrayList<DisplayComponent> list = new ArrayList<DisplayComponent>();
        for (OrePrefixes prefix : prefixes) {
            Optional<ItemComponent> componentOptional = GregTechOreDictUtil.getComponent(prefix, material);
            if (!componentOptional.isPresent()) continue;
            list.add(DisplayComponent.builder(componentOptional.get()).setAdditionalTooltip(Tooltip.create(Lang.GREGTECH_5_MATERIAL_TOOLS.transf("prefixlabel", prefix.mRegularLocalName), Tooltip.INFO_FORMATTING)).build());
        }
        return list;
    }

    private static enum MaterialPart {
        TOOL_HEADS(LayoutHandler.SlotGroupKeys.TOOL_PARTS, OrePrefixes.toolHeadSword, OrePrefixes.toolHeadPickaxe, OrePrefixes.toolHeadShovel, OrePrefixes.toolHeadAxe, OrePrefixes.toolHeadHoe, OrePrefixes.toolHeadSaw, OrePrefixes.toolHeadHammer, OrePrefixes.toolHeadFile, OrePrefixes.toolHeadUniversalSpade, OrePrefixes.toolHeadSense, OrePrefixes.toolHeadPlow, OrePrefixes.toolHeadDrill, OrePrefixes.toolHeadChainsaw, OrePrefixes.toolHeadWrench, OrePrefixes.toolHeadBuzzSaw),
        TURBINE_BLADE(LayoutHandler.SlotKeys.TURBINE_BLADE, OrePrefixes.turbineBlade);

        private final Layout.Key slotKey;
        private final ImmutableList<OrePrefixes> prefixes;

        private MaterialPart(Layout.Key slotKey, OrePrefixes ... prefixes) {
            this.slotKey = slotKey;
            this.prefixes = ImmutableList.copyOf((Object[])prefixes);
        }

        private void insertIntoSlot(Diagram.Builder builder, Materials material) {
            if (this.prefixes.size() == 1) {
                builder.insertIntoSlot((Layout.SlotKey)this.slotKey, DiagramFactory.getPrefixComponents((ImmutableList<OrePrefixes>)this.prefixes, material));
            } else {
                builder.autoInsertIntoSlotGroup((Layout.SlotGroupKey)this.slotKey).insertEachSafe(DiagramFactory.getPrefixComponents((ImmutableList<OrePrefixes>)this.prefixes, material));
            }
        }
    }
}

