/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.angermod.config;

import com.github.namikon.angermod.AngerMod;
import com.github.namikon.angermod.auxiliary.MinecraftBlock;
import eu.usrv.yamcore.config.ConfigManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AngerModConfig
extends ConfigManager {
    public List<MinecraftBlock> BlacklistedBlocks = null;
    public int EndermanAggrorange;
    public int PigmenAggrorange;
    public int SpawnProtectionTimeout;
    public int SpawnProtectionMoveTolerance;
    public int KamikazeChance;
    public int FriendlyMobRevengeRadius;
    public boolean PlayerSpawnProtection;
    public boolean MakeMobsAngryOnBlockBreak;
    public boolean FriendlyMobRevenge;
    public boolean KamikazeMobRevenge;
    public boolean KamikazeMobsDoTerrainDamage;
    private String[] _mDefaultBlacklistedEndBlocks = null;
    private String[] _mDefaultBlacklistedNetherBlocks = null;
    public String[] PigFoodTrigger;
    public String[] CowFoodTrigger;
    public String[] ChickenFoodTrigger;
    public String[] SheepFoodTrigger;
    public String[] ButcherItems;
    public String[] WhitelistedProtectionItems;
    private String[] tCfgBlacklistedEndBlocks = null;
    private String[] tCfgBlacklistedNetherBlocks = null;

    public AngerModConfig(File pConfigBaseDirectory, String pModCollectionDirectory, String pModID) {
        super(pConfigBaseDirectory, pModCollectionDirectory, pModID);
    }

    protected void PreInit() {
        this.BlacklistedBlocks = new ArrayList<MinecraftBlock>();
        this._mDefaultBlacklistedEndBlocks = new String[]{"gregtech:gt.blockores"};
        this._mDefaultBlacklistedNetherBlocks = new String[]{"gregtech:gt.blockores"};
        this.EndermanAggrorange = 16;
        this.PigmenAggrorange = 16;
        this.SpawnProtectionMoveTolerance = 5;
        this.SpawnProtectionTimeout = 10;
        this.KamikazeChance = 5;
        this.PigFoodTrigger = new String[]{"pork"};
        this.CowFoodTrigger = new String[]{"beef"};
        this.ChickenFoodTrigger = new String[]{"chicken", "egg"};
        this.SheepFoodTrigger = new String[]{"mutton"};
        this.ButcherItems = new String[]{"flint"};
        this.FriendlyMobRevengeRadius = 16;
        this.WhitelistedProtectionItems = new String[]{"EMT:BaseBaubles"};
    }

    protected void PostInit() {
        this.ParseBlacklistedBlocks(this.tCfgBlacklistedEndBlocks, 1);
        this.ParseBlacklistedBlocks(this.tCfgBlacklistedNetherBlocks, -1);
    }

    protected void Init() {
        this.tCfgBlacklistedEndBlocks = this._mainConfig.getStringList("EndBlocks", "Blacklist", this._mDefaultBlacklistedEndBlocks, "Define all Blocks here where Enderman should become angry when you break them");
        this.tCfgBlacklistedNetherBlocks = this._mainConfig.getStringList("NetherBlocks", "Blacklist", this._mDefaultBlacklistedNetherBlocks, "Define all Blocks here where Pigmen should become angry when you break them");
        this.ButcherItems = this._mainConfig.getStringList("KamikazeItemBlacklist", "Blacklist", this.ButcherItems, "If the player is using one of these items, entities will not explode if they are killed");
        this.EndermanAggrorange = this._mainConfig.getInt("Enderman", "Limits", this.EndermanAggrorange, 2, 128, "The maximum range where Enderman shall become angry");
        this.PigmenAggrorange = this._mainConfig.getInt("Pigmen", "Limits", this.PigmenAggrorange, 2, 128, "The maximum range where Pigmen shall become angry");
        this.KamikazeChance = this._mainConfig.getInt("KamikazeChance", "Limits", this.KamikazeChance, 1, 100, "Chance, in percent, how often a Kamikaze event will happen");
        this.FriendlyMobRevengeRadius = this._mainConfig.getInt("FriendlyMobRevengeRadius", "Limits", this.FriendlyMobRevengeRadius, 2, 128, "The maximum range where animals will flee/become angry once the food-trigger is.. triggered");
        this.SpawnProtectionTimeout = this._mainConfig.getInt("SpawnProtectionTimeout", "Limits", this.SpawnProtectionTimeout, 1, 2048, "The maximum number of seconds a player will be protected from damage if he is just standing still and doing nothing");
        this.SpawnProtectionMoveTolerance = this._mainConfig.getInt("SpawnProtectionMoveTolerance", "Limits", this.SpawnProtectionMoveTolerance, 1, 2048, "How many Blocks will the player be able to move away from his initial spawn location until his protection fades");
        this.PlayerSpawnProtection = this._mainConfig.getBoolean("ProtectionEnabled", "ModuleControl", false, "Define if new players / respawned players shall be ignored from monsters until they attack something, move or the timer runs out");
        this.MakeMobsAngryOnBlockBreak = this._mainConfig.getBoolean("BlockBreakEnabled", "ModuleControl", false, "Enable/disable block-breaking-makes-mobs-angry module");
        this.FriendlyMobRevenge = this._mainConfig.getBoolean("FriendlyMobRevenge", "ModuleControl", false, "If set to true, sheep will attack/flee if you eat mutton, pigs if you eat pork,... The attack/flee is based on additional mods you have installed");
        this.KamikazeMobRevenge = this._mainConfig.getBoolean("KamikazeMobRevenge", "ModuleControl", false, "Guess what it is ...");
        this.KamikazeMobsDoTerrainDamage = this._mainConfig.getBoolean("KamikazeMobsDoTerrainDamage", "Protection", false, "If set to true, the kamikaze event will cause terrain damage (but still follow gamerule 'mobGriefing')");
        this.PigFoodTrigger = this._mainConfig.getStringList("PigFoodTrigger", "MobRevengeTrigger", this.PigFoodTrigger, "If the food eaten by the player contains these keywords, all PIGS around will become angry (or flee)");
        this.CowFoodTrigger = this._mainConfig.getStringList("CowFoodTrigger", "MobRevengeTrigger", this.CowFoodTrigger, "If the food eaten by the player contains these keywords, all COWS around will become angry (or flee)");
        this.ChickenFoodTrigger = this._mainConfig.getStringList("ChickenFoodTrigger", "MobRevengeTrigger", this.ChickenFoodTrigger, "If the food eaten by the player contains these keywords, all CHICKEN around will become angry (or flee)");
        this.SheepFoodTrigger = this._mainConfig.getStringList("SheepFoodTrigger", "MobRevengeTrigger", this.SheepFoodTrigger, "If the food eaten by the player contains these keywords, all SHEEP around will become angry (or flee)");
        this.WhitelistedProtectionItems = this._mainConfig.getStringList("WhitelistedProtectionItems", "Whitelist", this.WhitelistedProtectionItems, "Set items here which change players invulnerability. You will notice those, as they will spam the console with *protection fades* messages");
    }

    private void ParseBlacklistedBlocks(String[] pBlockNames, int pDimension) {
        try {
            for (String tBlockName : pBlockNames) {
                try {
                    MinecraftBlock tBlock = new MinecraftBlock(tBlockName, pDimension);
                    AngerMod.Logger.info((Object)String.format("New block added for Dimension: %d BlockID: %s", pDimension, tBlockName));
                    this.BlacklistedBlocks.add(tBlock);
                }
                catch (Exception e) {
                    AngerMod.Logger.warn((Object)String.format("NetherBlock Definition %s will be ignored. Check your spelling [ModID]:[BlockName] or [ModID]:[BlockName]:[BlockMeta]", tBlockName));
                    AngerMod.Logger.DumpStack(e);
                }
            }
        }
        catch (Exception e) {
            AngerMod.Logger.error((Object)"Error while parsing Blacklist for Nether blocks");
            AngerMod.Logger.DumpStack(e);
        }
    }
}

