/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.team;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import serverutils.ServerUtilities;
import serverutils.command.team.CmdCreate;
import serverutils.events.team.ForgeTeamCreatedEvent;
import serverutils.lib.EnumTeamColor;
import serverutils.lib.command.CmdBase;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.TeamType;
import serverutils.lib.data.Universe;

public class CmdCreateServerTeam
extends CmdBase {
    public CmdCreateServerTeam() {
        super("create_server_team", CmdBase.Level.OP_OR_SP);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        this.checkArgs(sender, args, 1);
        if (!CmdCreate.isValidTeamID(args[0])) {
            throw ServerUtilities.error(sender, "serverutilities.lang.team.id_invalid", new Object[0]);
        }
        if (Universe.get().getTeam(args[0]).isValid()) {
            throw ServerUtilities.error(sender, "serverutilities.lang.team.id_already_exists", new Object[0]);
        }
        Universe universe = Universe.get();
        universe.clearCache();
        ForgeTeam team = new ForgeTeam(universe, universe.generateTeamUID((short)0), args[0], TeamType.SERVER);
        team.setTitle(team.getId());
        team.setColor(EnumTeamColor.NAME_MAP.getRandom(sender.func_130014_f_().field_73012_v));
        team.universe.addTeam(team);
        new ForgeTeamCreatedEvent(team).post();
        sender.func_145747_a(ServerUtilities.lang(sender, "serverutilities.lang.team.created", team.getId()));
        team.markDirty();
    }
}

