/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui.ranks;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.StatCollector;
import serverutils.client.gui.ranks.GuiRanks;
import serverutils.client.gui.ranks.GuiSelectRank;
import serverutils.client.gui.ranks.RankInst;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.Widget;
import serverutils.lib.gui.WidgetType;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.misc.MouseButton;

public class GuiPlayerRanks
extends GuiButtonListBase {
    private int usernameSize;
    private int valueSize;

    public GuiPlayerRanks() {
        this.setTitle(StatCollector.func_74838_a((String)"serverutilities.admin_panel.ranks.player_ranks"));
        this.setHasSearchBox(true);
    }

    @Override
    public void addButtons(Panel panel) {
        this.usernameSize = 0;
        this.valueSize = 0;
        for (Map.Entry<String, RankInst> entry : GuiRanks.playerRanks.entrySet()) {
            panel.add(new PlayerEntry(panel, entry.getKey(), entry.getValue()));
        }
        panel.widgets.sort(null);
    }

    @Override
    public String getFilterText(Widget widget) {
        return ((PlayerEntry)widget).username.toLowerCase();
    }

    private class PlayerEntry
    extends Button
    implements Comparable<PlayerEntry> {
        private final String username;
        private final String ranks;
        private final RankInst playerRank;

        public PlayerEntry(Panel panel, String u, RankInst r) {
            super(panel);
            this.username = u;
            this.playerRank = r;
            List<String> sortedParents = r.parents.stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList());
            this.ranks = this.getRanksAsString(sortedParents);
            Theme theme = GuiPlayerRanks.this.getTheme();
            GuiPlayerRanks.this.usernameSize = Math.max(GuiPlayerRanks.this.usernameSize, theme.getStringWidth(this.username) + 8);
            GuiPlayerRanks.this.valueSize = Math.max(GuiPlayerRanks.this.valueSize, theme.getStringWidth(this.ranks) + 8);
            this.setSize(GuiPlayerRanks.this.usernameSize + GuiPlayerRanks.this.valueSize, 14);
        }

        private String getRanksAsString(List<String> parents) {
            StringBuilder builder = new StringBuilder();
            for (String ranks : parents) {
                builder.append(StringUtils.firstUppercase(ranks)).append(", ");
            }
            int index = builder.lastIndexOf(", ");
            if (index >= 0) {
                builder.delete(index, index + 2);
            }
            return builder.toString();
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiSelectRank(this.username, this.playerRank).openGui();
        }

        @Override
        public void addMouseOverText(List<String> list) {
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            WidgetType type = WidgetType.mouseOver(this.isMouseOver());
            int textY = y + (h - theme.getFontHeight() + 1) / 2;
            theme.drawButton(x, y, GuiPlayerRanks.this.usernameSize, h, type);
            theme.drawString(this.username, x + 4, textY, 2);
            theme.drawButton(x + GuiPlayerRanks.this.usernameSize, y, GuiPlayerRanks.this.valueSize, h, type);
            theme.drawString(this.ranks, x + GuiPlayerRanks.this.usernameSize + 4, textY, 2);
        }

        @Override
        public int compareTo(PlayerEntry o) {
            return this.username.compareToIgnoreCase(o.username);
        }
    }
}

