/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellCacheRegistry;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.MEPassThrough;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.FuzzyPriorityList;
import appeng.util.prioitylist.OreFilteredList;
import appeng.util.prioitylist.PrecisePriorityList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CellInventoryHandler
extends MEInventoryHandler<IAEItemStack>
implements ICellInventoryHandler,
ICellCacheRegistry {
    CellInventoryHandler(IMEInventory<IAEItemStack> c) {
        super(c, StorageChannel.ITEMS);
        ICellInventory ci = this.getCellInv();
        if (ci != null) {
            IInventory upgrades = ci.getUpgradesInventory();
            IInventory config = ci.getConfigInventory();
            FuzzyMode fzMode = ci.getFuzzyMode();
            String filter = ci.getOreFilter();
            boolean hasInverter = false;
            boolean hasFuzzy = false;
            boolean hasOreFilter = false;
            boolean hasSticky = false;
            block6: for (int x = 0; x < upgrades.func_70302_i_(); ++x) {
                Upgrades u;
                ItemStack is = upgrades.func_70301_a(x);
                if (is == null || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
                switch (u) {
                    case FUZZY: {
                        hasFuzzy = true;
                        continue block6;
                    }
                    case INVERTER: {
                        hasInverter = true;
                        continue block6;
                    }
                    case ORE_FILTER: {
                        hasOreFilter = true;
                        continue block6;
                    }
                    case STICKY: {
                        hasSticky = true;
                        continue block6;
                    }
                }
            }
            this.setWhitelist(hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
            if (hasSticky) {
                this.setSticky(true);
            }
            if (hasOreFilter && !filter.isEmpty()) {
                this.setPartitionList(new OreFilteredList(filter));
            } else {
                IItemList<IAEItemStack> priorityList = AEApi.instance().storage().createItemList();
                for (int x = 0; x < config.func_70302_i_(); ++x) {
                    ItemStack is = config.func_70301_a(x);
                    if (is == null) continue;
                    priorityList.add(AEItemStack.create(is));
                }
                if (!priorityList.isEmpty()) {
                    if (hasFuzzy) {
                        this.setPartitionList(new FuzzyPriorityList<IAEItemStack>(priorityList, fzMode));
                    } else {
                        this.setPartitionList(new PrecisePriorityList<IAEItemStack>(priorityList));
                    }
                }
            }
        }
    }

    @Override
    public ICellInventory getCellInv() {
        IMEInventory o = this.getInternal();
        if (o instanceof MEPassThrough) {
            o = ((MEPassThrough)o).getInternal();
        }
        return (ICellInventory)(o instanceof ICellInventory ? o : null);
    }

    @Override
    public boolean isPreformatted() {
        return !this.getPartitionList().isEmpty();
    }

    @Override
    public boolean isFuzzy() {
        return this.getPartitionList() instanceof FuzzyPriorityList;
    }

    @Override
    public IncludeExclude getIncludeExcludeMode() {
        return this.getWhitelist();
    }

    public int getStatusForCell() {
        int val = this.getCellInv().getStatusForCell();
        if ((val == 1 || val == 2) && this.isPreformatted()) {
            val = 3;
        }
        return val;
    }

    @Override
    public boolean canGetInv() {
        return this.getCellInv() != null;
    }

    @Override
    public long getTotalBytes() {
        return this.getCellInv().getTotalBytes();
    }

    @Override
    public long getFreeBytes() {
        return this.getCellInv().getFreeBytes();
    }

    @Override
    public long getUsedBytes() {
        return this.getCellInv().getUsedBytes();
    }

    @Override
    public long getTotalTypes() {
        return this.getCellInv().getTotalItemTypes();
    }

    @Override
    public long getFreeTypes() {
        return this.getCellInv().getRemainingItemTypes();
    }

    @Override
    public long getUsedTypes() {
        return this.getCellInv().getStoredItemTypes();
    }

    @Override
    public int getCellStatus() {
        return this.getStatusForCell();
    }

    @Override
    public ICellCacheRegistry.TYPE getCellType() {
        return ICellCacheRegistry.TYPE.ITEM;
    }
}

