/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.math;

import com.cleanroommc.modularui.api.IMathValue;
import com.cleanroommc.modularui.utils.math.Constant;
import com.cleanroommc.modularui.utils.math.Group;
import com.cleanroommc.modularui.utils.math.Negate;
import com.cleanroommc.modularui.utils.math.Negative;
import com.cleanroommc.modularui.utils.math.Operation;
import com.cleanroommc.modularui.utils.math.Operator;
import com.cleanroommc.modularui.utils.math.Ternary;
import com.cleanroommc.modularui.utils.math.Variable;
import com.cleanroommc.modularui.utils.math.functions.Function;
import com.cleanroommc.modularui.utils.math.functions.classic.Abs;
import com.cleanroommc.modularui.utils.math.functions.classic.Exp;
import com.cleanroommc.modularui.utils.math.functions.classic.Ln;
import com.cleanroommc.modularui.utils.math.functions.classic.Mod;
import com.cleanroommc.modularui.utils.math.functions.classic.Pow;
import com.cleanroommc.modularui.utils.math.functions.classic.Sqrt;
import com.cleanroommc.modularui.utils.math.functions.limit.Clamp;
import com.cleanroommc.modularui.utils.math.functions.limit.Max;
import com.cleanroommc.modularui.utils.math.functions.limit.Min;
import com.cleanroommc.modularui.utils.math.functions.rounding.Ceil;
import com.cleanroommc.modularui.utils.math.functions.rounding.Floor;
import com.cleanroommc.modularui.utils.math.functions.rounding.Round;
import com.cleanroommc.modularui.utils.math.functions.rounding.Trunc;
import com.cleanroommc.modularui.utils.math.functions.string.StringContains;
import com.cleanroommc.modularui.utils.math.functions.string.StringEndsWith;
import com.cleanroommc.modularui.utils.math.functions.string.StringStartsWith;
import com.cleanroommc.modularui.utils.math.functions.trig.Acos;
import com.cleanroommc.modularui.utils.math.functions.trig.Asin;
import com.cleanroommc.modularui.utils.math.functions.trig.Atan;
import com.cleanroommc.modularui.utils.math.functions.trig.Atan2;
import com.cleanroommc.modularui.utils.math.functions.trig.Cos;
import com.cleanroommc.modularui.utils.math.functions.trig.Sin;
import com.cleanroommc.modularui.utils.math.functions.utility.DieRoll;
import com.cleanroommc.modularui.utils.math.functions.utility.DieRollInteger;
import com.cleanroommc.modularui.utils.math.functions.utility.HermiteBlend;
import com.cleanroommc.modularui.utils.math.functions.utility.Lerp;
import com.cleanroommc.modularui.utils.math.functions.utility.LerpRotate;
import com.cleanroommc.modularui.utils.math.functions.utility.Random;
import com.cleanroommc.modularui.utils.math.functions.utility.RandomInteger;
import com.cleanroommc.modularui.widgets.textfield.BaseTextFieldWidget;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Constructor;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MathBuilder {
    public static final Pattern DECIMAL_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?([eE]-?\\d+)?");
    public static final MathBuilder INSTANCE = new MathBuilder();
    public final Map<String, Variable> variables = new Object2ObjectOpenHashMap();
    public final Map<String, Class<? extends Function>> functions = new Object2ObjectOpenHashMap();
    protected boolean strict = true;

    public MathBuilder() {
        this.register(new Variable("PI", Math.PI));
        this.register(new Variable("E", Math.E));
        this.functions.put("floor", Floor.class);
        this.functions.put("round", Round.class);
        this.functions.put("ceil", Ceil.class);
        this.functions.put("trunc", Trunc.class);
        this.functions.put("clamp", Clamp.class);
        this.functions.put("max", Max.class);
        this.functions.put("min", Min.class);
        this.functions.put("abs", Abs.class);
        this.functions.put("exp", Exp.class);
        this.functions.put("ln", Ln.class);
        this.functions.put("sqrt", Sqrt.class);
        this.functions.put("mod", Mod.class);
        this.functions.put("pow", Pow.class);
        this.functions.put("cos", Cos.class);
        this.functions.put("sin", Sin.class);
        this.functions.put("acos", Acos.class);
        this.functions.put("asin", Asin.class);
        this.functions.put("atan", Atan.class);
        this.functions.put("atan2", Atan2.class);
        this.functions.put("lerp", Lerp.class);
        this.functions.put("lerprotate", LerpRotate.class);
        this.functions.put("random", Random.class);
        this.functions.put("randomi", RandomInteger.class);
        this.functions.put("roll", DieRoll.class);
        this.functions.put("rolli", DieRollInteger.class);
        this.functions.put("hermite", HermiteBlend.class);
        this.functions.put("str_contains", StringContains.class);
        this.functions.put("str_starts", StringStartsWith.class);
        this.functions.put("str_ends", StringEndsWith.class);
    }

    public MathBuilder lenient() {
        this.strict = false;
        return this;
    }

    public void register(Variable variable) {
        this.variables.put(variable.getName(), variable);
    }

    public IMathValue parse(String expression) throws Exception {
        return this.parseSymbols(this.breakdownChars(this.breakdown(expression)));
    }

    public String[] breakdown(String expression) throws Exception {
        if (this.strict && !expression.matches("^[\\w\\s_+-/*%^&|<>=!?:.,()\"'@~\\[\\]]+$")) {
            throw new Exception("Given expression '" + expression + "' contains illegal characters!");
        }
        String[] chars = expression.split("(?!^)");
        int left = 0;
        int right = 0;
        for (String s : chars) {
            if (s.equals("(")) {
                ++left;
                continue;
            }
            if (!s.equals(")")) continue;
            ++right;
        }
        if (left != right) {
            throw new Exception("Given expression '" + expression + "' has more uneven amount of parenthesis, there are " + left + " open and " + right + " closed!");
        }
        return chars;
    }

    public List<Object> breakdownChars(String[] chars) {
        ArrayList<Object> symbols = new ArrayList<Object>();
        StringBuilder buffer = new StringBuilder();
        int len = chars.length;
        boolean string = false;
        block0: for (int i = 0; i < len; ++i) {
            boolean longOperator;
            String s = chars[i];
            boolean bl = longOperator = i < chars.length - 1 && this.isOperator(s + chars[i + 1]);
            if (s.equals("\"")) {
                boolean bl2 = string = !string;
            }
            if (string) {
                buffer.append(s);
                continue;
            }
            if (this.isOperator(s) || longOperator || s.equals(",")) {
                if (s.equals("-")) {
                    boolean isOperatorBehind;
                    int size = symbols.size();
                    boolean isEmpty = buffer.toString().trim().isEmpty();
                    boolean isFirst = size == 0 && isEmpty;
                    boolean bl3 = isOperatorBehind = size > 0 && (this.isOperator(symbols.get(size - 1)) || symbols.get(size - 1).equals(",")) && isEmpty;
                    if (isFirst || isOperatorBehind) {
                        buffer.append(s);
                        continue;
                    }
                }
                if (buffer.length() > 0) {
                    symbols.add(buffer.toString());
                    buffer = new StringBuilder();
                }
                if (longOperator) {
                    symbols.add(s + chars[i + 1]);
                    ++i;
                    continue;
                }
                symbols.add(s);
                continue;
            }
            if (s.equals("(")) {
                if (buffer.length() > 0) {
                    symbols.add(buffer.toString());
                    buffer = new StringBuilder();
                }
                int counter = 1;
                for (int j = i + 1; j < len; ++j) {
                    String c = chars[j];
                    if (c.equals("(")) {
                        ++counter;
                    } else if (c.equals(")")) {
                        --counter;
                    }
                    if (counter == 0) {
                        symbols.add(this.breakdownChars(buffer.toString().split("(?!^)")));
                        i = j;
                        buffer = new StringBuilder();
                        continue block0;
                    }
                    buffer.append(c);
                }
                continue;
            }
            buffer.append(s);
        }
        if (buffer.length() > 0) {
            symbols.add(buffer.toString());
        }
        return this.trimSymbols(symbols);
    }

    private List<Object> trimSymbols(List<?> symbols) {
        ArrayList<Object> newSymbols = new ArrayList<Object>();
        for (Object value : symbols) {
            if (value instanceof String) {
                String string = (String)value;
                if ((string = string.trim()).isEmpty()) continue;
                newSymbols.add(string);
                continue;
            }
            newSymbols.add(this.trimSymbols((List)value));
        }
        return newSymbols;
    }

    public IMathValue parseSymbols(List<?> symbols) throws Exception {
        int lastOp;
        IMathValue ternary = this.tryTernary(symbols);
        if (ternary != null) {
            return ternary;
        }
        int size = symbols.size();
        if (size == 1) {
            return this.valueFromObject(symbols.get(0));
        }
        if (size == 2) {
            Object first = symbols.get(0);
            Object second = symbols.get(1);
            if ((this.isVariable(first) || first.equals("-")) && second instanceof List) {
                List list = (List)second;
                return this.createFunction((String)first, list);
            }
        }
        int op = lastOp = this.seekLastOperator(symbols);
        while (op != -1) {
            int leftOp = this.seekLastOperator(symbols, op - 1);
            if (leftOp != -1) {
                Operation left = this.operationForOperator((String)symbols.get(leftOp));
                Operation right = this.operationForOperator((String)symbols.get(op));
                if (right.value > left.value) {
                    IMathValue leftValue = this.parseSymbols(symbols.subList(0, leftOp));
                    IMathValue rightValue = this.parseSymbols(symbols.subList(leftOp + 1, size));
                    return new Operator(left, leftValue, rightValue);
                }
                if (left.value > right.value) {
                    Operation initial = this.operationForOperator((String)symbols.get(lastOp));
                    if (initial.value < left.value) {
                        IMathValue leftValue = this.parseSymbols(symbols.subList(0, lastOp));
                        IMathValue rightValue = this.parseSymbols(symbols.subList(lastOp + 1, size));
                        return new Operator(initial, leftValue, rightValue);
                    }
                    IMathValue leftValue = this.parseSymbols(symbols.subList(0, op));
                    IMathValue rightValue = this.parseSymbols(symbols.subList(op + 1, size));
                    return new Operator(right, leftValue, rightValue);
                }
            }
            op = leftOp;
        }
        Operation operation = this.operationForOperator((String)symbols.get(lastOp));
        return new Operator(operation, this.parseSymbols(symbols.subList(0, lastOp)), this.parseSymbols(symbols.subList(lastOp + 1, size)));
    }

    protected int seekLastOperator(List<?> symbols) {
        return this.seekLastOperator(symbols, symbols.size() - 1);
    }

    protected int seekLastOperator(List<?> symbols, int offset) {
        for (int i = offset; i >= 0; --i) {
            Object o = symbols.get(i);
            if (!this.isOperator(o)) continue;
            if (o.equals("-")) {
                Object prev;
                Object next = i < symbols.size() - 1 ? symbols.get(i + 1) : null;
                Object v0 = prev = i > 0 ? symbols.get(i - 1) : null;
                if (next instanceof List && (this.isOperator((Object)prev) || prev == null)) continue;
            }
            return i;
        }
        return -1;
    }

    protected IMathValue tryTernary(List<?> symbols) throws Exception {
        int question = -1;
        int questions = 0;
        int colon = -1;
        int colons = 0;
        int size = symbols.size();
        for (int i = 0; i < size; ++i) {
            Object object = symbols.get(i);
            if (!(object instanceof String)) continue;
            if (object.equals("?")) {
                if (question == -1) {
                    question = i;
                }
                ++questions;
                continue;
            }
            if (!object.equals(":")) continue;
            if (colons + 1 == questions && colon == -1) {
                colon = i;
            }
            ++colons;
        }
        if (questions == colons && question > 0 && question + 1 < colon && colon < size - 1) {
            return new Ternary(this.parseSymbols(symbols.subList(0, question)), this.parseSymbols(symbols.subList(question + 1, colon)), this.parseSymbols(symbols.subList(colon + 1, size)));
        }
        return null;
    }

    protected IMathValue createFunction(String first, List<?> args) throws Exception {
        if (first.equals("!")) {
            return new Negate(this.parseSymbols(args));
        }
        if (first.startsWith("!") && first.length() > 1) {
            return new Negate(this.createFunction(first.substring(1), args));
        }
        if (first.equals("-")) {
            return new Negative(new Group(this.parseSymbols(args)));
        }
        if (first.startsWith("-") && first.length() > 1) {
            return new Negative(this.createFunction(first.substring(1), args));
        }
        if (!this.functions.containsKey(first)) {
            throw new Exception("Function '" + first + "' couldn't be found!");
        }
        ArrayList<IMathValue> values = new ArrayList<IMathValue>();
        ArrayList buffer = new ArrayList();
        for (Object o : args) {
            if (o.equals(",")) {
                values.add(this.parseSymbols(buffer));
                buffer.clear();
                continue;
            }
            buffer.add(o);
        }
        if (!buffer.isEmpty()) {
            values.add(this.parseSymbols(buffer));
        }
        Class<? extends Function> function = this.functions.get(first);
        Constructor<? extends Function> ctor = function.getConstructor(IMathValue[].class, String.class);
        return ctor.newInstance(values.toArray(new IMathValue[0]), first);
    }

    public IMathValue valueFromObject(Object object) throws Exception {
        if (object instanceof String) {
            String symbol = (String)object;
            if (symbol.startsWith("!")) {
                return new Negate(this.valueFromObject(symbol.substring(1)));
            }
            if (symbol.startsWith("\"") && symbol.endsWith("\"")) {
                return new Constant(symbol.substring(1, symbol.length() - 1));
            }
            if (this.isDecimal(symbol)) {
                return new Constant(BaseTextFieldWidget.format.parse(symbol, new ParsePosition(0)).doubleValue());
            }
            if (this.isVariable(symbol)) {
                if (symbol.startsWith("-")) {
                    Variable value = this.getVariable(symbol = symbol.substring(1));
                    if (value != null) {
                        return new Negative(value);
                    }
                } else {
                    Variable value = this.getVariable(symbol);
                    if (value != null) {
                        return value;
                    }
                }
            }
        } else if (object instanceof List) {
            List list = (List)object;
            return new Group(this.parseSymbols(list));
        }
        throw new Exception("Given object couldn't be converted to value! " + object);
    }

    protected Variable getVariable(String name) {
        return this.variables.get(name);
    }

    protected Operation operationForOperator(String op) throws Exception {
        for (Operation operation : Operation.values()) {
            if (!operation.sign.equals(op)) continue;
            return operation;
        }
        throw new Exception("There is no such operator '" + op + "'!");
    }

    protected boolean isVariable(Object o) {
        String string;
        return o instanceof String && !this.isDecimal(string = (String)o) && !this.isOperator(string);
    }

    protected boolean isOperator(Object o) {
        String string;
        return o instanceof String && this.isOperator(string = (String)o);
    }

    protected boolean isOperator(String s) {
        return Operation.OPERATORS.contains(s) || s.equals("?") || s.equals(":");
    }

    protected boolean isDecimal(String s) {
        return DECIMAL_PATTERN.matcher(s).matches();
    }
}

