/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable.text;

import com.cleanroommc.modularui.api.MCHelper;
import java.util.Arrays;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.Nullable;

public class FontRenderHelper {
    private static final int min = 48;
    private static final int max = 114;
    private static final EnumChatFormatting[] formattingMap = new EnumChatFormatting[67];

    @Nullable
    public static EnumChatFormatting getForCharacter(char c) {
        if (c < '0' || c > 'r') {
            return null;
        }
        return formattingMap[c - 48];
    }

    public static EnumChatFormatting[] createFormattingState() {
        return new EnumChatFormatting[7];
    }

    public static void addAfter(EnumChatFormatting[] state, EnumChatFormatting formatting) {
        if (formatting == EnumChatFormatting.RESET) {
            Arrays.fill(state, null);
            state[6] = formatting;
            return;
        }
        state[6] = null;
        if (formatting.func_96301_b()) {
            state[formatting.ordinal() - 15] = formatting;
            return;
        }
        state[0] = formatting;
    }

    public static void parseFormattingState(EnumChatFormatting[] state, String text) {
        int i = -2;
        while ((i = text.indexOf(167, i + 2)) >= 0 && i < text.length() - 1) {
            EnumChatFormatting formatting = FontRenderHelper.getForCharacter(text.charAt(i + 1));
            if (formatting == null) continue;
            FontRenderHelper.addAfter(state, formatting);
        }
    }

    public static String getFormatting(EnumChatFormatting[] state) {
        if (FontRenderHelper.isReset(state)) {
            return EnumChatFormatting.RESET.toString();
        }
        StringBuilder builder = FontRenderHelper.getFormatting(state, new StringBuilder());
        return builder.length() == 0 ? "" : builder.toString();
    }

    public static StringBuilder getFormatting(EnumChatFormatting[] state, StringBuilder builder) {
        int n = 6;
        for (int i = 0; i < n; ++i) {
            EnumChatFormatting formatting = state[i];
            if (formatting == null) continue;
            builder.append(formatting);
        }
        return builder;
    }

    public static boolean isReset(EnumChatFormatting[] state) {
        return state[6] != null;
    }

    public static int getDefaultTextHeight() {
        FontRenderer fr = MCHelper.getFontRenderer();
        return fr != null ? fr.field_78288_b : 9;
    }

    public static int getFormatLength(String s, int start) {
        int l = 0;
        for (int i = Math.max(0, start); i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\u00a7') {
                if (i + 1 >= s.length()) {
                    return l;
                }
                if (FontRenderHelper.getForCharacter(c) == null) {
                    return l;
                }
                l += 2;
                ++i;
                continue;
            }
            return l;
        }
        return l;
    }

    static {
        for (EnumChatFormatting formatting : EnumChatFormatting.values()) {
            char c = formatting.toString().charAt(1);
            FontRenderHelper.formattingMap[c - 48] = formatting;
            if (!Character.isLetter(c)) continue;
            FontRenderHelper.formattingMap[Character.toUpperCase((char)c) - 48] = formatting;
        }
    }
}

