/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge;

import blockrenderer6343.client.world.ClientFakePlayer;
import com.google.common.collect.ImmutableList;
import com.google.common.math.LongMath;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.drawable.shapes.Rectangle;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicTextWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.FluidNameHolderWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.MTEHatchInputBusME;
import gregtech.common.tileentities.machines.MTEHatchOutputBusME;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import tectech.TecTech;
import tectech.loader.ConfigHandler;
import tectech.recipe.TecTechRecipeMaps;
import tectech.thing.block.BlockGodforgeGlass;
import tectech.thing.block.TileEntityForgeOfGods;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.gui.TecTechUITextures;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.godforge.MTEBaseModule;
import tectech.thing.metaTileEntity.multi.godforge.MTEExoticModule;
import tectech.thing.metaTileEntity.multi.godforge.MTEMoltenModule;
import tectech.thing.metaTileEntity.multi.godforge.MTEPlasmaModule;
import tectech.thing.metaTileEntity.multi.godforge.MTESmeltingModule;
import tectech.thing.metaTileEntity.multi.godforge.color.ForgeOfGodsStarColor;
import tectech.thing.metaTileEntity.multi.godforge.color.StarColorSetting;
import tectech.thing.metaTileEntity.multi.godforge.color.StarColorStorage;
import tectech.thing.metaTileEntity.multi.godforge.structure.ForgeOfGodsRingsStructureString;
import tectech.thing.metaTileEntity.multi.godforge.structure.ForgeOfGodsStructureString;
import tectech.thing.metaTileEntity.multi.godforge.upgrade.ForgeOfGodsUpgrade;
import tectech.thing.metaTileEntity.multi.godforge.upgrade.UpgradeStorage;
import tectech.thing.metaTileEntity.multi.godforge.util.ForgeOfGodsUI;
import tectech.thing.metaTileEntity.multi.godforge.util.GodforgeMath;
import tectech.thing.metaTileEntity.multi.godforge.util.MilestoneFormatter;
import tectech.thing.metaTileEntity.multi.godforge.util.MilestoneIcon;
import tectech.thing.metaTileEntity.multi.godforge.util.UpgradeColor;

public class MTEForgeOfGods
extends TTMultiblockBase
implements IConstructable,
ISurvivalConstructable {
    private static final int DEFAULT_FUEL_CONSUMPTION_FACTOR = 1;
    private static final int DEFAULT_MAX_BATTERY_CHARGE = 100;
    private static final int DEFAULT_RING_AMOUNT = 1;
    private static final int DEFAULT_ROTATION_SPEED = 5;
    private static final int DEFAULT_STAR_SIZE = 20;
    private static final String DEFAULT_STAR_COLOR = ForgeOfGodsStarColor.DEFAULT.getName();
    private static final MilestoneFormatter DEFAULT_FORMATTING_MODE = MilestoneFormatter.COMMA;
    private static final BigInteger DEFAULT_TOTAL_POWER = BigInteger.ZERO;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private int fuelConsumptionFactor = 1;
    private int selectedFuelType;
    private int internalBattery;
    private int maxBatteryCharge = 100;
    private int gravitonShardsAvailable;
    private int gravitonShardsSpent;
    private int ringAmount = 1;
    private int stellarFuelAmount;
    private int neededStartupFuel;
    private long fuelConsumption;
    private long totalRecipesProcessed;
    private long totalFuelConsumed;
    private float totalExtensionsBuilt;
    private float powerMilestonePercentage;
    private float recipeMilestonePercentage;
    private float fuelMilestonePercentage;
    private float structureMilestonePercentage;
    private float invertedPowerMilestonePercentage;
    private float invertedRecipeMilestonePercentage;
    private float invertedFuelMilestonePercentage;
    private float invertedStructureMilestonePercentage;
    private BigInteger totalPowerConsumed = DEFAULT_TOTAL_POWER;
    private boolean batteryCharging;
    private boolean inversion;
    private boolean gravitonShardEjection;
    private MilestoneFormatter formattingMode = DEFAULT_FORMATTING_MODE;
    private boolean isRenderActive;
    private boolean secretUpgrade;
    private boolean isRendererDisabled;
    private final ItemStack[] storedUpgradeWindowItems = new ItemStack[16];
    public ArrayList<MTEBaseModule> moduleHatches = new ArrayList();
    protected ItemStackHandler inputSlotHandler = new ItemStackHandler(16);
    private final UpgradeStorage upgrades = new UpgradeStorage();
    private ForgeOfGodsUpgrade currentUpgradeWindow;
    private final StarColorStorage starColors = new StarColorStorage();
    private String selectedStarColor = DEFAULT_STAR_COLOR;
    private int rotationSpeed = 5;
    private int starSize = 20;
    private ForgeOfGodsStarColor newStarColor = this.starColors.newTemplateColor();
    private int starColorR;
    private int starColorG;
    private int starColorB;
    private float starGamma;
    private int editingStarIndex;
    private int editingColorIndex;
    private ForgeOfGodsStarColor importedStarColor;
    private static final int FUEL_CONFIG_WINDOW_ID = 9;
    private static final int UPGRADE_TREE_WINDOW_ID = 10;
    private static final int INDIVIDUAL_UPGRADE_WINDOW_ID = 11;
    private static final int BATTERY_CONFIG_WINDOW_ID = 12;
    private static final int MILESTONE_WINDOW_ID = 13;
    private static final int INDIVIDUAL_MILESTONE_WINDOW_ID = 14;
    private static final int MANUAL_INSERTION_WINDOW_ID = 15;
    private static final int GENERAL_INFO_WINDOW_ID = 16;
    private static final int SPECIAL_THANKS_WINDOW_ID = 17;
    private static final int STAR_COSMETICS_WINDOW_ID = 18;
    private static final int STAR_CUSTOM_COLOR_WINDOW_ID = 19;
    private static final int STAR_CUSTOM_COLOR_IMPORT_WINDOW_ID = 20;
    private static final int STATISTICS_WINDOW_ID = 21;
    private static final int TEXTURE_INDEX = 960;
    private static final long POWER_MILESTONE_CONSTANT;
    private static final long RECIPE_MILESTONE_CONSTANT;
    private static final long FUEL_MILESTONE_CONSTANT = 10000L;
    private static final long RECIPE_MILESTONE_T7_CONSTANT;
    private static final long FUEL_MILESTONE_T7_CONSTANT;
    private static final BigInteger POWER_MILESTONE_T7_CONSTANT;
    private static final double POWER_LOG_CONSTANT;
    private static final double RECIPE_LOG_CONSTANT;
    private static final double FUEL_LOG_CONSTANT;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    protected static final String STRUCTURE_PIECE_SHAFT = "beam_shaft";
    protected static final String STRUCTURE_PIECE_FIRST_RING = "first_ring";
    protected static final String STRUCTURE_PIECE_FIRST_RING_AIR = "first_ring_air";
    protected static final String STRUCTURE_PIECE_SECOND_RING = "second_ring";
    protected static final String STRUCTURE_PIECE_SECOND_RING_AIR = "second_ring_air";
    protected static final String STRUCTURE_PIECE_THIRD_RING = "third_ring";
    protected static final String STRUCTURE_PIECE_THIRD_RING_AIR = "third_ring_air";
    private static final String SCANNER_INFO_BAR;
    private static final ItemStack STELLAR_FUEL;
    public static final IStructureDefinition<MTEForgeOfGods> STRUCTURE_DEFINITION;
    private final ArrayList<FluidStack> validFuelList = new ArrayList<FluidStack>(){
        {
            this.add(MaterialsUEVplus.DimensionallyTranscendentResidue.getFluid(1L));
            this.add(MaterialsUEVplus.RawStarMatter.getFluid(1L));
            this.add(MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(1L));
        }
    };
    int ticker = 0;
    private final int[] milestoneProgress = new int[]{0, 0, 0, 0};
    private int currentMilestoneID = 0;

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        int realBudget = elementBudget >= 1000 ? elementBudget : Math.min(1000, elementBudget * 5);
        int built = 0;
        if (Mods.BlockRenderer6343.isModLoaded() && env.getActor() instanceof ClientFakePlayer) {
            built = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 63, 14, 1, elementBudget, env, false, true);
            if (stackSize.field_77994_a > 1) {
                built += this.survivialBuildPiece(STRUCTURE_PIECE_SECOND_RING, stackSize, 55, 11, -67, realBudget, env, false, true);
            }
            if (stackSize.field_77994_a > 2) {
                built += this.survivialBuildPiece(STRUCTURE_PIECE_THIRD_RING, stackSize, 47, 13, -76, realBudget, env, false, true);
            }
            return built;
        }
        this.survivialBuildPiece(STRUCTURE_PIECE_SHAFT, stackSize, 63, 14, 1, realBudget, env, false, true);
        if (stackSize.field_77994_a > 0 && this.ringAmount < 1) {
            built += this.survivialBuildPiece(STRUCTURE_PIECE_FIRST_RING, stackSize, 63, 14, -59, realBudget, env, false, true);
        }
        if (stackSize.field_77994_a > 1 && this.ringAmount < 2) {
            built += this.survivialBuildPiece(STRUCTURE_PIECE_SECOND_RING, stackSize, 55, 11, -67, realBudget, env, false, true);
        }
        if (stackSize.field_77994_a > 2 && this.ringAmount < 3) {
            built += this.survivialBuildPiece(STRUCTURE_PIECE_THIRD_RING, stackSize, 47, 13, -76, realBudget, env, false, true);
        }
        return built;
    }

    public IStructureDefinition<MTEForgeOfGods> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public MTEForgeOfGods(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEForgeOfGods(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEForgeOfGods(this.mName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/GODFORGE_CONTROLLER");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(961), TextureFactory.builder().addIcon(ScreenON).extFacing().build(), TextureFactory.builder().addIcon(ScreenON).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(961)};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 63, 14, 1, stackSize, hintsOnly);
        if (stackSize.field_77994_a > 1) {
            this.buildPiece(STRUCTURE_PIECE_SECOND_RING, stackSize, hintsOnly, 55, 11, -67);
        }
        if (stackSize.field_77994_a > 2) {
            this.buildPiece(STRUCTURE_PIECE_THIRD_RING, stackSize, hintsOnly, 47, 13, -76);
        }
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.moduleHatches.clear();
        if (this.isRenderActive) {
            if (!this.structureCheck_EM(STRUCTURE_PIECE_SHAFT, 63, 14, 1) || !this.structureCheck_EM(STRUCTURE_PIECE_FIRST_RING_AIR, 63, 14, -59)) {
                this.destroyRenderer();
                return false;
            }
        } else if (!this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 63, 14, 1)) {
            return false;
        }
        if (this.internalBattery != 0 && !this.isRenderActive && !this.isRendererDisabled) {
            this.createRenderer();
        }
        if (this.mInputBusses.size() != 1) {
            return false;
        }
        if (this.mOutputBusses.size() != 1) {
            return false;
        }
        if (!(this.mOutputBusses.get(0) instanceof MTEHatchOutputBusME)) {
            return false;
        }
        if (!this.mEnergyHatches.isEmpty()) {
            return false;
        }
        if (!this.mExoticEnergyHatches.isEmpty()) {
            return false;
        }
        if (this.mInputHatches.size() != 1) {
            return false;
        }
        if (this.isUpgradeActive(ForgeOfGodsUpgrade.CD)) {
            if (this.checkPiece(STRUCTURE_PIECE_SECOND_RING, 55, 11, -67)) {
                this.ringAmount = 2;
                this.destroySecondRing();
                this.updateRenderer();
            }
            if (this.isRenderActive && this.ringAmount >= 2 && !this.checkPiece(STRUCTURE_PIECE_SECOND_RING_AIR, 55, 11, -67)) {
                this.destroyRenderer();
            }
        } else {
            if (this.ringAmount == 3) {
                this.buildThirdRing();
            }
            if (this.ringAmount >= 2) {
                this.ringAmount = 1;
                this.updateRenderer();
                this.buildSecondRing();
            }
        }
        if (this.isUpgradeActive(ForgeOfGodsUpgrade.EE)) {
            if (this.checkPiece(STRUCTURE_PIECE_THIRD_RING, 47, 13, -76)) {
                this.ringAmount = 3;
                this.destroyThirdRing();
                this.updateRenderer();
            }
            if (this.isRenderActive && this.ringAmount == 3 && !this.checkPiece(STRUCTURE_PIECE_THIRD_RING_AIR, 47, 13, -76)) {
                this.destroyRenderer();
            }
        } else if (this.ringAmount == 3) {
            this.ringAmount = 2;
            this.updateRenderer();
            this.buildThirdRing();
        }
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            ++this.ticker;
            if (this.ticker % 100 == 0) {
                this.ticker = 0;
                this.startRecipeProcessing();
                int maxModuleCount = 8;
                if (this.isUpgradeActive(ForgeOfGodsUpgrade.CD)) {
                    maxModuleCount += 4;
                }
                if (this.isUpgradeActive(ForgeOfGodsUpgrade.EE)) {
                    maxModuleCount += 4;
                }
                if (!this.mInputBusses.isEmpty() && (this.internalBattery == 0 || this.isUpgradeActive(ForgeOfGodsUpgrade.END))) {
                    MTEHatchInputBus inputBus = (MTEHatchInputBus)this.mInputBusses.get(0);
                    ItemStack[] inputBusInventory = inputBus.getRealInventory();
                    ItemStack itemToAbsorb = STELLAR_FUEL;
                    if (this.isUpgradeActive(ForgeOfGodsUpgrade.END) && this.internalBattery != 0) {
                        itemToAbsorb = GTOreDictUnificator.get(OrePrefixes.gem, MaterialsUEVplus.GravitonShard, 1L);
                    }
                    if (inputBusInventory != null) {
                        for (int i = 0; i < inputBusInventory.length; ++i) {
                            ItemStack itemStack = inputBusInventory[i];
                            if (itemStack == null || !itemStack.func_77969_a(itemToAbsorb)) continue;
                            int stacksize = itemStack.field_77994_a;
                            if (inputBus instanceof MTEHatchInputBusME) {
                                MTEHatchInputBusME meBus = (MTEHatchInputBusME)inputBus;
                                ItemStack realItem = meBus.getRealInventory()[i + 16];
                                if (realItem == null) break;
                                stacksize = realItem.field_77994_a;
                            }
                            inputBus.func_70298_a(i, stacksize);
                            if (this.internalBattery == 0) {
                                this.stellarFuelAmount += stacksize;
                            } else {
                                this.gravitonShardsAvailable += stacksize;
                            }
                            inputBus.updateSlots();
                        }
                    }
                    if (this.internalBattery == 0) {
                        this.neededStartupFuel = GodforgeMath.calculateStartupFuelConsumption(this);
                        if (this.stellarFuelAmount >= this.neededStartupFuel) {
                            this.stellarFuelAmount -= this.neededStartupFuel;
                            this.increaseBattery(this.neededStartupFuel);
                            if (!this.isRendererDisabled) {
                                this.createRenderer();
                            }
                        }
                    }
                }
                if (this.internalBattery != 0) {
                    this.drainFuel();
                }
                this.determineCompositionMilestoneLevel();
                this.checkInversionStatus();
                this.determineMilestoneProgress();
                if (!ConfigHandler.debug.DEBUG_MODE) {
                    this.determineGravitonShardAmount();
                }
                if (this.isUpgradeActive(ForgeOfGodsUpgrade.END) && this.gravitonShardEjection) {
                    this.ejectGravitonShards();
                }
                if (!this.moduleHatches.isEmpty() && this.internalBattery > 0 && this.moduleHatches.size() <= maxModuleCount) {
                    for (MTEBaseModule module : this.moduleHatches) {
                        if (GodforgeMath.allowModuleConnection(module, this)) {
                            module.connect();
                            GodforgeMath.calculateMaxHeatForModules(module, this);
                            GodforgeMath.calculateSpeedBonusForModules(module, this);
                            GodforgeMath.calculateMaxParallelForModules(module, this);
                            GodforgeMath.calculateEnergyDiscountForModules(module, this);
                            GodforgeMath.setMiscModuleParameters(module, this);
                            GodforgeMath.queryMilestoneStats(module, this);
                            if (this.isUpgradeActive(ForgeOfGodsUpgrade.TBF)) continue;
                            GodforgeMath.calculateProcessingVoltageForModules(module, this);
                            continue;
                        }
                        module.disconnect();
                    }
                } else if (this.moduleHatches.size() > maxModuleCount) {
                    for (MTEBaseModule module : this.moduleHatches) {
                        module.disconnect();
                    }
                }
                if (this.mEfficiency < 0) {
                    this.mEfficiency = 0;
                }
                this.endRecipeProcessing();
            }
        }
    }

    private void drainFuel() {
        this.fuelConsumption = (long)Math.max(GodforgeMath.calculateFuelConsumption(this) * 5.0 * (double)(this.batteryCharging ? 2 : 1), 1.0);
        if (this.fuelConsumption >= Integer.MAX_VALUE) {
            this.reduceBattery(this.fuelConsumptionFactor);
            return;
        }
        FluidStack fuelToDrain = new FluidStack(this.validFuelList.get(this.selectedFuelType), (int)this.fuelConsumption);
        for (MTEHatchInput hatch : GTUtility.filterValidMTEs(this.mInputHatches)) {
            FluidStack drained = hatch.drain(ForgeDirection.UNKNOWN, fuelToDrain, true);
            if (drained == null) continue;
            fuelToDrain.amount -= drained.amount;
            if (fuelToDrain.amount != 0) continue;
            this.totalFuelConsumed += (long)this.getFuelFactor();
            if (this.batteryCharging) {
                this.increaseBattery(this.fuelConsumptionFactor);
            }
            return;
        }
        this.reduceBattery(this.fuelConsumptionFactor);
    }

    public boolean addModuleToMachineList(IGregTechTileEntity tileEntity, int baseCasingIndex) {
        if (tileEntity == null) {
            return false;
        }
        IMetaTileEntity metaTileEntity = tileEntity.getMetaTileEntity();
        if (metaTileEntity == null) {
            return false;
        }
        if (metaTileEntity instanceof MTEBaseModule) {
            return this.moduleHatches.add((MTEBaseModule)metaTileEntity);
        }
        return false;
    }

    private TileEntityForgeOfGods getRenderer() {
        ChunkCoordinates renderPos = this.getRenderPos();
        TileEntity tile = this.getBaseMetaTileEntity().getWorld().func_147438_o(renderPos.field_71574_a, renderPos.field_71572_b, renderPos.field_71573_c);
        if (tile instanceof TileEntityForgeOfGods) {
            TileEntityForgeOfGods forgeTile = (TileEntityForgeOfGods)tile;
            return forgeTile;
        }
        return null;
    }

    private void updateRenderer() {
        TileEntityForgeOfGods tile = this.getRenderer();
        if (tile == null) {
            return;
        }
        tile.setRingCount(this.ringAmount);
        tile.setStarRadius(this.starSize);
        tile.setRotationSpeed(this.rotationSpeed);
        tile.setColor(this.starColors.getByName(this.selectedStarColor));
        tile.updateToClient();
    }

    private void createRenderer() {
        ChunkCoordinates renderPos = this.getRenderPos();
        this.getBaseMetaTileEntity().getWorld().func_147449_b(renderPos.field_71574_a, renderPos.field_71572_b, renderPos.field_71573_c, Blocks.field_150350_a);
        this.getBaseMetaTileEntity().getWorld().func_147449_b(renderPos.field_71574_a, renderPos.field_71572_b, renderPos.field_71573_c, TTCasingsContainer.forgeOfGodsRenderBlock);
        TileEntityForgeOfGods rendererTileEntity = (TileEntityForgeOfGods)this.getBaseMetaTileEntity().getWorld().func_147438_o(renderPos.field_71574_a, renderPos.field_71572_b, renderPos.field_71573_c);
        switch (this.ringAmount) {
            case 2: {
                this.destroyFirstRing();
                this.destroySecondRing();
                break;
            }
            case 3: {
                this.destroyFirstRing();
                this.destroySecondRing();
                this.destroyThirdRing();
                break;
            }
            default: {
                this.destroyFirstRing();
            }
        }
        rendererTileEntity.setRenderRotation(this.getRotation(), this.getDirection());
        this.updateRenderer();
        this.isRenderActive = true;
    }

    private void destroyRenderer() {
        ChunkCoordinates renderPos = this.getRenderPos();
        this.getBaseMetaTileEntity().getWorld().func_147449_b(renderPos.field_71574_a, renderPos.field_71572_b, renderPos.field_71573_c, Blocks.field_150350_a);
        switch (this.ringAmount) {
            case 2: {
                this.buildFirstRing();
                this.buildSecondRing();
                break;
            }
            case 3: {
                this.buildFirstRing();
                this.buildSecondRing();
                this.buildThirdRing();
                break;
            }
            default: {
                this.buildFirstRing();
            }
        }
        this.isRenderActive = false;
    }

    private ChunkCoordinates getRenderPos() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        double xOffset = 122 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double yOffset = 122 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        double zOffset = 122 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        return new ChunkCoordinates((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset));
    }

    private void destroyFirstRing() {
        this.buildPiece(STRUCTURE_PIECE_FIRST_RING_AIR, null, false, 63, 14, -59);
    }

    private void destroySecondRing() {
        this.buildPiece(STRUCTURE_PIECE_SECOND_RING_AIR, null, false, 55, 11, -67);
    }

    private void destroyThirdRing() {
        this.buildPiece(STRUCTURE_PIECE_THIRD_RING_AIR, null, false, 47, 13, -76);
    }

    private void buildFirstRing() {
        this.buildPiece(STRUCTURE_PIECE_FIRST_RING, null, false, 63, 14, -59);
    }

    private void buildSecondRing() {
        this.buildPiece(STRUCTURE_PIECE_SECOND_RING, null, false, 55, 11, -67);
    }

    private void buildThirdRing() {
        this.buildPiece(STRUCTURE_PIECE_THIRD_RING, null, false, 47, 13, -76);
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.isRendererDisabled) {
            this.isRendererDisabled = false;
        } else {
            this.isRendererDisabled = true;
            if (this.isRenderActive) {
                this.destroyRenderer();
            }
        }
        aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Animations are now " + (this.isRendererDisabled ? "disabled" : "enabled") + "."));
    }

    @Override
    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (this.isRenderActive) {
            this.destroyRenderer();
        }
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        str.add(SCANNER_INFO_BAR);
        str.add("Number of Rings: " + EnumChatFormatting.GOLD + this.ringAmount);
        str.add("Total Upgrades Unlocked: " + EnumChatFormatting.GOLD + this.getTotalActiveUpgrades());
        str.add("Connected Modules: " + EnumChatFormatting.GOLD + this.moduleHatches.size());
        str.add(SCANNER_INFO_BAR);
        return str.toArray(new String[0]);
    }

    @Override
    public void onRemoval() {
        if (this.moduleHatches != null && !this.moduleHatches.isEmpty()) {
            for (MTEBaseModule module : this.moduleHatches) {
                module.disconnect();
            }
        }
        super.onRemoval();
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        buildContext.addSyncedWindow(10, this::createUpgradeTreeWindow);
        buildContext.addSyncedWindow(11, this::createIndividualUpgradeWindow);
        buildContext.addSyncedWindow(9, this::createFuelConfigWindow);
        buildContext.addSyncedWindow(12, this::createBatteryWindow);
        buildContext.addSyncedWindow(13, this::createMilestoneWindow);
        buildContext.addSyncedWindow(14, this::createIndividualMilestoneWindow);
        buildContext.addSyncedWindow(15, this::createManualInsertionWindow);
        buildContext.addSyncedWindow(16, this::createGeneralInfoWindow);
        buildContext.addSyncedWindow(17, this::createSpecialThanksWindow);
        buildContext.addSyncedWindow(18, this::createStarCosmeticsWindow);
        buildContext.addSyncedWindow(19, this::createStarCustomColorWindow);
        buildContext.addSyncedWindow(20, this::createStarColorImportWindow);
        buildContext.addSyncedWindow(21, this::createStatisticsWindow);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.BACKGROUND_SCREEN_BLUE).setPos(4, 4).setSize(190, 85))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> button = new ArrayList<UITexture>();
            button.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            button.add(TecTechUITextures.OVERLAY_BUTTON_ARROW_BLUE_UP);
            return button.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"fog.button.upgradetree.tooltip")).setPos(174, 167).setTooltipShowUpDelay(5))).widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PICTURE_HEAT_SINK_16x8).setPos(174, 183).setSize(16, 8))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(9);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> button = new ArrayList<UITexture>();
            button.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            button.add(TecTechUITextures.OVERLAY_BUTTON_HEAT_ON);
            return button.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"fog.button.fuelconfig.tooltip")).setPos(174, 110).setTooltipShowUpDelay(5))).widget(TextWidget.dynamicText(this::storedFuelHeaderText).setDefaultColor(EnumChatFormatting.WHITE).setPos(6, 8).setSize(185, 10))).widget(TextWidget.dynamicText(this::storedFuel).setDefaultColor(EnumChatFormatting.WHITE).setPos(6, 20).setSize(185, 10))).widget(this.createBatteryButton((IWidgetBuilder<?>)builder))).widget((Widget)this.createEjectionSwitch((IWidgetBuilder<?>)builder))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isAllowedToWork(), val -> {
            if (val.booleanValue()) {
                this.getBaseMetaTileEntity().enableWorking();
            } else {
                this.getBaseMetaTileEntity().disableWorking();
            }
        }))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                this.checkMachine_EM(this.getBaseMetaTileEntity(), null);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> button = new ArrayList<UITexture>();
            button.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            button.add(TecTechUITextures.OVERLAY_CYCLIC_BLUE);
            return button.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"fog.button.structurecheck.tooltip")).setPos(8, 91).setTooltipShowUpDelay(5))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(13);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> button = new ArrayList<UITexture>();
            button.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            button.add(TecTechUITextures.OVERLAY_BUTTON_FLAG);
            return button.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"fog.button.milestones.tooltip")).setTooltipShowUpDelay(5).setPos(174, 91))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(16);
            }
        }).setSize(18, 18).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.clickhere")).setPos(172, 67).setTooltipShowUpDelay(5))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(17);
            }
        }).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"fog.button.thanks.tooltip")).setBackground(new IDrawable[]{TecTechUITextures.OVERLAY_BUTTON_HEART}).setPos(8, 69).setTooltipShowUpDelay(5))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(18);
            }
        }).addTooltip(StatCollector.func_74838_a((String)"fog.button.color.tooltip")).setBackground(() -> {
            ArrayList<UITexture> button = new ArrayList<UITexture>();
            button.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            button.add(TecTechUITextures.OVERLAY_BUTTON_RAINBOW_SPIRAL);
            return button.toArray(new IDrawable[0]);
        }).setPos(174, 148).setSize(16, 16).setTooltipShowUpDelay(5))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(21);
            }
        }).addTooltip(StatCollector.func_74838_a((String)"fog.button.statistics.tooltip")).setBackground(() -> {
            ArrayList<UITexture> button = new ArrayList<UITexture>();
            button.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            button.add(TecTechUITextures.OVERLAY_BUTTON_STATISTICS);
            return button.toArray(new IDrawable[0]);
        }).setPos(26, 91).setSize(16, 16).setTooltipShowUpDelay(5));
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PICTURE_GODFORGE_LOGO).setSize(18, 18).setPos(172, 67));
    }

    protected ButtonWidget createEjectionSwitch(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.gravitonShardEjection = !this.gravitonShardEjection;
        }).setBackground(() -> new UITexture[]{TecTechUITextures.BUTTON_CELESTIAL_32x32, this.gravitonShardEjection ? TecTechUITextures.OVERLAY_EJECTION_ON : TecTechUITextures.OVERLAY_EJECTION_LOCKED}).addTooltip(StatCollector.func_74838_a((String)"fog.button.ejection.tooltip")).setTooltipShowUpDelay(5).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.gravitonShardEjection, val -> {
            this.gravitonShardEjection = val;
        }), builder).setPos(44, 91).setSize(16, 16).setEnabled($ -> this.isUpgradeActive(ForgeOfGodsUpgrade.END)).attachSyncer(this.upgrades.getSyncer(ForgeOfGodsUpgrade.END), builder);
        return (ButtonWidget)button;
    }

    protected Widget createBatteryButton(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            if (clickData.mouseButton == 0) {
                this.batteryCharging = !this.batteryCharging;
            } else if (clickData.mouseButton == 1 && !widget.isClient() && this.isUpgradeActive(ForgeOfGodsUpgrade.REC)) {
                widget.getContext().openSyncedWindow(12);
            }
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            if (this.batteryCharging) {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_BATTERY_ON);
            } else {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_BATTERY_OFF);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(174, 129).setSize(16, 16);
        button.addTooltip(StatCollector.func_74838_a((String)"fog.button.battery.tooltip.01")).addTooltip(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"fog.button.battery.tooltip.02")).setTooltipShowUpDelay(5).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.batteryCharging, val -> {
            this.batteryCharging = val;
        }), builder);
        return button;
    }

    protected ModularWindow createBatteryWindow(EntityPlayer player) {
        int WIDTH = 78;
        int HEIGHT = 52;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)78, (int)52);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.BottomRight.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(78, 52)).add(75, 0).subtract(0, 10)));
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.batteryinfo", (Object[])new Object[0]).setPos(3, 4).setSize(74, 20))).widget(new NumericWidget().setSetter(val -> {
            this.maxBatteryCharge = (int)val;
        }).setGetter(() -> this.maxBatteryCharge).setBounds(1.0, 2.147483647E9).setDefaultValue(100.0).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(4, 25).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
        return builder.build();
    }

    protected ModularWindow createFuelConfigWindow(EntityPlayer player) {
        int w = 78;
        int h = 130;
        int parentW = this.getGUIWidth();
        int parentH = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)78, (int)130);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(parentW, parentH)).add(Alignment.TopRight.getAlignedPos(new Size(parentW, parentH), new Size(78, 130)).add(75, 0)));
        builder.widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.fuelconsumption", (Object[])new Object[0]).setPos(3, 2).setSize(74, 34));
        NumericWidget fuelFactor = new NumericWidget();
        fuelFactor.setSetter(val -> {
            this.fuelConsumptionFactor = (int)val;
        }).setGetter(() -> this.fuelConsumptionFactor).setBounds(1.0, (double)GodforgeMath.calculateMaxFuelFactor(this)).setDefaultValue(1.0).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(4, 35).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD});
        builder.widget((Widget)fuelFactor);
        builder.widget((Widget)this.upgrades.getSyncer(ForgeOfGodsUpgrade.CFCE).setOnClientUpdate($ -> fuelFactor.setMaxValue((double)GodforgeMath.calculateMaxFuelFactor(this))));
        builder.widget((Widget)this.upgrades.getSyncer(ForgeOfGodsUpgrade.GEM).setOnClientUpdate($ -> fuelFactor.setMaxValue((double)GodforgeMath.calculateMaxFuelFactor(this))));
        builder.widget((Widget)this.upgrades.getSyncer(ForgeOfGodsUpgrade.TSE).setOnClientUpdate($ -> fuelFactor.setMaxValue((double)GodforgeMath.calculateMaxFuelFactor(this))));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)ModularUITextures.ICON_INFO).setPos(64, 24).setSize(10, 10).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.0")).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.1")).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.2")).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.3")).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.4")).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelinfo.5")).setTooltipShowUpDelay(5))).widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.fueltype", (Object[])new Object[0]).setPos(3, 57).setSize(74, 24))).widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.fuelusage", (Object[])new Object[0]).setPos(3, 100).setSize(74, 20))).widget(TextWidget.dynamicText(this::fuelUsage).setPos(3, 115).setSize(74, 15))).widget(new MultiChildWidget().addChild(new FluidNameHolderWidget(() -> MaterialsUEVplus.DimensionallyTranscendentResidue.getFluid(1L).getUnlocalizedName().substring(6), String2 -> MaterialsUEVplus.DimensionallyTranscendentResidue.getFluid(1L).getUnlocalizedName()){

            public void buildTooltip(List<Text> tooltip) {
                FluidStack fluid = this.createFluidStack();
                this.addFluidNameInfo(tooltip, fluid);
                this.addAdditionalFluidInfo(tooltip, fluid);
            }
        }.setTooltipShowUpDelay(5).setPos(1, 1).setSize(16, 16)).addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.selectedFuelType = 0;
        }).setBackground(() -> {
            if (this.selectedFuelType == 0) {
                return new IDrawable[]{TecTechUITextures.SLOT_OUTLINE_GREEN};
            }
            return new IDrawable[0];
        }).setSize(18, 18).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(this::getFuelType, this::setFuelType), (IWidgetBuilder)builder)).setPos(6, 82).setSize(18, 18))).widget(new MultiChildWidget().addChild(new FluidNameHolderWidget(() -> MaterialsUEVplus.RawStarMatter.getFluid(1L).getUnlocalizedName().substring(6), String2 -> MaterialsUEVplus.RawStarMatter.getFluid(1L).getUnlocalizedName()){

            public void buildTooltip(List<Text> tooltip) {
                FluidStack fluid = this.createFluidStack();
                this.addFluidNameInfo(tooltip, fluid);
                this.addAdditionalFluidInfo(tooltip, fluid);
            }
        }.setTooltipShowUpDelay(5).setPos(1, 1).setSize(16, 16)).addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.selectedFuelType = 1;
        }).setBackground(() -> {
            if (this.selectedFuelType == 1) {
                return new IDrawable[]{TecTechUITextures.SLOT_OUTLINE_GREEN};
            }
            return new IDrawable[0];
        }).setSize(18, 18)).setPos(29, 82).setSize(18, 18))).widget(new MultiChildWidget().addChild(new FluidNameHolderWidget(() -> MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(1L).getUnlocalizedName().substring(6), String2 -> MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(1L).getUnlocalizedName()){

            public void buildTooltip(List<Text> tooltip) {
                FluidStack fluid = this.createFluidStack();
                this.addFluidNameInfo(tooltip, fluid);
                this.addAdditionalFluidInfo(tooltip, fluid);
            }
        }.setTooltipShowUpDelay(5).setPos(1, 1).setSize(16, 16)).addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.selectedFuelType = 2;
        }).setBackground(() -> {
            if (this.selectedFuelType == 2) {
                return new IDrawable[]{TecTechUITextures.SLOT_OUTLINE_GREEN};
            }
            return new IDrawable[0];
        }).setSize(18, 18)).setPos(52, 82).setSize(18, 18).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(this::getFuelType, this::setFuelType), (IWidgetBuilder)builder));
        return builder.build();
    }

    protected ModularWindow createMilestoneWindow(EntityPlayer player) {
        int WIDTH = 400;
        int HEIGHT = 300;
        ModularWindow.Builder builder = ModularWindow.builder((int)400, (int)300);
        builder.setBackground(new IDrawable[]{TecTechUITextures.BACKGROUND_SPACE});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.widget(this.createMilestoneButton(0, 80, 100, new Pos2d(62, 24)));
        builder.widget(this.createMilestoneButton(1, 70, 98, new Pos2d(263, 25)));
        builder.widget(this.createMilestoneButton(2, 100, 100, new Pos2d(52, 169)));
        builder.widget(this.createMilestoneButton(3, 100, 100, new Pos2d(248, 169)));
        builder.widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.powermilestone", (Object[])new Object[0]).setDefaultColor(EnumChatFormatting.GOLD).setPos(77, 45).setSize(50, 30));
        builder.widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.recipemilestone", (Object[])new Object[0]).setDefaultColor(EnumChatFormatting.GOLD).setPos(268, 45).setSize(60, 30));
        builder.widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.fuelmilestone", (Object[])new Object[0]).setDefaultColor(EnumChatFormatting.GOLD).setPos(77, 190).setSize(50, 30));
        builder.widget(TextWidget.localised((String)"gt.blockmachines.multimachine.FOG.purchasablemilestone", (Object[])new Object[0]).setDefaultColor(EnumChatFormatting.GOLD).setPos(268, 190).setSize(60, 30));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_BACKGROUND).setPos(37, 70).setSize(130, 7))).widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_BACKGROUND).setPos(233, 70).setSize(130, 7))).widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_BACKGROUND).setPos(37, 215).setSize(130, 7))).widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_BACKGROUND).setPos(233, 215).setSize(130, 7));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ProgressBar().setProgress(() -> Float.valueOf(this.powerMilestonePercentage)).setDirection(ProgressBar.Direction.RIGHT).setTexture(TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_RED, 130).setSynced(true, false).setSize(130, 7).setPos(37, 70))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.recipeMilestonePercentage)).setDirection(ProgressBar.Direction.RIGHT).setTexture(TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_PURPLE, 130).setSynced(true, false).setSize(130, 7).setPos(233, 70))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.fuelMilestonePercentage)).setDirection(ProgressBar.Direction.RIGHT).setTexture(TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_BLUE, 130).setSynced(true, false).setSize(130, 7).setPos(37, 215))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.structureMilestonePercentage)).setDirection(ProgressBar.Direction.RIGHT).setTexture(TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_RAINBOW, 130).setSynced(true, false).setSize(130, 7).setPos(233, 215))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.invertedPowerMilestonePercentage)).setDirection(ProgressBar.Direction.LEFT).setTexture(TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_RED_INVERTED, 130).setSynced(true, false).setSize(130, 7).setPos(37, 70))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.invertedRecipeMilestonePercentage)).setDirection(ProgressBar.Direction.LEFT).setTexture(TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_PURPLE_INVERTED, 130).setSynced(true, false).setSize(130, 7).setPos(233, 70))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.invertedFuelMilestonePercentage)).setDirection(ProgressBar.Direction.LEFT).setTexture(TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_BLUE_INVERTED, 130).setSynced(true, false).setSize(130, 7).setPos(37, 215))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.invertedStructureMilestonePercentage)).setDirection(ProgressBar.Direction.LEFT).setTexture(TecTechUITextures.PROGRESSBAR_GODFORGE_MILESTONE_RAINBOW_INVERTED, 130).setSynced(true, false).setSize(130, 7).setPos(233, 215))).widget(ButtonWidget.closeWindowButton((boolean)true).setOnClick((data, widget) -> {
            if (!widget.isClient()) {
                widget.getWindow().closeWindow();
                ForgeOfGodsUI.closeWindow(widget, 14);
            }
        }).setPos(382, 6));
        return builder.build();
    }

    protected ModularWindow createIndividualMilestoneWindow(EntityPlayer player) {
        int w = 150;
        int h = 150;
        MilestoneIcon icon = MilestoneIcon.VALUES[this.currentMilestoneID];
        Size iconSize = icon.getSize();
        ModularWindow.Builder builder = ModularWindow.builder((int)150, (int)150);
        builder.setBackground(new IDrawable[]{TecTechUITextures.BACKGROUND_GLOW_WHITE});
        builder.setDraggable(true);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(134, 4))).widget(new DrawableWidget().setDrawable((IDrawable)icon.getSymbol()).setSize(iconSize).setPos((150 - iconSize.width) / 2, (150 - iconSize.height) / 2))).widget(new TextWidget(icon.getNameText()).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(0, 8).setSize(150, 15))).widget(TextWidget.dynamicText(this::inversionStatusText).setDefaultColor(EnumChatFormatting.AQUA).setTextAlignment(Alignment.Center).setScale(0.8f).setPos(0, 120).setSize(150, 15))).widget(TextWidget.dynamicText(() -> this.totalMilestoneProgress(this.currentMilestoneID)).setScale(0.7f).setDefaultColor(EnumChatFormatting.WHITE).setTextAlignment(Alignment.Center).setPos(5, 30).setSize(140, 30))).widget(TextWidget.dynamicText(() -> this.currentMilestoneLevel(this.currentMilestoneID)).setScale(0.7f).setDefaultColor(EnumChatFormatting.WHITE).setTextAlignment(Alignment.Center).setPos(5, 50).setSize(140, 30))).widget(TextWidget.dynamicText(() -> this.milestoneProgressText(this.currentMilestoneID)).setScale(0.7f).setDefaultColor(EnumChatFormatting.WHITE).setSize(140, 30).setPos(5, 70))).widget(TextWidget.dynamicText(() -> this.gravitonShardAmountText(this.currentMilestoneID)).setScale(0.7f).setDefaultColor(EnumChatFormatting.WHITE).setSize(140, 30).setPos(5, 90))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            if (clickData.mouseButton == 0) {
                this.formattingMode = this.formattingMode.cycle();
            }
        }).setSize(10, 10).addTooltip(StatCollector.func_74838_a((String)"fog.button.formatting.tooltip")).setBackground(new IDrawable[]{TecTechUITextures.OVERLAY_CYCLIC_BLUE}).setPos(5, 135).setTooltipShowUpDelay(5).attachSyncer((FakeSyncWidget)new FakeSyncWidget.ByteSyncer(() -> (byte)this.formattingMode.ordinal(), val -> {
            this.formattingMode = MilestoneFormatter.VALUES[MathHelper.func_76125_a((int)val.byteValue(), (int)0, (int)(MilestoneFormatter.VALUES.length - 1))];
        }), (IWidgetBuilder)builder));
        return builder.build();
    }

    private Widget createMilestoneButton(int milestoneID, int width, int height, Pos2d pos) {
        return new ButtonWidget().setOnClick((clickData, widget) -> {
            this.currentMilestoneID = milestoneID;
            ForgeOfGodsUI.reopenWindow(widget, 14);
        }).setSize(width, height).setBackground(() -> {
            IDrawable[] iDrawableArray;
            switch (milestoneID) {
                case 1: {
                    IDrawable[] iDrawableArray2 = new IDrawable[1];
                    iDrawableArray = iDrawableArray2;
                    iDrawableArray2[0] = TecTechUITextures.PICTURE_GODFORGE_MILESTONE_CONVERSION_GLOW;
                    break;
                }
                case 2: {
                    IDrawable[] iDrawableArray3 = new IDrawable[1];
                    iDrawableArray = iDrawableArray3;
                    iDrawableArray3[0] = TecTechUITextures.PICTURE_GODFORGE_MILESTONE_CATALYST_GLOW;
                    break;
                }
                case 3: {
                    IDrawable[] iDrawableArray4 = new IDrawable[1];
                    iDrawableArray = iDrawableArray4;
                    iDrawableArray4[0] = TecTechUITextures.PICTURE_GODFORGE_MILESTONE_COMPOSITION_GLOW;
                    break;
                }
                default: {
                    IDrawable[] iDrawableArray5 = new IDrawable[1];
                    iDrawableArray = iDrawableArray5;
                    iDrawableArray5[0] = TecTechUITextures.PICTURE_GODFORGE_MILESTONE_CHARGE_GLOW;
                }
            }
            return iDrawableArray;
        }).addTooltip(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.milestoneinfo")).setPos(pos).setTooltipShowUpDelay(5);
    }

    protected ModularWindow createUpgradeTreeWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)300, (int)300);
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        ((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)((Scrollable)scrollable.widget(this.createUpgradeConnectorLine(new Pos2d(143, 71), 45, 0.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.START, ForgeOfGodsUpgrade.IGCC))).widget(this.createUpgradeConnectorLine(new Pos2d(124, 124), 60, 27.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.IGCC, ForgeOfGodsUpgrade.STEM))).widget(this.createUpgradeConnectorLine(new Pos2d(162, 124), 60, 333.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.IGCC, ForgeOfGodsUpgrade.CFCE))).widget(this.createUpgradeConnectorLine(new Pos2d(94, 184), 60, 27.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.STEM, ForgeOfGodsUpgrade.GISS))).widget(this.createUpgradeConnectorLine(new Pos2d(130, 184), 60, 336.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.STEM, ForgeOfGodsUpgrade.FDIM))).widget(this.createUpgradeConnectorLine(new Pos2d(156, 184), 60, 24.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.CFCE, ForgeOfGodsUpgrade.FDIM))).widget(this.createUpgradeConnectorLine(new Pos2d(192, 184), 60, 333.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.CFCE, ForgeOfGodsUpgrade.SA))).widget(this.createUpgradeConnectorLine(new Pos2d(143, 251), 45, 0.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.FDIM, ForgeOfGodsUpgrade.GPCI))).widget(this.createUpgradeConnectorLine(new Pos2d(143, 311), 45, 0.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.GPCI, ForgeOfGodsUpgrade.GEM))).widget(this.createUpgradeConnectorLine(new Pos2d(78, 250), 110, 5.0f, UpgradeColor.RED, ForgeOfGodsUpgrade.GISS, ForgeOfGodsUpgrade.REC))).widget(this.createUpgradeConnectorLine(new Pos2d(110, 290), 80, 40.0f, UpgradeColor.RED, ForgeOfGodsUpgrade.GPCI, ForgeOfGodsUpgrade.REC))).widget(this.createUpgradeConnectorLine(new Pos2d(208, 250), 110, 355.0f, UpgradeColor.RED, ForgeOfGodsUpgrade.SA, ForgeOfGodsUpgrade.CTCDD))).widget(this.createUpgradeConnectorLine(new Pos2d(176, 290), 80, 320.0f, UpgradeColor.RED, ForgeOfGodsUpgrade.GPCI, ForgeOfGodsUpgrade.CTCDD))).widget(this.createUpgradeConnectorLine(new Pos2d(100, 355), 80, 313.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.REC, ForgeOfGodsUpgrade.QGPIU))).widget(this.createUpgradeConnectorLine(new Pos2d(186, 355), 80, 47.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.CTCDD, ForgeOfGodsUpgrade.QGPIU))).widget(this.createUpgradeConnectorLine(new Pos2d(143, 430), 48, 0.0f, UpgradeColor.ORANGE, ForgeOfGodsUpgrade.QGPIU, ForgeOfGodsUpgrade.TCT))).widget(this.createUpgradeConnectorLine(new Pos2d(143, 490), 48, 0.0f, UpgradeColor.ORANGE, ForgeOfGodsUpgrade.TCT, ForgeOfGodsUpgrade.EPEC))).widget(this.createUpgradeConnectorLine(new Pos2d(143, 550), 48, 0.0f, UpgradeColor.ORANGE, ForgeOfGodsUpgrade.EPEC, ForgeOfGodsUpgrade.POS))).widget(this.createUpgradeConnectorLine(new Pos2d(143, 610), 48, 0.0f, UpgradeColor.ORANGE, ForgeOfGodsUpgrade.POS, ForgeOfGodsUpgrade.NGMS))).widget(this.createUpgradeConnectorLine(new Pos2d(110, 410), 80, 40.0f, UpgradeColor.PURPLE, ForgeOfGodsUpgrade.QGPIU, ForgeOfGodsUpgrade.SEFCP))).widget(this.createUpgradeConnectorLine(new Pos2d(83, 490), 48, 0.0f, UpgradeColor.PURPLE, ForgeOfGodsUpgrade.SEFCP, ForgeOfGodsUpgrade.CNTI))).widget(this.createUpgradeConnectorLine(new Pos2d(83, 550), 48, 0.0f, UpgradeColor.PURPLE, ForgeOfGodsUpgrade.CNTI, ForgeOfGodsUpgrade.NDPE))).widget(this.createUpgradeConnectorLine(new Pos2d(101, 590), 80, 320.0f, UpgradeColor.PURPLE, ForgeOfGodsUpgrade.NDPE, ForgeOfGodsUpgrade.NGMS))).widget(this.createUpgradeConnectorLine(new Pos2d(53, 536), 35, 45.0f, UpgradeColor.PURPLE, ForgeOfGodsUpgrade.CNTI, ForgeOfGodsUpgrade.DOP))).widget(this.createUpgradeConnectorLine(new Pos2d(176, 410), 80, 320.0f, UpgradeColor.GREEN, ForgeOfGodsUpgrade.QGPIU, ForgeOfGodsUpgrade.GGEBE))).widget(this.createUpgradeConnectorLine(new Pos2d(203, 490), 48, 0.0f, UpgradeColor.GREEN, ForgeOfGodsUpgrade.GGEBE, ForgeOfGodsUpgrade.IMKG))).widget(this.createUpgradeConnectorLine(new Pos2d(203, 550), 48, 0.0f, UpgradeColor.GREEN, ForgeOfGodsUpgrade.IMKG, ForgeOfGodsUpgrade.DOR))).widget(this.createUpgradeConnectorLine(new Pos2d(185, 590), 80, 40.0f, UpgradeColor.GREEN, ForgeOfGodsUpgrade.DOR, ForgeOfGodsUpgrade.NGMS))).widget(this.createUpgradeConnectorLine(new Pos2d(233, 476), 35, 315.0f, UpgradeColor.GREEN, ForgeOfGodsUpgrade.GGEBE, ForgeOfGodsUpgrade.TPTP))).widget(this.createUpgradeConnectorLine(new Pos2d(143, 670), 48, 0.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.NGMS, ForgeOfGodsUpgrade.SEDS))).widget(this.createUpgradeConnectorLine(new Pos2d(101, 707), 75, 62.3f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.SEDS, ForgeOfGodsUpgrade.PA))).widget(this.createUpgradeConnectorLine(new Pos2d(53, 772), 78, 0.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.PA, ForgeOfGodsUpgrade.CD))).widget(this.createUpgradeConnectorLine(new Pos2d(95, 837), 75, 297.7f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.CD, ForgeOfGodsUpgrade.TSE))).widget(this.createUpgradeConnectorLine(new Pos2d(191, 837), 75, 62.3f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.TSE, ForgeOfGodsUpgrade.TBF))).widget(this.createUpgradeConnectorLine(new Pos2d(233, 772), 78, 0.0f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.TBF, ForgeOfGodsUpgrade.EE))).widget(this.createUpgradeConnectorLine(new Pos2d(191, 747), 75, 62.3f, UpgradeColor.BLUE, ForgeOfGodsUpgrade.EE, ForgeOfGodsUpgrade.END));
        for (ForgeOfGodsUpgrade upgrade : this.upgrades.getAllUpgrades()) {
            scrollable.widget(this.createUpgradeBox(upgrade, (IWidgetBuilder<?>)scrollable));
        }
        ((Scrollable)scrollable.widget(new MultiChildWidget().addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            this.secretUpgrade = !this.secretUpgrade;
        }).setSize(40, 15).setBackground(() -> {
            if (this.secretUpgrade) {
                return new IDrawable[]{TecTechUITextures.BUTTON_SPACE_PRESSED_32x16};
            }
            return new IDrawable[0];
        }).addTooltip(StatCollector.func_74838_a((String)"fog.upgrade.tt.secret")).setTooltipShowUpDelay(20)).addChild(new TextWidget(StatCollector.func_74838_a((String)"fog.upgrade.tt.short.secret")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setSize(34, 9).setPos(3, 4).setEnabled(widget -> this.secretUpgrade)).addChild(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.PICTURE_UPGRADE_CONNECTOR_BLUE_OPAQUE).setEnabled(widget -> this.secretUpgrade).setPos(40, 4).setSize(20, 6)).setPos(new Pos2d(66, 56)))).widget(new TextWidget("").setPos(0, 945));
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)TecTechUITextures.BACKGROUND_STAR).setPos(0, 0).setSize(300, 300))).widget(scrollable.setSize(292, 292).setPos(4, 4))).widget(ButtonWidget.closeWindowButton((boolean)true).setOnClick((data, widget) -> {
            if (!widget.isClient()) {
                widget.getWindow().closeWindow();
                ForgeOfGodsUI.closeWindow(widget, 11);
            }
        }).setPos(282, 4));
        if (ConfigHandler.debug.DEBUG_MODE) {
            builder.widget(new MultiChildWidget().addChild(new ButtonWidget().setOnClick((clickData, widget) -> this.upgrades.resetAll()).setSize(40, 15).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).addTooltip(StatCollector.func_74838_a((String)"fog.debug.resetbutton.tooltip")).setTooltipShowUpDelay(5)).addChild(new TextWidget(StatCollector.func_74838_a((String)"fog.debug.resetbutton.text")).setTextAlignment(Alignment.Center).setScale(0.57f).setMaxWidth(36).setPos(3, 3)).addChild(new NumericWidget().setSetter(val -> {
                this.gravitonShardsAvailable = (int)val;
            }).setGetter(() -> this.gravitonShardsAvailable).setBounds(0.0, 112.0).setDefaultValue(0.0).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(25, 18).setPos(4, 16).addTooltip(StatCollector.func_74838_a((String)"fog.debug.gravitonshardsetter.tooltip")).setTooltipShowUpDelay(5).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD})).addChild(new ButtonWidget().setOnClick((clickData, widget) -> this.upgrades.unlockAll()).setSize(40, 15).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).addTooltip(StatCollector.func_74838_a((String)"fog.debug.unlockall.text")).setTooltipShowUpDelay(5).setPos(0, 35)).addChild(new TextWidget(StatCollector.func_74838_a((String)"fog.debug.unlockall.text")).setTextAlignment(Alignment.Center).setScale(0.57f).setMaxWidth(36).setPos(3, 38)).setPos(4, 4));
        }
        return builder.build();
    }

    protected ModularWindow createIndividualUpgradeWindow(EntityPlayer player) {
        ForgeOfGodsUpgrade upgrade = this.currentUpgradeWindow;
        ModularWindow.Builder builder = ModularWindow.builder((Size)upgrade.getWindowSize());
        builder.setBackground(new IDrawable[]{upgrade.getBackground()});
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.gravitonShardsAvailable, val -> {
            this.gravitonShardsAvailable = val;
        }));
        builder.widget(this.upgrades.getSyncer(upgrade));
        builder.widget(ForgeOfGodsUI.getIndividualUpgradeGroup(upgrade, () -> this.gravitonShardsAvailable, () -> this.completeUpgrade(upgrade), () -> this.respecUpgrade(upgrade), () -> this.isUpgradeActive(upgrade)));
        if (upgrade.hasExtraCost()) {
            builder.widget(ForgeOfGodsUI.createMaterialInputButton(upgrade, () -> this.upgrades.isCostPaid(upgrade), (clickData, widget) -> {
                ForgeOfGodsUI.reopenWindow(widget, 15);
                ForgeOfGodsUI.closeWindow(widget, 11);
                ForgeOfGodsUI.closeWindow(widget, 10);
            }));
        }
        return builder.build();
    }

    private void completeUpgrade(ForgeOfGodsUpgrade upgrade) {
        if (this.isUpgradeActive(upgrade)) {
            return;
        }
        if (!this.upgrades.checkPrerequisites(upgrade)) {
            return;
        }
        if (!this.upgrades.checkSplit(upgrade, this.ringAmount)) {
            return;
        }
        if (!this.upgrades.checkCost(upgrade, this.gravitonShardsAvailable)) {
            return;
        }
        this.upgrades.unlockUpgrade(upgrade);
        this.gravitonShardsAvailable -= upgrade.getShardCost();
        this.gravitonShardsSpent += upgrade.getShardCost();
    }

    private void respecUpgrade(ForgeOfGodsUpgrade upgrade) {
        if (!this.isUpgradeActive(upgrade)) {
            return;
        }
        if (!this.upgrades.checkDependents(upgrade)) {
            return;
        }
        this.upgrades.respecUpgrade(upgrade);
        this.gravitonShardsAvailable += upgrade.getShardCost();
        this.gravitonShardsSpent -= upgrade.getShardCost();
        if (upgrade == ForgeOfGodsUpgrade.END) {
            this.gravitonShardEjection = false;
        }
    }

    private Widget createUpgradeBox(ForgeOfGodsUpgrade upgrade, IWidgetBuilder<?> builder) {
        return new MultiChildWidget().addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            this.currentUpgradeWindow = upgrade;
            if (clickData.mouseButton == 0) {
                if (clickData.shift) {
                    if (!upgrade.hasExtraCost() || this.upgrades.isCostPaid(upgrade)) {
                        this.completeUpgrade(upgrade);
                    } else {
                        ForgeOfGodsUI.reopenWindow(widget, 15);
                        ForgeOfGodsUI.closeWindow(widget, 11);
                        ForgeOfGodsUI.closeWindow(widget, 10);
                    }
                } else {
                    ForgeOfGodsUI.reopenWindow(widget, 11);
                }
            } else if (clickData.mouseButton == 1) {
                this.respecUpgrade(upgrade);
            }
        }).setSize(40, 15).setBackground(() -> {
            if (this.isUpgradeActive(upgrade)) {
                return new IDrawable[]{TecTechUITextures.BUTTON_SPACE_PRESSED_32x16};
            }
            return new IDrawable[]{TecTechUITextures.BUTTON_SPACE_32x16};
        }).addTooltip(upgrade.getNameText()).setTooltipShowUpDelay(5)).addChild(new TextWidget(upgrade.getShortNameText()).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setSize(34, 9).setPos(3, 4)).setPos(upgrade.getTreePos()).attachSyncer(this.upgrades.getSyncer(upgrade), builder);
    }

    private Widget createUpgradeConnectorLine(Pos2d pos, int length, float rotationAngle, UpgradeColor color, ForgeOfGodsUpgrade startUpgrade, ForgeOfGodsUpgrade endUpgrade) {
        return new DrawableWidget().setDrawable(() -> {
            UITexture texture = color.getConnector();
            if (this.isUpgradeActive(startUpgrade) && this.isUpgradeActive(endUpgrade)) {
                texture = color.getOpaqueConnector();
            }
            return texture.withRotationDegree(rotationAngle);
        }).setPos(pos).setSize(6, length);
    }

    protected ModularWindow createManualInsertionWindow(EntityPlayer player) {
        ForgeOfGodsUpgrade upgrade = this.currentUpgradeWindow;
        ItemStack[] inputs = upgrade.getExtraCost();
        int WIDTH = 189;
        int HEIGHT = 106;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        for (int i = 0; i < 16; ++i) {
            this.inputSlotHandler.insertItem(i, this.storedUpgradeWindowItems[i], false);
            this.storedUpgradeWindowItems[i] = null;
        }
        ModularWindow.Builder builder = ModularWindow.builder((int)189, (int)106);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.TopRight.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(189, 106))).subtract(5, 0).add(0, 4));
        builder.widget(this.upgrades.getSyncer(upgrade));
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inputSlotHandler, (int)4).startFromSlot(0).endAtSlot(15).phantom(false).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(112, 6));
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getWindow().closeWindow();
                ForgeOfGodsUI.reopenWindow(widget, 10);
                ForgeOfGodsUI.reopenWindow(widget, 11);
            }
        }).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, new Text("x")}).setPos(179, 0).setSize(10, 10));
        builder.widget(new MultiChildWidget().addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                this.upgrades.payCost(upgrade, this.inputSlotHandler);
                ForgeOfGodsUI.reopenWindow(widget, 15);
            }
        }).setPlayClickSound(true).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setSize(179, 18)).addChild(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.consumeUpgradeMats")).setTextAlignment(Alignment.Center).setScale(0.75f).setPos(0, 1).setSize(179, 18)).setPos(5, 82).setSize(179, 16));
        for (int i = 0; i < 12; ++i) {
            int ii = i;
            ItemStack stack = null;
            if (i < inputs.length) {
                stack = inputs[i];
            }
            Widget costWidget = ForgeOfGodsUI.createExtraCostWidget(stack, () -> this.upgrades.getPaidCosts(upgrade)[ii]);
            costWidget.setPos(5 + 36 * (i / 4), 6 + 18 * (i % 4));
            builder.widget(costWidget);
        }
        return builder.build();
    }

    protected ModularWindow createGeneralInfoWindow(EntityPlayer player) {
        return ForgeOfGodsUI.createGeneralInfoWindow(() -> this.inversion, val -> {
            this.inversion = val;
        });
    }

    protected ModularWindow createSpecialThanksWindow(EntityPlayer player) {
        return ForgeOfGodsUI.createSpecialThanksWindow();
    }

    protected ModularWindow createStarCosmeticsWindow(EntityPlayer player) {
        int WIDTH = 200;
        int HEIGHT = 200;
        ModularWindow.Builder builder = ModularWindow.builder((int)200, (int)200);
        builder.setBackground(new IDrawable[]{TecTechUITextures.BACKGROUND_GLOW_WHITE});
        builder.setDraggable(true);
        builder.widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.selectedStarColor, val -> {
            this.selectedStarColor = val;
        }));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.editingStarIndex, val -> {
            this.editingStarIndex = val;
        }));
        builder.widget(this.starColors.getSyncer());
        ((ModularWindow.Builder)builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(184, 4))).widget(new TextWidget(StatCollector.func_74838_a((String)"fog.cosmetics.header")).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setScale(1.0f).setPos(0, 5).setSize(200, 15));
        builder.widget(new TextWidget(EnumChatFormatting.UNDERLINE + StatCollector.func_74838_a((String)"fog.cosmetics.color")).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setPos(9, 25).setSize(60, 10));
        for (int i = 0; i < 7; ++i) {
            MultiChildWidget widget2 = this.createColorGroup(i);
            widget2.setPos(8, 45 + i * 20);
            builder.widget((Widget)widget2);
        }
        MultiChildWidget newPreset = new MultiChildWidget();
        Function<Widget, Boolean> newPresetEnabled = $ -> !this.starColors.isFull();
        newPreset.setSize(18, 80);
        newPreset.setPosProvider(($, $$, $$$) -> new Pos2d(8, 45 + this.starColors.size() * 20));
        newPreset.setEnabled(newPresetEnabled);
        newPreset.addChild(new ButtonWidget().setOnClick((data, widget) -> {
            if (!widget.isClient()) {
                this.editingStarIndex = -1;
                this.openCustomStarColorWindowFresh((Widget)widget, null);
            }
        }).setPlayClickSound(true).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).addTooltip(StatCollector.func_74838_a((String)"fog.cosmetics.starcolor")).setSize(16, 16).setPos(0, 0).setEnabled(newPresetEnabled));
        newPreset.addChild(new TextWidget("+").setDefaultColor(EnumChatFormatting.DARK_GRAY).setTextAlignment(Alignment.Center).setSize(16, 16).setPos(0, 0).setEnabled(newPresetEnabled));
        newPreset.addChild(new TextWidget(StatCollector.func_74838_a((String)"fog.cosmetics.customstarcolor")).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setSize(60, 18).setPos(20, 0).setEnabled(newPresetEnabled));
        builder.widget((Widget)newPreset);
        builder.widget(new TextWidget(EnumChatFormatting.UNDERLINE + StatCollector.func_74838_a((String)"fog.cosmetics.misc")).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setPos(120, 25).setSize(80, 10));
        builder.widget(TextWidget.localised((String)"fog.cosmetics.spin", (Object[])new Object[0]).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setPos(120, 45).setSize(60, 18));
        NumericWidget rotationWidget = new NumericWidget();
        rotationWidget.setGetter(() -> this.rotationSpeed).setSetter(val -> {
            if (this.rotationSpeed != (int)val) {
                this.rotationSpeed = (int)val;
                if (!rotationWidget.isClient()) {
                    this.updateRenderer();
                }
            }
        }).setBounds(0.0, 100.0).setDefaultValue(5.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(35, 18).setPos(155, 45).addTooltip(StatCollector.func_74838_a((String)"fog.cosmetics.onlyintegers")).setTooltipShowUpDelay(5).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD});
        builder.widget((Widget)rotationWidget);
        builder.widget(TextWidget.localised((String)"fog.cosmetics.size", (Object[])new Object[0]).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.CenterLeft).setPos(120, 65).setSize(60, 18));
        NumericWidget spinWidget = new NumericWidget();
        spinWidget.setGetter(() -> this.starSize).setSetter(val -> {
            if (this.starSize != (int)val) {
                this.starSize = (int)val;
                if (!spinWidget.isClient()) {
                    this.updateRenderer();
                }
            }
        }).setBounds(1.0, 40.0).setDefaultValue(20.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(35, 18).setPos(155, 65).addTooltip(StatCollector.func_74838_a((String)"fog.cosmetics.onlyintegers")).setTooltipShowUpDelay(5).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD});
        builder.widget((Widget)spinWidget);
        return builder.build();
    }

    private MultiChildWidget createColorGroup(int index) {
        int textWidth = 60;
        MultiChildWidget parent = new MultiChildWidget();
        parent.setSize(18, 80);
        Function<Widget, Boolean> enabledCheck = $ -> index < this.starColors.size();
        parent.addChild(new ButtonWidget().setOnClick((data, widget) -> {
            if (!widget.isClient() && index < this.starColors.size()) {
                ForgeOfGodsStarColor color = this.starColors.getByIndex(index);
                if (data.shift && !color.isPresetColor()) {
                    this.editingStarIndex = index;
                    this.openCustomStarColorWindowFresh((Widget)widget, color);
                } else {
                    this.selectedStarColor = color.getName();
                    this.updateRenderer();
                }
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ForgeOfGodsStarColor color;
            UITexture bg = GTUITextures.BUTTON_STANDARD;
            if (index < this.starColors.size() && (color = this.starColors.getByIndex(index)).getName().equals(this.selectedStarColor)) {
                bg = GTUITextures.BUTTON_STANDARD_PRESSED;
            }
            return new IDrawable[]{bg};
        }).addTooltips((List)ImmutableList.of((Object)StatCollector.func_74838_a((String)"fog.cosmetics.selectcolor.tooltip.1"), (Object)StatCollector.func_74838_a((String)"fog.cosmetics.selectcolor.tooltip.2"))).setSize(16, 16).setPos(0, 0).setEnabled(enabledCheck));
        parent.addChild(new DrawableWidget().setDrawable(() -> {
            if (index < this.starColors.size()) {
                return this.starColors.getByIndex(index).getDrawable();
            }
            return IDrawable.EMPTY;
        }).setPos(1, 1).setSize(14, 14).setEnabled(enabledCheck));
        parent.addChild(new DynamicTextWidget(() -> {
            if (index < this.starColors.size()) {
                ForgeOfGodsStarColor color = this.starColors.getByIndex(index);
                return new Text(color.getName());
            }
            return Text.EMPTY;
        }).setDefaultColor(-22016).setTextAlignment(Alignment.CenterLeft).setSize(60, 18).setPos(20, 0).setEnabled(enabledCheck));
        return parent;
    }

    protected ModularWindow createStarCustomColorWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)200, (int)200);
        builder.setBackground(new IDrawable[]{TecTechUITextures.BACKGROUND_GLOW_WHITE});
        builder.setDraggable(true);
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.starColorR, val -> {
            this.starColorR = val;
        }));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.starColorG, val -> {
            this.starColorG = val;
        }));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.starColorB, val -> {
            this.starColorB = val;
        }));
        builder.widget((Widget)new FakeSyncWidget.FloatSyncer(() -> Float.valueOf(this.starGamma), val -> {
            this.starGamma = val.floatValue();
        }));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.editingColorIndex, val -> {
            this.editingColorIndex = val;
        }));
        builder.widget((Widget)new FakeSyncWidget(() -> this.newStarColor, val -> {
            this.newStarColor = val;
        }, ForgeOfGodsStarColor::writeToBuffer, ForgeOfGodsStarColor::readFromBuffer));
        ((ModularWindow.Builder)builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(184, 4))).widget(TextWidget.localised((String)"fog.cosmetics.starcolor", (Object[])new Object[0]).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setScale(1.0f).setPos(0, 5).setSize(200, 15));
        Widget redField = ForgeOfGodsUI.createStarColorRGBMGroup(ForgeOfGodsUI.StarColorRGBM.RED, val -> {
            this.starColorR = (int)val;
        }, () -> this.starColorR);
        builder.widget(redField.setPos(8, 21));
        Widget greenField = ForgeOfGodsUI.createStarColorRGBMGroup(ForgeOfGodsUI.StarColorRGBM.GREEN, val -> {
            this.starColorG = (int)val;
        }, () -> this.starColorG);
        builder.widget(greenField.setPos(8, 40));
        Widget blueField = ForgeOfGodsUI.createStarColorRGBMGroup(ForgeOfGodsUI.StarColorRGBM.BLUE, val -> {
            this.starColorB = (int)val;
        }, () -> this.starColorB);
        builder.widget(blueField.setPos(8, 59));
        Widget gammaField = ForgeOfGodsUI.createStarColorRGBMGroup(ForgeOfGodsUI.StarColorRGBM.GAMMA, val -> {
            this.starGamma = (float)val;
        }, () -> this.starGamma);
        builder.widget(gammaField.setPos(8, 78));
        Widget colorPreviewBox = new DrawableWidget().setDrawable(() -> new Rectangle().setColor(Color.rgb((int)this.starColorR, (int)this.starColorG, (int)this.starColorB))).setSize(168, 15).setPos(16, 99);
        builder.widget(colorPreviewBox);
        Widget colorApplyButton = ForgeOfGodsUI.createStarColorButton(() -> {
            if (this.editingColorIndex >= 0) {
                return "fog.cosmetics.applycolor";
            }
            return "fog.cosmetics.addcolor";
        }, () -> {
            if (this.editingColorIndex >= 0) {
                return "fog.cosmetics.applycolor.tooltip";
            }
            return "fog.cosmetics.addcolor.tooltip";
        }, (clickData, widget) -> {
            if (!widget.isClient()) {
                StarColorSetting color = new StarColorSetting(this.starColorR, this.starColorG, this.starColorB, this.starGamma);
                if (this.editingColorIndex >= 0 && this.editingColorIndex < this.newStarColor.numColors()) {
                    this.newStarColor.setColor(this.editingColorIndex, color);
                } else {
                    this.newStarColor.addColor(color);
                }
                ForgeOfGodsUI.reopenWindow(widget, 19);
            }
        });
        builder.widget(colorApplyButton.setPos(63, 118));
        Widget colorResetButton = ForgeOfGodsUI.createStarColorButton("fog.cosmetics.resetcolor", "fog.cosmetics.resetcolor.tooltip", (clickData, widget) -> {
            if (!widget.isClient()) {
                this.starColorR = 179;
                this.starColorG = 204;
                this.starColorB = 255;
                this.starGamma = 3.0f;
            }
        });
        builder.widget(colorResetButton.setPos(102, 118));
        for (int i = 0; i < 9; ++i) {
            int ii = i;
            MultiChildWidget colorListEntry = new MultiChildWidget();
            colorListEntry.setSize(18, 18);
            colorListEntry.setPos(8 + i * 18, 136);
            colorListEntry.addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
                if (widget.isClient()) {
                    return;
                }
                if (clickData.mouseButton == 0) {
                    if (this.editingColorIndex == ii) {
                        this.editingColorIndex = -1;
                        return;
                    }
                    if (ii < this.newStarColor.numColors()) {
                        this.editingColorIndex = ii;
                        StarColorSetting color = this.newStarColor.getColor(ii);
                        this.starColorR = color.getColorR();
                        this.starColorG = color.getColorG();
                        this.starColorB = color.getColorB();
                        this.starGamma = color.getGamma();
                    }
                } else if (clickData.mouseButton == 1 && ii < this.newStarColor.numColors()) {
                    this.newStarColor.removeColor(ii);
                    if (this.editingColorIndex == ii) {
                        this.editingColorIndex = -1;
                    } else if (this.editingColorIndex > ii) {
                        --this.editingColorIndex;
                    }
                    ForgeOfGodsUI.reopenWindow(widget, 19);
                }
            }).setPlayClickSound(false).setBackground(() -> {
                if (this.editingColorIndex == ii) {
                    return new IDrawable[]{TecTechUITextures.UNSELECTED_OPTION, TecTechUITextures.SLOT_OUTLINE_GREEN};
                }
                return new IDrawable[]{TecTechUITextures.UNSELECTED_OPTION};
            }).dynamicTooltip(() -> {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add(StatCollector.func_74838_a((String)"fog.cosmetics.colorlist.tooltip.1"));
                ret.add(StatCollector.func_74838_a((String)"fog.cosmetics.colorlist.tooltip.2"));
                if (ii < this.newStarColor.numColors()) {
                    ret.add("");
                    StarColorSetting color = this.newStarColor.getColor(ii);
                    ret.add(ForgeOfGodsUI.StarColorRGBM.RED.tooltip(color.getColorR()));
                    ret.add(ForgeOfGodsUI.StarColorRGBM.GREEN.tooltip(color.getColorG()));
                    ret.add(ForgeOfGodsUI.StarColorRGBM.BLUE.tooltip(color.getColorB()));
                    ret.add(ForgeOfGodsUI.StarColorRGBM.GAMMA.tooltip(color.getGamma()));
                }
                return ret;
            }).setUpdateTooltipEveryTick(true).setTooltipShowUpDelay(5).setSize(18, 18).setPos(0, 0));
            colorListEntry.addChild(new DrawableWidget().setDrawable(() -> {
                if (ii < this.newStarColor.numColors()) {
                    StarColorSetting color = this.newStarColor.getColor(ii);
                    return new Rectangle().setColor(Color.rgb((int)color.getColorR(), (int)color.getColorG(), (int)color.getColorB()));
                }
                return IDrawable.EMPTY;
            }).setSize(16, 16).setPos(1, 1));
            builder.widget((Widget)colorListEntry);
        }
        Widget cycleRateField = new NumericWidget().setSetter(val -> this.newStarColor.setCycleSpeed((int)val)).setGetter(() -> this.newStarColor.getCycleSpeed()).setBounds(1.0, 100.0).setDefaultValue(1.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).addTooltip(StatCollector.func_74838_a((String)"fog.cosmetics.cyclespeed")).setTooltipShowUpDelay(5).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(21, 16).setPos(171, 137);
        builder.widget(cycleRateField);
        Widget nameEntryField = new TextFieldWidget().setSetter(val -> this.newStarColor.setName((String)val)).setGetter(() -> this.newStarColor.getName()).setMaxLength(15).setTextAlignment(Alignment.CenterLeft).setTextColor(-22016).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).addTooltips((List)ImmutableList.of((Object)StatCollector.func_74838_a((String)"fog.cosmetics.starcolorname.tooltip.1"), (Object)StatCollector.func_74838_a((String)"fog.cosmetics.starcolorname.tooltip.2"))).setTooltipShowUpDelay(5).setPos(101, 158).setSize(91, 16);
        builder.widget(nameEntryField);
        Widget nameLabel = TextWidget.localised((String)"fog.cosmetics.starcolorname", (Object[])new Object[0]).setTextAlignment(Alignment.CenterLeft).setDefaultColor(EnumChatFormatting.GOLD).setPos(8, 158).setSize(100, 16);
        builder.widget(nameLabel);
        Widget savePresetButton = ForgeOfGodsUI.createStarColorButton("fog.cosmetics.savecolors", "fog.cosmetics.savecolors.tooltip", (clickData, widget) -> {
            if (!widget.isClient()) {
                if (this.newStarColor.numColors() == 0) {
                    return;
                }
                if (this.editingStarIndex >= 0) {
                    this.starColors.insert(this.newStarColor, this.editingStarIndex);
                    this.selectedStarColor = this.newStarColor.getName();
                    this.updateRenderer();
                } else {
                    this.starColors.store(this.newStarColor);
                }
                widget.getWindow().closeWindow();
                ForgeOfGodsUI.reopenWindow(widget, 18);
            }
        });
        builder.widget(savePresetButton.setPos(138, 177));
        Widget deletePresetButton = ForgeOfGodsUI.createStarColorButton("fog.cosmetics.deletecolors", "fog.cosmetics.deletecolors.tooltip", (clickData, widget) -> {
            if (!widget.isClient()) {
                this.starColors.drop(this.newStarColor);
                if (this.selectedStarColor.equals(this.newStarColor.getName())) {
                    this.selectedStarColor = ForgeOfGodsStarColor.DEFAULT.getName();
                    this.updateRenderer();
                }
                widget.getWindow().closeWindow();
                ForgeOfGodsUI.reopenWindow(widget, 18);
            }
        });
        builder.widget(deletePresetButton.setPos(101, 177));
        Widget importPresetButton = ForgeOfGodsUI.createStarColorButton("fog.cosmetics.importcolors", "fog.cosmetics.importcolors.tooltip", (clickData, widget) -> {
            if (!widget.isClient()) {
                this.importedStarColor = null;
                widget.getContext().openSyncedWindow(20);
            }
        });
        builder.widget(importPresetButton.setPos(64, 177));
        Widget exportPresetButton = ForgeOfGodsUI.createStarColorButton("fog.cosmetics.exportcolors", "fog.cosmetics.exportcolors.tooltip", (clickData, widget) -> {
            if (widget.isClient()) {
                if (this.newStarColor.numColors() == 0) {
                    return;
                }
                if (Desktop.isDesktopSupported()) {
                    String output = this.newStarColor.serializeToString();
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(output), null);
                }
            }
        });
        builder.widget(exportPresetButton.setPos(27, 177));
        return builder.build();
    }

    protected ModularWindow createStarColorImportWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)200, (int)100);
        builder.setBackground(new IDrawable[]{TecTechUITextures.BACKGROUND_GLOW_WHITE_HALF});
        builder.setDraggable(true);
        builder.widget((Widget)new FakeSyncWidget(() -> this.importedStarColor, val -> {
            this.importedStarColor = val;
        }, ForgeOfGodsStarColor::writeToBuffer, ForgeOfGodsStarColor::readFromBuffer));
        ((ModularWindow.Builder)builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(184, 4))).widget(TextWidget.localised((String)"fog.cosmetics.importer.import", (Object[])new Object[0]).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setScale(1.0f).setPos(0, 5).setSize(200, 15));
        TextFieldWidget textField = new TextFieldWidget();
        textField.setSynced(false, true).setSetter(val -> {
            if (!textField.isClient()) {
                if (val == null || val.isEmpty()) {
                    this.importedStarColor = null;
                    return;
                }
                this.importedStarColor = ForgeOfGodsStarColor.deserialize(val);
            }
        }).setMaxLength(Short.MAX_VALUE).setScrollBar().setTextAlignment(Alignment.CenterLeft).setTextColor(Color.WHITE.normal).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(184, 18).setPos(8, 20);
        builder.widget((Widget)textField);
        for (int i = 0; i < 9; ++i) {
            int ii = i;
            Widget colorEntry = new DrawableWidget().setDrawable(() -> {
                if (this.importedStarColor != null && ii < this.importedStarColor.numColors()) {
                    StarColorSetting color = this.importedStarColor.getColor(ii);
                    return new Rectangle().setColor(Color.rgb((int)color.getColorR(), (int)color.getColorG(), (int)color.getColorB())).withOffset(1.0f, 1.0f, -2.0f, -2.0f);
                }
                return IDrawable.EMPTY;
            }).setBackground(new IDrawable[]{TecTechUITextures.UNSELECTED_OPTION}).dynamicTooltip(() -> {
                if (this.importedStarColor != null && ii < this.importedStarColor.numColors()) {
                    StarColorSetting color = this.importedStarColor.getColor(ii);
                    ArrayList<String> ret = new ArrayList<String>();
                    ret.add(ForgeOfGodsUI.StarColorRGBM.RED.tooltip(color.getColorR()));
                    ret.add(ForgeOfGodsUI.StarColorRGBM.GREEN.tooltip(color.getColorG()));
                    ret.add(ForgeOfGodsUI.StarColorRGBM.BLUE.tooltip(color.getColorB()));
                    ret.add(ForgeOfGodsUI.StarColorRGBM.GAMMA.tooltip(color.getGamma()));
                    return ret;
                }
                return Collections.emptyList();
            }).setSize(18, 18).setPos(8 + i * 18, 42);
            builder.widget(colorEntry);
        }
        Widget cycleRateText = new DynamicTextWidget(() -> {
            if (this.importedStarColor != null) {
                return new Text(Integer.toString(this.importedStarColor.getCycleSpeed()));
            }
            return Text.EMPTY;
        }).setTextAlignment(Alignment.Center).setDefaultColor(Color.WHITE.normal).addTooltip(StatCollector.func_74838_a((String)"fog.cosmetics.cyclespeed")).setTooltipShowUpDelay(5).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(21, 16).setPos(171, 43);
        builder.widget(cycleRateText);
        Widget validatorText = new DynamicTextWidget(() -> {
            if (this.importedStarColor == null) {
                return new Text(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"fog.cosmetics.importer.error"));
            }
            return new Text(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"fog.cosmetics.importer.valid"));
        }).setTextAlignment(Alignment.Center).setPos(0, 62).setSize(200, 16);
        builder.widget(validatorText);
        Widget confirmImportButton = ForgeOfGodsUI.createStarColorButton("fog.cosmetics.importer.apply", "fog.cosmetics.importer.apply.tooltip", (clickData, widget) -> {
            if (!widget.isClient() && this.importedStarColor != null) {
                widget.getWindow().closeWindow();
                this.openCustomStarColorWindowFresh((Widget)widget, this.importedStarColor);
            }
        });
        builder.widget(confirmImportButton.setPos(101, 77));
        Widget resetImportButton = ForgeOfGodsUI.createStarColorButton("fog.cosmetics.importer.reset", "fog.cosmetics.importer.reset.tooltip", (clickData, widget) -> {
            if (!widget.isClient()) {
                this.importedStarColor = null;
            }
        });
        builder.widget(resetImportButton.setPos(64, 77));
        return builder.build();
    }

    private void openCustomStarColorWindowFresh(Widget widget, @Nullable ForgeOfGodsStarColor importedColor) {
        if (!widget.isClient()) {
            if (importedColor == null) {
                importedColor = this.starColors.newTemplateColor();
            }
            this.newStarColor = importedColor;
            this.editingColorIndex = -1;
            this.starColorR = 179;
            this.starColorG = 204;
            this.starColorB = 255;
            this.starGamma = 3.0f;
            ForgeOfGodsUI.reopenWindow(widget, 19);
        }
    }

    protected ModularWindow createStatisticsWindow(EntityPlayer player) {
        int i;
        int WIDTH = 300;
        int HEIGHT = 300;
        ModularWindow.Builder builder = ModularWindow.builder((int)300, (int)300);
        builder.setBackground(new IDrawable[]{TecTechUITextures.BACKGROUND_GLOW_WHITE});
        builder.setDraggable(true);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.modulestats")).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setScale(1.0f).setPos(0, 8).setSize(300, 15))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.heat")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(12, 56).setSize(69, 30).addTooltip(StatCollector.func_74838_a((String)"fog.text.tooltip.heat")).setTooltipShowUpDelay(5))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.effectiveheat")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(12, 86).setSize(69, 30).addTooltip(StatCollector.func_74838_a((String)"fog.text.tooltip.effectiveheat")).setTooltipShowUpDelay(5))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.parallel")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(12, 116).setSize(69, 30).addTooltip(StatCollector.func_74838_a((String)"fog.text.tooltip.parallel")).setTooltipShowUpDelay(5))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.speedbonus")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(12, 146).setSize(69, 30).addTooltip(StatCollector.func_74838_a((String)"fog.text.tooltip.speedbonus")).setTooltipShowUpDelay(5))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.energydiscount")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(12, 176).setSize(69, 30).addTooltip(StatCollector.func_74838_a((String)"fog.text.tooltip.energydiscount")).setTooltipShowUpDelay(5))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.ocdivisor")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(12, 206).setSize(69, 30).addTooltip(StatCollector.func_74838_a((String)"fog.text.tooltip.ocdivisor")).setTooltipShowUpDelay(5))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.powerforge")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(88, 40).setSize(40, 10))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.meltingcore")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(141, 40).setSize(40, 10))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.plasmafab")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(193, 40).setSize(44, 10))).widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.exoticizer")).setScale(0.8f).setDefaultColor(EnumChatFormatting.GOLD).setTextAlignment(Alignment.Center).setPos(246, 43).setSize(40, 10));
        for (i = 0; i < 4; ++i) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)new Rectangle().setColor(Color.rgb((int)190, (int)200, (int)0))).setSize(1, 197).setPos(81 + 53 * i, 38));
        }
        for (i = 0; i < 7; ++i) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)new Rectangle().setColor(Color.rgb((int)0, (int)170, (int)170))).setSize(276, 1).setPos(12, 55 + 30 * i));
        }
        MTESmeltingModule smelting = new MTESmeltingModule("smelting");
        MTEMoltenModule molten = new MTEMoltenModule("molten");
        MTEPlasmaModule plasma = new MTEPlasmaModule("plasma");
        MTEExoticModule exotic = new MTEExoticModule("exotic");
        builder.widget((Widget)new FakeSyncWidget.ByteSyncer(() -> (byte)this.formattingMode.ordinal(), val -> {
            this.formattingMode = MilestoneFormatter.VALUES[MathHelper.func_76125_a((int)val.byteValue(), (int)0, (int)(MilestoneFormatter.VALUES.length - 1))];
        }));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.fuelConsumptionFactor, val -> {
            this.fuelConsumptionFactor = val;
        }));
        builder.widget(this.upgrades.getFullSyncer());
        for (int i2 = 0; i2 < 24; ++i2) {
            String relevantInfo;
            MTEBaseModule module;
            switch (i2 % 4) {
                case 1: {
                    module = molten;
                    break;
                }
                case 2: {
                    module = plasma;
                    break;
                }
                case 3: {
                    module = exotic;
                    break;
                }
                default: {
                    module = smelting;
                }
            }
            int cleanDiv4 = i2 / 4;
            switch (cleanDiv4) {
                case 1: {
                    GodforgeMath.calculateMaxHeatForModules(module, this);
                    relevantInfo = String.valueOf(this.formattingMode.format(module.getHeatForOC()));
                    break;
                }
                case 2: {
                    GodforgeMath.calculateMaxParallelForModules(module, this);
                    relevantInfo = String.valueOf(this.formattingMode.format(module.getMaxParallel()));
                    break;
                }
                case 3: {
                    GodforgeMath.calculateSpeedBonusForModules(module, this);
                    relevantInfo = String.valueOf(GTUtility.formatNumbers(module.getSpeedBonus()));
                    break;
                }
                case 4: {
                    GodforgeMath.calculateEnergyDiscountForModules(module, this);
                    relevantInfo = String.valueOf(GTUtility.formatNumbers(module.getEnergyDiscount()));
                    break;
                }
                case 5: {
                    GodforgeMath.setMiscModuleParameters(module, this);
                    relevantInfo = String.valueOf(GTUtility.formatNumbers(module.getOverclockTimeFactor()));
                    break;
                }
                default: {
                    GodforgeMath.calculateMaxHeatForModules(module, this);
                    relevantInfo = String.valueOf(this.formattingMode.format(module.getHeat()));
                }
            }
            builder.widget(new MultiChildWidget().addChild(new ButtonWidget().setOnClick((clickData, widget) -> {}).setSize(53, 30)).addChild(new DynamicTextWidget(() -> new Text(relevantInfo)).setScale(1.0f).setDefaultColor(EnumChatFormatting.GREEN).setTextAlignment(Alignment.Center).setSize(53, 30)).setPos(81 + i2 % 4 * 53, 55 + i2 / 4 * 30));
        }
        ((ModularWindow.Builder)builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(284, 4))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            if (clickData.mouseButton == 0) {
                this.formattingMode = this.formattingMode.cycle();
                ForgeOfGodsUI.reopenWindow(widget, 21);
            }
        }).setSize(20, 20).addTooltip(StatCollector.func_74838_a((String)"fog.button.formatting.tooltip")).setBackground(new IDrawable[]{TecTechUITextures.OVERLAY_CYCLIC_BLUE}).setPos(8, 272).setTooltipShowUpDelay(5));
        return builder.build();
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Stellar Forge").addInfo(EnumChatFormatting.ITALIC + "Also known as Godforge or Gorge for short.").addSeparator(EnumChatFormatting.AQUA, 73).addInfo("A massive structure harnessing the thermal, gravitational and").addInfo("kinetic energy of a stabilised neutron star for material processing.").addInfo("This multiblock can house " + EnumChatFormatting.RED + "up to 16 modules " + EnumChatFormatting.GRAY + "which utilize the star to energize materials").addInfo("to varying degrees, ranging from regular smelting to matter degeneration.").addInfo("EU requirements for all modules are handled via wireless energy directly.").addSeparator(EnumChatFormatting.AQUA, 73).addInfo("This multiblock has an " + EnumChatFormatting.GOLD + "extensive upgrade tree " + EnumChatFormatting.GRAY + "which influences all of its functions,").addInfo("such as " + EnumChatFormatting.GOLD + "unlocking new module types" + EnumChatFormatting.GRAY + ", " + EnumChatFormatting.GOLD + "increasing heat levels " + EnumChatFormatting.GRAY + "and " + EnumChatFormatting.GOLD + "granting").addInfo(EnumChatFormatting.GOLD + "various processing speed bonuses" + EnumChatFormatting.GRAY + ". " + EnumChatFormatting.GRAY + "These upgrades can be unlocked by reaching").addInfo("certain milestones and/or spending materials.").addSeparator(EnumChatFormatting.AQUA, 73).addInfo(EnumChatFormatting.GREEN + "Clicking on the logo in the controller gui opens an extensive information window" + EnumChatFormatting.GRAY + ",").addInfo("explaining everything there is to know about this multiblock.").beginStructureBlock(127, 29, 186, false).addStructureInfo("Total blocks needed for the structure with " + MTEForgeOfGods.getRingText("1", "2", "3") + "rings:").addStructureInfo(MTEForgeOfGods.getRingText("3943", "7279", "11005") + "Transcendentally Amplified Magnetic Confinement Casing").addStructureInfo(MTEForgeOfGods.getRingText("2819", "4831", "6567") + "Singularity Reinforced Stellar Shielding Casing").addStructureInfo(MTEForgeOfGods.getRingText("272", "512", "824") + "Celestial Matter Guidance Casing").addStructureInfo(MTEForgeOfGods.getRingText("130", "144", "158") + "Boundless Gravitationally Severed Structure Casing").addStructureInfo(MTEForgeOfGods.getRingText("9", "54", "155") + "Spatially Transcendent Gravitational Lens Block").addStructureInfo(MTEForgeOfGods.getRingText("345", "357", "397") + MTEForgeOfGods.getRingText("Remote", "Medial", "Central") + "Graviton Flow Modulator").addStructureInfo(EnumChatFormatting.GOLD + "36" + EnumChatFormatting.GRAY + " Stellar Energy Siphon Casing").addStructureInfoSeparator().addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " Input Hatch").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " Output Bus (ME)").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " Input Bus").toolTipFinisher(EnumChatFormatting.AQUA, 73, new String[0]);
        return tt;
    }

    private static String getRingText(String oneRing, String twoRings, String threeRings) {
        return EnumChatFormatting.DARK_PURPLE + oneRing + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.DARK_GREEN + twoRings + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.AQUA + threeRings + EnumChatFormatting.GRAY + " ";
    }

    @Override
    public boolean energyFlowOnRunningTick(ItemStack aStack, boolean allowProduction) {
        return true;
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.hint.1")};
    }

    public int getFuelType() {
        return this.selectedFuelType;
    }

    private void setFuelType(int fuelType) {
        this.selectedFuelType = fuelType;
    }

    public int getFuelFactor() {
        return this.fuelConsumptionFactor;
    }

    public boolean isUpgradeActive(ForgeOfGodsUpgrade upgrade) {
        return this.upgrades.isUpgradeActive(upgrade);
    }

    public int getRingAmount() {
        return this.ringAmount;
    }

    public int getTotalActiveUpgrades() {
        return this.upgrades.getTotalActiveUpgrades();
    }

    private Text fuelUsage() {
        return new Text(this.fuelConsumption + " L/5s");
    }

    private Text storedFuel() {
        if (this.internalBattery == 0) {
            return new Text(this.stellarFuelAmount + "/" + this.neededStartupFuel);
        }
        return new Text(this.internalBattery + "/" + this.maxBatteryCharge);
    }

    private Text storedFuelHeaderText() {
        if (this.internalBattery == 0) {
            return new Text(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.storedstartupfuel"));
        }
        return new Text(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.storedfuel"));
    }

    private void checkInversionStatus() {
        int inversionChecker = 0;
        for (int progress : this.milestoneProgress) {
            if (progress < 7) break;
            ++inversionChecker;
        }
        this.inversion = inversionChecker == 4;
    }

    public boolean isInversionAvailable() {
        return this.inversion;
    }

    private Text inversionStatusText() {
        String inversionStatus = "";
        if (this.inversion) {
            inversionStatus = EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.inversionactive");
        }
        return new Text(inversionStatus);
    }

    private void determineCompositionMilestoneLevel() {
        int[] uniqueModuleCount = new int[5];
        int smelting = 0;
        int molten = 0;
        int plasma = 0;
        int exotic = 0;
        int exoticMagmatter = 0;
        for (MTEBaseModule module : this.moduleHatches) {
            if (module instanceof MTESmeltingModule) {
                uniqueModuleCount[0] = 1;
                ++smelting;
                continue;
            }
            if (module instanceof MTEMoltenModule) {
                uniqueModuleCount[1] = 1;
                ++molten;
                continue;
            }
            if (module instanceof MTEPlasmaModule) {
                uniqueModuleCount[2] = 1;
                ++plasma;
                continue;
            }
            if (!(module instanceof MTEExoticModule)) continue;
            if (!((MTEExoticModule)module).isMagmatterModeOn()) {
                uniqueModuleCount[3] = 1;
                ++exotic;
                continue;
            }
            uniqueModuleCount[4] = 1;
            ++exoticMagmatter;
        }
        this.totalExtensionsBuilt = Arrays.stream(uniqueModuleCount).sum() + this.ringAmount - 1;
        if (this.inversion) {
            this.totalExtensionsBuilt += (float)(smelting - 1 + (molten - 1) * 2 + (plasma - 1) * 3 + (exotic - 1) * 4 + (exoticMagmatter - 1) * 5) / 5.0f;
        }
        this.milestoneProgress[3] = (int)Math.floor(this.totalExtensionsBuilt);
    }

    private void determineMilestoneProgress() {
        float actualProgress;
        int closestRelevantSeven;
        float rawProgress;
        if (this.milestoneProgress[0] < 7) {
            this.powerMilestonePercentage = (float)Math.max(Math.log(this.totalPowerConsumed.divide(BigInteger.valueOf(POWER_MILESTONE_CONSTANT)).longValue()) / POWER_LOG_CONSTANT + 1.0, 0.0) / 7.0f;
            this.milestoneProgress[0] = (int)Math.floor(this.powerMilestonePercentage * 7.0f);
        }
        if (this.inversion) {
            rawProgress = (this.totalPowerConsumed.divide(POWER_MILESTONE_T7_CONSTANT).floatValue() - 1.0f) / 7.0f;
            closestRelevantSeven = (int)Math.floor(rawProgress);
            actualProgress = rawProgress - (float)closestRelevantSeven;
            this.milestoneProgress[0] = 7 + (int)Math.floor(rawProgress * 7.0f);
            if (closestRelevantSeven % 2 == 0) {
                this.invertedPowerMilestonePercentage = actualProgress;
                this.powerMilestonePercentage = 1.0f - this.invertedPowerMilestonePercentage;
            } else {
                this.powerMilestonePercentage = actualProgress;
                this.invertedPowerMilestonePercentage = 1.0f - this.powerMilestonePercentage;
            }
        }
        if (this.milestoneProgress[1] < 7) {
            this.recipeMilestonePercentage = (float)Math.max(Math.log((float)this.totalRecipesProcessed * 1.0f / (float)RECIPE_MILESTONE_CONSTANT) / RECIPE_LOG_CONSTANT + 1.0, 0.0) / 7.0f;
            this.milestoneProgress[1] = (int)Math.floor(this.recipeMilestonePercentage * 7.0f);
        }
        if (this.inversion) {
            rawProgress = ((float)this.totalRecipesProcessed / (float)RECIPE_MILESTONE_T7_CONSTANT - 1.0f) / 7.0f;
            closestRelevantSeven = (int)Math.floor(rawProgress);
            actualProgress = rawProgress - (float)closestRelevantSeven;
            this.milestoneProgress[1] = 7 + (int)Math.floor(rawProgress * 7.0f);
            if (closestRelevantSeven % 2 == 0) {
                this.invertedRecipeMilestonePercentage = actualProgress;
                this.recipeMilestonePercentage = 1.0f - this.invertedRecipeMilestonePercentage;
            } else {
                this.recipeMilestonePercentage = actualProgress;
                this.invertedRecipeMilestonePercentage = 1.0f - this.recipeMilestonePercentage;
            }
        }
        if (this.milestoneProgress[2] < 7) {
            this.fuelMilestonePercentage = (float)Math.max(Math.log((float)this.totalFuelConsumed * 1.0f / 10000.0f) / FUEL_LOG_CONSTANT + 1.0, 0.0) / 7.0f;
            this.milestoneProgress[2] = (int)Math.floor(this.fuelMilestonePercentage * 7.0f);
        }
        if (this.inversion) {
            rawProgress = ((float)this.totalFuelConsumed / (float)FUEL_MILESTONE_T7_CONSTANT - 1.0f) / 7.0f;
            closestRelevantSeven = (int)Math.floor(rawProgress);
            actualProgress = rawProgress - (float)closestRelevantSeven;
            this.milestoneProgress[2] = 7 + (int)Math.floor(rawProgress * 7.0f);
            if (closestRelevantSeven % 2 == 0) {
                this.invertedFuelMilestonePercentage = actualProgress;
                this.fuelMilestonePercentage = 1.0f - this.invertedFuelMilestonePercentage;
            } else {
                this.fuelMilestonePercentage = actualProgress;
                this.invertedFuelMilestonePercentage = 1.0f - this.fuelMilestonePercentage;
            }
        }
        if (this.milestoneProgress[3] <= 7) {
            this.structureMilestonePercentage = this.totalExtensionsBuilt / 7.0f;
        }
        if (this.inversion) {
            rawProgress = (this.totalExtensionsBuilt - 7.0f) / 7.0f;
            closestRelevantSeven = (int)Math.floor(rawProgress);
            actualProgress = rawProgress - (float)closestRelevantSeven;
            if (closestRelevantSeven % 2 == 0) {
                this.invertedStructureMilestonePercentage = actualProgress;
                this.structureMilestonePercentage = 1.0f - this.invertedStructureMilestonePercentage;
            } else {
                this.structureMilestonePercentage = actualProgress;
                this.invertedStructureMilestonePercentage = 1.0f - this.structureMilestonePercentage;
            }
        }
    }

    private void determineGravitonShardAmount() {
        int sum = 0;
        for (int progress : this.milestoneProgress) {
            if (!this.inversion) {
                progress = Math.min(progress, 7);
            }
            sum += progress * (progress + 1) / 2;
        }
        this.gravitonShardsAvailable = sum - this.gravitonShardsSpent;
    }

    private void ejectGravitonShards() {
        if (this.mOutputBusses.size() == 1) {
            while (this.gravitonShardsAvailable >= 64) {
                this.addOutput(GTOreDictUnificator.get(OrePrefixes.gem, MaterialsUEVplus.GravitonShard, 64L));
                this.gravitonShardsAvailable -= 64;
                this.gravitonShardsSpent += 64;
            }
            this.addOutput(GTOreDictUnificator.get(OrePrefixes.gem, MaterialsUEVplus.GravitonShard, (long)this.gravitonShardsAvailable));
            this.gravitonShardsSpent += this.gravitonShardsAvailable;
            this.gravitonShardsAvailable = 0;
        }
    }

    private Text gravitonShardAmountText(int milestoneID) {
        int progress = this.milestoneProgress[milestoneID];
        if (!this.inversion) {
            progress = Math.min(progress, 7);
        }
        int sum = progress * (progress + 1) / 2;
        return new Text(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.shardgain") + ": " + EnumChatFormatting.GRAY + sum);
    }

    private Text totalMilestoneProgress(int milestoneID) {
        Number progress;
        String suffix;
        switch (milestoneID) {
            case 0: {
                suffix = StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.power");
                progress = this.totalPowerConsumed;
                break;
            }
            case 1: {
                suffix = StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.recipes");
                progress = this.totalRecipesProcessed;
                break;
            }
            case 2: {
                suffix = StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelconsumed");
                progress = this.totalFuelConsumed;
                break;
            }
            case 3: {
                suffix = StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.extensions");
                progress = this.milestoneProgress[3];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Milestone ID");
            }
        }
        return new Text(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.totalprogress") + ": " + EnumChatFormatting.GRAY + this.formattingMode.format(progress) + " " + suffix);
    }

    private Text currentMilestoneLevel(int milestoneID) {
        int milestoneLevel = this.inversion ? this.milestoneProgress[milestoneID] : Math.min(this.milestoneProgress[milestoneID], 7);
        return new Text(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.milestoneprogress") + ": " + EnumChatFormatting.GRAY + milestoneLevel);
    }

    private Text milestoneProgressText(int milestoneID) {
        Number max;
        String suffix;
        String progressText = StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.progress");
        Text done = new Text(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.milestonecomplete") + (this.formattingMode != DEFAULT_FORMATTING_MODE ? EnumChatFormatting.DARK_RED + "?" : ""));
        if (this.milestoneProgress[milestoneID] >= 7 && !this.inversion) {
            return done;
        }
        switch (milestoneID) {
            case 0: {
                suffix = StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.power");
                if (this.inversion) {
                    max = POWER_MILESTONE_T7_CONSTANT.multiply(BigInteger.valueOf(this.milestoneProgress[0] - 5));
                    break;
                }
                max = BigInteger.valueOf(LongMath.pow((long)9L, (int)this.milestoneProgress[0])).multiply(BigInteger.valueOf(LongMath.pow((long)10L, (int)15)));
                break;
            }
            case 1: {
                suffix = StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.recipes");
                if (this.inversion) {
                    max = RECIPE_MILESTONE_T7_CONSTANT * (long)(this.milestoneProgress[1] - 5);
                    break;
                }
                max = LongMath.pow((long)6L, (int)this.milestoneProgress[1]) * LongMath.pow((long)10L, (int)7);
                break;
            }
            case 2: {
                suffix = StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.fuelconsumed");
                if (this.inversion) {
                    max = FUEL_MILESTONE_T7_CONSTANT * (long)(this.milestoneProgress[2] - 5);
                    break;
                }
                max = LongMath.pow((long)3L, (int)this.milestoneProgress[2]) * LongMath.pow((long)10L, (int)4);
                break;
            }
            case 3: {
                suffix = StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.extensions");
                max = this.milestoneProgress[3] + 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Milestone ID");
            }
        }
        return new Text(progressText + ": " + EnumChatFormatting.GRAY + this.formattingMode.format(max) + " " + suffix);
    }

    private void increaseBattery(int amount) {
        if (this.internalBattery + amount <= this.maxBatteryCharge) {
            this.internalBattery += amount;
        } else {
            this.internalBattery = this.maxBatteryCharge;
            this.batteryCharging = false;
        }
    }

    public void reduceBattery(int amount) {
        if (this.internalBattery - amount <= 0) {
            this.internalBattery = 0;
            if (!this.moduleHatches.isEmpty()) {
                for (MTEBaseModule module : this.moduleHatches) {
                    module.disconnect();
                }
            }
            this.destroyRenderer();
        } else {
            this.internalBattery -= amount;
            this.totalFuelConsumed += (long)amount;
        }
    }

    public int getBatteryCharge() {
        return this.internalBattery;
    }

    public int getMaxBatteryCharge() {
        return this.maxBatteryCharge;
    }

    public void addTotalPowerConsumed(BigInteger amount) {
        this.totalPowerConsumed = this.totalPowerConsumed.add(amount);
    }

    public void addTotalRecipesProcessed(long amount) {
        this.totalRecipesProcessed += amount;
    }

    @Override
    protected void setHatchRecipeMap(MTEHatchInput hatch) {
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return TecTechRecipeMaps.godforgeFakeUpgradeCostRecipes;
    }

    @Override
    public void setItemNBT(NBTTagCompound NBT2) {
        this.saveGeneralNBT(NBT2, false);
        super.saveNBTData(NBT2);
    }

    @Override
    public void saveNBTData(NBTTagCompound NBT2) {
        this.saveGeneralNBT(NBT2, true);
        NBTTagCompound upgradeWindowStorageNBTTag = new NBTTagCompound();
        int storageIndex = 0;
        for (ItemStack itemStack : this.inputSlotHandler.getStacks()) {
            if (itemStack != null) {
                upgradeWindowStorageNBTTag.func_74768_a(storageIndex + "stacksizeOfStoredUpgradeItems", itemStack.field_77994_a);
                NBT2.func_74782_a(storageIndex + "storedUpgradeItem", (NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
            }
            ++storageIndex;
        }
        NBT2.func_74782_a("upgradeWindowStorage", (NBTBase)upgradeWindowStorageNBTTag);
        NBT2.func_74768_a("rotationSpeed", this.rotationSpeed);
        NBT2.func_74768_a("starSize", this.starSize);
        NBT2.func_74778_a("selectedStarColor", this.selectedStarColor);
        NBT2.func_74768_a("ringAmount", this.ringAmount);
        NBT2.func_74757_a("isRenderActive", this.isRenderActive);
        NBT2.func_74757_a("isRendererDisabled", this.isRendererDisabled);
        super.saveNBTData(NBT2);
    }

    private void saveGeneralNBT(NBTTagCompound NBT2, boolean force) {
        if (force || this.selectedFuelType != 0) {
            NBT2.func_74768_a("selectedFuelType", this.selectedFuelType);
        }
        if (force || this.internalBattery != 0) {
            NBT2.func_74768_a("internalBattery", this.internalBattery);
        }
        if (force || this.batteryCharging) {
            NBT2.func_74757_a("batteryCharging", this.batteryCharging);
        }
        if (force || this.gravitonShardsAvailable != 0) {
            NBT2.func_74768_a("gravitonShardsAvailable", this.gravitonShardsAvailable);
        }
        if (force || this.gravitonShardsSpent != 0) {
            NBT2.func_74768_a("gravitonShardsSpent", this.gravitonShardsSpent);
        }
        if (force || this.totalRecipesProcessed != 0L) {
            NBT2.func_74772_a("totalRecipesProcessed", this.totalRecipesProcessed);
        }
        if (force || this.totalFuelConsumed != 0L) {
            NBT2.func_74772_a("totalFuelConsumed", this.totalFuelConsumed);
        }
        if (force || this.stellarFuelAmount != 0) {
            NBT2.func_74768_a("starFuelStored", this.stellarFuelAmount);
        }
        if (force || this.gravitonShardEjection) {
            NBT2.func_74757_a("gravitonShardEjection", this.gravitonShardEjection);
        }
        if (force || this.secretUpgrade) {
            NBT2.func_74757_a("secretUpgrade", this.secretUpgrade);
        }
        if (force || this.fuelConsumptionFactor != 1) {
            NBT2.func_74768_a("fuelConsumptionFactor", this.fuelConsumptionFactor);
        }
        if (force || this.maxBatteryCharge != 100) {
            NBT2.func_74768_a("batterySize", this.maxBatteryCharge);
        }
        if (force || !DEFAULT_TOTAL_POWER.equals(this.totalPowerConsumed)) {
            NBT2.func_74773_a("totalPowerConsumed", this.totalPowerConsumed.toByteArray());
        }
        if (force || this.formattingMode != DEFAULT_FORMATTING_MODE) {
            NBT2.func_74768_a("formattingMode", this.formattingMode.ordinal());
        }
        this.upgrades.serializeToNBT(NBT2, force);
        this.starColors.serializeToNBT(NBT2);
    }

    @Override
    public void loadNBTData(NBTTagCompound NBT2) {
        this.selectedFuelType = NBT2.func_74762_e("selectedFuelType");
        this.internalBattery = NBT2.func_74762_e("internalBattery");
        this.batteryCharging = NBT2.func_74767_n("batteryCharging");
        this.gravitonShardsAvailable = NBT2.func_74762_e("gravitonShardsAvailable");
        this.gravitonShardsSpent = NBT2.func_74762_e("gravitonShardsSpent");
        this.totalRecipesProcessed = NBT2.func_74763_f("totalRecipesProcessed");
        this.totalFuelConsumed = NBT2.func_74763_f("totalFuelConsumed");
        this.stellarFuelAmount = NBT2.func_74762_e("starFuelStored");
        this.gravitonShardEjection = NBT2.func_74767_n("gravitonShardEjection");
        this.secretUpgrade = NBT2.func_74767_n("secretUpgrade");
        if (NBT2.func_74764_b("fuelConsumptionFactor")) {
            this.fuelConsumptionFactor = NBT2.func_74762_e("fuelConsumptionFactor");
        }
        if (NBT2.func_74764_b("batterySize")) {
            this.maxBatteryCharge = NBT2.func_74762_e("batterySize");
        }
        if (NBT2.func_74764_b("totalPowerConsumed")) {
            this.totalPowerConsumed = new BigInteger(NBT2.func_74770_j("totalPowerConsumed"));
        }
        if (NBT2.func_74764_b("formattingMode")) {
            int index = MathHelper.func_76125_a((int)NBT2.func_74762_e("formattingMode"), (int)0, (int)MilestoneFormatter.VALUES.length);
            this.formattingMode = MilestoneFormatter.VALUES[index];
        }
        NBTTagCompound tempItemTag = NBT2.func_74775_l("upgradeWindowStorage");
        for (int index = 0; index < 16; ++index) {
            int stackSize = tempItemTag.func_74762_e(index + "stacksizeOfStoredUpgradeItems");
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)NBT2.func_74775_l(index + "storedUpgradeItem"));
            if (itemStack == null) continue;
            this.storedUpgradeWindowItems[index] = itemStack.func_77979_a(stackSize);
        }
        if (NBT2.func_74764_b("rotationSpeed")) {
            this.rotationSpeed = NBT2.func_74762_e("rotationSpeed");
        }
        if (NBT2.func_74764_b("starSize")) {
            this.starSize = NBT2.func_74762_e("starSize");
        }
        if (NBT2.func_74764_b("selectedStarColor")) {
            this.selectedStarColor = NBT2.func_74779_i("selectedStarColor");
        }
        if (NBT2.func_74764_b("ringAmount")) {
            this.ringAmount = NBT2.func_74762_e("ringAmount");
        }
        this.isRenderActive = NBT2.func_74767_n("isRenderActive");
        this.isRendererDisabled = NBT2.func_74767_n("isRendererDisabled");
        this.upgrades.rebuildFromNBT(NBT2);
        this.starColors.rebuildFromNBT(NBT2);
        super.loadNBTData(NBT2);
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_GOD_FORGE_LOOP;
    }

    static {
        POWER_MILESTONE_CONSTANT = LongMath.pow((long)10L, (int)15);
        RECIPE_MILESTONE_CONSTANT = LongMath.pow((long)10L, (int)7);
        RECIPE_MILESTONE_T7_CONSTANT = RECIPE_MILESTONE_CONSTANT * LongMath.pow((long)6L, (int)6);
        FUEL_MILESTONE_T7_CONSTANT = 10000L * LongMath.pow((long)3L, (int)6);
        POWER_MILESTONE_T7_CONSTANT = BigInteger.valueOf(POWER_MILESTONE_CONSTANT).multiply(BigInteger.valueOf(LongMath.pow((long)9L, (int)6)));
        POWER_LOG_CONSTANT = Math.log(9.0);
        RECIPE_LOG_CONSTANT = Math.log(6.0);
        FUEL_LOG_CONSTANT = Math.log(3.0);
        SCANNER_INFO_BAR = EnumChatFormatting.BLUE.toString() + EnumChatFormatting.STRIKETHROUGH + "--------------------------------------------";
        STELLAR_FUEL = Mods.Avaritia.isModLoaded() ? GTModHandler.getModItem(Mods.Avaritia.ID, "Resource", 1L, 8) : GTOreDictUnificator.get(OrePrefixes.block, Materials.Neutronium, 1L);
        STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, ForgeOfGodsStructureString.MAIN_STRUCTURE).addShape(STRUCTURE_PIECE_SHAFT, ForgeOfGodsStructureString.BEAM_SHAFT).addShape(STRUCTURE_PIECE_FIRST_RING, ForgeOfGodsStructureString.FIRST_RING).addShape(STRUCTURE_PIECE_FIRST_RING_AIR, ForgeOfGodsStructureString.FIRST_RING_AIR).addShape(STRUCTURE_PIECE_SECOND_RING, ForgeOfGodsRingsStructureString.SECOND_RING).addShape(STRUCTURE_PIECE_SECOND_RING_AIR, ForgeOfGodsRingsStructureString.SECOND_RING_AIR).addShape(STRUCTURE_PIECE_THIRD_RING, ForgeOfGodsRingsStructureString.THIRD_RING).addShape(STRUCTURE_PIECE_THIRD_RING_AIR, ForgeOfGodsRingsStructureString.THIRD_RING_AIR).addElement('A', HatchElementBuilder.builder().atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus).casingIndex(963).dot(1).buildAndChain(TTCasingsContainer.GodforgeCasings, 3)).addElement('B', StructureUtility.ofBlock((Block)TTCasingsContainer.GodforgeCasings, (int)0)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.GodforgeCasings, (int)1)).addElement('D', StructureUtility.ofBlock((Block)TTCasingsContainer.GodforgeCasings, (int)2)).addElement('E', StructureUtility.ofBlock((Block)TTCasingsContainer.GodforgeCasings, (int)3)).addElement('F', StructureUtility.ofBlock((Block)TTCasingsContainer.GodforgeCasings, (int)4)).addElement('G', StructureUtility.ofBlock((Block)TTCasingsContainer.GodforgeCasings, (int)5)).addElement('H', StructureUtility.ofBlock((Block)BlockGodforgeGlass.INSTANCE, (int)0)).addElement('I', StructureUtility.ofBlock((Block)TTCasingsContainer.GodforgeCasings, (int)7)).addElement('J', HatchElementBuilder.builder().atLeast(moduleElement.Module).casingIndex(960).dot(2).buildAndChain(TTCasingsContainer.GodforgeCasings, 0)).addElement('K', StructureUtility.ofBlock((Block)TTCasingsContainer.GodforgeCasings, (int)6)).addElement('L', StructureUtility.ofBlock((Block)Blocks.field_150350_a, (int)0)).build();
    }

    public static enum moduleElement implements IHatchElement<MTEForgeOfGods>
    {
        Module(MTEForgeOfGods::addModuleToMachineList, new Class[]{MTEBaseModule.class}){

            @Override
            public long count(MTEForgeOfGods tileEntity) {
                return tileEntity.moduleHatches.size();
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<MTEForgeOfGods> adder;

        @SafeVarargs
        private moduleElement(IGTHatchAdder<MTEForgeOfGods> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTEForgeOfGods> adder() {
            return this.adder;
        }
    }
}

