/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMaps;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.HashSet;
import java.util.Set;

public class RecipeGenMetalRecipe
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenMetalRecipe(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        Logger.WARNING("Generating Metal recipes for " + material.getLocalizedName());
        if (ItemUtils.checkForInvalidItems(material.getIngot(1)) && ItemUtils.checkForInvalidItems(material.getBlock(1))) {
            GTValues.RA.stdBuilder().itemInputs(material.getIngot(9)).itemOutputs(material.getBlock(1)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
            Logger.WARNING("Compress Block Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (ItemUtils.checkForInvalidItems(material.getIngot(1)) && ItemUtils.checkForInvalidItems(material.getRod(1))) {
            GTValues.RA.stdBuilder().itemInputs(material.getIngot(1)).itemOutputs(material.getRod(1), material.getSmallDust(2)).duration(Math.max(material.getMass() / 8L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.latheRecipes);
            Logger.WARNING("Lathe Rod Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (ItemUtils.checkForInvalidItems(material.getRod(1)) && ItemUtils.checkForInvalidItems(material.getBolt(1))) {
            GTValues.RA.stdBuilder().itemInputs(material.getRod(1)).itemOutputs(material.getBolt(4)).duration(Math.max(material.getMass() * 2L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.cutterRecipes);
            Logger.WARNING("Cut Bolt Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (ItemUtils.checkForInvalidItems(material.getRod(1)) && ItemUtils.checkForInvalidItems(material.getLongRod(1))) {
            GTValues.RA.stdBuilder().itemInputs(material.getRod(2)).itemOutputs(material.getLongRod(1)).duration((int)Math.max(material.getMass(), 1L)).eut(16).addTo(RecipeMaps.hammerRecipes);
            Logger.WARNING("Hammer Long Rod Recipe: " + material.getLocalizedName() + " - Success");
            GTValues.RA.stdBuilder().itemInputs(material.getLongRod(1)).itemOutputs(material.getRod(2)).duration(Math.max(material.getMass(), 1L)).eut(4).addTo(RecipeMaps.cutterRecipes);
        }
        if (ItemUtils.checkForInvalidItems(material.getBolt(1)) && ItemUtils.checkForInvalidItems(material.getScrew(1))) {
            GTValues.RA.stdBuilder().itemInputs(material.getBolt(1)).itemOutputs(material.getScrew(1)).duration(Math.max(material.getMass() / 8L, 1L)).eut(4).addTo(RecipeMaps.latheRecipes);
            Logger.WARNING("Lathe Screw Recipe: " + material.getLocalizedName() + " - Success");
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

