/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.recipe.RecipeMaps;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.HashSet;
import java.util.Set;

public class RecipeGenAlloySmelter
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenAlloySmelter(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        int tVoltageMultiplier = material.vVoltageMultiplier;
        long duration = Math.max(material.getMass() * 2L, 1L);
        if (ItemUtils.checkForInvalidItems(material.getIngot(1)) && ItemUtils.checkForInvalidItems(material.getNugget(1))) {
            GTValues.RA.stdBuilder().itemInputs(material.getIngot(1), ItemList.Shape_Mold_Nugget.get(0L, new Object[0])).itemOutputs(material.getNugget(9)).duration(duration).eut(tVoltageMultiplier).addTo(RecipeMaps.alloySmelterRecipes);
        }
        if (ItemUtils.checkForInvalidItems(material.getIngot(1)) && ItemUtils.checkForInvalidItems(material.getGear(1))) {
            GTValues.RA.stdBuilder().itemInputs(material.getIngot(8), ItemList.Shape_Mold_Gear.get(0L, new Object[0])).itemOutputs(material.getGear(1)).duration(duration).eut(tVoltageMultiplier).addTo(RecipeMaps.alloySmelterRecipes);
        }
        if (ItemUtils.checkForInvalidItems(material.getIngot(1)) && ItemUtils.checkForInvalidItems(material.getNugget(1))) {
            GTValues.RA.stdBuilder().itemInputs(material.getNugget(9), ItemList.Shape_Mold_Ingot.get(0L, new Object[0])).itemOutputs(material.getIngot(1)).duration(duration).eut(tVoltageMultiplier).addTo(RecipeMaps.alloySmelterRecipes);
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

