/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchFluidGenerator;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class METHatchAirIntake
extends MTEHatchFluidGenerator {
    public METHatchAirIntake(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public METHatchAirIntake(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new METHatchAirIntake(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public String[] getCustomTooltip() {
        String[] aTooltip = new String[]{"DO NOT OBSTRUCT THE INPUT!", "Draws in Air from the surrounding environment", "Creates " + this.getAmountOfFluidToGenerate() + "L of Air every " + this.getMaxTickTime() + " ticks"};
        return aTooltip;
    }

    @Override
    public Fluid getFluidToGenerate() {
        return FluidUtils.getAir(1).getFluid();
    }

    @Override
    public int getAmountOfFluidToGenerate() {
        return 1000;
    }

    @Override
    public int getMaxTickTime() {
        return 4;
    }

    @Override
    public int getCapacity() {
        return 128000;
    }

    @Override
    public boolean doesHatchMeetConditionsToGenerate() {
        return this.getBaseMetaTileEntity().getAirAtSide(this.getBaseMetaTileEntity().getFrontFacing());
    }

    @Override
    public void generateParticles(World aWorld, String name) {
        float zSpd;
        float xSpd;
        if (this.getBaseMetaTileEntity().isServerSide()) {
            return;
        }
        float ran1 = floatGen.nextFloat();
        float ran2 = 0.0f;
        float ran3 = 0.0f;
        ran2 = floatGen.nextFloat();
        ran3 = floatGen.nextFloat();
        IGregTechTileEntity aMuffler = this.getBaseMetaTileEntity();
        ForgeDirection aDir = aMuffler.getFrontFacing();
        float xPos = (float)aDir.offsetX * 0.76f + (float)aMuffler.getXCoord() + 0.25f;
        float yPos = (float)aDir.offsetY * 0.76f + (float)aMuffler.getYCoord() + 0.65f;
        float zPos = (float)aDir.offsetZ * 0.76f + (float)aMuffler.getZCoord() + 0.25f;
        float ySpd = (float)aDir.offsetY * 0.1f + 0.2f + 0.1f * floatGen.nextFloat();
        if (aDir.offsetY == -1) {
            float temp = floatGen.nextFloat() * 2.0f * (float)Math.PI;
            xSpd = (float)Math.sin(temp) * 0.1f;
            zSpd = (float)Math.cos(temp) * 0.1f;
            ySpd = -ySpd;
            yPos -= 0.8f;
        } else {
            xSpd = (float)aDir.offsetX * (0.1f + 0.2f * floatGen.nextFloat());
            zSpd = (float)aDir.offsetZ * (0.1f + 0.2f * floatGen.nextFloat());
            xSpd = -xSpd;
            zSpd = -zSpd;
        }
        aWorld.func_72869_a(name, (double)(xPos + ran1 * 0.5f), (double)(yPos + floatGen.nextFloat() * 0.5f), (double)(zPos + floatGen.nextFloat() * 0.5f), (double)xSpd, (double)(-ySpd), (double)zSpd);
        aWorld.func_72869_a(name, (double)(xPos + ran2 * 0.5f), (double)(yPos + floatGen.nextFloat() * 0.5f), (double)(zPos + floatGen.nextFloat() * 0.5f), (double)xSpd, (double)(-ySpd), (double)zSpd);
        aWorld.func_72869_a(name, (double)(xPos + ran3 * 0.5f), (double)(yPos + floatGen.nextFloat() * 0.5f), (double)(zPos + floatGen.nextFloat() * 0.5f), (double)xSpd, (double)(-ySpd), (double)zSpd);
    }
}

