/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.agrichem;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.objects.GTItemStack;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.material.MaterialMisc;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.OreDictUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.plugin.agrichem.block.AgrichemFluids;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.railcraft.utils.RailcraftUtils;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class BioRecipes {
    private static Item mFert;
    private static Item mDustDirt;
    private static Fluid mSalineWater;
    private static Fluid mDistilledWater;
    private static Fluid mThermalWater;
    private static Fluid mAir;
    private static Fluid mSulfuricWasteWater;
    private static Fluid mAmmonia;
    private static Fluid mMethanol;
    private static Fluid mAceticAcid;
    private static Fluid mPropionicAcid;
    private static Fluid mLiquidPlastic;
    private static Fluid mFermentationBase;
    private static Fluid mCarbonDioxide;
    private static Fluid mCarbonMonoxide;
    private static Fluid mEthylene;
    private static Fluid mEthanol;
    private static Fluid mChlorine;
    private static Fluid mHydrogen;
    private static Fluid mDilutedSulfuricAcid;
    private static Fluid mSulfuricAcid;
    private static Fluid mUrea;
    public static Fluid mFormaldehyde;
    private static Fluid mLiquidResin;
    private static Fluid mMethane;
    private static Fluid mBenzene;
    private static Fluid mEthylbenzene;
    private static Fluid mStyrene;
    private static Fluid mButanol;
    private static Fluid mAcetone;
    public static final HashSet<GTItemStack> mFruits;
    public static final HashSet<GTItemStack> mVege;
    public static final HashSet<GTItemStack> mNuts;
    public static final HashSet<GTItemStack> mSeeds;
    public static final ArrayList<ItemStack> mList_Master_FruitVege;
    public static final ArrayList<ItemStack> mList_Master_Seeds;

    private static ItemStack getGreenAlgaeRecipeChip() {
        return BioRecipes.getBioChip(4);
    }

    private static ItemStack getBrownAlgaeRecipeChip() {
        return BioRecipes.getBioChip(8);
    }

    private static ItemStack getGoldenBrownAlgaeRecipeChip() {
        return BioRecipes.getBioChip(12);
    }

    private static ItemStack getRedAlgaeRecipeChip() {
        return BioRecipes.getBioChip(16);
    }

    private static ItemStack getBioChip(int aID) {
        return ItemUtils.simpleMetaStack(AgriculturalChem.mBioCircuit, aID, 0);
    }

    public static void init() {
        Logger.INFO("[Bio] Setting Variables");
        BioRecipes.initRecipeVars();
        Logger.INFO("[Bio] Generating Biochip Recipes");
        BioRecipes.recipeBioChip();
        Logger.INFO("[Bio] Generating Recipes");
        BioRecipes.recipeAlgaeBiomass();
        Logger.INFO("[Bio] Finished with recipes");
    }

    private static void initRecipeVars() {
        mFert = AgriculturalChem.dustOrganicFertilizer;
        mDustDirt = AgriculturalChem.dustDirt;
        if (!FluidUtils.doesFluidExist("saltwater")) {
            mSalineWater = FluidUtils.generateFluidNoPrefix("saltwater", "Salt Water", 200, new short[]{10, 30, 220, 100});
        } else {
            FluidStack aWaterStack;
            Materials aSaltWater = MaterialUtils.getMaterial("saltwater");
            if (aSaltWater != null && (aWaterStack = aSaltWater.getFluid(1L)) != null) {
                mSalineWater = aSaltWater.getFluid(1L).getFluid();
            }
            if (mSalineWater == null) {
                mSalineWater = FluidUtils.getWildcardFluidStack("saltwater", 1).getFluid();
            }
            if (ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cellSaltWater", 1) == null) {
                new BaseItemComponent("saltwater", "Salt Water", new short[]{10, 30, 220});
            }
        }
        mDistilledWater = FluidUtils.getDistilledWater(1).getFluid();
        mThermalWater = FluidUtils.getFluidStack("ic2hotwater", 1).getFluid();
        mAir = FluidUtils.getFluidStack("air", 1).getFluid();
        mSulfuricWasteWater = FluidUtils.getFluidStack("sulfuricapatite", 1).getFluid();
        mAmmonia = MaterialMisc.AMMONIA.getFluidStack(1).getFluid();
        mEthylene = FluidUtils.getFluidStack("ethylene", 1).getFluid();
        mEthanol = FluidUtils.getFluidStack("bioethanol", 1).getFluid();
        mDilutedSulfuricAcid = FluidUtils.getFluidStack("dilutedsulfuricacid", 1).getFluid();
        mSulfuricAcid = FluidUtils.getFluidStack("sulfuricacid", 1).getFluid();
        mFormaldehyde = FluidUtils.getFluidStack("fluid.formaldehyde", 1).getFluid();
        mMethane = FluidUtils.getFluidStack("methane", 1).getFluid();
        mBenzene = FluidUtils.getFluidStack("benzene", 1).getFluid();
        mEthylbenzene = FluidUtils.getFluidStack("fluid.ethylbenzene", 1).getFluid();
        mStyrene = FluidUtils.getFluidStack("styrene", 1).getFluid();
        mMethanol = FluidUtils.getFluidStack("methanol", 1).getFluid();
        mLiquidPlastic = FluidUtils.getWildcardFluidStack("plastic", 1).getFluid();
        mCarbonDioxide = MaterialMisc.CARBON_DIOXIDE.getFluidStack(1).getFluid();
        mCarbonMonoxide = MaterialMisc.CARBON_MONOXIDE.getFluidStack(1).getFluid();
        mChlorine = FluidUtils.getFluidStack("chlorine", 1).getFluid();
        mHydrogen = FluidUtils.getFluidStack("hydrogen", 1).getFluid();
        mAceticAcid = AgrichemFluids.mAceticAcid;
        mPropionicAcid = AgrichemFluids.mPropionicAcid;
        mUrea = AgrichemFluids.mUrea;
        mLiquidResin = AgrichemFluids.mLiquidResin;
        mFermentationBase = AgrichemFluids.mFermentationBase;
        mButanol = AgrichemFluids.mButanol;
        mAcetone = AgrichemFluids.mAcetone;
    }

    private static void recipeAlgaeBiomass() {
        BioRecipes.recipeGreenAlgae();
        BioRecipes.recipeBrownAlgae();
        BioRecipes.recipeGoldenBrownAlgae();
        BioRecipes.recipeRedAlgae();
        BioRecipes.recipeWoodPellets();
        BioRecipes.recipeWoodBricks();
        BioRecipes.recipeCellulosePulp();
        BioRecipes.recipeCatalystCarrier();
        BioRecipes.recipeAluminiumSilverCatalyst();
        BioRecipes.recipeAceticAcid();
        BioRecipes.recipePropionicAcid();
        BioRecipes.recipeFermentationBase();
        BioRecipes.recipeEthanol();
        BioRecipes.recipeCelluloseFibre();
        BioRecipes.recipeGoldenBrownCelluloseFiber();
        BioRecipes.recipeRedCelluloseFiber();
        BioRecipes.recipeSodiumHydroxide();
        BioRecipes.recipeSodiumCarbonate();
        BioRecipes.recipePelletMold();
        BioRecipes.recipeAluminiumPellet();
        BioRecipes.recipeLithiumChloride();
        BioRecipes.recipeSulfuricAcid();
        BioRecipes.recipeUrea();
        BioRecipes.recipeRawBioResin();
        BioRecipes.recipeLiquidResin();
        BioRecipes.recipeCompost();
        BioRecipes.recipeMethane();
        BioRecipes.recipeBenzene();
        BioRecipes.recipeStyrene();
        BioRecipes.registerFuels();
    }

    private static void registerFuels() {
        ItemUtils.registerFuel(ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), 800);
        ItemUtils.registerFuel(ItemUtils.getSimpleStack(AgriculturalChem.mWoodBrick, 1), 4800);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("cellButanol", 1)).metadata(GTRecipeConstants.FUEL_VALUE, 400).metadata(GTRecipeConstants.FUEL_TYPE, 0).duration(0).eut(0).addTo(GTRecipeConstants.Fuel);
    }

    private static void recipeGreenAlgae() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 4)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getGreenAlgaeRecipeChip(), ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 10)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 5)).duration(150).eut(16).addTo(RecipeMaps.assemblerRecipes);
    }

    private static void recipeBrownAlgae() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 2)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 10)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mAlginicAcid, 2)).duration(40).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.extractorRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBrownAlgaeRecipeChip(), ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 20)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mLithiumChloride, 5)).duration(120).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 1200).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBrownAlgaeRecipeChip(), ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 40)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 20)).fluidInputs(FluidUtils.getDistilledWater(2000)).duration(600).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
    }

    private static void recipeGoldenBrownAlgae() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, 1)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getGoldenBrownAlgaeRecipeChip(), ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, 10)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownCelluloseFiber, 5)).duration(150).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.assemblerRecipes);
    }

    private static void recipeRedAlgae() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, 1)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 2)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getRedAlgaeRecipeChip(), ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, 10)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mRedCelluloseFiber, 5)).duration(150).eut(TierEU.RECIPE_HV / 2L).addTo(RecipeMaps.assemblerRecipes);
    }

    private static void recipeCelluloseFibre() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 8), ItemUtils.getSimpleStack(AgriculturalChem.mAlginicAcid, 2)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mCellulosePulp, 10)).duration(200).eut(16).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(2), ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 12)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 24)).duration(48).eut(8).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 12)).fluidOutputs(Materials.Methanol.getFluid(1000L)).duration(150).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.fluidExtractionRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 3)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(16), ItemUtils.getSimpleStack(AgriculturalChem.mCellulosePulp, 4)).fluidInputs(FluidUtils.getFluidStack(mAceticAcid, 500), FluidUtils.getFluidStack(mPropionicAcid, 500)).fluidOutputs(FluidUtils.getFluidStack(mLiquidPlastic, 1000)).duration(200).eut(240).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeWoodPellets() {
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1)}, ItemUtils.getSimpleStack(AgriculturalChem.mWoodBrick, 2));
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 12), ItemUtils.getSimpleStack(AgriculturalChem.mPelletMold, 0)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 3)).duration(200).eut(16).addTo(RecipeMaps.extruderRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(2), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 8)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mWoodBrick, 2)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1)).fluidOutputs(FluidUtils.getFluidStack(mCarbonDioxide, 70)).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.fluidExtractionRecipes);
        if (Mods.Railcraft.isModLoaded()) {
            RailcraftUtils.addCokeOvenRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 2), true, true, ItemUtils.getItemStackOfAmountFromOreDict("gemCharcoal", 3), GTValues.NF, 1200);
        }
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 2), BioRecipes.getBioChip(3)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("gemCharcoal", 3)).eut(16).duration(120).addTo(GTPPRecipeMaps.cokeOvenRecipes);
    }

    private static void recipeWoodBricks() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(3), ItemUtils.getOrePrefixStack(OrePrefixes.dust, Materials.Wood, 50)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mWoodBrick, 1)).duration(2000).eut(16).addTo(RecipeMaps.assemblerRecipes);
    }

    private static void recipeCellulosePulp() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(2), ItemUtils.getSimpleStack(AgriculturalChem.mCellulosePulp, 4)).itemOutputs(ItemUtils.getSimpleStack(Items.field_151121_aF, 4)).duration(40).eut(16).addTo(RecipeMaps.assemblerRecipes);
    }

    private static void recipeCatalystCarrier() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(20), GTOreDictUnificator.get(OrePrefixes.plate, Materials.Steel, 8L), GTOreDictUnificator.get(OrePrefixes.wireFine, Materials.Copper, 4L), GTOreDictUnificator.get(OrePrefixes.screw, Materials.Tin, 6L)).itemOutputs(CI.getEmptyCatalyst(1)).duration(6000).eut(16).addTo(RecipeMaps.assemblerRecipes);
    }

    private static void recipeAluminiumSilverCatalyst() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(4), CI.getEmptyCatalyst(10), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Aluminium, 4L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Silver, 4L)).itemOutputs(CI.getGreenCatalyst(10)).duration(400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.assemblerRecipes);
    }

    private static void recipeAceticAcid() {
        GTValues.RA.stdBuilder().itemInputs(CI.getGreenCatalyst(0)).fluidInputs(FluidUtils.getFluidStack(mMethanol, 700), FluidUtils.getFluidStack(mCarbonMonoxide, 700)).fluidOutputs(FluidUtils.getFluidStack(mAceticAcid, 700)).duration(2400).eut(60).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(CI.getNumberedBioCircuit(14)).fluidInputs(FluidUtils.getFluidStack(mFermentationBase, 1000)).fluidOutputs(FluidUtils.getFluidStack(mAceticAcid, 1000)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 2)).duration(1200).eut(16).noOptimize().addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
    }

    private static void processFermentationOreDict() {
        BioRecipes.processOreDictEntry("listAllfruit", mFruits);
        BioRecipes.processOreDictEntry("listAllFruit", mFruits);
        BioRecipes.processOreDictEntry("listAllveggie", mVege);
        BioRecipes.processOreDictEntry("listAllVeggie", mVege);
        BioRecipes.processOreDictEntry("listAllnut", mNuts);
        BioRecipes.processOreDictEntry("listAllNut", mNuts);
        BioRecipes.processOreDictEntry("listAllseed", mSeeds);
        BioRecipes.processOreDictEntry("listAllSeed", mSeeds);
        if (!mFruits.isEmpty()) {
            for (GTItemStack g : mFruits) {
                mList_Master_FruitVege.add(g.toStack());
            }
        }
        if (!mVege.isEmpty()) {
            for (GTItemStack g : mVege) {
                mList_Master_FruitVege.add(g.toStack());
            }
        }
        if (!mNuts.isEmpty()) {
            for (GTItemStack g : mNuts) {
                mList_Master_FruitVege.add(g.toStack());
            }
        }
        if (!mSeeds.isEmpty()) {
            for (GTItemStack g : mSeeds) {
                mList_Master_Seeds.add(g.toStack());
            }
        }
    }

    private static void processOreDictEntry(String aOreName, HashSet<GTItemStack> mfruits2) {
        ArrayList aTemp = OreDictionary.getOres((String)aOreName);
        if (!aTemp.isEmpty()) {
            for (ItemStack stack : aTemp) {
                mfruits2.add(new GTItemStack(stack));
            }
        }
    }

    private static void recipeFermentationBase() {
        BioRecipes.processFermentationOreDict();
        ArrayList aMap = OreDictionary.getOres((String)"cropSugarbeet");
        for (ItemStack a : mList_Master_FruitVege) {
            if (aMap.contains(a) || !ItemUtils.checkForInvalidItems(a)) continue;
            GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(2), ItemUtils.getSimpleStack(a, 10)).fluidInputs(FluidUtils.getFluidStack(mDistilledWater, 1000)).fluidOutputs(FluidUtils.getFluidStack(mFermentationBase, 1000)).duration(600).eut(2).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        }
        for (ItemStack a : mList_Master_Seeds) {
            if (!ItemUtils.checkForInvalidItems(a)) continue;
            GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(3), ItemUtils.getSimpleStack(a, 20)).fluidInputs(FluidUtils.getFluidStack(mDistilledWater, 1000)).fluidOutputs(FluidUtils.getFluidStack(mFermentationBase, 1000)).duration(600).eut(2).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(4), ItemUtils.getSimpleStack(Items.field_151120_aE, 32)).fluidInputs(FluidUtils.getFluidStack(mDistilledWater, 1000)).fluidOutputs(FluidUtils.getFluidStack(mFermentationBase, 1000)).duration(600).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(5), ItemUtils.getSimpleStack(Items.field_151120_aE, 32), ItemUtils.getSimpleStack(ModItems.dustCalciumCarbonate, 2)).fluidInputs(FluidUtils.getFluidStack(mThermalWater, 2000)).fluidOutputs(FluidUtils.getFluidStack(mFermentationBase, 2000)).duration(200).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        if (OreDictUtils.containsValidEntries("cropSugarbeet")) {
            GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(4), ItemUtils.getItemStackOfAmountFromOreDict("cropSugarbeet", 4)).fluidInputs(FluidUtils.getFluidStack(mDistilledWater, 1000)).fluidOutputs(FluidUtils.getFluidStack(mFermentationBase, 1000)).duration(600).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
            GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(5), ItemUtils.getItemStackOfAmountFromOreDict("cropSugarbeet", 4), ItemUtils.getSimpleStack(ModItems.dustCalciumCarbonate, 2)).fluidInputs(FluidUtils.getFluidStack(mThermalWater, 2000)).fluidOutputs(FluidUtils.getFluidStack(mFermentationBase, 2000)).duration(200).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 0).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(5), ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownCelluloseFiber, 6), ItemUtils.getSimpleStack(AgriculturalChem.mRedCelluloseFiber, 16)).fluidInputs(FluidUtils.getFluidStack(mFermentationBase, 48000)).fluidOutputs(FluidUtils.getFluidStack(mButanol, 18000), FluidUtils.getFluidStack(mAcetone, 9000), FluidUtils.getFluidStack(mEthanol, 3000)).duration(2000).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).noOptimize().addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipePropionicAcid() {
        GTValues.RA.stdBuilder().itemInputs(CI.getGreenCatalyst(0)).fluidInputs(FluidUtils.getFluidStack(mEthylene, 1000), FluidUtils.getFluidStack(mCarbonMonoxide, 1000), FluidUtils.getFluidStack(mDistilledWater, 1000)).fluidOutputs(FluidUtils.getFluidStack(mPropionicAcid, 1000)).duration(200).eut(60).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeEthanol() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(2)).fluidInputs(FluidUtils.getFluidStack(mFermentationBase, 1000)).fluidOutputs(FluidUtils.getFluidStack(mEthanol, 100)).duration(400).eut(TierEU.RECIPE_MV / 2L).addTo(RecipeMaps.distilleryRecipes);
    }

    private static void recipeGoldenBrownCelluloseFiber() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownCelluloseFiber, 5)).fluidOutputs(Materials.Ammonia.getGas(500L)).duration(300).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.fluidExtractionRecipes);
    }

    private static void recipeRedCelluloseFiber() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mRedCelluloseFiber, 3)).itemOutputs(ItemUtils.getSimpleStack(ModItems.dustCalciumCarbonate, 5)).duration(100).eut(TierEU.RECIPE_HV / 2L).addTo(RecipeMaps.extractorRecipes);
    }

    private static void recipeSodiumHydroxide() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(4)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mSodiumHydroxide, 3)).fluidInputs(FluidUtils.getFluidStack(mSalineWater, 1000)).fluidOutputs(FluidUtils.getFluidStack(mChlorine, 1000), FluidUtils.getFluidStack(mHydrogen, 1000)).duration(6000).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(5), ItemUtils.getItemStackOfAmountFromOreDict("dustSodium", 5)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mSodiumHydroxide, 15)).fluidInputs(FluidUtils.getFluidStack(mDistilledWater, 5000)).fluidOutputs(FluidUtils.getFluidStack(mHydrogen, 5000)).duration(1200).eut(60).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeSodiumCarbonate() {
        if (OreDictUtils.containsValidEntries("fuelCoke")) {
            GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(18), ItemUtils.getItemStackOfAmountFromOreDict("fuelCoke", 1), ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 6), ItemUtils.getSimpleStack(AgriculturalChem.mAluminiumPellet, 5)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mSodiumAluminate, 8)).fluidOutputs(FluidUtils.getFluidStack(mCarbonDioxide, 1000)).duration(2400).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(18), ItemUtils.getItemStackOfAmountFromOreDict("dustCoal", 2), ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 6), ItemUtils.getSimpleStack(AgriculturalChem.mAluminiumPellet, 5)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mSodiumAluminate, 8)).fluidOutputs(FluidUtils.getFluidStack(mCarbonDioxide, 1000)).duration(3600).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipePelletMold() {
        GregtechItemList.Pellet_Mold.set(ItemUtils.getSimpleStack(AgriculturalChem.mPelletMold, 1));
        GTValues.RA.stdBuilder().itemInputs(MaterialsAlloy.TUMBAGA.getBlock(1)).itemOutputs(GregtechItemList.Pellet_Mold.get(1L, new Object[0])).duration(9000).eut(TierEU.RECIPE_MV / 4L * 3L).addTo(RecipeMaps.latheRecipes);
    }

    private static void recipeAluminiumPellet() {
        ArrayList<String> aOreNames = new ArrayList<String>();
        aOreNames.add("Lazurite");
        aOreNames.add("Bauxite");
        aOreNames.add("Grossular");
        aOreNames.add("Pyrope");
        aOreNames.add("Sodalite");
        aOreNames.add("Spodumene");
        aOreNames.add("Ruby");
        aOreNames.add("Sapphire");
        aOreNames.add("GreenSapphire");
        HashMap<String, Integer> aOreData1 = new HashMap<String, Integer>();
        HashMap<String, Integer> aOreData2 = new HashMap<String, Integer>();
        HashMap<String, Integer> aOreData3 = new HashMap<String, Integer>();
        aOreData1.put("Lazurite", 120);
        aOreData1.put("Bauxite", 90);
        aOreData1.put("Grossular", 90);
        aOreData1.put("Pyrope", 90);
        aOreData1.put("Sodalite", 90);
        aOreData1.put("Spodumene", 90);
        aOreData1.put("Ruby", 60);
        aOreData1.put("Sapphire", 30);
        aOreData1.put("GreenSapphire", 30);
        aOreData2.put("Lazurite", 14);
        aOreData2.put("Bauxite", 39);
        aOreData2.put("Grossular", 20);
        aOreData2.put("Pyrope", 20);
        aOreData2.put("Sodalite", 11);
        aOreData2.put("Spodumene", 10);
        aOreData2.put("Ruby", 6);
        aOreData2.put("Sapphire", 5);
        aOreData2.put("GreenSapphire", 5);
        aOreData3.put("Lazurite", 3);
        aOreData3.put("Bauxite", 16);
        aOreData3.put("Grossular", 2);
        aOreData3.put("Pyrope", 2);
        aOreData3.put("Sodalite", 3);
        aOreData3.put("Spodumene", 1);
        aOreData3.put("Ruby", 2);
        aOreData3.put("Sapphire", 2);
        aOreData3.put("GreenSapphire", 2);
        HashMap<String, ItemStack> aOreCache = new HashMap<String, ItemStack>();
        Iterator iterator = aOreNames.iterator();
        while (iterator.hasNext()) {
            String aOreName;
            String aTemp = aOreName = (String)iterator.next();
            aOreName = "crushedPurified" + aOreName;
            if (!ItemUtils.doesOreDictHaveEntryFor(aOreName)) continue;
            aOreCache.put(aTemp, ItemUtils.getItemStackOfAmountFromOreDict(aOreName, 1));
        }
        for (String aOreName : aOreNames) {
            GTValues.RA.stdBuilder().itemInputs(CI.getNumberedBioCircuit(14), ItemUtils.getSimpleStack((ItemStack)aOreCache.get(aOreName), (int)((Integer)aOreData2.get(aOreName)))).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mCleanAluminiumMix, (int)Math.ceil((double)((Integer)aOreData3.get(aOreName)).intValue() * 1.4))).fluidInputs(FluidUtils.getSteam(2000 * (Integer)aOreData2.get(aOreName))).fluidOutputs(FluidUtils.getFluidStack(AgriculturalChem.RedMud, 100 * (int)Math.ceil((double)((Integer)aOreData3.get(aOreName)).intValue() * 1.4))).duration(1200).eut((Integer)aOreData1.get(aOreName)).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, aOreName.equals("Bauxite") ? 2 : 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mCleanAluminiumMix, 3), ItemUtils.getSimpleStack(AgriculturalChem.mPelletMold, 0)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mAluminiumPellet, 4)).duration(600).eut(TierEU.RECIPE_MV / 2L).addTo(RecipeMaps.extruderRecipes);
    }

    private static void recipeLithiumChloride() {
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.RockSalt, 8L), ItemUtils.getSimpleStack(AgriculturalChem.mLithiumChloride, 10)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Lithium, 2L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Lithium, 3L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Lithium, 3L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Lithium, 5L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Potassium, 2L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Potassium, 5L)).outputChances(7500, 8000, 8500, 9000, 7500, 8500).fluidInputs(FluidUtils.getFluidStack(mAir, 4000)).fluidOutputs(FluidUtils.getFluidStack(mChlorine, 500)).duration(1800).eut(TierEU.RECIPE_MV / 2L).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        if (OreDictUtils.containsValidEntries("dustPotash")) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Potash, 10L), ItemUtils.getSimpleStack(AgriculturalChem.mLithiumChloride, 16)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Lithium, 3L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Lithium, 5L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Lithium, 5L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Lithium, 7L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Ash, 2L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Ash, 2L)).outputChances(7500, 8000, 8500, 9000, 9000, 9000).fluidInputs(FluidUtils.getFluidStack(mThermalWater, 2000)).fluidOutputs(FluidUtils.getFluidStack(mChlorine, 250)).duration(1200).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        }
    }

    private static void recipeSulfuricAcid() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(7), ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 10), ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 6)).fluidInputs(FluidUtils.getFluidStack(mDistilledWater, 5000)).fluidOutputs(FluidUtils.getFluidStack(mSulfuricAcid, 5000)).duration(1000).eut(60).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(7), ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownCelluloseFiber, 2), ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 10)).fluidInputs(FluidUtils.getFluidStack(mDistilledWater, 5000)).fluidOutputs(FluidUtils.getFluidStack(mSulfuricAcid, 5000)).duration(120).eut(180).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 3).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeUrea() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(9)).fluidInputs(FluidUtils.getFluidStack(mAmmonia, 600), FluidUtils.getFluidStack(mCarbonDioxide, 300)).fluidOutputs(FluidUtils.getFluidStack(mUrea, 300), FluidUtils.getFluidStack(mDistilledWater, 300)).duration(100).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(9)).fluidInputs(FluidUtils.getFluidStack(mUrea, 200), FluidUtils.getFluidStack(mFormaldehyde, 200)).fluidOutputs(FluidUtils.getFluidStack(mLiquidResin, 200)).duration(100).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeRawBioResin() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(3), ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 5), ItemUtils.getSimpleStack(Blocks.field_150346_d, 1)).itemOutputs(ItemUtils.getSimpleStack(AgriculturalChem.mRawBioResin, 1)).fluidInputs(FluidUtils.getFluidStack(mDistilledWater, 100)).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeLiquidResin() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(3), ItemUtils.getSimpleStack(AgriculturalChem.mRawBioResin, 1)).fluidInputs(FluidUtils.getFluidStack(mEthanol, 200)).fluidOutputs(FluidUtils.getFluidStack(mLiquidResin, 500)).duration(100).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(3), ItemUtils.getSimpleStack(AgriculturalChem.mCellulosePulp, 8)).itemOutputs(ItemUtils.getSimpleStack(Ic2Items.resin, 32)).fluidInputs(FluidUtils.getFluidStack(mLiquidResin, 144)).duration(1200).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeCompost() {
        ItemStack aFert;
        if (Mods.Forestry.isModLoaded()) {
            aFert = ItemUtils.getSimpleStack(AgriculturalChem.aFertForestry, 32);
            GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(11), ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 16), ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 8)).itemOutputs(aFert).fluidInputs(FluidUtils.getFluidStack(mUrea, 200)).duration(600).eut(60).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        }
        aFert = ItemUtils.getSimpleStack(AgriculturalChem.aFertIC2, 32);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(12), ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 16), ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 8)).itemOutputs(aFert).fluidInputs(FluidUtils.getFluidStack(mUrea, 200)).duration(600).eut(60).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeMethane() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(12), ItemUtils.getSimpleStack(AgriculturalChem.mAlgaeBiosmass, 10)).fluidInputs(FluidUtils.getFluidStack(mDistilledWater, 500)).fluidOutputs(FluidUtils.getFluidStack(mMethane, 500)).duration(100).eut(64).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(13), ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 8), ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownCelluloseFiber, 6), ItemUtils.getSimpleStack(AgriculturalChem.mRedCelluloseFiber, 4)).fluidInputs(FluidUtils.getFluidStack(mMethane, 2000)).fluidOutputs(FluidUtils.getFluidStack(mEthylene, 2000)).duration(200).eut(60).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeBenzene() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(19), CI.getGreenCatalyst(0)).fluidInputs(FluidUtils.getFluidStack(mMethane, 6000)).fluidOutputs(FluidUtils.getFluidStack(mBenzene, 1000), Materials.Hydrogen.getGas(18000L)).duration(160).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeStyrene() {
        GTValues.RA.stdBuilder().itemInputs(BioRecipes.getBioChip(20), CI.getGreenCatalyst(0)).fluidInputs(FluidUtils.getFluidStack(mEthylbenzene, 100)).fluidOutputs(FluidUtils.getFluidStack(mStyrene, 100), Materials.Hydrogen.getGas(200L)).duration(320).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void recipeBioChip() {
        GTModHandler.addShapelessCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 0L, new Object[0]), 0L, new Object[]{OrePrefixes.circuit.get(Materials.ULV)});
        long bits = 0L;
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 1L, new Object[0]), 0L, new Object[]{"d  ", " P ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 2L, new Object[0]), 0L, new Object[]{" d ", " P ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 3L, new Object[0]), 0L, new Object[]{"  d", " P ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 4L, new Object[0]), 0L, new Object[]{"   ", " Pd", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 5L, new Object[0]), 0L, new Object[]{"   ", " P ", "  d", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 6L, new Object[0]), 0L, new Object[]{"   ", " P ", " d ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 7L, new Object[0]), 0L, new Object[]{"   ", " P ", "d  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 8L, new Object[0]), 0L, new Object[]{"   ", "dP ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 9L, new Object[0]), 0L, new Object[]{"P d", "   ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 10L, new Object[0]), 0L, new Object[]{"P  ", "  d", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 11L, new Object[0]), 0L, new Object[]{"P  ", "   ", "  d", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 12L, new Object[0]), 0L, new Object[]{"P  ", "   ", " d ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 13L, new Object[0]), 0L, new Object[]{"  P", "   ", "  d", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 14L, new Object[0]), 0L, new Object[]{"  P", "   ", " d ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 15L, new Object[0]), 0L, new Object[]{"  P", "   ", "d  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 16L, new Object[0]), 0L, new Object[]{"  P", "d  ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 17L, new Object[0]), 0L, new Object[]{"   ", "   ", "d P", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 18L, new Object[0]), 0L, new Object[]{"   ", "d  ", "  P", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 19L, new Object[0]), 0L, new Object[]{"d  ", "   ", "  P", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 20L, new Object[0]), 0L, new Object[]{" d ", "   ", "  P", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 21L, new Object[0]), 0L, new Object[]{"d  ", "   ", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 22L, new Object[0]), 0L, new Object[]{" d ", "   ", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 23L, new Object[0]), 0L, new Object[]{"  d", "   ", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 24L, new Object[0]), 0L, new Object[]{"   ", "  d", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
    }

    static {
        mFruits = new HashSet();
        mVege = new HashSet();
        mNuts = new HashSet();
        mSeeds = new HashSet();
        mList_Master_FruitVege = new ArrayList();
        mList_Master_Seeds = new ArrayList();
    }
}

