/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.config;

import com.gtnewhorizon.gtnhlib.config.Config;

@Config(modid="miscutils", configSubDirectory="GTPlusPlus", filename="GTPlusPlus")
@Config.LangKeyPattern(pattern="gtpp.gui.config.%cat.%field", fullyQualified=true)
@Config.Comment(value={"General section"})
@Config.RequiresMcRestart
public class Configuration {
    public static final Debug debug = new Debug();
    public static final Machines machines = new Machines();
    public static final Gregtech gregtech = new Gregtech();
    public static final Features features = new Features();
    public static final Visual visual = new Visual();
    public static final Worldgen worldgen = new Worldgen();

    @Config.Comment(value={"Debug section"})
    public static class Debug {
        @Config.Comment(value={"Makes many machines display lots of debug logging."})
        @Config.DefaultBoolean(value=false)
        public boolean MachineInfo;
        @Config.Comment(value={"Makes all items hidden from NEI display."})
        @Config.DefaultBoolean(value=false)
        public boolean showHiddenNEIItems;
        @Config.Comment(value={"Dumps all GT++ and Toxic Everglade Data to en_US.lang in the config folder. This config option can be used by foreign players to generate blank .lang files, which they can populate with their language of choice."})
        @Config.DefaultBoolean(value=false)
        public boolean dumpItemAndBlockData;
    }

    @Config.Comment(value={"Machines section"})
    public static class Machines {
        @Config.Comment(value={"Allows the use of TC shards across many recipes by oreDicting them into a common group."})
        @Config.DefaultBoolean(value=false)
        public boolean enableThaumcraftShardUnification;
        @Config.Comment(value={"Alkaluscraft Related - Removes IC2 Cables Except glass fibre. Few other Misc Tweaks."})
        @Config.DefaultBoolean(value=false)
        public boolean disableIC2Recipes;
        @Config.Comment(value={"Sets the steam per second value in LV,MV,HV boilers (respectively 1x,2x,3x this number for the tiers)"})
        @Config.DefaultInt(value=750)
        public int boilerSteamPerSecond;
    }

    @Config.Comment(value={"GregTech section"})
    public static class Gregtech {
        @Config.Comment(value={"Rotors below this durability will be removed, prevents NEI clutter. Minimum Durability is N * x, where N is the new value set and x is the turbine size, where 1 is Tiny and 4 is Huge. Set to 0 to disable."})
        @Config.DefaultInt(value=25500)
        public int turbineCutoffBase;
    }

    @Config.Comment(value={"Features section"})
    public static class Features {
        @Config.Comment(value={"Hides every filled IC2 Universal Cell from NEI."})
        @Config.DefaultBoolean(value=true)
        public boolean hideUniversalCells;
    }

    @Config.Comment(value={"Visual section"})
    public static class Visual {
        @Config.Comment(value={"Enables Animated GT++ Textures"})
        @Config.DefaultBoolean(value=true)
        public boolean enableAnimatedTextures;
        @Config.Comment(value={"Use GT textures"})
        @Config.DefaultBoolean(value=true)
        public boolean useGregtechTextures;
    }

    @Config.Comment(value={"Worldgen section"})
    public static class Worldgen {
        @Config.Comment(value={"The ID of the Toxic Everglades."})
        @Config.DefaultInt(value=227)
        public int EVERGLADES_ID;
        @Config.Comment(value={"The biome within the Toxic Everglades."})
        @Config.DefaultInt(value=199)
        public int EVERGLADESBIOME_ID;
    }
}

