/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.minecraft;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class BTF_FluidTank
extends FluidTank {
    public FluidStack mFluid;

    public BTF_FluidTank(int capacity) {
        super(capacity);
    }

    public FluidStack getFluid() {
        return this.getDrainableStack();
    }

    public int getFluidAmount() {
        return this.getDrainableStack() != null ? this.getDrainableStack().amount : 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound aNBT) {
        super.writeToNBT(aNBT);
        if (this.mFluid != null) {
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
        }
        return aNBT;
    }

    public FluidTank readFromNBT(NBTTagCompound aNBT) {
        this.mFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid"));
        return this;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return true;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return true;
    }

    public FluidStack getFillableStack() {
        return this.mFluid;
    }

    public FluidStack setFillableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        return this.mFluid;
    }

    public FluidStack getDrainableStack() {
        return this.mFluid;
    }

    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        return this.mFluid;
    }

    public boolean isFluidChangingAllowed() {
        return true;
    }

    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid != null && aFluid.getFluid().getID() > 0 && aFluid.amount > 0 && this.canTankBeFilled() && this.isFluidInputAllowed(aFluid)) {
            if (this.getFillableStack() != null && this.getFillableStack().getFluid().getID() > 0) {
                if (!this.getFillableStack().isFluidEqual(aFluid)) {
                    return 0;
                }
                int space = this.getCapacity() - this.getFillableStack().amount;
                if (aFluid.amount <= space) {
                    if (doFill) {
                        FluidStack arg9999 = this.getFillableStack();
                        arg9999.amount += aFluid.amount;
                    }
                    return aFluid.amount;
                }
                if (doFill) {
                    this.getFillableStack().amount = this.getCapacity();
                }
                return space;
            }
            if (aFluid.amount <= this.getCapacity()) {
                if (doFill) {
                    this.setFillableStack(aFluid.copy());
                }
                return aFluid.amount;
            }
            if (doFill) {
                this.setFillableStack(aFluid.copy());
                this.getFillableStack().amount = this.getCapacity();
            }
            return this.getCapacity();
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getDrainableStack() != null && this.canTankBeEmptied()) {
            if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
                this.setDrainableStack(null);
                return null;
            }
            int used = Math.min(this.getDrainableStack().amount, maxDrain);
            if (doDrain) {
                FluidStack arg9999 = this.getDrainableStack();
                arg9999.amount -= used;
            }
            FluidStack drained = this.getDrainableStack().copy();
            drained.amount = used;
            if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
                this.setDrainableStack(null);
            }
            return drained;
        }
        return null;
    }

    public int getCapacity() {
        return super.getCapacity();
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public void setFluid(FluidStack fluid) {
        this.setFillableStack(fluid);
    }

    public void setCapacity(int capacity) {
        super.setCapacity(capacity);
    }

    public FluidStack drain(FluidStack aFluid, boolean doDrain) {
        return this.drain(aFluid.amount, doDrain);
    }
}

